/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.meta.entity;

import com.kingdee.bos.meta.entity.BizDataType;
import com.kingdee.bos.meta.entity.EntityInfoVisitor;
import com.kingdee.bos.meta.entity.MetaEntity;
import com.kingdee.bos.meta.entity.MetaProperty;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.resource.BizDataTypeInfo;

public class EntityInfoVisitorImpl
implements EntityInfoVisitor {
    private MetaEntity metaEntity = new MetaEntity();
    private EntityObjectInfo entity;

    public MetaEntity getMetaEntity() {
        return this.metaEntity;
    }

    @Override
    public void visit(EntityObjectInfo entity) {
        this.entity = entity;
        this.metaEntity.bosType = entity.getType().toString();
        this.metaEntity.alias = entity.getAlias();
        for (PropertyInfo p : entity.getPropertiesRuntime()) {
            if (p instanceof OwnPropertyInfo) {
                this.visit((OwnPropertyInfo)p);
                continue;
            }
            this.visit((LinkPropertyInfo)p, entity);
        }
    }

    @Override
    public void visit(OwnPropertyInfo property) {
        this.visitOwnProperty(property, null);
    }

    private void visitOwnProperty(OwnPropertyInfo property, String parentProperty) {
        MetaProperty mp = this.addAProperty((PropertyInfo)property, parentProperty);
        mp.dataType = property.getDataType();
        BizDataTypeInfo bizDataType = property.getBizDataType();
        if (bizDataType != null) {
            BizDataType bdt;
            mp.bizDataType = bdt = BizDataType.valueOf(bizDataType.getName());
        }
    }

    private MetaProperty addAProperty(PropertyInfo property, String parentProperty) {
        MetaProperty mp = new MetaProperty();
        mp.name = parentProperty == null ? property.getName() : parentProperty + "." + property.getName();
        mp.alias = property.getAlias();
        this.metaEntity.properties.add(mp);
        return mp;
    }

    @Override
    public void visit(LinkPropertyInfo property, EntityObjectInfo ownEntity) {
        this.visitLinkProperty(property, ownEntity, null);
    }

    private void visitLinkProperty(LinkPropertyInfo property, EntityObjectInfo ownEntity, String parentProperty) {
        MetaProperty mp = this.addAProperty((PropertyInfo)property, parentProperty);
        RelationshipInfo relation = property.getRelationship();
        EntityObjectInfo entryEntity = relation.getSupplierObject();
        if (this.isCompositionRelation(ownEntity, relation)) {
            mp.dataType = DataType.OBJECTCOLLECTION;
            this.visitCompositeEntity(property.getName(), entryEntity);
        } else {
            mp.dataType = DataType.OBJECTVALUE;
        }
        mp.linkBosType = entryEntity.getType().toString();
    }

    private boolean isCompositionRelation(EntityObjectInfo ownEntity, RelationshipInfo relation) {
        return relation.getLinkType(this.entity).equals((Object)RelationshipType.COMPOSITION) && ownEntity.equals((Object)relation.getClientObject());
    }

    private void visitCompositeEntity(String entityProperty, EntityObjectInfo entity) {
        for (PropertyInfo p : entity.getPropertiesRuntime()) {
            if (p instanceof OwnPropertyInfo) {
                this.visitOwnProperty((OwnPropertyInfo)p, entityProperty);
                continue;
            }
            this.visitLinkProperty((LinkPropertyInfo)p, entity, entityProperty);
        }
    }
}

