/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.meta.ui;

import com.kingdee.bos.meta.ui.ListUIObjectInfoVisitor;
import com.kingdee.bos.meta.ui.MetaAction;
import com.kingdee.bos.meta.ui.MetaColumn;
import com.kingdee.bos.meta.ui.MetaComponent;
import com.kingdee.bos.meta.ui.MetaComponentProperty;
import com.kingdee.bos.meta.ui.MetaDataObject;
import com.kingdee.bos.meta.ui.MetaEventBinding;
import com.kingdee.bos.meta.ui.MetaLayout;
import com.kingdee.bos.meta.ui.MetaListUI;
import com.kingdee.bos.meta.ui.MetaPropertyBinding;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class ListUIObjectInfoVisitorImpl
implements ListUIObjectInfoVisitor {
    private MetaListUI metaUI = new MetaListUI();
    private Stack stack = new Stack();
    private Map<String, MetaPropertyBinding> proptyBindings = new HashMap<String, MetaPropertyBinding>();

    public MetaListUI getMetaUI() {
        return this.metaUI;
    }

    @Override
    public void accept(UIObjectInfo uiObject) {
        this.metaUI.name = uiObject.getFullName();
        this.metaUI.alias = uiObject.getAlias();
        this.metaUI.title = uiObject.getTitle();
        this.metaUI.description = uiObject.getDescription();
        this.metaUI.userDefined = uiObject.isUserDefined();
        Iterator iter = uiObject.getComponents().iterator();
        while (iter.hasNext()) {
            this.accept((ComponentInfo)iter.next());
        }
        iter = uiObject.getDataObjects().iterator();
        while (iter.hasNext()) {
            this.accept((DataObjectInfo)iter.next());
        }
        iter = uiObject.getActions().iterator();
        while (iter.hasNext()) {
            this.accept((ActionInfo)iter.next());
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(ComponentInfo component) {
        if (this.metaUI.components == null) {
            this.metaUI.components = new ArrayList<MetaComponent>();
        }
        MetaComponent mc = new MetaComponent();
        this.metaUI.components.add(mc);
        mc.name = component.getName();
        mc.alias = component.getAlias();
        mc.classType = component.getClassType();
        mc.constraints = component.getConstraint();
        mc.herited = component.isHerited();
        mc.isContainer = component.isContainer();
        if (component.getParent() != null) {
            mc.parentName = component.getParent().getName();
        }
        try {
            this.stack.push(mc);
            if (component.getLayoutInfo() != null) {
                this.accept(component.getLayoutInfo());
            }
            Iterator iter = component.getProperties().iterator();
            while (iter.hasNext()) {
                this.accept((PropertyInfo)iter.next());
            }
            iter = component.getPropertyBindings().iterator();
            while (iter.hasNext()) {
                this.accept((PropertyBindingInfo)iter.next());
            }
            iter = component.getEventBindings().iterator();
            while (iter.hasNext()) {
                this.accept((EventBindingInfo)iter.next());
            }
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(component.getClassType())) {
                this.parseTable(component);
            }
        }
        finally {
            this.stack.pop();
        }
    }

    private void parseTable(ComponentInfo component) {
        String formatXml = component.getPropertyByName("formatXml").getValue();
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)formatXml);
        ArrayList<MetaColumn> columns = new ArrayList<MetaColumn>();
        for (ColumnInfo ci : tableInfo.getColumns()) {
            MetaColumn column = new MetaColumn(ci.getName());
            column.setHide(ci.isHide());
            column.setMerge(ci.isMergeable());
            String propertyName = column.getName() + ".text";
            MetaPropertyBinding mpb = this.proptyBindings.get(propertyName);
            if (mpb != null) {
                column.setFieldName(mpb.bindingField);
            }
            columns.add(column);
        }
        this.metaUI.columns = columns;
    }

    @Override
    public void accept(DataObjectInfo dataObject) {
        MetaDataObject mdo = new MetaDataObject();
        mdo.name = dataObject.getName();
        mdo.type = dataObject.getType();
        mdo.objectType = dataObject.getObjectType();
        mdo.userDefined = dataObject.isUserDefined();
        mdo.herited = dataObject.isHerited();
        if (this.metaUI.dataObjects == null) {
            this.metaUI.dataObjects = new ArrayList<MetaDataObject>();
        }
        this.metaUI.dataObjects.add(mdo);
        if (dataObject.getName().equals("mainQuery")) {
            this.metaUI.mainQueryPK = MetaDataPK.create((String)dataObject.getType());
        }
    }

    @Override
    public void accept(ActionInfo action) {
        MetaAction ma = new MetaAction();
        ma.name = action.getName();
        ma.alias = action.getControlName();
        ma.acceleratorKey = action.getAcceleratorKey();
        ma.actionCommandKey = action.getActionCommandKey();
        ma.actionExtendProperty = action.getActionExtendProperty();
        ma.actionPerformed = action.getActionPerformed();
        ma.afterActionPerformed = action.getAfterActionPerformed();
        ma.batchMethodName = action.getBatchMethodName();
        ma.beforeActionPerformed = action.getBeforeActionPerformed();
        ma.className = action.getClassName();
        ma.daemonRun = action.isDaemonRun();
        ma.enable = action.isEnabled();
        ma.smallIcon = action.getSmallIcon();
        ma.shortDescription = action.getShortDesc();
        ma.longDescription = action.getLongDesc();
        ma.services = action.getServices();
        if (this.metaUI.actions == null) {
            this.metaUI.actions = new ArrayList<MetaAction>();
        }
        this.metaUI.actions.add(ma);
    }

    @Override
    public void accept(PropertyInfo property) {
        MetaComponentProperty mp = new MetaComponentProperty();
        mp.name = property.getName();
        mp.type = property.getType();
        mp.userDefined = property.isUserDefined();
        mp.value = property.getValue();
        MetaComponent mc = (MetaComponent)this.stack.peek();
        if (mc.properties == null) {
            mc.properties = new ArrayList<MetaComponentProperty>();
        }
        mc.properties.add(mp);
    }

    @Override
    public void accept(PropertyBindingInfo propertyBinding) {
        MetaPropertyBinding mpb = new MetaPropertyBinding();
        mpb.bindingField = propertyBinding.getBingdingField();
        mpb.bindingObject = propertyBinding.getBindingObject();
        mpb.fieldType = propertyBinding.getFieldType();
        mpb.propertyName = propertyBinding.getPropertyName();
        mpb.propertyType = propertyBinding.getPropertyType();
        MetaComponent mc = (MetaComponent)this.stack.peek();
        if (mc.propertyBindings == null) {
            mc.propertyBindings = new ArrayList<MetaPropertyBinding>();
        }
        mc.propertyBindings.add(mpb);
        this.proptyBindings.put(mpb.propertyName, mpb);
    }

    @Override
    public void accept(EventBindingInfo eventBinding) {
        MetaEventBinding meb = new MetaEventBinding();
        meb.code = eventBinding.getCode();
        meb.eventName = eventBinding.getEventName();
        meb.eventType = eventBinding.getEventType();
        meb.herited = eventBinding.isHerited();
        meb.isBindWorkFlow = eventBinding.isBindWorkFlow();
        meb.listenerAdapter = eventBinding.getListenerAdapter();
        meb.listenerType = eventBinding.getListenerType();
        meb.methodName = eventBinding.getMethodName();
        meb.userDefined = eventBinding.isUserDefined();
        MetaComponent mc = (MetaComponent)this.stack.peek();
        if (mc.eventBindings == null) {
            mc.eventBindings = new ArrayList<MetaEventBinding>();
        }
        mc.eventBindings.add(meb);
    }

    @Override
    public void accept(LayoutInfo layoutInfo) {
        MetaLayout ml = new MetaLayout();
        ml.name = layoutInfo.getName();
        ml.type = layoutInfo.getType();
        ml.value = layoutInfo.getValue();
        MetaComponent mc = (MetaComponent)this.stack.peek();
        mc.layout = ml;
    }

    @Override
    public void finish() {
        if (this.metaUI.components == null) {
            return;
        }
        HashMap<String, MetaComponent> map = new HashMap<String, MetaComponent>();
        for (MetaComponent mc : this.metaUI.components) {
            map.put(mc.name, mc);
        }
        for (MetaComponent mc : this.metaUI.components) {
            if (mc.parentName == null) continue;
            mc.parent = (MetaComponent)map.get(mc.parentName);
            if (mc.parent.components == null) {
                mc.parent.components = new ArrayList<MetaComponent>();
            }
            mc.parent.components.add(mc);
        }
    }
}

