/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.login;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.bos.webservice.WSConfig;
import com.kingdee.bos.webservice.login.WSContext;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;

public class EASLoginProxy {
    private static final Logger logger = Logger.getLogger(EASLoginProxy.class);
    public static final String EAS_DEFAULT_AUTH_PATTERN = "BaseDB";
    public static final String EAS_AUTH_PATTERN_LTPATOKEN = "BaseTrdLtpaToken";
    private static Map userSessionCache = Collections.synchronizedMap(new HashMap());
    private static Map userPwCache = Collections.synchronizedMap(new HashMap());

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType) {
        return this.login(userName, password, slnName, dcName, language, dbType, EAS_DEFAULT_AUTH_PATTERN);
    }

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType, String authPattern) {
        return this.login(userName, password, slnName, dcName, language, dbType, authPattern, 0);
    }

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType, String authPattern, int isEncodePwd) {
        WSContext wsctx = new WSContext();
        wsctx.setUserName(userName);
        wsctx.setPassword(password);
        wsctx.setSlnName(slnName);
        wsctx.setDcName(dcName);
        wsctx.setDbType(dbType);
        String encodePwd = null;
        encodePwd = isEncodePwd == 0 ? EASLoginProxy.encodePassword(userName, password) : (isEncodePwd == 1 ? password : password);
        String key = userName + "_" + slnName + "_" + dcName + "_" + language;
        ILoginModule loginModule = null;
        String loginUrl = null;
        try {
            loginUrl = "tcp://localhost:" + ORMRPConfig.getTcpConnectionPort();
            loginModule = this.getLoginModule(loginUrl);
        }
        catch (BOSException e) {
            logger.error((Object)"WebService login fail:", (Throwable)e);
            wsctx.setSessionId(null);
        }
        catch (RuntimeException re) {
            if (RPCException.getErrorCode((Throwable)re) == 1002) {
                RemoteBOSObjectFactory.getInstance(loginUrl).getSession().close();
                try {
                    loginModule = this.getLoginModule(loginUrl);
                }
                catch (BOSException e) {
                    logger.error((Object)"WebService login fail agin :", (Throwable)e);
                    wsctx.setSessionId(null);
                }
            }
            logger.error((Object)"WebService login fail:", (Throwable)re);
            wsctx.setSessionId(null);
        }
        String clientIp = null;
        try {
            if (loginModule == null) {
                logger.error((Object)"WebService login fail: loginModule is null...");
                return null;
            }
            String sessionId = null;
            try {
                sessionId = this.getSessionIdFromCache(encodePwd, key, authPattern, loginModule);
            }
            catch (Exception e) {
                logger.error((Object)"WebService get SessionId from Cache fail...", (Throwable)e);
            }
            if (sessionId == null) {
                clientIp = this.getClientIp();
                Locale locale = new Locale(language);
                LoginContext ctx = new LoginContext(userName, encodePwd, slnName, dcName, locale, clientIp, null);
                ctx.put("dbType", (Object)EASLoginProxy.getDbType(dbType));
                ctx.put("UserAuthPattern", (Object)authPattern);
                ctx.put("ClientIP", (Object)clientIp);
                ctx.setLoginType(LoginType.WEBSERVICE);
                ctx.put("SwitchToNewLoginFlow", (Object)"true");
                try {
                    sessionId = loginModule.login(ctx);
                }
                catch (RPCConnectException rpce) {
                    logger.error((Object)"WebService login fail and RPCConnect");
                    RemoteBOSObjectFactory.getInstance((String)loginUrl).clearSession();
                    loginModule = this.getLoginModule(loginUrl);
                    sessionId = loginModule.login(ctx);
                }
                catch (RPCException rpce) {
                    logger.error((Object)"WebService login fail and RPCConnect");
                    RemoteBOSObjectFactory.getInstance((String)loginUrl).clearSession();
                    loginModule = this.getLoginModule(loginUrl);
                    sessionId = loginModule.login(ctx);
                }
            }
            wsctx.setSessionId(sessionId);
            ORMRPCServiceLocator.setCurrentServiceURL((String)loginUrl);
        }
        catch (BOSException e) {
            logger.error((Object)"WebService login fail:", (Throwable)e);
            logger.error((Object)("clientIp:" + clientIp));
            wsctx.setSessionId(null);
        }
        catch (Throwable e) {
            logger.error((Object)"WebService login fail:", e);
            logger.error((Object)("clientIp:" + clientIp));
            wsctx.setSessionId(null);
        }
        return wsctx;
    }

    private String getSessionIdFromCache(String encodePwd, String key, String authPattern, ILoginModule loginModule) throws BOSException, EASBizException {
        String sessionId = null;
        if (userSessionCache.containsKey(key)) {
            String pwd = (String)userPwCache.get(key);
            if (encodePwd.equals(pwd) || EAS_AUTH_PATTERN_LTPATOKEN.equals(authPattern)) {
                sessionId = (String)userSessionCache.get(key);
                if (sessionId != null && sessionId.trim().length() > 0) {
                    boolean flag = loginModule.bindingRpcSession(sessionId);
                    if (!flag) {
                        sessionId = null;
                    }
                } else {
                    sessionId = null;
                }
            } else {
                sessionId = null;
            }
        }
        try {
            if (!StringUtils.isEmpty(sessionId)) {
                IUserMonitor userMonitor = this.getUserMonitor();
                userMonitor.updateLastOperateTime(sessionId);
                userMonitor.updateTimerLastOperateTime(sessionId);
            }
        }
        catch (Exception e) {
            logger.info((Object)"update error:", (Throwable)e);
        }
        return sessionId;
    }

    private IUserMonitor getUserMonitor() throws BOSException, EASBizException {
        return UserMonitorFactory.getLocalInstance(null);
    }

    private ILoginModule getLoginModule(String url) throws BOSException {
        try {
            RPCService.inServiceInvoke.set("aaaaaaaaaaa");
            if (WSConfig.getRomoteLocate() == null || WSConfig.getRomoteLocate().equals("true")) {
                ILoginModule iLoginModule = LoginModuleFactory.getRemoteInstance((String)url);
                return iLoginModule;
            }
            ILoginModule iLoginModule = LoginModuleFactory.getLocalInstance(null);
            return iLoginModule;
        }
        finally {
            RPCService.inServiceInvoke.set(null);
        }
    }

    public boolean logout(String userName, String slnName, String dcName, String language) {
        if (WSConfig.getRomoteLocate() == null || !WSConfig.getRomoteLocate().equals("false")) {
            return true;
        }
        boolean flag = true;
        String key = userName + "_" + slnName + "_" + dcName + "_" + language;
        try {
            String loginUrl = "tcp://localhost:" + ORMRPConfig.getTcpConnectionPort();
            ILoginModule loginModule = this.getLoginModule(loginUrl);
            if (userSessionCache.containsKey(key) && loginModule != null) {
                String sessionId = (String)userSessionCache.get(key);
                if (sessionId != null && sessionId.trim().length() > 0 && (flag = loginModule.isOnline(sessionId))) {
                    flag = loginModule.logout(sessionId);
                }
                userSessionCache.remove(key);
                userPwCache.remove(key);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"WebService logout fail:", (Throwable)e);
        }
        catch (Throwable e) {
            logger.error((Object)"WebService logout fail:", e);
        }
        return flag;
    }

    public WSContext loginByLtpaToken(String userName, String ltpaToken, String slnName, String dcName, String language, int dbType) {
        WSContext wsctx = new WSContext();
        wsctx.setUserName(userName);
        wsctx.setSlnName(slnName);
        wsctx.setDcName(dcName);
        wsctx.setDbType(dbType);
        if (!EASLoginProxy.authenticate(userName, ltpaToken)) {
            logger.error((Object)("webservice loginByLtpaToken fail,ltpaToken is wrong. userName:" + userName + ", ltpaToken:" + ltpaToken));
            return wsctx;
        }
        LtpaToken token = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig());
        String password = token.getTokenStr();
        return this.login(userName, password, slnName, dcName, language, dbType, EAS_AUTH_PATTERN_LTPATOKEN, 0);
    }

    private static boolean authenticate(String userNumber, String cipher) {
        boolean result = false;
        LtpaTokenManager.loadDefaultConfig();
        if (cipher == null || StringUtils.isEmpty((String)cipher)) {
            return false;
        }
        String token = cipher;
        if (LtpaTokenManager.isValid((String)token)) {
            result = LtpaTokenManager.compare((String)token, (String)userNumber);
        }
        logger.debug((Object)("BaseLtpaToken:" + userNumber + "/" + cipher));
        return result;
    }

    private static String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            e.printStackTrace();
        }
        if (encodedPassword == null) {
            encodedPassword = "";
        }
        return encodedPassword;
    }

    private static String getDbType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2 UDB";
            }
            case 2: {
                return "Oracle";
            }
        }
        return "MS SQL Server";
    }

    private String getClientIp() {
        String napClientIP = null;
        try {
            HttpServletRequest request = (HttpServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            napClientIP = request.getHeader("nap_proxy_client_ip");
            if (StringUtils.isEmpty((String)napClientIP)) {
                napClientIP = request.getRemoteAddr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty(napClientIP)) {
            napClientIP = "127.0.0.1";
        }
        return napClientIP;
    }
}

