/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.tool;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WSDDFileGenerator {
    private static final String NEWLINE = "\n";
    private static final String INDENT = "    ";

    public StringBuffer generateWSDDFile(BusinessObjectInfo objectInfo, Map files) {
        StringBuffer wsddFile = new StringBuffer();
        wsddFile.append("<service name=\"WS" + objectInfo.getName() + "\" provider=\"java:RPC\">");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append("<parameter name=\"className\" value=\"" + objectInfo.getPackage() + ".WS" + objectInfo.getName() + "Srv\"/>");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append("<parameter name=\"allowedMethods\" value=\"*\"/>");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append("<beanMapping qname=\"myNS:WSBean\" xmlns:myNS=\"urn:client\" languageSpecificType=\"java:com.kingdee.bos.webservice.WSBean\"/>");
        for (String key : files.keySet()) {
            String className = key.substring(key.lastIndexOf(".") + 1);
            wsddFile.append(NEWLINE);
            wsddFile.append(INDENT);
            wsddFile.append("<beanMapping qname=\"myNS:" + className + "\" xmlns:myNS=\"urn:client\" languageSpecificType=\"java:" + key + "\"/>");
        }
        wsddFile.append(NEWLINE);
        wsddFile.append("</service>");
        return wsddFile;
    }

    public Set getWSDDFiles(BusinessObjectInfo objectInfo, Map files) {
        HashSet<String> result = new HashSet<String>();
        for (String key : files.keySet()) {
            String className = key.substring(key.lastIndexOf(".") + 1);
            result.add("<beanMapping qname=\"myNS:" + className + "\" xmlns:myNS=\"urn:client." + objectInfo.getName().toLowerCase() + "\" languageSpecificType=\"java:" + key + "\"/>");
        }
        return result;
    }

    public StringBuffer generateAllWSDDFile(BusinessObjectInfo objectInfo, Set lines) {
        StringBuffer wsddFile = new StringBuffer();
        wsddFile.append("<deployment xmlns=\"http://xml.apache.org/axis/wsdd/\"");
        wsddFile.append(NEWLINE);
        wsddFile.append("    xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append("<service name=\"WS" + objectInfo.getName() + "\" provider=\"java:RPC\">");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append(INDENT);
        wsddFile.append("<parameter name=\"className\" value=\"" + objectInfo.getPackage() + ".webservice.WS" + objectInfo.getName() + "SrvProxy\"/>");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append(INDENT);
        wsddFile.append("<parameter name=\"allowedMethods\" value=\"*\"/>");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append(INDENT);
        wsddFile.append("<beanMapping qname=\"myNS:WSBean\" xmlns:myNS=\"urn:client." + objectInfo.getName().toLowerCase() + "\" languageSpecificType=\"java:com.kingdee.bos.webservice.WSBean\"/>");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append(INDENT);
        wsddFile.append("<beanMapping qname=\"myNS:WSInvokeException\" xmlns:myNS=\"urn:client." + objectInfo.getName().toLowerCase() + "\" languageSpecificType=\"java:com.kingdee.bos.webservice.WSInvokeException\"/>");
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append(INDENT);
        if (objectInfo instanceof EntityObjectInfo) {
            wsddFile.append("<beanMapping qname=\"myNS:" + objectInfo.getName() + "WSPK\" xmlns:myNS=\"urn:client." + objectInfo.getName().toLowerCase() + "\" languageSpecificType=\"java:" + objectInfo.getPackage() + ".webservice." + objectInfo.getName() + "WSPK\"/>");
            wsddFile.append(NEWLINE);
            wsddFile.append(INDENT);
            wsddFile.append(INDENT);
        }
        for (String key : lines) {
            wsddFile.append(NEWLINE);
            wsddFile.append(INDENT);
            wsddFile.append(INDENT);
            wsddFile.append(key);
        }
        wsddFile.append(NEWLINE);
        wsddFile.append(INDENT);
        wsddFile.append("</service>");
        wsddFile.append(NEWLINE);
        wsddFile.append("</deployment>");
        return wsddFile;
    }
}

