/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.tool.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.facade.IFacadeCtrl;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.webservice.tool.config.DeployConfigDelegate;
import com.kingdee.util.SAXBuilderFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class DeployWebServiceConfigUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.webservice.config.DeployWebServiceConfigUtil");
    private static final String STR_DEPLOY_OBJECTS = "deployObjects";
    private static final String STR_DEPLOY_OBJECT = "deployObject";
    private static final String STR_TYPE = "type";
    private static final String STR_NAME = "name";
    private static final String STR_PACKAGE = "package";
    private static final String STR_DEPLOY_METHODS = "deployMethods";
    private static final String STR_DEPLOY_METHOD = "deployMethod";
    private static final String STR_ID = "id";
    private static final String STR_TYPE_ENTITY = "entity";
    private static final String STR_TYPE_FACADE = "facade";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addDeployObject(DeployConfigDelegate delegate, String filePath) {
        if (delegate == null || filePath == null) {
            logger.error((Object)"\u53d1\u5e03\u5bf9\u8c61\u4e3a\u7a7a\u6216\u8005\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u6709\u8bef\uff01");
            return false;
        }
        File file = new File(filePath + "/WebServiceDeploy.xml");
        BusinessObjectInfo object = delegate.getObject();
        List methodList = delegate.getMethodList();
        String type = STR_TYPE_ENTITY;
        if (object instanceof FacadeInfo) {
            type = STR_TYPE_FACADE;
        }
        String name = object.getName();
        String pk = object.getPackage();
        OutputStream os = null;
        try {
            Element root;
            Document doc;
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    logger.error((Object)"error, can not create configuration file");
                    boolean bl = false;
                    return bl;
                }
                doc = new Document();
                root = new Element(STR_DEPLOY_OBJECTS);
                doc.setRootElement(root);
            } else {
                logger.debug((Object)("read config file: " + file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                doc = builder.build(file);
                root = doc.getRootElement();
                if (!root.getName().equals(STR_DEPLOY_OBJECTS)) {
                    logger.error((Object)("error, " + file.getName() + "is not a valid file,root tag must be 'deployObjects'"));
                    boolean e = false;
                    return e;
                }
            }
            String objName = object.getName();
            List dobjects = root.getChildren();
            Iterator dObjs = dobjects.iterator();
            while (dObjs.hasNext()) {
                boolean typeEqu = false;
                boolean nameEqu = false;
                boolean pkEqu = false;
                boolean canBreak = false;
                Element dobj = (Element)dObjs.next();
                List dobjContent = dobj.getChildren();
                for (Element content : dobjContent) {
                    String conName = content.getName();
                    if (conName.equals(STR_TYPE)) {
                        if (content.getText().equals(type)) {
                            typeEqu = true;
                        }
                    } else if (conName.equals(STR_NAME)) {
                        if (content.getText().equals(name)) {
                            nameEqu = true;
                        }
                    } else if (conName.equals(STR_PACKAGE) && content.getText().equals(pk)) {
                        pkEqu = true;
                    }
                    if (!typeEqu || !nameEqu || !pkEqu) continue;
                    root.removeContent((Content)dobj);
                    canBreak = true;
                    break;
                }
                if (!canBreak) continue;
            }
            Element newObj = new Element(STR_DEPLOY_OBJECT);
            Element dType = new Element(STR_TYPE);
            dType.setText(type);
            newObj.addContent((Content)dType);
            Element dName = new Element(STR_NAME);
            dName.setText(name);
            newObj.addContent((Content)dName);
            Element dPk = new Element(STR_PACKAGE);
            dPk.setText(pk);
            newObj.addContent((Content)dPk);
            Element dMtd = new Element(STR_DEPLOY_METHODS);
            int size = methodList.size();
            for (int i = 0; i < size; ++i) {
                MethodInfo met = (MethodInfo)methodList.get(i);
                Element dmethod = new Element(STR_DEPLOY_METHOD);
                dmethod.setAttribute(STR_ID, met.getInnerID());
                dMtd.addContent((Content)dmethod);
            }
            newObj.addContent((Content)dMtd);
            root.addContent((Content)newObj);
            Format format = Format.getCompactFormat();
            format.setEncoding("utf-8");
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outputter = new XMLOutputter(format);
            os = new FileOutputStream(file);
            outputter.output(doc, os);
            return true;
        }
        catch (IOException ie) {
            logger.error((Object)("read file " + file.getAbsolutePath() + " error: " + ie.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (JDOMException de) {
            logger.error((Object)("parse file " + file.getAbsolutePath() + " error: " + de.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static List getAllDeployObject(String configFilePath, String metadataPath) {
        if (configFilePath == null || metadataPath == null) {
            logger.error((Object)"error, \u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u6216\u5143\u6570\u636e\u8def\u5f84\u6709\u8bef\uff01");
            return null;
        }
        ArrayList<DeployConfigDelegate> delegates = new ArrayList<DeployConfigDelegate>();
        File file = new File(configFilePath + "/WebServiceDeploy.xml");
        if (!file.exists()) {
            logger.error((Object)"error, \u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
            return null;
        }
        try {
            logger.info((Object)("read config file: " + file.getAbsolutePath()));
            SAXBuilder builder = SAXBuilderFactory.create();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            if (!root.getName().equals(STR_DEPLOY_OBJECTS)) {
                logger.error((Object)("error, " + file.getName() + "is not a valid file,root tag must be 'deployObjects'"));
                return new ArrayList();
            }
            List dobjects = root.getChildren();
            Iterator dObjs = dobjects.iterator();
            while (dObjs.hasNext()) {
                String type = "";
                String name = "";
                String pk = "";
                ArrayList<String> methodIds = new ArrayList<String>();
                Element dobj = (Element)dObjs.next();
                List dobjContent = dobj.getChildren();
                for (Element content : dobjContent) {
                    String conName = content.getName();
                    if (conName.equals(STR_TYPE)) {
                        type = content.getText();
                        continue;
                    }
                    if (conName.equals(STR_NAME)) {
                        name = content.getText();
                        continue;
                    }
                    if (conName.equals(STR_PACKAGE)) {
                        pk = content.getText();
                        continue;
                    }
                    if (!conName.equals(STR_DEPLOY_METHODS)) continue;
                    List methods = content.getChildren();
                    for (Element methodE : methods) {
                        String id = methodE.getAttribute(STR_ID).getValue();
                        methodIds.add(id);
                    }
                }
                Context ctx = new Context();
                ctx.put((Object)"METADATAPATH", (Object)metadataPath);
                EntityObjectInfo boi = null;
                AbstractMetaDataCtrl ctrl = null;
                if (type.equals(STR_TYPE_ENTITY)) {
                    ctrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.ENTITY);
                    boi = ((IEntityObjectCtrl)ctrl).getValue((IMetaDataPK)new MetaDataPK(pk, name));
                } else if (type.equals(STR_TYPE_FACADE)) {
                    ctrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.FACADE);
                    boi = ((IFacadeCtrl)ctrl).getValue((IMetaDataPK)new MetaDataPK(pk, name));
                }
                if (boi == null) continue;
                DeployConfigDelegate delegate = new DeployConfigDelegate();
                delegate.setObject((BusinessObjectInfo)boi);
                int size = methodIds.size();
                block7: for (int i = 0; i < size; ++i) {
                    String mid = (String)methodIds.get(i);
                    MethodCollection col = boi.getAllMethods();
                    int cSize = col.size();
                    for (int j = 0; j < cSize; ++j) {
                        MethodInfo me = col.get(j);
                        if (!me.getInnerID().equals(mid)) continue;
                        delegate.addDeployMethod(me);
                        continue block7;
                    }
                }
                delegates.add(delegate);
            }
            return delegates;
        }
        catch (IOException ie) {
            logger.error((Object)("read file " + file.getAbsolutePath() + " error: " + ie.getMessage()));
            return null;
        }
        catch (JDOMException de) {
            logger.error((Object)("parse file " + file.getAbsolutePath() + " error: " + de.getMessage()));
            return null;
        }
        catch (BOSException be) {
            logger.error((Object)("load metadata " + file.getAbsolutePath() + " error: " + be.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean editDeployObject(String filePath, List delegateList) {
        if (delegateList == null || delegateList.size() < 1 || filePath == null) {
            logger.error((Object)"\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u6709\u8bef\u6216\u53d1\u5e03\u5bf9\u8c61\u5217\u8868\u4e3a\u7a7a\uff01");
            return false;
        }
        File file = new File(filePath + "/WebServiceDeploy.xml");
        OutputStream os = null;
        try {
            Element root;
            Document doc;
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    logger.error((Object)"can not create configuration file");
                    boolean bl = false;
                    return bl;
                }
                doc = new Document();
                root = new Element(STR_DEPLOY_OBJECTS);
                doc.setRootElement(root);
            } else {
                logger.debug((Object)("read config file: " + file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                doc = builder.build(file);
                root = doc.getRootElement();
                if (!root.getName().equals(STR_DEPLOY_OBJECTS)) {
                    logger.error((Object)(file.getName() + "is not a valid file,root tag must be 'deployObjects'"));
                    boolean e = false;
                    return e;
                }
            }
            root.setContent(new ArrayList());
            int size = delegateList.size();
            for (int i = 0; i < size; ++i) {
                DeployConfigDelegate delegate = (DeployConfigDelegate)delegateList.get(i);
                BusinessObjectInfo object = delegate.getObject();
                List methodList = delegate.getMethodList();
                String type = STR_TYPE_ENTITY;
                if (object instanceof FacadeInfo) {
                    type = STR_TYPE_FACADE;
                }
                String name = object.getName();
                String pk = object.getPackage();
                String objName = object.getName();
                Element newObj = new Element(STR_DEPLOY_OBJECT);
                Element dType = new Element(STR_TYPE);
                dType.setText(type);
                newObj.addContent((Content)dType);
                Element dName = new Element(STR_NAME);
                dName.setText(name);
                newObj.addContent((Content)dName);
                Element dPk = new Element(STR_PACKAGE);
                dPk.setText(pk);
                newObj.addContent((Content)dPk);
                Element dMtd = new Element(STR_DEPLOY_METHODS);
                int msize = methodList.size();
                for (int j = 0; j < msize; ++j) {
                    MethodInfo met = (MethodInfo)methodList.get(j);
                    Element dmethod = new Element(STR_DEPLOY_METHOD);
                    dmethod.setAttribute(STR_ID, met.getInnerID());
                    dMtd.addContent((Content)dmethod);
                }
                newObj.addContent((Content)dMtd);
                root.addContent((Content)newObj);
            }
            Format format = Format.getCompactFormat();
            format.setEncoding("utf-8");
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outputter = new XMLOutputter(format);
            os = new FileOutputStream(file);
            outputter.output(doc, os);
            return true;
        }
        catch (IOException ie) {
            logger.error((Object)("read file " + file.getAbsolutePath() + " error: " + ie.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (JDOMException de) {
            logger.error((Object)("parse file " + file.getAbsolutePath() + " error: " + de.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

