/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.CustomizedAccess;
import com.kingdee.bos.metadata.access.MDAccess;
import com.kingdee.bos.metadata.access.MetaDataAccessLoader;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CommonQuery;
import com.kingdee.eas.base.commonquery.CommonQuerySelect;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.TreeNode;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CommonQueryAccess
extends CustomizedAccess<CommonQuerySelect, CommonQuery> {
    private static final String DEFAULT_F7_QUERY = "defaultF7Query";
    private static final String F7_DISPLAY_FORMAT = "displayFormat";
    private static final String F7_EDIT_FORMAT = "editFormat";
    private static final String F7_COMMIT_FORMAT = "commitFormat";
    private static final String DEFAULT_DISPLAY_FIELD = "defaultDisplayField";

    public CommonQueryAccess(Context ctx) {
        super(ctx);
    }

    public CommonQuery create(CommonQuerySelect select) throws BOSException {
        String fullName = select.getFullName();
        if (select.isQuery()) {
            QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)MetaDataPK.create((String)fullName));
            return this.create(queryInfo, select);
        }
        if (select.isEntityDefaultF7Query()) {
            fullName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)fullName)).getExtendedProperty(DEFAULT_F7_QUERY);
            QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)MetaDataPK.create((String)fullName));
            return this.create(queryInfo, select);
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)fullName));
        return this.create(entity, select);
    }

    private CommonQuery create(QueryInfo queryInfo, CommonQuerySelect select) throws BOSException {
        int i;
        String[] fields;
        queryInfo = (QueryInfo)MDAccess.getMDByLoader((Context)this.ctx, (AbstractMetaDataValue)queryInfo, (MetaDataAccessLoader.Description)select.getAccessLoader());
        CommonQuery query = new CommonQuery();
        if (select.orgTypeSelected()) {
            query.setOrgType(QueryUtils.getOrgType(queryInfo));
        }
        if ((fields = select.fieldRefMetaDataSelected()) != null) {
            DataObject[] dos = new DataObject[fields.length];
            for (i = 0; i < fields.length; ++i) {
                dos[i] = QueryUtils.getRefMetaData(this.ctx, queryInfo, fields[i]);
            }
            query.setFieldRefMetaData(dos);
        }
        if ((fields = select.fieldFormatSelected()) != null) {
            String[][] formats = new String[fields.length][3];
            int formatType = select.getFormatType();
            QueryFieldCollection queryFields = queryInfo.getUnits().getQueryFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                QueryFieldInfo queryFieldInfo = queryFields.get(fields[i2]);
                if (formatType == 1 || formatType == 3 || formatType == 5 || formatType == 7) {
                    String textField = queryFieldInfo.getExtendedProperty(F7_DISPLAY_FORMAT);
                    if (textField == null || textField.trim().equalsIgnoreCase("")) {
                        EntityObjectInfo entityObjectInfo = QueryUtils.getEntity(this.ctx, QueryUtils.getEntityName(queryInfo, fields[i2]));
                        textField = "$" + entityObjectInfo.getExtendedProperty(DEFAULT_DISPLAY_FIELD) + "$";
                    }
                    formats[i2][0] = textField;
                    continue;
                }
                if (formatType == 2 || formatType == 3 || formatType == 7) {
                    formats[i2][1] = queryFieldInfo.getExtendedProperty(F7_EDIT_FORMAT);
                    continue;
                }
                if (formatType != 4 && formatType != 5 && formatType != 7) continue;
                formats[i2][2] = queryFieldInfo.getExtendedProperty(F7_COMMIT_FORMAT);
            }
            query.setFieldFormat(formats);
        }
        if ((fields = select.fieldIsStringSelected()) != null) {
            boolean[] isString = new boolean[fields.length];
            for (i = 0; i < fields.length; ++i) {
                isString[i] = this.isString(queryInfo, fields[i]);
            }
            query.setFieldIsString(isString);
        }
        if (select.queryFilterTreeNodeSelected() && queryInfo instanceof JoinQueryInfo) {
            query.setQueryFilterTreeNode(this.buildQueryFilterTreeNode(queryInfo));
        }
        return query;
    }

    private TreeNode buildQueryFilterTreeNode(QueryInfo queryInfo) throws BOSException {
        SubObjectInfo mainInfo = queryInfo.getMainObject();
        DataObject dataObject = this.getDataObjectBySubObjectInfo(mainInfo);
        TreeNode root = new TreeNode(dataObject);
        Map<String, ArrayList<PropertyUnitInfo>> subObjectAndSonFieldsMap = this.getSubObjectAndSonFieldsMap(queryInfo);
        this.insertChildNode(root, mainInfo, subObjectAndSonFieldsMap);
        return root;
    }

    private void insertChildNode(TreeNode parentNode, SubObjectInfo objInfo, Map<String, ArrayList<PropertyUnitInfo>> subObjectAndSonFieldsMap) {
        JoinCollection joinColl = objInfo.getJoinsFromClient();
        JoinInfo joinInfo = null;
        int size = joinColl.size();
        for (int i = 0; i < size; ++i) {
            joinInfo = joinColl.get(i);
            SubObjectInfo rightInfo = joinInfo.getRightObject();
            DataObject dataObject = this.getDataObjectByJoinInfo(joinInfo);
            if (StringUtils.isEmpty((String)dataObject.getName())) {
                dataObject = this.getDataObjectBySubObjectInfo(rightInfo);
            }
            TreeNode tmpNode = new TreeNode(dataObject);
            if (!subObjectAndSonFieldsMap.containsKey(rightInfo.getName())) continue;
            parentNode.add(tmpNode);
            this.insertChildNode(tmpNode, rightInfo, subObjectAndSonFieldsMap);
        }
        this.insertLeafNode(parentNode, objInfo, subObjectAndSonFieldsMap);
    }

    private DataObject getDataObjectByJoinInfo(JoinInfo joinInfo) {
        DataObject dataObject = new DataObject();
        EntityObjectInfo parentEntityInfo = this.getEntityObjectInfo(joinInfo.getLeftObject());
        String fieldName = joinInfo.getRightObject().getName();
        PropertyCollection properties = parentEntityInfo.getInheritedDuplicatedProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo prop = properties.get(i);
            if (!fieldName.equals(prop.getName())) continue;
            dataObject.setName(prop.getAlias());
            dataObject.setValue(prop.getName());
            break;
        }
        return dataObject;
    }

    private DataObject getDataObjectBySubObjectInfo(SubObjectInfo objectInfo) {
        DataObject dataObject = new DataObject();
        EntityObjectInfo entityInfo = this.getEntityObjectInfo(objectInfo);
        if (entityInfo != null) {
            dataObject.setName(entityInfo.getAlias());
            dataObject.setValue(entityInfo.getName());
        }
        return dataObject;
    }

    private void insertLeafNode(TreeNode parentNode, SubObjectInfo objInfo, Map<String, ArrayList<PropertyUnitInfo>> subObjectAndSonFieldsMap) {
        String subObjectName = objInfo.getName();
        ArrayList<PropertyUnitInfo> sonFieldList = subObjectAndSonFieldsMap.get(subObjectName);
        if (sonFieldList == null) {
            return;
        }
        int size = sonFieldList.size();
        for (int i = 0; i < size; ++i) {
            QueryFieldInfo fieldInfo = (QueryFieldInfo)sonFieldList.get(i);
            DataObject dataObject = this.getDataObjectByFieldInfo(fieldInfo);
            parentNode.add(new TreeNode(dataObject));
        }
    }

    private DataObject getDataObjectByFieldInfo(QueryFieldInfo fieldInfo) {
        DataObject dataObject = new DataObject();
        dataObject.setName(fieldInfo.getDisplayName());
        dataObject.setValue(fieldInfo.getName());
        return dataObject;
    }

    private EntityObjectInfo getEntityObjectInfo(SubObjectInfo objInfo) {
        EntityObjectInfo eoInfo = null;
        if (objInfo instanceof SubEntityInfo) {
            SubEntityInfo seInfo = (SubEntityInfo)objInfo;
            eoInfo = seInfo.getEntityRef();
        }
        return eoInfo;
    }

    private Map<String, ArrayList<PropertyUnitInfo>> getSubObjectAndSonFieldsMap(QueryInfo queryInfo) {
        HashMap<String, ArrayList<PropertyUnitInfo>> ret = new HashMap<String, ArrayList<PropertyUnitInfo>>();
        PropertyUnitCollection units = queryInfo.getUnits();
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            PropertyRefCollection proRefCol;
            PropertyUnitInfo unit = units.get(i);
            if (!(unit instanceof QueryFieldInfo) || !"true".equalsIgnoreCase(unit.getExtendedProperty("isCommonQueryFilter")) || (proRefCol = unit.getPropertyRefs()) == null || proRefCol.size() != 1) continue;
            PropertyRefInfo proRefInfo = proRefCol.get(0);
            String subEntityName = proRefInfo.getSubEntity().getName();
            ArrayList fieldList = ret.containsKey(subEntityName) ? (ArrayList)ret.get(subEntityName) : new ArrayList();
            fieldList.add(unit);
            ret.put(subEntityName, fieldList);
        }
        return ret;
    }

    private static boolean isString(PropertyInfo ownPropertyInfo) {
        if (ownPropertyInfo instanceof OwnPropertyInfo) {
            return DataType.STRING.equals((Object)((OwnPropertyInfo)ownPropertyInfo).getDataType());
        }
        return false;
    }

    private boolean isString(QueryInfo queryInfo, String queryFieldName) throws BOSException {
        UnionQueryInfo uqInfo;
        SubObjectInfo subObj;
        if (queryInfo instanceof UnionQueryInfo && (subObj = (uqInfo = (UnionQueryInfo)queryInfo).getMainObject()) instanceof SubQueryInfo) {
            queryInfo = ((SubQueryInfo)subObj).getQueryRef();
        }
        QueryFieldInfo fieldInfo = queryInfo.getUnits().getQueryFields().get(queryFieldName);
        String entityNameInQueryField = null;
        PropertyRefCollection refCol = fieldInfo.getPropertyRefs();
        if (refCol == null || refCol.size() < 1) {
            return DataType.STRING.getName().equals(fieldInfo.getReturnType().getName());
        }
        if (refCol.get(0).getSubEntity() == null) {
            QueryInfo subQueryInfo = refCol.get(0).getSubQuery().getQueryRef();
            queryFieldName = queryFieldName.substring(queryFieldName.indexOf(".") + 1);
            return this.isString(subQueryInfo, queryFieldName);
        }
        entityNameInQueryField = refCol.get(0).getSubEntity().getName();
        String entityProperty = refCol.get(0).getRefProperty().getName();
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubEntityInfo subEntityInfo;
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (!(subObjectInfo instanceof SubEntityInfo) || !(subEntityInfo = (SubEntityInfo)subObjectInfo).getName().equalsIgnoreCase(entityNameInQueryField)) continue;
            String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName)).getPropertyByName(entityProperty);
            return CommonQueryAccess.isString((PropertyInfo)ownPropertyInfo);
        }
        return false;
    }

    private CommonQuery create(EntityObjectInfo entity, CommonQuerySelect select) throws BOSException {
        int i;
        CommonQuery query = new CommonQuery();
        String[] fields = select.fieldRefMetaDataSelected();
        if (fields != null) {
            DataObject[] dos = new DataObject[fields.length];
            for (i = 0; i < fields.length; ++i) {
                dos[i] = this.getRefMetaData(entity, fields[i]);
                dos[i].setOwner(fields[i]);
            }
            query.setFieldRefMetaData(dos);
        }
        if ((fields = select.fieldIsStringSelected()) != null) {
            boolean[] isString = new boolean[fields.length];
            for (i = 0; i < fields.length; ++i) {
                EntityObjectInfo tmp = CommonQueryAccess.getEntity(entity, fields[i]);
                isString[i] = CommonQueryAccess.isString(tmp.getPropertyByName(CommonQueryAccess.getPropertyName(fields[i])));
            }
            query.setFieldIsString(isString);
        }
        return query;
    }

    private DataObject getRefMetaData(EntityObjectInfo entity, String propertiyName) {
        if (propertiyName.indexOf(".") > 0) {
            entity = CommonQueryAccess.getEntity(entity, propertiyName);
            propertiyName = propertiyName.substring(propertiyName.lastIndexOf(".") + 1);
        }
        DataObject dataObject = null;
        PropertyCollection propertyCollection = CommonQueryAccess.getAllEntityProperties(entity);
        int size = propertyCollection.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            String propName = propertyInfo.getName();
            if (!propName.toLowerCase().equalsIgnoreCase(propertiyName.toLowerCase())) continue;
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    String enumName = ownPropertyInfo.getMetaDataRef();
                    BizEnumInfo enum1 = CommonQueryAccess.getEnum(this.ctx, enumName);
                    if (enum1.isDynamic()) {
                        dataObject.setValue(enumName);
                    } else {
                        dataObject.setValue(enum1.getClassName());
                    }
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(BooleanEnum.class.getName());
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.DATE) || ownPropertyInfo.getDataType().equals((Object)DataType.TIMESTAMP) || ownPropertyInfo.getDataType().equals((Object)DataType.TIME)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(null);
                    return dataObject;
                }
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(entity.getFullName());
                return dataObject;
            }
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            EntityObjectInfo refEntity = CommonQueryAccess.getEntity(entity.getFullName(), linkPropertyInfo);
            String refEntityName = refEntity.getFullName();
            dataObject = new DataObject();
            if (QueryUtils.isSimpleEntity(refEntity)) {
                dataObject.setName("SIMPLE_ENTITY");
                dataObject.setValue(refEntityName);
                return dataObject;
            }
            return this.getRefMetaData(refEntity, propertiyName);
        }
        return dataObject;
    }

    private static EntityObjectInfo getEntity(EntityObjectInfo mainEntity, String propertyValue) {
        EntityObjectInfo entity = mainEntity;
        PropertyCollection propertyCollection = CommonQueryAccess.getAllEntityProperties(entity);
        int size = propertyCollection.size();
        StringTokenizer stringTokenizer = new StringTokenizer(propertyValue, ".");
        String temp = stringTokenizer.nextToken();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(temp)) continue;
            if (stringTokenizer.hasMoreTokens()) {
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                entity = CommonQueryAccess.getEntity(CommonQueryAccess.getEntity(entity.getFullName(), linkPropertyInfo), propertyValue.substring(propertyValue.indexOf(".") + 1));
            }
            return entity;
        }
        return entity;
    }

    private static EntityObjectInfo getEntity(String mainEntityName, LinkPropertyInfo linkPropertyInfo) {
        String tempEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        if (!tempEntityName.equalsIgnoreCase(mainEntityName)) {
            return linkPropertyInfo.getRelationship().getSupplierObject();
        }
        return linkPropertyInfo.getRelationship().getClientObject();
    }

    private static String getPropertyName(String str) {
        int index = str.lastIndexOf(".");
        if (index != 0) {
            str = str.substring(index + 1);
        }
        return str;
    }

    private static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    private static BizEnumInfo getEnum(Context ctx, String enumName) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)enumName));
    }
}

