/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols;

import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.eas.framework.query.component.IQueryTextField;
import com.kingdee.eas.framework.query.component.KDRoundRectLabel;
import com.kingdee.eas.framework.query.component.QueryTextField;
import com.kingdee.eas.framework.util.StringUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;

public class ItemLabel
extends KDLabel {
    private static final long serialVersionUID = 4863940881798261907L;
    private static final Color Color_Item = new Color(157, 180, 198);
    private static final Color Color_Item_Over = new Color(132, 157, 179);
    static final Color Color_Text = new Color(221, 230, 235);
    private static final Color Color_Text_Over = new Color(188, 222, 250);
    static final int R_TEXT = 3;
    static final int textGap = 2;
    static final int textSpace = 6;
    static final int H_ITEM = 17;
    private int MAX_W_TEXT = 90;
    private int W_LABEL = 60;
    private static final int L_LABEL = 8;
    protected KDCommonPromptDialog.FilterFieldItem listItem;
    protected KDLabel textLabel;
    protected int widthText = 22;
    protected IQueryTextField queryTextField;
    private boolean itemLabelAtFirst = true;
    private boolean itemLabelNeedOverState = true;

    public void setMaxTextLabelWidth(int width) {
        this.MAX_W_TEXT = width;
    }

    public void setItemLabelNeedOverState(boolean itemLabelNeedOverState) {
        this.itemLabelNeedOverState = itemLabelNeedOverState;
    }

    public void setItemLabelAtFirst(boolean itemLabelAtFirst) {
        this.itemLabelAtFirst = itemLabelAtFirst;
    }

    public KDCommonPromptDialog.FilterFieldItem getListItem() {
        return this.listItem;
    }

    private String getListPopupItemText(KDCommonPromptDialog.FilterFieldItem filterItem) {
        String text = filterItem.toString();
        int length = StringUtility.length((String)text);
        text = length > 8 ? " " + StringUtility.substring((String)text, (int)8) + "..." : "  " + text;
        return text;
    }

    public void setItemLabelWidth(int width) {
        this.W_LABEL = width;
    }

    public int getItemLabelWidth() {
        return this.W_LABEL;
    }

    public ItemLabel(IQueryTextField queryTextField, KDCommonPromptDialog.FilterFieldItem listPopupItem) {
        this.queryTextField = queryTextField;
        String text = this.getListPopupItemText(listPopupItem);
        this.setText(text);
        if (listPopupItem == null) {
            throw new IllegalArgumentException("ListPopupItem=" + listPopupItem);
        }
        this.listItem = listPopupItem;
        this.setToolTipText(listPopupItem.toString());
        this.textLabel = this.createTextLabel(listPopupItem);
        this.initLabel();
        this.initTextLabel();
    }

    protected KDLabel createTextLabel(KDCommonPromptDialog.FilterFieldItem listPopupItem) {
        return new KDRoundRectLabel(listPopupItem.getValue(), 3);
    }

    KDLabel getTextLabel() {
        return this.textLabel;
    }

    public int getWidth() {
        return this.W_LABEL + this.widthText + 2;
    }

    public boolean contains(Point p) {
        return super.contains(p) || this.textLabel.contains(p);
    }

    private void initLabel() {
        this.setSize(this.W_LABEL, 17);
        this.setPreferredSize(new Dimension(this.W_LABEL, 17));
        this.setBounds(0, 0, this.W_LABEL, 17);
        if (this.itemLabelNeedOverState) {
            this.setBackground(Color_Item);
            this.setForeground(Color.WHITE);
        }
        this.setOpaque(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void initTextLabel() {
        this.textLabel.setSize(this.widthText, 17);
        this.textLabel.setPreferredSize(new Dimension(this.widthText, 17));
        this.textLabel.setBounds(0, 0, this.widthText, 17);
        this.textLabel.setBackground(Color_Text);
        this.textLabel.setForeground(Color.BLACK);
        this.textLabel.setOpaque(true);
        this.textLabel.setHorizontalAlignment(0);
    }

    public void paint(Graphics g) {
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, this.W_LABEL, this.getHeight(), 3.0, 3.0);
        g.setClip(rect);
        super.paint(g);
    }

    public int paint(Graphics2D g2d, int x, int y) {
        if (this.itemLabelAtFirst) {
            x = this.paintItemLabel(g2d, x, y);
            x = this.paintTextLabel(g2d, x, y);
        } else {
            x = this.paintTextLabel(g2d, x, y);
            x = this.paintItemLabel(g2d, x, y);
        }
        return x;
    }

    protected int paintItemLabel(Graphics2D g2d, int x, int y) {
        this.queryTextField.getCellRendererPane().paintComponent(g2d, (Component)((Object)this), (Container)((Object)this), x, y, this.W_LABEL, 17);
        x = x + this.W_LABEL + (this.itemLabelAtFirst ? 2 : QueryTextField.iconGap);
        return x;
    }

    protected int paintTextLabel(Graphics2D g2d, int x, int y) {
        FontMetrics fm = g2d.getFontMetrics();
        int width = fm.stringWidth(this.listItem.getValue()) + 6;
        if (width != this.widthText) {
            this.widthText = width;
            if (this.widthText > this.MAX_W_TEXT) {
                this.widthText = this.MAX_W_TEXT;
            }
            this.textLabel.setSize(this.widthText, 17);
            this.textLabel.setPreferredSize(new Dimension(this.widthText, 17));
            this.textLabel.setBounds(0, 0, this.widthText, 17);
        }
        this.queryTextField.getCellRendererPane().paintComponent(g2d, (Component)this.getTextLabel(), (Container)((Object)this), x, y, this.widthText, 17);
        x = x + this.widthText + (this.itemLabelAtFirst ? QueryTextField.iconGap : 0);
        return x;
    }

    void setMouseState(boolean isOver, int x) {
        if (!isOver) {
            if (this.itemLabelNeedOverState) {
                this.setBackground(Color_Item);
            }
            this.textLabel.setBackground(Color_Text);
            return;
        }
        this.setMouseState(x);
    }

    private void setMouseState(int x) {
        if (this.itemLabelAtFirst) {
            if (x > this.W_LABEL) {
                this.setTextLabelOverMouseState();
            } else {
                this.setItemLabelOverMouseState();
            }
        } else if (x > this.widthText) {
            this.setItemLabelOverMouseState();
        } else {
            this.setTextLabelOverMouseState();
        }
    }

    private void setItemLabelOverMouseState() {
        if (this.itemLabelNeedOverState) {
            this.setBackground(Color_Item_Over);
        }
        this.textLabel.setBackground(Color_Text);
    }

    private void setTextLabelOverMouseState() {
        if (this.itemLabelNeedOverState) {
            this.setBackground(Color_Item);
        }
        this.textLabel.setBackground(Color_Text_Over);
    }

    MouseListener[] getMouseListeners(int x) {
        if (this.itemLabelAtFirst) {
            if (x > this.W_LABEL) {
                return this.textLabel.getMouseListeners();
            }
            return this.getMouseListeners();
        }
        if (x > this.widthText) {
            return this.getMouseListeners();
        }
        return this.textLabel.getMouseListeners();
    }

    MouseMotionListener[] getMouseMotionListeners(int x) {
        if (this.itemLabelAtFirst) {
            if (x > this.W_LABEL) {
                return this.textLabel.getMouseMotionListeners();
            }
            return this.getMouseMotionListeners();
        }
        if (x > this.widthText) {
            return this.getMouseMotionListeners();
        }
        return this.textLabel.getMouseMotionListeners();
    }
}

