/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class QueryAgent {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ctrl.extendcontrols.QueryAgent");
    protected static final String OBJECTDISPLAYSPLITTER = ";";
    private boolean isCapitalSensitiveQuery = false;
    private boolean isAutoIgnoreDuplicatedRow = true;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean hasCUDefaultFilter = true;
    private boolean handleCUFilter = true;
    protected MetaDataPK queryInfoPK;
    protected EntityViewInfo entityView;
    private FilterInfo defaultFilter;
    protected EntityViewInfo runtimeEntityView;
    protected SelectorItemCollection selectorCollection;
    protected boolean enabledMultiSelection = false;
    protected int returnValueType = 0;
    protected IQueryExecutor queryExecutor;
    private Context mainOrgContext = null;

    public void setAutoIgnoreDuplicatedRow(boolean isAutoIgnoreDuplicatedRow) {
        this.isAutoIgnoreDuplicatedRow = isAutoIgnoreDuplicatedRow;
    }

    public QueryAgent() {
        String capitalSensitiveQuery = ParamHelper.getCapitalSensitiveQuery();
        if (capitalSensitiveQuery != null && capitalSensitiveQuery.equalsIgnoreCase("true")) {
            this.isCapitalSensitiveQuery = true;
        }
    }

    public boolean getHasCUDefaultFilter() {
        return this.hasCUDefaultFilter;
    }

    public void setHasCUDefaultFilter(boolean hasCUDefaultFilter) {
        this.hasCUDefaultFilter = hasCUDefaultFilter;
    }

    public boolean isHandleCUFilter() {
        return this.handleCUFilter;
    }

    public void setHandleCUFilter(boolean handleCUFilter) {
        this.handleCUFilter = handleCUFilter;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    public MetaDataPK getQueryInfoPK() {
        return this.queryInfoPK;
    }

    public QueryInfo getQueryInfo() {
        return BosHelper.getQueryInfo(this.queryInfoPK);
    }

    public void setQueryInfoPK(MetaDataPK dataPK) {
        if (dataPK != null) {
            if (dataPK.equals((Object)this.queryInfoPK)) {
                return;
            }
            this.queryInfoPK = dataPK;
            this.setQueryExecutor(null);
            this.fireStateChanged();
        } else if (this.queryInfoPK != null) {
            this.queryInfoPK = null;
            this.setQueryExecutor(null);
            this.fireStateChanged();
        } else {
            return;
        }
    }

    public EntityViewInfo getEntityViewInfo() {
        return this.entityView;
    }

    public void setEntityViewInfo(EntityViewInfo v) {
        FilterInfo f;
        this.entityView = v;
        if (this.entityView != null && (f = this.entityView.getFilter()) == null) {
            f = new FilterInfo();
            this.entityView.setFilter(f);
        }
        this.fireStateChanged();
    }

    public void setDefaultFilterInfo(FilterInfo fi) {
        this.defaultFilter = fi;
    }

    public EntityViewInfo getRuntimeEntityView2() {
        if (this.runtimeEntityView == null) {
            if (this.entityView != null) {
                String str = this.getEntityViewInfo().toString();
                try {
                    this.runtimeEntityView = new EntityViewInfo(str);
                }
                catch (ParserException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                this.runtimeEntityView = new EntityViewInfo();
            }
            this.combineRuntimeFilterAndCU(this.runtimeEntityView);
        }
        return this.runtimeEntityView;
    }

    public EntityViewInfo getRuntimeEntityView() {
        if (this.runtimeEntityView == null) {
            if (this.entityView != null) {
                String str = this.getEntityViewInfo().toString();
                try {
                    this.runtimeEntityView = new EntityViewInfo(str);
                }
                catch (ParserException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                this.runtimeEntityView = new EntityViewInfo();
            }
            this.combineRuntimeFilterAndCU(this.runtimeEntityView);
            try {
                this.combineRuntimeFilterWithDefaultFilter(this.runtimeEntityView);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.runtimeEntityView;
    }

    private void combineRuntimeFilterWithDefaultFilter(EntityViewInfo rtevi) throws Exception {
        if (this.defaultFilter != null && this.defaultFilter.getFilterItems().size() != 0) {
            FilterInfo fi = this.cloneDefaultFilter();
            if (rtevi.getFilter() == null || rtevi.getFilter().getFilterItems().size() == 0) {
                rtevi.setFilter(fi);
            } else {
                rtevi.getFilter().mergeFilter(fi, "and");
            }
        }
    }

    private FilterInfo cloneDefaultFilter() {
        FilterInfo fi = null;
        try {
            fi = new FilterInfo(this.defaultFilter.toString());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return fi;
    }

    public void resetRuntimeEntityView() {
        this.runtimeEntityView = null;
    }

    public SelectorItemCollection getSelectorCollection() {
        return this.selectorCollection;
    }

    public void setSelectorCollection(SelectorItemCollection collection) {
        this.selectorCollection = collection;
    }

    public boolean isEnabledMultiSelection() {
        return this.enabledMultiSelection;
    }

    public void setEnabledMultiSelection(boolean b) {
        this.enabledMultiSelection = b;
    }

    public int getReturnValueType() {
        return this.returnValueType;
    }

    public void setReturnValueType(int i) {
        this.returnValueType = i;
    }

    public IQueryExecutor getQueryExecutor() {
        MetaDataPK pk;
        if ((this.queryExecutor == null || this.mainOrgContext != null) && (pk = this.getQueryInfoPK()) != null) {
            this.queryExecutor = BosHelper.createQueryExecutor(pk, this.mainOrgContext);
            boolean isAdmin = UserType.SYSTEM.equals((Object)SysContext.getSysContext().getCurrentUserInfo().getType());
            if (isAdmin) {
                this.queryExecutor.option().isIgnorePermissionCheck = true;
            }
            this.queryExecutor.option().isAutoIgnoreDuplicatedRow = this.isAutoIgnoreDuplicatedRow;
        }
        return this.queryExecutor;
    }

    public Context getMainOrgContext() {
        return this.mainOrgContext;
    }

    public void setMainOrgContext(Context mainOrgContext) {
        this.mainOrgContext = mainOrgContext;
    }

    public void switchMainOrgContext(String orgID) {
        if (this.mainOrgContext == null) {
            this.mainOrgContext = new Context();
        }
        try {
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)orgID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setQueryExecutor(IQueryExecutor exec) {
        this.queryExecutor = exec;
    }

    public boolean upgradeEntityViewFromOrigin(Map[] maps) {
        if (maps == null || maps.length < 1) {
            return false;
        }
        this.initFilterObjects();
        EntityViewInfo view = this.getRuntimeEntityView();
        FilterInfo fi = view.getFilter();
        if (fi == null) {
            fi = new FilterInfo();
            view.setFilter(fi);
        }
        boolean segBracket = false;
        StringBuffer str = new StringBuffer();
        FilterItemCollection coll = fi.getFilterItems();
        int index = coll.size();
        String maskString = fi.getMaskString();
        if (index > 0) {
            if (maskString == null || maskString.length() < 1) {
                return false;
            }
            if (index > 1) {
                segBracket = true;
            }
            if (segBracket) {
                str.append('(');
            }
            str.append(maskString);
            if (segBracket) {
                str.append(')');
            }
            str.append(" and ");
        } else {
            index = 0;
        }
        String key = null;
        String value = null;
        Set keys = null;
        boolean childBracket = false;
        segBracket = index > 0 && maps.length > 1;
        if (segBracket) {
            str.append('(');
        }
        for (int i = 0; i < maps.length; ++i) {
            if (maps[i].size() > 1) {
                childBracket = true;
            }
            if (childBracket) {
                str.append('(');
            }
            keys = maps[i].keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = (String)maps[i].get(key);
                String[] subValues = value.split(OBJECTDISPLAYSPLITTER);
                if (subValues != null) {
                    if (subValues.length > 0) {
                        str.append('(');
                    }
                    for (int isub = 0; isub < subValues.length; ++isub) {
                        FilterItemInfo item = null;
                        ObjectUuidPK userId = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
                        if (this.isCapitalSensitiveQuery) {
                            item = new FilterItemInfo(key, (Object)ParamHelper.getMatchString(key, subValues[isub].trim(), this.queryInfoPK == null ? "" : this.queryInfoPK.getFullName(), (IObjectPK)userId), CompareType.LIKE);
                        } else {
                            String oql = "upper(" + key + ") like '" + ParamHelper.getMatchString(key, subValues[isub].trim(), this.queryInfoPK == null ? "" : this.queryInfoPK.getFullName(), (IObjectPK)userId).toUpperCase() + "'";
                            item = new FilterItemInfo(oql);
                        }
                        coll.add(item);
                        str.append(" #" + index);
                        ++index;
                        if (isub >= subValues.length - 1) continue;
                        str.append(" or ");
                    }
                    if (subValues.length > 0) {
                        str.append(')');
                    }
                }
                if (!it.hasNext()) continue;
                str.append(" and ");
            }
            if (childBracket) {
                str.append(')');
            }
            if (i >= maps.length - 1) continue;
            str.append(" or ");
        }
        if (segBracket) {
            str.append(')');
        }
        fi.setMaskString(str.toString());
        return true;
    }

    public boolean upgradeEntityViewFromOriginEqual(Map[] maps) {
        if (maps == null || maps.length < 1) {
            return false;
        }
        this.initFilterObjects();
        this.resetRuntimeEntityView();
        EntityViewInfo view = this.getRuntimeEntityView();
        FilterInfo fi = view.getFilter();
        if (fi == null) {
            fi = new FilterInfo();
            view.setFilter(fi);
        }
        boolean segBracket = false;
        StringBuffer str = new StringBuffer();
        FilterItemCollection coll = fi.getFilterItems();
        int index = coll.size();
        String maskString = fi.getMaskString();
        if (index > 0) {
            if (maskString == null || maskString.length() < 1) {
                return false;
            }
            if (index > 1) {
                segBracket = true;
            }
            if (segBracket) {
                str.append('(');
            }
            str.append(maskString);
            if (segBracket) {
                str.append(')');
            }
            str.append(" and ");
        } else {
            index = 0;
        }
        String key = null;
        String value = null;
        Set keys = null;
        boolean childBracket = false;
        segBracket = index > 0 && maps.length > 1;
        if (segBracket) {
            str.append('(');
        }
        for (int i = 0; i < maps.length; ++i) {
            if (maps[i].size() > 1) {
                childBracket = true;
            }
            if (childBracket) {
                str.append('(');
            }
            keys = maps[i].keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = (String)maps[i].get(key);
                String[] subValues = value.split(OBJECTDISPLAYSPLITTER);
                if (subValues != null) {
                    if (subValues.length > 0) {
                        str.append('(');
                    }
                    for (int isub = 0; isub < subValues.length; ++isub) {
                        coll.add(new FilterItemInfo(key, (Object)subValues[isub].trim(), CompareType.EQUALS));
                        str.append(" #" + index);
                        ++index;
                        if (isub >= subValues.length - 1) continue;
                        str.append(" or ");
                    }
                    if (subValues.length > 0) {
                        str.append(')');
                    }
                }
                if (!it.hasNext()) continue;
                str.append(" and ");
            }
            if (childBracket) {
                str.append(')');
            }
            if (i >= maps.length - 1) continue;
            str.append(" or ");
        }
        if (segBracket) {
            str.append(')');
        }
        fi.setMaskString(str.toString());
        return true;
    }

    public boolean upgradeEntityViewFromOriginLike(Map[] maps) {
        int isub;
        String[] subValues;
        Iterator it;
        int i;
        if (maps == null || maps.length < 1) {
            return false;
        }
        this.initFilterObjects();
        EntityViewInfo view = this.getRuntimeEntityView();
        FilterInfo fi = view.getFilter();
        if (fi == null) {
            fi = new FilterInfo();
            view.setFilter(fi);
        }
        boolean segBracket = false;
        StringBuffer str = new StringBuffer();
        FilterItemCollection coll = fi.getFilterItems();
        int index = coll.size();
        String maskString = fi.getMaskString();
        if (index > 0) {
            if (maskString == null || maskString.length() < 1) {
                return false;
            }
            if (index > 1) {
                segBracket = true;
            }
            if (segBracket) {
                str.append('(');
            }
            str.append(maskString);
            if (segBracket) {
                str.append(')');
            }
            str.append(" and ");
        } else {
            index = 0;
        }
        String key = null;
        String value = null;
        Set keys = null;
        boolean childBracket = false;
        segBracket = index > 0 && maps.length > 1;
        if (segBracket) {
            str.append('(');
        }
        for (i = 0; i < maps.length; ++i) {
            if (maps[i].size() > 1) {
                childBracket = true;
            }
            if (childBracket) {
                str.append('(');
            }
            keys = maps[i].keySet();
            it = keys.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = (String)maps[i].get(key);
                subValues = value.split(OBJECTDISPLAYSPLITTER);
                if (subValues != null) {
                    if (subValues.length > 0) {
                        str.append('(');
                    }
                    for (isub = 0; isub < subValues.length; ++isub) {
                        str.append('(');
                        coll.add(new FilterItemInfo(key, null, CompareType.EQUALS));
                        str.append(" #" + index);
                        str.append(" or ");
                        coll.add(new FilterItemInfo(key, (Object)subValues[isub].trim(), CompareType.NOTEQUALS));
                        str.append(" #" + ++index);
                        ++index;
                        str.append(')');
                        if (isub >= subValues.length - 1) continue;
                        str.append(" and ");
                    }
                    if (subValues.length > 0) {
                        str.append(')');
                    }
                }
                if (!it.hasNext()) continue;
                str.append(" and ");
            }
            if (childBracket) {
                str.append(')');
            }
            if (i >= maps.length - 1) continue;
            str.append(" and ");
        }
        str.append(" and ");
        str.append('(');
        for (i = 0; i < maps.length; ++i) {
            if (maps[i].size() > 1) {
                childBracket = true;
            }
            if (childBracket) {
                str.append('(');
            }
            keys = maps[i].keySet();
            it = keys.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = (String)maps[i].get(key);
                subValues = value.split(OBJECTDISPLAYSPLITTER);
                if (subValues != null) {
                    if (subValues.length > 0) {
                        str.append('(');
                    }
                    for (isub = 0; isub < subValues.length; ++isub) {
                        FilterItemInfo item = null;
                        ObjectUuidPK userId = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
                        if (this.isCapitalSensitiveQuery) {
                            item = new FilterItemInfo(key, (Object)ParamHelper.getMatchString(key, subValues[isub].trim(), this.queryInfoPK == null ? "" : this.queryInfoPK.getFullName(), (IObjectPK)userId), CompareType.LIKE);
                        } else {
                            String oql = "upper(" + key + ") like '" + ParamHelper.getMatchString(key, subValues[isub].trim(), this.queryInfoPK == null ? "" : this.queryInfoPK.getFullName(), (IObjectPK)userId).toUpperCase() + "'";
                            oql = this.fixOql(oql);
                            item = new FilterItemInfo(oql);
                        }
                        coll.add(item);
                        str.append(" #" + index);
                        ++index;
                        if (isub >= subValues.length - 1) continue;
                        str.append(" or ");
                    }
                    if (subValues.length > 0) {
                        str.append(')');
                    }
                }
                if (!it.hasNext()) continue;
                str.append(" and ");
            }
            if (childBracket) {
                str.append(')');
            }
            if (i >= maps.length - 1) continue;
            str.append(" or ");
        }
        str.append(')');
        if (segBracket) {
            str.append(')');
        }
        fi.setMaskString(str.toString());
        return true;
    }

    private void initFilterObjects() {
        EntityViewInfo view = this.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
            this.setEntityViewInfo(view);
        }
    }

    public IRowSet executeQuery(int start, int length) {
        if (length == 0) {
            return null;
        }
        IRowSet rowset = null;
        IQueryExecutor exec = this.getQueryExecutor();
        if (exec == null) {
            logger.warn((Object)"warning: \u67e5\u8be2\u6267\u884c\u4f53\u4e3a\u7a7a!");
            return null;
        }
        EntityViewInfo info = this.getRuntimeEntityView();
        if (info.getSorter() != null && info.getSorter().size() > 0) {
            exec.option().isIgnoreOrder = true;
        }
        logger.debug((Object)("entityviewInfo:" + info == null ? "" : info.toString()));
        exec.setObjectView(info);
        try {
            rowset = length < 0 ? exec.executeQuery() : exec.executeQuery(start, length);
        }
        catch (BOSException e) {
            logger.error((Object)"execute query error:", (Throwable)e);
        }
        this.resetRuntimeEntityView();
        return rowset;
    }

    private void combineRuntimeFilterAndCU(EntityViewInfo currentViewInfo) {
        if (this.hasCUDefaultFilter && this.handleCUFilter && this.isCUNeeded() && currentViewInfo != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cu.longnumber", (Object)(SysContext.getSysContext().getCurrentCtrlUnit().getNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1 or #2 or #3");
            if (currentViewInfo.getFilter() != null) {
                try {
                    currentViewInfo.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                currentViewInfo.setFilter(filter);
            }
        }
    }

    private boolean isCUNeeded() {
        if (this.queryInfoPK == null) {
            return false;
        }
        boolean cuNeeded = false;
        try {
            QuerySelect select = new QuerySelect(this.queryInfoPK.getFullName());
            select.setDependProject((Project.Projects)this.queryInfoPK.getKeyValue("dependProject"));
            select.mainEntitySelect().propertySelect().select("cu", "name");
            SimpleQuery query = MetaDataAccessFactory.getRemoteInstance().select(select);
            cuNeeded = query.mainEntity().property("cu") != null;
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return cuNeeded;
    }

    private String fixOql(String oql) {
        if (StringUtils.isEmpty((String)oql)) {
            return "";
        }
        StringBuilder string = new StringBuilder(oql);
        String ch = "'";
        int first = string.indexOf(ch);
        string.deleteCharAt(string.length() - 1);
        String replace = "";
        if (first + 1 <= string.length()) {
            replace = string.substring(first + 1);
            replace = replace.replaceAll("\\'", "''");
            string.replace(first + 1, string.length(), replace);
        }
        string.append("'");
        return string.toString();
    }
}

