/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.rpa.IRpaServers;
import com.kingdee.eas.base.rpa.RpaClientInfo;
import com.kingdee.eas.base.rpa.RpaServersFactory;
import com.kingdee.eas.base.rpa.RpaServersInfo;
import com.kingdee.eas.base.rpa.app.AbstractRpaClientControllerBean;
import com.kingdee.eas.base.rpa.app.RpaClientStaus;
import com.kingdee.eas.base.rpa.app.rpaSrv.YsqRpaServer;
import com.kingdee.eas.base.rpa.util.Json;
import com.kingdee.eas.base.rpa.util.RPAAESUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RpaClientControllerBean
extends AbstractRpaClientControllerBean {
    @Override
    protected void _syncRpaClient(Context ctx, String rpaServerId) throws BOSException, EASBizException {
        IRpaServers iRpaServers = RpaServersFactory.getLocalInstance(ctx);
        ObjectStringPK rpaServerPk = new ObjectStringPK(rpaServerId);
        RpaServersInfo rpaServersInfo = (RpaServersInfo)iRpaServers.getValue((IObjectPK)rpaServerPk);
        iRpaServers.checkServerConn(rpaServersInfo);
        List<RpaClientInfo> rpaClient = null;
        switch (rpaServersInfo.getRpaType().getValue()) {
            case 2: {
                rpaClient = this.getYsqRpaClient(rpaServersInfo);
                break;
            }
            default: {
                rpaClient = this.getYsqRpaClient(rpaServersInfo);
            }
        }
        this.updateProcesses(ctx, rpaServerId, rpaClient);
    }

    private void updateProcesses(Context ctx, String rpaServerId, List<RpaClientInfo> rpaClients) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < rpaClients.size(); ++i) {
            colls.add((CoreBaseInfo)rpaClients.get(i));
        }
        this.delete(ctx, "where rpaServer.id='" + rpaServerId + "'");
        this.addnewBatchData(ctx, colls);
    }

    private List<RpaClientInfo> getYsqRpaClient(Context ctx, String rpaServerId) throws BOSException, EASBizException {
        IRpaServers iRpaServers = RpaServersFactory.getLocalInstance(ctx);
        ObjectStringPK rpaServerPk = new ObjectStringPK(rpaServerId);
        iRpaServers.checkServerConn(rpaServerPk.toString());
        RpaServersInfo rpaServersInfo = (RpaServersInfo)iRpaServers.getValue((IObjectPK)rpaServerPk);
        return this.getYsqRpaClient(rpaServersInfo);
    }

    private List<RpaClientInfo> getYsqRpaClient(RpaServersInfo rpaServersInfo) throws BOSException {
        ArrayList<RpaClientInfo> rpaClients = new ArrayList<RpaClientInfo>();
        String ysqRpaClients = null;
        try {
            RPAAESUtils.IS_PRIVACY_SECRET.set(false);
            String ysqToken = YsqRpaServer.getYsqToken(rpaServersInfo.getHttpUrl(), rpaServersInfo.getAppkey(), rpaServersInfo.getAppsecret());
            ysqRpaClients = YsqRpaServer.getYsqRobots(rpaServersInfo.getHttpUrl(), ysqToken);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Json rtJson = new Json(ysqRpaClients);
        Integer code = rtJson.getValue("code", Integer.class);
        if ("0".equals(code.toString())) {
            int total = rtJson.getValue("result.total", Integer.class);
            if (total > 0) {
                Map[] items;
                for (Map item : items = rtJson.getValue("result.items", Map[].class)) {
                    RpaClientInfo rpaClient = new RpaClientInfo();
                    rpaClient.setAgentNo((String)item.get("agentNo"));
                    rpaClient.setAgentName((String)item.get("agentName"));
                    rpaClient.setAgentAlias((String)item.get("agentAlias"));
                    rpaClient.setAgentIp((String)item.get("agentIp"));
                    rpaClient.setRpaUserName((String)item.get("rpaUserName"));
                    rpaClient.setUserName((String)item.get("userName"));
                    rpaClient.setUserDomain((String)item.get("userDomain"));
                    rpaClient.setDataStatus(RpaClientStaus.getEnum((String)item.get("dataStatus")));
                    rpaClient.setRpaServer(rpaServersInfo);
                    rpaClients.add(rpaClient);
                }
            }
        } else {
            throw new BOSException("getYsqClients fail...");
        }
        return rpaClients;
    }
}

