/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.rpa.IRpaProcesses;
import com.kingdee.eas.base.rpa.IRpaServers;
import com.kingdee.eas.base.rpa.RpaProcessParamInfo;
import com.kingdee.eas.base.rpa.RpaProcessesFactory;
import com.kingdee.eas.base.rpa.RpaProcessesInfo;
import com.kingdee.eas.base.rpa.RpaServersFactory;
import com.kingdee.eas.base.rpa.RpaServersInfo;
import com.kingdee.eas.base.rpa.app.AbstractRpaProcessParamControllerBean;
import com.kingdee.eas.base.rpa.app.ProcessParamType;
import com.kingdee.eas.base.rpa.app.RpaException;
import com.kingdee.eas.base.rpa.app.rpaSrv.YsqRpaServer;
import com.kingdee.eas.base.rpa.util.Json;
import com.kingdee.eas.base.rpa.util.RPAAESUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RpaProcessParamControllerBean
extends AbstractRpaProcessParamControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.rpa.app.RpaProcessParamControllerBean");

    @Override
    protected void _syncRpaProcessParams(Context ctx, String rpaProcessId) throws BOSException, EASBizException {
        IRpaProcesses iRpaProcesses = RpaProcessesFactory.getLocalInstance(ctx);
        ObjectStringPK rpaProcessPk = new ObjectStringPK(rpaProcessId);
        RpaProcessesInfo rpaProcessesInfo = (RpaProcessesInfo)iRpaProcesses.getValue((IObjectPK)rpaProcessPk);
        IRpaServers iRpaServers = RpaServersFactory.getLocalInstance(ctx);
        ObjectStringPK rpaServerPk = new ObjectStringPK(rpaProcessesInfo.getRpaServer().getId().toString());
        RpaServersInfo rpaServersInfo = (RpaServersInfo)iRpaServers.getValue((IObjectPK)rpaServerPk);
        iRpaServers.checkServerConn(rpaServersInfo);
        List<RpaProcessParamInfo> ysqRpaProcessParam = null;
        switch (rpaServersInfo.getRpaType().getValue()) {
            case 2: {
                ysqRpaProcessParam = this.getYsqRpaProcessParam(rpaServersInfo, rpaProcessesInfo);
                break;
            }
            default: {
                ysqRpaProcessParam = this.getYsqRpaProcessParam(rpaServersInfo, rpaProcessesInfo);
            }
        }
        this.updateProcesParams(ctx, rpaProcessId, ysqRpaProcessParam);
    }

    private void updateProcesParams(Context ctx, String rpaProcessId, List<RpaProcessParamInfo> RpaProcessParams) throws EASBizException, BOSException {
        CoreBaseCollection updateColls = new CoreBaseCollection();
        CoreBaseCollection addColls = new CoreBaseCollection();
        HashSet<String> procParamNames = new HashSet<String>();
        for (int i = 0; i < RpaProcessParams.size(); ++i) {
            RpaProcessParamInfo rpaProcessParamInfo = RpaProcessParams.get(i);
            String name = rpaProcessParamInfo.getName();
            RpaProcessParamInfo rpaProcessParamFromDb = this.getRpaProcessParamInfo(ctx, "select id,value where rpaProcess.id='" + rpaProcessId + "' and name='" + name + "'");
            if (rpaProcessParamFromDb != null) {
                rpaProcessParamInfo.setId(rpaProcessParamFromDb.getId());
                rpaProcessParamInfo.setValue(rpaProcessParamFromDb.getValue());
                updateColls.add((CoreBaseInfo)rpaProcessParamInfo);
            } else {
                addColls.add((CoreBaseInfo)rpaProcessParamInfo);
            }
            procParamNames.add(name);
        }
        this.updateBatchData(ctx, updateColls);
        this.addnewBatchData(ctx, addColls);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("rpaProcess.id", (Object)rpaProcessId, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("name", procParamNames, CompareType.NOTINCLUDE));
        this.delete(ctx, filterInfo);
    }

    private List<RpaProcessParamInfo> getYsqRpaProcessParam(RpaServersInfo rpaServersInfo, RpaProcessesInfo rpaProcessesInfo) throws BOSException, EASBizException {
        ArrayList<RpaProcessParamInfo> rpaProcessParams = new ArrayList<RpaProcessParamInfo>();
        String ysqProcesses = null;
        try {
            RPAAESUtils.IS_PRIVACY_SECRET.set(false);
            String ysqToken = YsqRpaServer.getYsqToken(rpaServersInfo.getHttpUrl(), rpaServersInfo.getAppkey(), rpaServersInfo.getAppsecret());
            ysqProcesses = YsqRpaServer.getProcessParams(rpaServersInfo.getHttpUrl(), ysqToken, rpaProcessesInfo.getProcCode(), null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Json rtJson = new Json(ysqProcesses);
        Integer code = rtJson.getValue("code", Integer.class);
        if ("0".equals(code.toString())) {
            Map[] items;
            for (Map item : items = rtJson.getValue("result", Map[].class)) {
                RpaProcessParamInfo rpaProcessParam = new RpaProcessParamInfo();
                rpaProcessParam.setName((String)item.get("Name"));
                rpaProcessParam.setType(ProcessParamType.getEnum((String)item.get("Type")));
                rpaProcessParam.setValue((String)item.get("Value"));
                rpaProcessParam.setDesc((String)item.get("Desc"));
                rpaProcessParam.setRpaProcess(rpaProcessesInfo);
                rpaProcessParams.add(rpaProcessParam);
            }
        } else {
            String errorMsg = rtJson.getValue("msg", String.class);
            throw new EASBizException(RpaException.RPADATASYNFAIL, new Object[]{"RPA\u6d41\u7a0b", errorMsg});
        }
        return rpaProcessParams;
    }

    @Override
    public RpaProcessParamInfo getRpaProcessParamInfo(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super.getRpaProcessParamInfo(ctx, oql);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
        catch (InvalidEntityViewException ex1) {
            throw new BOSException((Throwable)ex1);
        }
    }
}

