/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.rpa.IRpaServers;
import com.kingdee.eas.base.rpa.RpaProcessesInfo;
import com.kingdee.eas.base.rpa.RpaServersFactory;
import com.kingdee.eas.base.rpa.RpaServersInfo;
import com.kingdee.eas.base.rpa.app.AbstractRpaProcessesControllerBean;
import com.kingdee.eas.base.rpa.app.rpaSrv.YsqRpaServer;
import com.kingdee.eas.base.rpa.util.Json;
import com.kingdee.eas.base.rpa.util.RPAAESUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RpaProcessesControllerBean
extends AbstractRpaProcessesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.rpa.app.RpaProcessesControllerBean");
    private static final int DELAY_MINUTE = 1;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("ss mm HH dd MM ? yyyy");

    @Override
    protected void _syncRpaProcesses(Context ctx, String rpaServerId) throws BOSException, EASBizException {
        IRpaServers iRpaServers = RpaServersFactory.getLocalInstance(ctx);
        ObjectStringPK rpaServerPk = new ObjectStringPK(rpaServerId);
        RpaServersInfo rpaServersInfo = (RpaServersInfo)iRpaServers.getValue((IObjectPK)rpaServerPk);
        iRpaServers.checkServerConn(rpaServersInfo);
        List<RpaProcessesInfo> ysqProcesses = null;
        switch (rpaServersInfo.getRpaType().getValue()) {
            case 2: {
                ysqProcesses = this.getYsqProcesses(rpaServersInfo);
                break;
            }
            default: {
                ysqProcesses = this.getYsqProcesses(rpaServersInfo);
            }
        }
        this.updateProcesses(ctx, rpaServerId, ysqProcesses);
    }

    private void updateProcesses(Context ctx, String rpaServerId, List<RpaProcessesInfo> RpaProcesses2) throws EASBizException, BOSException {
        CoreBaseCollection updateColls = new CoreBaseCollection();
        CoreBaseCollection addColls = new CoreBaseCollection();
        HashSet<String> procCodes = new HashSet<String>();
        for (int i = 0; i < RpaProcesses2.size(); ++i) {
            RpaProcessesInfo rpaProcessesInfo = RpaProcesses2.get(i);
            IObjectPK[] pks = this._getPKList(ctx, "select id  where rpaServer.id='" + rpaServerId + "' and procCode = '" + rpaProcessesInfo.getProcCode() + "'");
            if (pks != null && pks.length > 0) {
                rpaProcessesInfo.setId(BOSUuid.read((String)pks[0].toString()));
                updateColls.add((CoreBaseInfo)rpaProcessesInfo);
            } else {
                addColls.add((CoreBaseInfo)rpaProcessesInfo);
            }
            procCodes.add(rpaProcessesInfo.getProcCode());
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        this._updatePartialBatchData(ctx, (IObjectCollection)updateColls, selectorItemCollection);
        this.addnewBatchData(ctx, addColls);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("procCode", procCodes, CompareType.NOTINCLUDE));
        this.delete(ctx, filterInfo);
    }

    private List<RpaProcessesInfo> getYsqProcesses(Context ctx, String rpaServerId) throws BOSException, EASBizException {
        IRpaServers iRpaServers = RpaServersFactory.getLocalInstance(ctx);
        ObjectStringPK rpaServerPk = new ObjectStringPK(rpaServerId);
        iRpaServers.checkServerConn(rpaServerPk.toString());
        RpaServersInfo rpaServersInfo = (RpaServersInfo)iRpaServers.getValue((IObjectPK)rpaServerPk);
        return this.getYsqProcesses(rpaServersInfo);
    }

    private List<RpaProcessesInfo> getYsqProcesses(RpaServersInfo rpaServersInfo) throws BOSException {
        ArrayList<RpaProcessesInfo> ppaProcesses = new ArrayList<RpaProcessesInfo>();
        String ysqProcesses = null;
        try {
            RPAAESUtils.IS_PRIVACY_SECRET.set(false);
            String ysqToken = YsqRpaServer.getYsqToken(rpaServersInfo.getHttpUrl(), rpaServersInfo.getAppkey(), rpaServersInfo.getAppsecret());
            ysqProcesses = YsqRpaServer.getYsqProcesses(rpaServersInfo.getHttpUrl(), ysqToken);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Json rtJson = new Json(ysqProcesses);
        Integer code = rtJson.getValue("code", Integer.class);
        if ("0".equals(code.toString())) {
            int total = rtJson.getValue("result.total", Integer.class);
            if (total > 0) {
                Map[] items;
                for (Map item : items = rtJson.getValue("result.items", Map[].class)) {
                    RpaProcessesInfo rpaProcess = new RpaProcessesInfo();
                    rpaProcess.setProcCode((String)item.get("procCode"));
                    rpaProcess.setProcName((String)item.get("procName"));
                    rpaProcess.setProcDesc((String)item.get("procDesc"));
                    rpaProcess.setRpaServer(rpaServersInfo);
                    ppaProcesses.add(rpaProcess);
                }
            }
        } else {
            throw new BOSException("getYsqProcesses fail...");
        }
        return ppaProcesses;
    }

    public static String scheduleExpre() {
        Date date = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, 1);
        date = c.getTime();
        return SDF.format(date);
    }
}

