/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.rpa.RpaClientFactory;
import com.kingdee.eas.base.rpa.RpaProcessesFactory;
import com.kingdee.eas.base.rpa.RpaServersInfo;
import com.kingdee.eas.base.rpa.app.AbstractRpaServersControllerBean;
import com.kingdee.eas.base.rpa.app.RpaException;
import com.kingdee.eas.base.rpa.app.rpaSrv.YsqRpaServer;
import com.kingdee.eas.base.rpa.util.Json;
import com.kingdee.eas.base.rpa.util.RPAAESUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class RpaServersControllerBean
extends AbstractRpaServersControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.rpa.app.RpaServersControllerBean");
    private static final String HTTPSURL_PREFIX = "https://";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RpaServersInfo rpaServersInfo = (RpaServersInfo)model;
        this.checkBeforeAddNew(ctx, rpaServersInfo);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RpaServersInfo rpaServersInfo = (RpaServersInfo)model;
        this.checkBeforeAddNew(ctx, rpaServersInfo);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RpaServersInfo rpaServersInfo = (RpaServersInfo)model;
        this.checkBeforeUpdate(ctx, pk, rpaServersInfo);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        this.innerUpdatePartial(ctx, model, selector);
    }

    private void checkBeforeUpdate(Context ctx, IObjectPK pk, RpaServersInfo info) throws EASBizException, BOSException {
        String httpUrl = info.getHttpUrl();
        this.checkHttpUrl(ctx, httpUrl);
        try {
            String appkey = RPAAESUtils.encrypt(info.getAppkey());
            info.setAppkey(appkey);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkBeforeAddNew(Context ctx, RpaServersInfo info) throws EASBizException, BOSException {
        String httpUrl = info.getHttpUrl();
        this.checkHttpUrl(ctx, httpUrl);
    }

    private void checkHttpUrl(Context ctx, String httpUrl) throws BOSException, EASBizException {
        int preLen;
        if (StringUtils.isEmpty((String)httpUrl)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"\u670d\u52a1\u5730\u5740"});
        }
        httpUrl = httpUrl.trim();
        int end = (httpUrl = httpUrl.toLowerCase()).indexOf("/", preLen = HTTPSURL_PREFIX.length());
        httpUrl = end > -1 ? httpUrl.substring(0, end) : httpUrl.substring(0);
        if (this.exists(ctx, "select 1 where httpUrl like '" + httpUrl + "%'")) {
            RpaServersInfo rpaServersInfo = (RpaServersInfo)this.getValue(ctx, "select number where httpUrl like '" + httpUrl + "%'");
            String number = rpaServersInfo.getNumber();
            throw new RpaException(RpaException.RPASERVERREPEATERROR, new Object[]{httpUrl, number});
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RpaServersInfo rpaServersInfo = (RpaServersInfo)super._getValue(ctx, pk);
        this.privacyDeal(rpaServersInfo);
        return rpaServersInfo;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        RpaServersInfo rpaServersInfo = (RpaServersInfo)super._getValue(ctx, pk, selector);
        this.privacyDeal(rpaServersInfo);
        return rpaServersInfo;
    }

    private void privacyDeal(RpaServersInfo rpaServersInfo) throws BOSException {
        if (RPAAESUtils.IS_PRIVACY_SECRET.get() == null || RPAAESUtils.IS_PRIVACY_SECRET.get().booleanValue()) {
            rpaServersInfo.setAppsecret("");
        } else if (!StringUtils.isEmpty((String)rpaServersInfo.getAppsecret())) {
            try {
                rpaServersInfo.setAppsecret(RPAAESUtils.decrypt(rpaServersInfo.getAppsecret()));
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        RPAAESUtils.IS_PRIVACY_SECRET.remove();
    }

    @Override
    protected void _checkServerConn(Context ctx, String rpaServerId) throws BOSException, EASBizException {
        RpaServersInfo rpaServersInfo = (RpaServersInfo)this.getValue(ctx, (IObjectPK)new ObjectStringPK(rpaServerId));
        this._checkServerConn(ctx, rpaServersInfo);
    }

    @Override
    protected void _checkServerConn(Context ctx, RpaServersInfo rpaServersInfo) throws BOSException, EASBizException {
        String result = null;
        try {
            RPAAESUtils.IS_PRIVACY_SECRET.set(false);
            result = YsqRpaServer.testServerAccess(rpaServersInfo.getHttpUrl(), rpaServersInfo.getAppkey(), rpaServersInfo.getAppsecret());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RpaException(RpaException.RPASERVERCONNFAIL, new Object[]{"\u670d\u52a1\u8bbf\u95ee\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u914d\u7f6e\u6216\u8005\u670d\u52a1\u662f\u5426\u53ef\u7528\uff01"});
        }
        if (!StringUtils.isEmpty((String)result)) {
            Json rtJson = new Json(result);
            Integer code = rtJson.getValue("code", Integer.class);
            if (!"0".equals(code.toString())) {
                String errorMsg = rtJson.getValue("msg", String.class);
                throw new RpaException(RpaException.RPASERVERCONNFAIL, new Object[]{errorMsg});
            }
        } else {
            throw new RpaException(RpaException.RPASERVERCONNFAIL, new Object[]{"access return is null"});
        }
    }

    @Override
    protected String _getYsqToken(Context ctx, String rpaServerId) throws BOSException, EASBizException {
        RpaServersInfo rpaServersInfo = (RpaServersInfo)this.getValue(ctx, (IObjectPK)new ObjectStringPK(rpaServerId));
        String ysqToken = null;
        try {
            RPAAESUtils.IS_PRIVACY_SECRET.set(false);
            ysqToken = YsqRpaServer.getYsqToken(rpaServersInfo.getHttpUrl(), rpaServersInfo.getAppkey(), rpaServersInfo.getAppsecret());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ysqToken;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        RpaProcessesFactory.getLocalInstance(ctx).delete("where rpaServer.id = '" + pk.toString() + "'");
        RpaClientFactory.getLocalInstance(ctx).delete("where rpaServer.id = '" + pk.toString() + "'");
    }
}

