/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.base.rpa.util.Json;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    static SSL ssl = new SSL();
    private static final boolean HOSTNAME_VERIFY = true;

    private HttpUtil() {
    }

    public static String doGetRequest(String httpUrl, Map<String, String> header, String jsonStr) {
        return HttpUtil.request(httpUrl, header, jsonStr, true, false);
    }

    public static String jsonRequest(String httpUrl, String jsonStr) {
        return HttpUtil.request(httpUrl, null, jsonStr, false, true);
    }

    public static String doPostRequest(String httpUrl, Map<String, String> header, String jsonStr) {
        return HttpUtil.request(httpUrl, header, jsonStr, false, true);
    }

    private static String request(String httpUrl, Map<String, String> header, String httpArg, boolean isGet, boolean isContentTypeJSON) {
        String result = null;
        StringBuffer sbf = new StringBuffer();
        HttpURLConnection connection = null;
        FilterOutputStream out = null;
        BufferedReader reader = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            if (isGet) {
                connection.setRequestMethod("GET");
            } else {
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                if (isContentTypeJSON) {
                    connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
                }
                out = new DataOutputStream(connection.getOutputStream());
                ((DataOutputStream)out).writeBytes(httpArg);
                ((DataOutputStream)out).flush();
            }
            if (header != null && header.size() > 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            result = sbf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("HTTP\u8fde\u63a5\u5931\u8d25", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    public static Map<String, String> getHeader(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration keys = request.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            params.put(key.toLowerCase(), request.getHeader(key).toLowerCase());
        }
        return params;
    }

    public static String getHeader(String headerName) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return request.getHeader(headerName);
    }

    public static String getRequestIp(HttpServletRequest request) {
        return request.getHeader("x-forwarded-for") == null ? request.getRemoteAddr() : request.getHeader("x-forwarded-for");
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        boolean flag = false;
        String requestType = request.getHeader("X-Requested-With");
        if ("XMLHttpRequest".equalsIgnoreCase(requestType)) {
            flag = true;
        }
        return flag;
    }

    public static void writeJson(HttpServletResponse response, Object result) {
        HttpUtil.writeJson(response, result, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJson(HttpServletResponse response, Object result, int status) {
        PrintWriter writer = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            ((ServletRequest)response).setCharacterEncoding("UTF-8");
            response.setStatus(status);
            writer = response.getWriter();
            writer.print(Json.toString(result));
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException e) {
            logger.error("\u54cd\u5e94json\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f:{}", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public static void writeText(HttpServletResponse response, Object result) {
        HttpUtil.writeJson(response, result, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText(HttpServletResponse response, Object result, int status) {
        PrintWriter writer = null;
        try {
            response.setContentType("text/html;charset=utf-8");
            ((ServletRequest)response).setCharacterEncoding("UTF-8");
            response.setStatus(status);
            writer = response.getWriter();
            writer.print(JSON.toJSONString((Object)result));
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException e) {
            logger.error("\u54cd\u5e94text\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStaticResourceContent(String filepath) {
        BufferedReader br = null;
        try {
            ClassPathResource resource = new ClassPathResource(filepath);
            File file = resource.getFile();
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuffer buff = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                buff.append(line);
            }
            String string = buff.toString();
            IOUtils.closeQuietly((Reader)br);
            return string;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u9759\u6001\u7f51\u9875\u5185\u5bb9\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f:{}", (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetRequest(String url, String accesstoken, String timestamp, String signature) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String inputLine;
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(HttpUtil.isHttps(url));
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("accesstoken", accesstoken);
            httpGet.setHeader("timestamp", timestamp);
            httpGet.setHeader("signature", signature);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            while ((inputLine = reader.readLine()) != null) {
                buffer.append(inputLine);
            }
            httpClient.close();
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8fdc\u7a0b\u8fde\u63a5\u5185\u5bb9\u5931\u8d25, e:{}, url:{}", (Object)e.getMessage(), (Object)url);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequest(String url, String param) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String inputLine;
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(HttpUtil.isHttps(url));
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Accept", "*/*");
            httpPost.setHeader("Connection", "Keep-Alive");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            httpPost.setHeader("Accept-Charset", "utf-8");
            httpPost.setHeader("Content-type", "application/json");
            StringEntity entity = new StringEntity(param);
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            while ((inputLine = reader.readLine()) != null) {
                buffer.append(inputLine);
            }
            httpClient.close();
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528WebUtils.sendPost\u5931\u8d25, e:{}, url:{}", (Object)e.getMessage(), (Object)url);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequestByParams(String url, Map<String, String> params) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String inputLine;
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(HttpUtil.isHttps(url));
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Accept", "*/*");
            httpPost.setHeader("Connection", "Keep-Alive");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            httpPost.setHeader("Accept-Charset", "utf-8");
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (String name : params.keySet()) {
                nvps.add(new BasicNameValuePair(name, params.get(name)));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            while ((inputLine = reader.readLine()) != null) {
                buffer.append(inputLine);
            }
            httpClient.close();
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528WebUtils.sendPost\u5931\u8d25, e:{}, url:{}", (Object)e.getMessage(), (Object)url);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequestByParamsWithHeader(String signature, String timestamp, String accesstoken, String url, Map<String, Object> params) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String inputLine;
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(HttpUtil.isHttps(url));
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Accept", "*/*");
            httpPost.setHeader("Connection", "Keep-Alive");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            httpPost.setHeader("Accept-Charset", "utf-8");
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            httpPost.setHeader("signature", signature);
            httpPost.setHeader("timestamp", timestamp);
            httpPost.setHeader("accesstoken", accesstoken);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (String name : params.keySet()) {
                nvps.add(new BasicNameValuePair(name, params.get(name).toString()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            while ((inputLine = reader.readLine()) != null) {
                buffer.append(inputLine);
            }
            httpClient.close();
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528WebUtils.sendPost\u5931\u8d25, e:{}, url:{}", (Object)e.getMessage(), (Object)url);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return buffer.toString();
    }

    private static CloseableHttpClient getHttpClient(boolean isHttps) {
        if (isHttps) {
            return HttpClients.custom().setSSLHostnameVerifier(HttpUtil.ssl.hostnameVerifier).setSSLContext(HttpUtil.ssl.context).build();
        }
        return HttpClients.createDefault();
    }

    private static boolean isHttps(String url) {
        return url.startsWith("https:");
    }

    public static class SSL {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        SSLContext context;

        SSL() {
            X509TrustManager x509 = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] ax509certificate, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] ax509certificate, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            try {
                this.context = SSLContext.getInstance("TLS");
                this.context.init(null, new TrustManager[]{x509}, new SecureRandom());
            }
            catch (Exception e) {
                logger.error(" \u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
    }
}

