/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.util;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static Logger logger = Logger.getLogger(HttpUtils.class);

    public static String postJson(String url, String json, Map<String, String> headerParams) throws ClientProtocolException, IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setHeader("Accept", "application/json");
        Set<String> keySet = headerParams.keySet();
        for (String paramName : keySet) {
            httpPost.setHeader(paramName, headerParams.get(paramName));
        }
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            HttpEntity respEnt = response.getEntity();
            return EntityUtils.toString((HttpEntity)respEnt, (String)"UTF-8");
        }
        logger.error((Object)("\u8bf7\u6c42\u5f02\u5e38\uff0curl:" + url + " ; statusCode:" + statusCode));
        throw new IOException("\u8bf7\u6c42\u5f02\u5e38\uff0curl:" + url + " ; statusCode:" + statusCode);
    }

    public static String postJson(String url, String json) throws ClientProtocolException, IOException {
        return HttpUtils.postJson(url, json, new HashMap<String, String>());
    }

    public static String getBySendJson(String url, String json, Map<String, String> headerParams) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGetWithEntity httpGetWithEntity = new HttpGetWithEntity(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        httpGetWithEntity.setConfig(requestConfig);
        httpGetWithEntity.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpGetWithEntity.setHeader("Accept", "application/json");
        Set<String> keySet = headerParams.keySet();
        for (String paramName : keySet) {
            httpGetWithEntity.setHeader(paramName, headerParams.get(paramName));
        }
        StringEntity httpEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        httpGetWithEntity.setEntity((HttpEntity)httpEntity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGetWithEntity);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            HttpEntity respEnt = response.getEntity();
            return EntityUtils.toString((HttpEntity)respEnt, (String)"UTF-8");
        }
        logger.error((Object)("\u8bf7\u6c42\u5f02\u5e38\uff0curl:" + url + " ; statusCode:" + statusCode));
        throw new IOException("\u8bf7\u6c42\u5f02\u5e38\uff0curl:" + url + " ; statusCode:" + statusCode);
    }

    public static class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        private static final String METHOD_NAME = "GET";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpGetWithEntity() {
        }

        public HttpGetWithEntity(URI uri) {
            this.setURI(uri);
        }

        HttpGetWithEntity(String uri) {
            this.setURI(URI.create(uri));
        }
    }
}

