/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.AbstractSSCUnitOrgInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.base.wssc.ImageHandlerCollection;
import com.kingdee.eas.base.wssc.ImageHandlerFactory;
import com.kingdee.eas.base.wssc.ImageHandlerInfo;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.base.wssc.PhonePhotoCacheEntryInfo;
import com.kingdee.eas.base.wssc.PhonePhotoCacheInfo;
import com.kingdee.eas.base.wssc.SSCUnitInfo;
import com.kingdee.eas.base.wssc.SSCUnitOrgFactory;
import com.kingdee.eas.base.wssc.WSSCException;
import com.kingdee.eas.base.wssc.app.AbstractPhonePhotoFacadeControllerBean;
import com.kingdee.eas.base.wssc.app.Submit2ImageSysThread;
import com.kingdee.eas.base.wssc.app.UploadMode;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.image.SavePhotoCacheInfo;
import com.kingdee.eas.base.wssc.image.ViewSavedPhtotoResultInfo;
import com.kingdee.eas.base.wssc.image.helper.NoticeImageSysFactory;
import com.kingdee.eas.base.wssc.image.helper.xmlParmas.bean.CMSaveForMobile;
import com.kingdee.eas.base.wssc.image.helper.xmlParmas.bean.CMSaveForMobileInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysSubmitInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewOnPhoneInfo;
import com.kingdee.eas.base.wssc.imageNew.helper.NoticeImageSysFactory_New;
import com.kingdee.eas.base.wssc.imageNew.interfaces.impl.BillImageByBillIDImpl;
import com.kingdee.eas.base.wssc.imageNew.interfaces.impl.BillImageByNOImpl;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.base.wssc.imageNew.util.MultiImageConfig;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class PhonePhotoFacadeControllerBean
extends AbstractPhonePhotoFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.PhonePhotoFacadeControllerBean");
    private static String filePath = PhonePhotoFacadeControllerBean.getFilePath();

    private static String getFilePath() {
        String tmp = System.getProperty("java.security.auth.login.config");
        if (tmp != null) {
            tmp = tmp.replace("login.config", "");
            tmp.trim();
            if (tmp.contains("properties")) {
                tmp = tmp.replace("properties", "doc");
            } else {
                File docFile = new File(tmp = tmp + "doc" + File.separator);
                if (!docFile.exists()) {
                    docFile.mkdirs();
                }
            }
            tmp = tmp + "PhonePhotoCache" + File.separator;
            File cacheFile = new File(tmp);
            if (!cacheFile.exists()) {
                cacheFile.mkdirs();
            }
        }
        return tmp;
    }

    @Override
    protected String _savePhoto(Context ctx, SavePhotoCacheInfo savePhotoInfo) throws BOSException, EASBizException {
        try {
            String id = null;
            PhonePhotoCacheInfo phonePhotoInfo = new PhonePhotoCacheInfo();
            id = BOSUuid.create((BOSObjectType)phonePhotoInfo.getBOSType()).toString();
            String billID = this.decodeId(savePhotoInfo.getBillID());
            savePhotoInfo.setBillID(billID);
            logger.error((Object)("save billid:" + billID));
            String seqSql = "select b.FID,b.FImageNumber,p.FSeq from t_wsc_PhonePhotoCache p, T_wsc_billImageMap b where p.FBillImageMapID = b.FID and b.FbillID = ? order by p.FSeq";
            String insertSql_1 = "insert into t_wsc_PhonePhotoCache (FID, FBillIMageMapID, Fseq) values (?, ? , ?)";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)seqSql, (Object[])new Object[]{billID});
            int seq_p = 0;
            String billImageMapID = null;
            String imageNumber = null;
            while (rowSet.next()) {
                seq_p = rowSet.getInt("FSeq") + 1;
                billImageMapID = rowSet.getString("FID");
                imageNumber = rowSet.getString("FImageNumber");
            }
            if (seq_p == 0) {
                BillImageMapInfo billImageInfo = null;
                IBillImageMap iBillImageMap = BillImageMapFactory.getLocalInstance(ctx);
                CoreBaseCollection collection = iBillImageMap.getCollection("where billID = '" + billID + "'");
                if (collection != null && !collection.isEmpty()) {
                    billImageInfo = (BillImageMapInfo)collection.get(0);
                    imageNumber = billImageInfo.getImageNumber();
                }
                if (billImageInfo == null) {
                    imageNumber = BillImageFacadeFactory.getLocalInstance(ctx).genImageNumber(null, billID);
                    iBillImageMap = BillImageMapFactory.getLocalInstance(ctx);
                    collection = iBillImageMap.getCollection("where billID = '" + billID + "'");
                    billImageInfo = (BillImageMapInfo)collection.get(0);
                }
                billImageMapID = billImageInfo.getId().toString();
            }
            DbUtil.execute((Context)ctx, (String)insertSql_1, (Object[])new Object[]{id, billImageMapID, seq_p});
            List<SavePhotoCacheInfo.InnerInfo> photoList = savePhotoInfo.getPhotos();
            int length = photoList.size();
            String insertSql = "insert into T_WSC_PhonePhotoCacheEntry (FID, FSeq, FParentID, FName_L2, FSize, FPixel, FPhoto) values(?, ?, ?, ?, ?, ?, ?)";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(length);
            String[] entryIDs = new String[length];
            String[] fileFullNames = new String[length];
            String _filePath = filePath + imageNumber + File.separator;
            File _filePathFile = new File(_filePath);
            if (!_filePathFile.exists()) {
                _filePathFile.mkdirs();
            }
            for (int i = 0; i < length; ++i) {
                String entryID;
                SavePhotoCacheInfo.InnerInfo innerInfo = photoList.get(i);
                entryIDs[i] = entryID = BOSUuid.create((BOSObjectType)new PhonePhotoCacheEntryInfo().getBOSType()).toString();
                int seq = i;
                String parentID = id;
                String name = innerInfo.getName() + seq_p + i;
                int size = innerInfo.getSize();
                String pixel = innerInfo.getPixel();
                fileFullNames[i] = _filePath + seq_p + "_" + pixel + ".jpg";
                this.savePhoto2FileSys(savePhotoInfo.isUseStream(), innerInfo, fileFullNames[i]);
                paramsList.add(new Object[]{entryID, seq, parentID, name, size, pixel, fileFullNames[i]});
            }
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
            return id;
        }
        catch (BOSException e) {
            logger.error((Object)("\u6682\u5b58\u56fe\u7247\u81f3EAS\u670d\u52a1\u5668\u51fa\u73b0\u5f02\u5e38." + (Object)((Object)e)));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)("\u6682\u5b58\u56fe\u7247\u81f3EAS\u670d\u52a1\u5668\u51fa\u73b0\u5f02\u5e38." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u6682\u5b58\u56fe\u7247\u81f3EAS\u670d\u52a1\u5668\u51fa\u73b0\u5f02\u5e38." + e});
        }
    }

    private void savePhoto2FileSys(boolean userStream, SavePhotoCacheInfo.InnerInfo innerInfo, String fileFullName) throws Exception, EASBizException {
        OutputStream os = null;
        InputStream is = null;
        try {
            File file = new File(fileFullName);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            os = new FileOutputStream(file);
            if (userStream) {
                is = innerInfo.getInputStream();
                int next = is.read();
                while (next != -1) {
                    os.write(next);
                    next = is.read();
                }
                os.write(next);
            } else {
                os.write(innerInfo.getBytes());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    @Override
    protected ViewSavedPhtotoResultInfo _viewSavedPhoto(Context ctx, boolean useStream, String phonePhotoCacheID, String[] pixels) throws BOSException, EASBizException {
        try {
            ViewSavedPhtotoResultInfo resultInfo = new ViewSavedPhtotoResultInfo(useStream);
            phonePhotoCacheID = this.decodeId(phonePhotoCacheID);
            resultInfo.setPhonePhotoCacheID(phonePhotoCacheID);
            List<ViewSavedPhtotoResultInfo.InnerInfo> photos = resultInfo.getPhotos();
            String insertSql = "select pe.FID, pe.FSeq, pe.FParentID, pe.FName_L2, pe.FSize, pe.FPixel, pe.FPhoto, b.FBillID from  T_WSC_PhonePhotoCacheEntry pe, T_WSC_PhonePhotoCache pc, T_WSC_BillIMageMap b where pe.FParentID = pc.FID and pc.FBillImageMapID = b.FID and pe.FParentID = ?";
            StringBuilder inSql = new StringBuilder(" and FPixel in (");
            for (int i = 0; i < pixels.length; ++i) {
                inSql.append("'").append(pixels[i]).append("',");
            }
            insertSql = insertSql + inSql.replace(inSql.length() - 1, inSql.length(), ")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)insertSql, (Object[])new Object[]{phonePhotoCacheID});
            while (rowSet.next()) {
                ViewSavedPhtotoResultInfo.InnerInfo photo = new ViewSavedPhtotoResultInfo.InnerInfo(resultInfo);
                photo.setName(rowSet.getString("FName_L2"));
                photo.setPixel(rowSet.getString("FPixel"));
                photo.setSize(rowSet.getInt("FSize"));
                String fileFullName = rowSet.getString("FPhoto");
                this.getPhotoFromFileSys(useStream, photo, fileFullName);
                photos.add(photo);
                resultInfo.setBillID(rowSet.getString("FBillID"));
            }
            return resultInfo;
        }
        catch (BOSException e) {
            logger.error((Object)("\u67e5\u770bEAS\u6682\u5b58\u56fe\u7247\u51fa\u73b0\u5f02\u5e38." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u67e5\u770bEAS\u6682\u5b58\u56fe\u7247\u51fa\u73b0\u5f02\u5e38." + e});
        }
    }

    private ViewSavedPhtotoResultInfo.InnerInfo getPhotoFromFileSys(boolean useStream, ViewSavedPhtotoResultInfo.InnerInfo photo, String fileFullName) throws Exception, EASBizException {
        block14: {
            InputStream is = null;
            try {
                File file = new File(fileFullName);
                if (file.exists()) {
                    is = new FileInputStream(file);
                    if (useStream) {
                        photo.setInputStream(is);
                        break block14;
                    }
                    if (is == null) break block14;
                    try {
                        int length = (int)file.length();
                        byte[] bytes = new byte[length];
                        is.read(bytes);
                        photo.setBytes(bytes);
                        break block14;
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        throw e;
                    }
                }
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u56fe\u7247\u5728\u6587\u4ef6\u7cfb\u7edf,\u5df2\u88ab\u5220\u9664!"});
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw e;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        logger.error((Object)e2);
                    }
                }
            }
        }
        return photo;
    }

    @Override
    protected boolean _deleteSavedPhotos(Context ctx, String[] phonePhotoCacheIDs) throws BOSException, EASBizException {
        try {
            if (phonePhotoCacheIDs.length == 0) {
                return true;
            }
            String sql = "select pe.FPhoto from  T_WSC_PhonePhotoCacheEntry pe, T_WSC_PhonePhotoCache pc where pe.FParentID = pc.FID and pc.FID in (";
            String deleteSql = "delete from T_WSC_PhonePhotoCache where FID in (";
            String deleteSqlEntry = "delete from T_WSC_PhonePhotoCacheEntry where FParentID in (";
            for (int i = 0; i < phonePhotoCacheIDs.length; ++i) {
                phonePhotoCacheIDs[i] = this.decodeId(phonePhotoCacheIDs[i]);
                sql = sql + "'" + phonePhotoCacheIDs[i] + "',";
                deleteSql = deleteSql + "'" + phonePhotoCacheIDs[i] + "',";
                deleteSqlEntry = deleteSqlEntry + "'" + phonePhotoCacheIDs[i] + "',";
            }
            sql = sql.substring(0, sql.length() - 1) + ")";
            deleteSql = deleteSql.substring(0, deleteSql.length() - 1) + ")";
            deleteSqlEntry = deleteSqlEntry.substring(0, deleteSqlEntry.length() - 1) + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fileFullName = rowSet.getString("FPhoto");
                File file = new File(fileFullName);
                if (!file.exists()) continue;
                file.delete();
            }
            DbUtil.execute((Context)ctx, (String)deleteSqlEntry);
            DbUtil.execute((Context)ctx, (String)deleteSql);
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)("\u5220\u9664EAS\u6682\u5b58\u56fe\u7247\u51fa\u73b0\u5f02\u5e38." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u5220\u9664EAS\u6682\u5b58\u56fe\u7247\u51fa\u73b0\u5f02\u5e38." + e});
        }
    }

    @Override
    protected String[] _getAllSavedPhotoIDs(Context ctx, String billID) throws BOSException, EASBizException {
        try {
            billID = this.decodeId(billID);
            String sql = "select pc.FID from T_WSC_PhonePhotoCache pc,T_wsc_billImageMap b where pc.FBillImageMapID = b.FID and b.FBillID = ? group by pc.FID";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billID});
            ArrayList<String> list = new ArrayList<String>();
            while (rowSet != null && rowSet.next()) {
                list.add(rowSet.getString("FID"));
            }
            return list.toArray(new String[0]);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u5355\u636e\u7f13\u5b58\u7684\u6240\u6709\u56fe\u7247id\u51fa\u73b0\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u83b7\u53d6\u5355\u636e\u7f13\u5b58\u7684\u6240\u6709\u56fe\u7247id\u51fa\u73b0\u5f02\u5e38.billID:" + billID + ".." + e});
        }
    }

    @Override
    protected void _submit2ImageSys(Context ctx, String billID) throws BOSException, EASBizException {
        InputStream[] inputStreams = null;
        String[] filePaths = null;
        billID = this.decodeId(billID);
        logger.error((Object)("_submit2ImageSys billid:" + billID));
        String imageNumber = null;
        String imageType = WebServiceConfig.getPropertiesValue(ctx, "image.system.type");
        if (Configure.enableMultiImage(ctx)) {
            BillImageMapInfo info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByBillIDImpl(), billID);
            imageType = MultiImageConfig.getPropertiesValue(ctx, info.getImageSysId(), "image.system.type");
        }
        if ("TCZT".equalsIgnoreCase(imageType)) {
            this.tcztSubmit2ImageSys(ctx, billID);
            return;
        }
        try {
            ArrayList<String> entryIds = new ArrayList<String>();
            HashSet<Integer> seqs = new HashSet<Integer>();
            ImageStateEnum state = BillImageFacadeFactory.getLocalInstance(ctx).getImageState(null, billID);
            if (ImageStateEnum.UPLOADING_IMAGE.equals((Object)state)) {
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u5f71\u50cf\u63d0\u4ea4\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u4e0a\u4f20.billID:" + billID + "."});
            }
            if (!"FPY".equalsIgnoreCase(imageType) && (ImageStateEnum.HAS_IMAGE.equals((Object)state) || ImageStateEnum.REUPLOAD_IMAGE.equals((Object)state))) {
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u5df2\u6709\u5f71\u50cf\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u4e0a\u4f20\uff0c\u5982\u9700\u91cd\u4f20\uff0c\u8bf7\u5148\u9000\u626b.billID:" + billID + "."});
            }
            String selectIDsql = "select b.FImageNumber, pe.FID, pc.FSeq , pe.FSize from T_WSC_PhonePhotoCache pc, T_wsc_billImageMap b,T_WSC_PhonePhotoCacheEntry pe where pc.FBillImageMapID = b.FID and pe.FParentID = pc.FID  and  b.FBillID = ? group by b.FImageNumber, pe.FID, pc.FSeq , pe.FSize order by pc.FSeq ASC, pe.FSize DESC";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectIDsql, (Object[])new Object[]{billID});
            while (rowSet != null && rowSet.next()) {
                if (imageNumber == null) {
                    imageNumber = rowSet.getString("FImageNumber");
                }
                String tmpID = rowSet.getString("FID");
                Integer tmpSeq = rowSet.getInt("FSeq");
                if (seqs.contains(tmpSeq)) continue;
                seqs.add(tmpSeq);
                entryIds.add(tmpID);
            }
            if (entryIds == null || entryIds.size() == 0) {
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38,\u627e\u4e0d\u5230\u6682\u5b58\u5f71\u50cf\u5206\u5f55id!billID:" + billID + ".."});
            }
            String sql = "select FPhoto from T_WSC_PhonePhotoCacheEntry where FID";
            StringBuilder inSql = new StringBuilder(" in (");
            for (int i = 0; i < entryIds.size(); ++i) {
                inSql.append("'").append((String)entryIds.get(i)).append("',");
            }
            sql = sql + inSql.replace(inSql.length() - 1, inSql.length(), ")");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            inputStreams = new InputStream[entryIds.size()];
            filePaths = new String[entryIds.size()];
            int index = 0;
            while (rowSet.next()) {
                String path = rowSet.getString("FPhoto");
                inputStreams[index] = new FileInputStream(new File(path));
                filePaths[index] = path;
                ++index;
            }
            NoticeImageSysSubmitInfo submitInfo = new NoticeImageSysSubmitInfo();
            submitInfo.setBarCode(imageNumber);
            submitInfo.setInputStreams(inputStreams);
            submitInfo.setOperateID(ctx.getCaller() + "");
            submitInfo.setOperateName(ctx.getUserName());
            submitInfo.setFilePaths(filePaths);
            Submit2ImageSysThread sThread = new Submit2ImageSysThread(ctx).setSubmitInfo(submitInfo);
            sThread.start();
            if (sThread.isSuceess()) {
                BillImageFacadeFactory.getLocalInstance(ctx).updateImageState(null, billID, ImageStateEnum.UPLOADING_IMAGE);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)("\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + e});
        }
    }

    @Override
    public boolean _submit2ImageSysNew(Context ctx, String billID, String orgId, UploadMode uploadMode, String[] newPhonePhotoCacheIDs) throws BOSException, EASBizException {
        logger.error((Object)("\u5f00\u59cb\u4e0a\u4f20\uff0cuploadMode:" + (Object)((Object)uploadMode)));
        billID = this.decodeId(billID);
        if (uploadMode.equals((Object)UploadMode.COVER)) {
            this._deleteSavedPhotos(ctx, this.getAlreadyUploadedPhotoIDs(ctx, billID, newPhonePhotoCacheIDs));
        }
        orgId = this.decodeId(orgId);
        logger.error((Object)(" orgId:" + orgId + " billID:" + billID));
        AbstractSSCUnitOrgInfo sscUnitOrgInfo = null;
        try {
            sscUnitOrgInfo = SSCUnitOrgFactory.getLocalInstance(ctx).getSSCUnitOrgInfo("where org = '" + orgId + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        SSCUnitInfo sscInfo = null;
        if (sscUnitOrgInfo == null) {
            logger.error((Object)"\u626b\u63cf\u70b9\u6ca1\u6709\u5206\u914d\u8be5\u7ec4\u7ec7!");
            throw new NullPointerException("\u626b\u63cf\u70b9\u6ca1\u6709\u5206\u914d\u7ec4\u7ec7!" + orgId);
        }
        sscInfo = sscUnitOrgInfo.getSscUnit();
        ImageHandlerCollection imageHandlerColl = ImageHandlerFactory.getLocalInstance(ctx).getImageHandlerCollection("where sscUnitID = '" + sscInfo.getId() + "'");
        if (imageHandlerColl == null || imageHandlerColl.isEmpty()) {
            logger.error((Object)("\u626b\u63cf\u70b9\u6ca1\u6709\u5206\u914d\u4eba\u5458\uff01" + sscInfo.getNumber()));
            throw new NullPointerException("\u626b\u63cf\u70b9\u6ca1\u6709\u5206\u914d\u4eba\u5458\uff01" + sscInfo.getNumber());
        }
        ImageHandlerInfo imageHandler = imageHandlerColl.get(0);
        InputStream[] inputStreams = null;
        String imageNumber = null;
        if ("TCZT".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, "image.system.type"))) {
            this.tcztSubmit2ImageSys(ctx, billID);
            return true;
        }
        try {
            logger.error((Object)("_submit2ImageSys billid:" + billID));
            ArrayList<String> entryIds = new ArrayList<String>();
            HashSet<Integer> seqs = new HashSet<Integer>();
            ImageStateEnum state = BillImageFacadeFactory.getLocalInstance(ctx).getImageState(null, billID);
            if (ImageStateEnum.UPLOADING_IMAGE.equals((Object)state)) {
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u5f71\u50cf\u63d0\u4ea4\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u4e0a\u4f20.billID:" + billID + "."});
            }
            if (ImageStateEnum.NO_IMAGE.equals((Object)state)) {
                uploadMode = UploadMode.FIRST;
                logger.error((Object)("\u72b6\u6001\u8868\u660e\u662f\u9996\u6b21,uploadMode:" + (Object)((Object)uploadMode)));
            }
            String newPhonePhotoCacheIDsSql = " ( ";
            for (int i = 0; i < newPhonePhotoCacheIDs.length; ++i) {
                String phonePhotoCacheID = this.decodeId(newPhonePhotoCacheIDs[i]);
                newPhonePhotoCacheIDsSql = newPhonePhotoCacheIDsSql + "'" + phonePhotoCacheID + "',";
            }
            newPhonePhotoCacheIDsSql = newPhonePhotoCacheIDsSql.substring(0, newPhonePhotoCacheIDsSql.length() - 1) + " ) ";
            String selectIDsql = "select b.FImageNumber, pe.FID, pc.FSeq , pe.FSize from T_WSC_PhonePhotoCache pc, T_wsc_billImageMap b,T_WSC_PhonePhotoCacheEntry pe where pc.FBillImageMapID = b.FID and pe.FParentID = pc.FID  and  b.FBillID = ? and pc.fid in " + newPhonePhotoCacheIDsSql + " group by b.FImageNumber, pe.FID, pc.FSeq , pe.FSize order by pc.FSeq ASC, pe.FSize DESC";
            logger.error((Object)("selectIDsql:" + selectIDsql + " billID:" + billID));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectIDsql, (Object[])new Object[]{billID});
            while (rowSet != null && rowSet.next()) {
                if (imageNumber == null) {
                    imageNumber = rowSet.getString("FImageNumber");
                    logger.error((Object)("imageNumber:" + imageNumber));
                }
                String tmpID = rowSet.getString("FID");
                logger.error((Object)("tmpID:" + tmpID));
                Integer tmpSeq = rowSet.getInt("FSeq");
                logger.error((Object)("tmpSeq:" + tmpSeq));
                if (seqs.contains(tmpSeq)) continue;
                seqs.add(tmpSeq);
                entryIds.add(tmpID);
            }
            if (entryIds == null || entryIds.size() == 0) {
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38,\u627e\u4e0d\u5230\u6682\u5b58\u5f71\u50cf\u5206\u5f55id!billID:" + billID + ".."});
            }
            String sql = "select FPhoto from T_WSC_PhonePhotoCacheEntry where FID";
            StringBuilder inSql = new StringBuilder(" in (");
            for (int i = 0; i < entryIds.size(); ++i) {
                inSql.append("'").append((String)entryIds.get(i)).append("',");
            }
            sql = sql + inSql.replace(inSql.length() - 1, inSql.length(), ")");
            logger.error((Object)("sql:" + sql));
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            inputStreams = new InputStream[entryIds.size()];
            int index = 0;
            while (rowSet.next()) {
                inputStreams[index] = new FileInputStream(new File(rowSet.getString("FPhoto")));
                ++index;
            }
            NoticeImageSysSubmitInfo submitInfo = new NoticeImageSysSubmitInfo();
            submitInfo.setBarCode(imageNumber);
            submitInfo.setInputStreams(inputStreams);
            String operateID = imageHandler.getHandlerID().getId().toString();
            logger.error((Object)("operateID:" + operateID));
            submitInfo.setOperateID(operateID);
            PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(operateID));
            submitInfo.setOperateName(person.getName());
            logger.error((Object)("operatename:" + person.getName()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("defOrgUnit.number"));
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller(), selector);
            submitInfo.setScanLocation(user.getDefOrgUnit().getNumber() == null ? "01" : user.getDefOrgUnit().getNumber());
            Submit2ImageSysThread submit2imageSysThread = new Submit2ImageSysThread(ctx);
            submit2imageSysThread.setSubmitInfo(submitInfo);
            if (uploadMode == null) {
                logger.error((Object)"mode is null");
            } else {
                logger.error((Object)("mode:" + (Object)((Object)uploadMode)));
            }
            submit2imageSysThread.setUploadMode(uploadMode);
            if (uploadMode != UploadMode.ADD && uploadMode != UploadMode.COVER) {
                BillImageFacadeFactory.getLocalInstance(ctx).updateImageState(null, billID, ImageStateEnum.UPLOADING_IMAGE);
            }
            logger.error((Object)("----\u5f00\u59cb\u4e0a\u4f20{billID:" + billID + ",imageNumber:" + submitInfo.getBarCode()));
            submit2imageSysThread.run();
            logger.error((Object)("----\u7ed3\u675f\u4e0a\u4f20{billID:" + billID + ",imageNumber:" + submitInfo.getBarCode()));
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)("\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)("\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + e});
        }
    }

    protected String[] getAlreadyUploadedPhotoIDs(Context ctx, String billID, String[] newPhonePhotoCacheIDs) throws BOSException, EASBizException {
        try {
            billID = this.decodeId(billID);
            String newPhonePhotoCacheIDsSql = " ( ";
            for (int i = 0; i < newPhonePhotoCacheIDs.length; ++i) {
                String phonePhotoCacheID = this.decodeId(newPhonePhotoCacheIDs[i]);
                newPhonePhotoCacheIDsSql = newPhonePhotoCacheIDsSql + "'" + phonePhotoCacheID + "',";
            }
            newPhonePhotoCacheIDsSql = newPhonePhotoCacheIDsSql.substring(0, newPhonePhotoCacheIDsSql.length() - 1) + " ) ";
            String sql = "select pc.FID from T_WSC_PhonePhotoCache pc,T_wsc_billImageMap b where pc.FBillImageMapID = b.FID and b.FBillID = ? and pc.fid not in " + newPhonePhotoCacheIDsSql + " group by pc.FID";
            logger.error((Object)("\u5220\u9664\u5df2\u7ecf\u4e0a\u4f20\u8fc7\u7684\u56fe\u7247\u7f13\u5b58\uff0c\u53ea\u6709\u8986\u76d6\u4e0a\u4f20\u4f1a\u8c03\u7528\u6b64\u65b9\u6cd5\uff1a" + sql));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billID});
            ArrayList<String> list = new ArrayList<String>();
            while (rowSet != null && rowSet.next()) {
                list.add(rowSet.getString("FID"));
            }
            return list.toArray(new String[0]);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u5355\u636e\u7f13\u5b58\u7684\u6240\u6709\u56fe\u7247id\u51fa\u73b0\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u83b7\u53d6\u5355\u636e\u7f13\u5b58\u7684\u6240\u6709\u56fe\u7247id\u51fa\u73b0\u5f02\u5e38.billID:" + billID + ".." + e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tcztSubmit2ImageSys(Context ctx, String billID) throws BOSException, EASBizException {
        InputStream inputSt = null;
        try {
            billID = this.decodeId(billID);
            logger.error((Object)("_submit2ImageSys billid:" + billID));
            HashSet<Integer> seqs = new HashSet<Integer>();
            ImageStateEnum state = BillImageFacadeFactory.getLocalInstance(ctx).getImageState(null, billID);
            if (ImageStateEnum.UPLOADING_IMAGE.equals((Object)state)) {
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u5f71\u50cf\u63d0\u4ea4\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u4e0a\u4f20.billID:" + billID + "."});
            }
            if (ImageStateEnum.HAS_IMAGE.equals((Object)state) || ImageStateEnum.REUPLOAD_IMAGE.equals((Object)state)) {
                throw new WSSCException(WSSCException.UNKNOW, new Object[]{"\u5df2\u6709\u5f71\u50cf\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u4e0a\u4f20\uff0c\u5982\u9700\u91cd\u4f20\uff0c\u8bf7\u5148\u9000\u626b.billID:" + billID + "."});
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" select b.FImageNumber, pe.FID, pc.FSeq , pe.FSize ,pe.FName_l2,pe.FPhoto ");
            sb.append(" from T_WSC_PhonePhotoCache pc, T_wsc_billImageMap b,T_WSC_PhonePhotoCacheEntry pe ");
            sb.append(" where pc.FBillImageMapID = b.FID and pe.FParentID = pc.FID ");
            sb.append(" and  b.FBillID = ? ");
            sb.append(" group by b.FImageNumber, pe.FID, pc.FSeq , pe.FSize,pe.fname_l2,pe.FPhoto order by pc.FSeq ASC, pe.FSize DESC ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billID});
            String imageNumber = null;
            ArrayList<CMSaveForMobileInfo> cmList = new ArrayList<CMSaveForMobileInfo>();
            while (rowSet != null && rowSet.next()) {
                if (imageNumber == null) {
                    imageNumber = rowSet.getString("FImageNumber");
                }
                String tmpID = rowSet.getString("FID");
                Integer tmpSeq = rowSet.getInt("FSeq");
                if (seqs.contains(tmpSeq)) continue;
                seqs.add(tmpSeq);
                CMSaveForMobileInfo cmForMobileInfo = new CMSaveForMobileInfo();
                cmForMobileInfo.setFile_name(rowSet.getString("FName_l2"));
                cmForMobileInfo.setFile_size(rowSet.getString("FSize"));
                cmForMobileInfo.setFile_seq(tmpSeq + "");
                inputSt = new FileInputStream(new File(rowSet.getString("FPhoto")));
                try {
                    byte[] date = new byte[inputSt.available()];
                    inputSt.read(date);
                    BASE64Encoder base64Encoder = new BASE64Encoder();
                    String file_value = base64Encoder.encodeBuffer(date);
                    cmForMobileInfo.setFile_value(file_value);
                    cmForMobileInfo.setFile_format("0");
                    cmList.add(cmForMobileInfo);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        inputSt.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
            CMSaveForMobile CM = new CMSaveForMobile();
            CM.setBarCode(imageNumber);
            CM.setCmList(cmList);
            CM.setBusi_serial_no(imageNumber);
            CM.setBranch_no(imageNumber);
            CM.setUser_no(ctx.getCaller() + "");
            CM.setImageCount(seqs.size() + "");
            BillImageFacadeFactory.getLocalInstance(ctx).updateImageState(null, billID, ImageStateEnum.UPLOADING_IMAGE);
            Submit2ImageSysThread sThread = new Submit2ImageSysThread(ctx).setSubmitInfo(CM);
            sThread.start();
            if (sThread.isSuceess()) {
                BillImageFacadeFactory.getLocalInstance(ctx).updateImageState(null, billID, ImageStateEnum.UPLOADING_IMAGE);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)("\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u63d0\u4ea4EAS\u6682\u5b58\u56fe\u7247\u81f3\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38.billID:" + billID + ".." + e});
        }
        finally {
            if (inputSt != null) {
                try {
                    inputSt.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void deleteAll(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    this.deleteAll(files[i]);
                }
            }
            file.delete();
        }
    }

    @Override
    protected String _viewPhotoFromImageSys(Context ctx, String imageNumber) throws BOSException, EASBizException {
        try {
            Object url = null;
            NoticeImageSysViewOnPhoneInfo viewPhotoInfo = new NoticeImageSysViewOnPhoneInfo();
            viewPhotoInfo.setBarCode(imageNumber);
            viewPhotoInfo.setViewPersonId(ctx.getCaller().toString());
            viewPhotoInfo.setApp(true);
            if (Configure.enableMultiImage(ctx)) {
                BillImageMapInfo info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByNOImpl(), imageNumber);
                if (ImageStateEnum.NO_IMAGE.equals((Object)info.getImageState())) {
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u4e0a\u4f20\u5f71\u50cf\uff01"));
                }
                return NoticeImageSysFactory_New.getInstance(ctx, info.getImageSysId()).viewPhotoOnPhone(viewPhotoInfo);
            }
            String billID = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageNumber);
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
            return NoticeImageSysFactory.getInstance(ctx, sscNumber).viewPhotoOnPhone(viewPhotoInfo);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u67e5\u770b\u5f71\u50cf\u5730\u5740\u5f02\u5e38.imageNumber:" + imageNumber + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)("\u83b7\u53d6\u67e5\u770b\u5f71\u50cf\u5730\u5740\u5f02\u5e38.imageNumber:" + imageNumber + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u83b7\u53d6\u67e5\u770b\u5f71\u50cf\u5730\u5740\u5f02\u5e38.imageNumber:" + imageNumber + ".." + e});
        }
    }

    @Override
    protected String _viewPhotoFromImageSysByBillID(Context ctx, String billID) throws BOSException, EASBizException {
        try {
            billID = this.decodeId(billID);
            String imageNumber = BillImageFacadeFactory.getLocalInstance(ctx).getImageNumber(null, billID);
            return this._viewPhotoFromImageSys(ctx, imageNumber);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u67e5\u770b\u5f71\u50cf\u5730\u5740\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)("\u83b7\u53d6\u67e5\u770b\u5f71\u50cf\u5730\u5740\u5f02\u5e38.billID:" + billID + ".." + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u83b7\u53d6\u67e5\u770b\u5f71\u50cf\u5730\u5740\u5f02\u5e38.billID:" + billID + ".." + e});
        }
    }

    @Override
    protected boolean _clearSavedPhotos(Context ctx, String billID) throws BOSException, EASBizException {
        try {
            billID = this.decodeId(billID);
            this._deleteSavedPhotos(ctx, this._getAllSavedPhotoIDs(ctx, billID));
            String imageNumber = BillImageFacadeFactory.getLocalInstance(ctx).getImageNumber(null, billID);
            File file = new File(filePath + imageNumber);
            if (file.exists()) {
                this.deleteAll(file);
            }
        }
        catch (Exception e) {
            throw new WSSCException(WSSCException.UNKNOW, e, new Object[]{"\u6e05\u9664\u5355\u636e\u7f13\u5b58\u5f02\u5e38.billID:" + billID + ".." + e});
        }
        return true;
    }

    private String decodeId(String id) {
        String result = id;
        try {
            new ObjectUuidPK(id);
            logger.error((Object)"\u4f20\u9012\u7684\u662f\u6709\u6548\u7684id\uff0c\u65e0\u9700decode\uff01");
        }
        catch (Exception e) {
            logger.error((Object)("\u4f20\u9012\u7684\u4e0d\u662f\u6709\u6548\u7684id\uff0cdecode\u4e4b.Exception:" + e));
            result = URLDecoder.decode(id);
        }
        return result;
    }
}

