/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.base.wssc.IImageHandleTask;
import com.kingdee.eas.base.wssc.ImageHandleTaskCollection;
import com.kingdee.eas.base.wssc.ImageHandleTaskEntryCollection;
import com.kingdee.eas.base.wssc.ImageHandleTaskEntryFactory;
import com.kingdee.eas.base.wssc.ImageHandleTaskEntryInfo;
import com.kingdee.eas.base.wssc.ImageHandleTaskFactory;
import com.kingdee.eas.base.wssc.ImageHandleTaskInfo;
import com.kingdee.eas.base.wssc.ImageHandlerCollection;
import com.kingdee.eas.base.wssc.ImageHandlerFactory;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.base.wssc.SSCUnitCollection;
import com.kingdee.eas.base.wssc.SSCUnitFactory;
import com.kingdee.eas.base.wssc.SSCUnitInfo;
import com.kingdee.eas.base.wssc.WSSCException;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.app.webservice.WSContext;
import com.kingdee.eas.base.wssc.image.SSCImageUtils;
import com.kingdee.eas.base.wssc.image.pojo.BaseBillInfo;
import com.kingdee.eas.base.wssc.image.pojo.BaseImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.BaseImageList;
import com.kingdee.eas.base.wssc.image.pojo.ImageStateParamInfo;
import com.kingdee.eas.base.wssc.image.pojo.ReceiveImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.RescanImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.SendImageInfo;
import com.kingdee.eas.base.wssc.imageNew.pojo.BillFiledOrgTypeInfo;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.base.wssc.imageNew.util.WSSCImageUtils;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.Person;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;

public class SSCImageHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.SSCImageHandler");
    public static final String IMAGE_READY = "1";
    public static final String IMAGE_NOT_READY = "0";
    public static String DPLOY_TYPE_UNION = "0";
    public static String DPLOY_TYPE_INDEPENDENT = "1";
    private static final String RESCAN_VALUE = "1";

    void saveImageReady(Context ctx, BaseImageList baseList) throws BOSException, EASBizException {
        ReceiveImageInfo imageInfo2 = null;
        logger.error((Object)"*********saveImageReady begin");
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        HashSet<String> imageNoSet = new HashSet<String>();
        BillImageMapInfo billImageMapInfo = null;
        for (ReceiveImageInfo imageInfo2 : baseList.getImageList()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageInfo2.getImageNo()));
            String billID = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageInfo2.getImageNo());
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
            view.setFilter(filter);
            BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
            if (billImageMapCollection == null || billImageMapCollection.size() <= 0) {
                throw new EASBizException(WSSCException.CUSTOM, new Object[]{"imageNumber:" + imageInfo2.getImageNo() + ",billId:" + billID + " no data"});
            }
            billImageMapInfo = billImageMapCollection.get(0);
            billImageMapInfo.setScanClientIP(imageInfo2.getScanClientIP());
            billImageMapInfo.setScanTime(SSCImageUtils.convertStr2Date(imageInfo2.getScanTime()));
            if (imageInfo2.getScanUserID().indexOf("((()))") > -1) {
                int end = imageInfo2.getScanUserID().indexOf("((()))");
                billImageMapInfo.setScanUserID(imageInfo2.getScanUserID().substring(0, end));
            } else {
                billImageMapInfo.setScanUserID(imageInfo2.getScanUserID());
            }
            SSCUnitInfo sscUnitInfo = null;
            String sscUnit = imageInfo2.getScanClientIP();
            try {
                sscUnitInfo = this.getSSCUnitByName(ctx, sscUnit);
            }
            catch (Exception e) {
                sscUnitInfo = null;
                logger.error((Object)("\u4e0d\u5b58\u5728\u540d\u4e3a:" + sscUnit + "\u7684\u626b\u63cf\u70b9,\u7ee7\u7eed\u5c1d\u8bd5\u7528scanUserID\u67e5\u8be2.scanUserID:" + billImageMapInfo.getScanUserID()), (Throwable)e);
            }
            if (sscUnitInfo == null && org.apache.commons.lang.StringUtils.isNotBlank((String)billImageMapInfo.getScanUserID())) {
                String scanUserID = billImageMapInfo.getScanUserID();
                filter = new FilterInfo();
                ObjectUuidPK uuidPK = null;
                try {
                    BOSUuid uuid = BOSUuid.read((String)scanUserID);
                    uuidPK = new ObjectUuidPK(uuid);
                    if (!new Person().getType().equals((Object)uuidPK.getObjectType())) {
                        uuidPK = null;
                    }
                }
                catch (Exception e) {
                    uuidPK = null;
                    logger.error((Object)("scanUserID(" + scanUserID + ")\u4e0d\u662f\u6709\u6548\u7684person\u7684id,\u653e\u5f03\u67e5\u8be2,\u626b\u63cf\u70b9\u8bbe\u7f6e\u4e3a\u7a7a."), (Throwable)e);
                }
                if (uuidPK != null) {
                    filter.getFilterItems().add(new FilterItemInfo("handlerID.id", (Object)scanUserID));
                    view.setFilter(filter);
                    ImageHandlerCollection imageHandlerCollection = ImageHandlerFactory.getLocalInstance(ctx).getImageHandlerCollection(view);
                    if (imageHandlerCollection != null && imageHandlerCollection.size() > 0) {
                        sscUnitInfo = imageHandlerCollection.get(0).getSscUnitID();
                    }
                }
            }
            billImageMapInfo.setSscUnit(sscUnitInfo);
            if (imageInfo2.getPageCount() > 0) {
                billImageMapInfo.setPageCount(imageInfo2.getPageCount());
            }
            billImageMap.update((IObjectPK)new ObjectUuidPK(billImageMapInfo.getId()), (CoreBaseInfo)billImageMapInfo);
            imageNoSet.add(imageInfo2.getImageNo());
        }
        logger.error((Object)"*********saveImageReady end");
        logger.error((Object)"********* saveImageReady updateHandleTask begin");
        this.updateHandleTask(ctx, imageNoSet);
        logger.error((Object)"*********saveImageReady updateHandleTask end");
    }

    private SSCUnitInfo getSSCUnitByName(Context ctx, String sscUnitName) throws BOSException {
        SSCUnitInfo sscUnitInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)sscUnitName));
        view.setFilter(filter);
        SSCUnitCollection sscUnitCollection = SSCUnitFactory.getLocalInstance(ctx).getSSCUnitCollection(view);
        if (sscUnitCollection == null || sscUnitCollection.size() <= 0) {
            String message = "\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a " + sscUnitName + " \u7684\u626b\u63cf\u70b9\u3002";
            logger.error((Object)message);
            throw new BOSException(message);
        }
        sscUnitInfo = sscUnitCollection.get(0);
        return sscUnitInfo;
    }

    void updateHandleTask(Context ctx, Set imageNoSet) throws BOSException, EASBizException {
        this.updateHandleTaskState(ctx, imageNoSet, "1");
    }

    void createAccount(Context ctx, List<String> billIDList, BaseImageList newList) throws BOSException, EASBizException {
        for (String billID : billIDList) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
            entityView.setFilter(filter);
            BillImageMapCollection billImageMapCollection = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapCollection(entityView);
            if (billImageMapCollection == null || billImageMapCollection.size() <= 0) continue;
            BillImageMapInfo billImageMapInfo = billImageMapCollection.get(0);
            newList.addImageList(this.getImageInfo(ctx, billImageMapInfo));
        }
    }

    void updateAccount(Context ctx, List<String> billIDList) throws BOSException {
        this.updateAccount(ctx, billIDList, ImageStateEnum.HAS_IMAGE);
    }

    BaseImageList getImageList(Context ctx, String scanUserID) throws BOSException {
        BaseImageList newList = new BaseImageList();
        ImageHandleTaskEntryCollection icls = ImageHandleTaskEntryFactory.getLocalInstance(ctx).getImageHandleTaskEntryCollection("select parentID.* where imageHandler = '" + scanUserID + "' and parentID.state = '" + IMAGE_NOT_READY + "'");
        if (null != icls && icls.size() > 0) {
            logger.error((Object)String.valueOf(icls.size()));
            int j = icls.size();
            for (int i = 0; i < j; ++i) {
                RescanImageInfo imageInfo = new RescanImageInfo();
                imageInfo.setImageNo(icls.get(i).getParentID().getBarcode());
                String rescanMessage = icls.get(i).getParentID().getTaskContent();
                logger.error((Object)("\u9000\u626b\u610f\u89c1\u7279\u6b8a\u5b57\u7b26\u8f6c\u4e49\u524d:" + rescanMessage));
                if (rescanMessage != null) {
                    rescanMessage = rescanMessage.replace("&", "&amp;");
                    rescanMessage = rescanMessage.replace("'", "&apos;");
                    rescanMessage = rescanMessage.replace("<", "&lt;");
                    rescanMessage = rescanMessage.replace(">", "&gt;");
                    rescanMessage = rescanMessage.replace("\"", "&quot;");
                }
                logger.error((Object)("\u9000\u626b\u610f\u89c1\u7279\u6b8a\u5b57\u7b26\u8f6c\u4e49\u540e:" + rescanMessage));
                imageInfo.setRescanMessage(rescanMessage);
                imageInfo.setRescanUser(icls.get(i).getParentID().getTaskHandler());
                newList.addImageList(imageInfo);
            }
        }
        return newList;
    }

    BaseImageList getNeedScanImageList(Context ctx, String personID) throws BOSException {
        BaseImageList newList = new BaseImageList();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fnumber , fcause,famount from t_bc_bizaccountbill where FApplierID = ?  ");
        sql.append(" and fneedphoto=1 and (fisrefpaperpark = 0 or fisrefpaperpark=3 or fisrefpaperpark is null ) ");
        sql.append(" union ");
        sql.append(" select fnumber , fcause,famount from T_BC_TravelAccountBill where FApplierID = ? ");
        sql.append(" and fneedphoto=1 and (fisrefpaperpark = 0 or fisrefpaperpark=3 or fisrefpaperpark is null ) ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{personID, personID});
        try {
            while (rows.next()) {
                BaseBillInfo info = new BaseBillInfo();
                info.setNumber(rows.getString("fnumber"));
                info.setCause(rows.getString("fcause"));
                info.setAmount(rows.getBigDecimal("famount").toString());
                info.setImageMark(null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getNeedScanImageList error");
            e.printStackTrace();
        }
        return newList;
    }

    void updateTravelAccount(Context ctx, Set imageNoSet) throws BOSException {
        String inSql = SSCImageUtils.getStrFromSet(imageNoSet);
        String sql = "update T_BC_TravelAccountBill set fisRefPaperPark=2 where fimageNo in " + inSql;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    void updateBizAccount(Context ctx, Set imageNoSet) throws BOSException {
        String inSql = SSCImageUtils.getStrFromSet(imageNoSet);
        String sql = "update T_BC_BizAccountBill set fisRefPaperPark=2 where fimageNo in " + inSql;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    void createTravelAccount(Context ctx, Set imageNoSet, BaseImageList newList) throws BOSException {
    }

    private SendImageInfo getImageInfo(Context ctx, BillImageMapInfo billImageMapInfo) throws BOSException, EASBizException {
        SendImageInfo imageInfo = new SendImageInfo();
        String billId = billImageMapInfo.getBillID();
        imageInfo.setBillNo(billId);
        imageInfo.setImageNo(billImageMapInfo.getImageNumber());
        imageInfo.setImageExists("Exists");
        if (ImageStateEnum.NO_IMAGE.equals((Object)billImageMapInfo.getImageState()) || ImageStateEnum.RESCAN_IAMGE.equals((Object)billImageMapInfo.getImageState())) {
            imageInfo.setImageAllowScan("AllowScan");
        }
        try {
            String simpleCode = Configure.getBillOrgFiledTypeSimpleCode(ctx);
            BOSObjectType type = BOSUuid.read((String)billId).getType();
            try {
                imageInfo.setBillBosType(type.toString());
                EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSUuid.getBOSObjectType((String)billId, (boolean)true));
                imageInfo.setBillTypeName(entityObjectInfo.getAlias());
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(billId));
            BillFiledOrgTypeInfo info = WSSCImageUtils.getBillFiledOrgType(ctx, type.toString(), billValue, simpleCode);
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getOrgFiledValue()));
            if (fullOrgUnitInfo != null && fullOrgUnitInfo.getNumber() != null) {
                imageInfo.setApplierCompany(fullOrgUnitInfo.getNumber());
                imageInfo.setApplierCompanyName(fullOrgUnitInfo.getName());
            }
            String creatorCode = Configure.getBillImageCachParam(ctx, "creatorCode", "4A44F49F!creator");
            String creatorId = WSSCImageUtils.getBillCreatorID(ctx, billValue, creatorCode, "creator");
            String billNumber = billValue.get("number") == null ? "" : billValue.get("number").toString();
            imageInfo.setCreatorId(creatorId);
            imageInfo.setNumber(billNumber);
            Map<String, String> map = WSSCImageUtils.getPhoneAndEmailAndName(ctx, creatorId);
            imageInfo.setCreatorName(org.apache.commons.lang.StringUtils.isEmpty((String)map.get("createName")) ? "" : map.get("createName"));
            imageInfo.setCreatorPhone(org.apache.commons.lang.StringUtils.isEmpty((String)map.get("cellNumber")) ? "" : map.get("cellNumber"));
            imageInfo.setCreatorEmail(org.apache.commons.lang.StringUtils.isEmpty((String)map.get("email")) ? "" : map.get("email"));
            imageInfo.setCreatorNumber(org.apache.commons.lang.StringUtils.isEmpty((String)map.get("createNumber")) ? "" : map.get("createNumber"));
            imageInfo.setResource("2");
            if (org.apache.commons.lang.StringUtils.isEmpty((String)billImageMapInfo.getExtendBillID())) {
                imageInfo.setFsource("2");
                imageInfo.setFerpDataId(ctx.getAIS());
            }
            imageInfo.setExtendName(billImageMapInfo.getExtendName() == null ? "" : billImageMapInfo.getExtendName());
            imageInfo.setExtendID(billImageMapInfo.getExtendBillID() == null ? "" : billImageMapInfo.getExtendBillID());
        }
        catch (Throwable e) {
            logger.error((Object)"imageInfo setApplierCompany error", e);
        }
        return imageInfo;
    }

    void createBizAccount(Context ctx, Set imageNoSet, BaseImageList newList) throws BOSException {
    }

    EntityViewInfo buildSendImageView(Set imageNoSet) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isRefPaperPark"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("imageNo"));
        view.getSelector().add(new SelectorItemInfo("amount"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNo", (Object)imageNoSet, CompareType.INCLUDE));
        return view;
    }

    void invokeTaskCenterService(Context ctx, BaseImageList baseList) throws BOSException, EASBizException, RemoteException {
        logger.error((Object)"***************invokeTaskCenterService:begin");
        String imageNo = null;
        ReceiveImageInfo imageInfo2 = null;
        HashSet<String> taskImageSet = new HashSet<String>();
        logger.error((Object)("baseList.getImageList().size():" + baseList.getImageList().size()));
        if (0 != baseList.getImageList().size()) {
            JSONArray imageArr = new JSONArray();
            for (ReceiveImageInfo imageInfo2 : baseList.getImageList()) {
                logger.error((Object)("**********imageInfo.getImageNo():" + imageInfo2.getImageNo()));
                if (taskImageSet.contains(imageInfo2.getImageNo())) continue;
                imageNo = imageInfo2.getImageNo();
                taskImageSet.add(imageNo);
                imageArr.put((Object)SSCImageUtils.getImageJosnObj(imageNo));
            }
            logger.error((Object)("updateImageState is :" + imageArr.toString()));
            String res = "";
            if (imageInfo2 == null) {
                logger.error((Object)"this is null although is never happen...maybe,if you see this,please check code");
                throw new EASBizException(WSSCException.UNKNOW, new Object[]{"invokeTaskCenterService input param is empty,please check"});
            }
            String deployType = IMAGE_NOT_READY;
            String sscNumber = WSSCUtils.getSSCNumberByImageNb(ctx, imageInfo2.getImageNo());
            deployType = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "deployType");
            if (DPLOY_TYPE_INDEPENDENT.equals(deployType)) {
                logger.error((Object)"SSCImageHandler.invokeTaskCenterService is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("updateImageState");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                res = call.invoke(new Object[]{imageArr.toString()}).toString();
            } else {
                try {
                    logger.error((Object)"SSCImageHandler.invokeTaskCenterService is RPC!");
                    Class<?> factoryClz = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                    Method getInsMethod = factoryClz.getMethod("getLocalInstance", Context.class);
                    Object facadeObj = getInsMethod.invoke(null, ctx);
                    Method updateImageStateMethod = facadeObj.getClass().getMethod("updateImageState", String.class);
                    res = (String)updateImageStateMethod.invoke(facadeObj, imageArr.toString());
                }
                catch (Exception e) {
                    logger.error((Object)("RPC\u901a\u77e5\u5171\u4eab\u4e2d\u5fc3\u66f4\u65b0\u5f71\u50cf\u72b6\u6001\u51fa\u9519\uff01" + e.getMessage()));
                    throw new BOSException((Throwable)e);
                }
            }
            logger.error((Object)("updateImageState return :" + res));
            if (!res.equals(imageNo)) {
                String message = "update SSC image state error!";
                logger.error((Object)message);
                throw new BOSException(message);
            }
        }
    }

    void invokeTaskCenterServiceRescan(Context ctx, BaseImageList baseList) throws BOSException, EASBizException, RemoteException {
        logger.error((Object)"***************invokeTaskCenterServiceRescan:begin");
        ImageStateParamInfo imageInfo2 = null;
        HashSet taskImageSet = new HashSet();
        logger.error((Object)("*********taskImageSet.size:" + taskImageSet.size() + ",baseList.getImageList().size():" + baseList.getImageList().size()));
        if (taskImageSet.size() != baseList.getImageList().size()) {
            JSONArray imageArr = new JSONArray();
            String imageNo = null;
            for (ImageStateParamInfo imageInfo2 : baseList.getImageList()) {
                imageNo = imageInfo2.getImageNo();
                logger.error((Object)("**********imageInfo.getImageNo():" + imageInfo2.getImageNo()));
                if (taskImageSet.contains(imageInfo2.getImageNo())) continue;
                logger.error((Object)"********** contains");
                String previousNodeAssignId = this.getPreviousNodeAssignId(ctx, imageNo);
                imageArr.put((Object)SSCImageUtils.getImageJosnObj(imageInfo2, previousNodeAssignId));
            }
            logger.error((Object)("updateImageState is :" + imageArr.toString()));
            String res = "";
            if (imageInfo2 == null) {
                logger.error((Object)"this is null although is never happen...maybe,if you see this,please check code");
                throw new EASBizException(WSSCException.UNKNOW, new Object[]{"invokeTaskCenterService input param is empty,please check"});
            }
            String deployType = IMAGE_NOT_READY;
            String sscNumber = WSSCUtils.getSSCNumberByImageNb(ctx, imageInfo2.getImageNo());
            deployType = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "deployType");
            if (DPLOY_TYPE_INDEPENDENT.equals(deployType)) {
                logger.error((Object)"SSCImageHandler.invokeTaskCenterServiceRescan is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("updateImageState");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                res = call.invoke(new Object[]{imageArr.toString(), "1"}).toString();
            } else {
                try {
                    logger.error((Object)"SSCImageHandler.invokeTaskCenterServiceRescan is RPC!");
                    Class<?> factoryClz = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                    Method getInsMethod = factoryClz.getMethod("getLocalInstance", Context.class);
                    Object facadeObj = getInsMethod.invoke(null, ctx);
                    Method updateImageStateMethod = facadeObj.getClass().getMethod("updateImageState", String.class, String.class);
                    res = (String)updateImageStateMethod.invoke(facadeObj, imageArr.toString(), "1");
                }
                catch (Exception e) {
                    logger.error((Object)("RPC\u901a\u77e5\u5171\u4eab\u4e2d\u5fc3\u66f4\u65b0\u5f71\u50cf\u72b6\u6001\u4e3a\u2018\u9000\u56de\u91cd\u626b\u2019\u51fa\u9519\uff01" + e.getMessage()));
                    throw new BOSException((Throwable)e);
                }
            }
            logger.error((Object)("updateImageState return :" + res));
            if (imageNo == null || !imageNo.equals(res)) {
                String message = "update SSC image state error!";
                logger.error((Object)message);
                throw new BOSException(message);
            }
        }
    }

    protected String getPreviousNodeAssignId(Context ctx, String imageNo) {
        try {
            String billID = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageNo);
            String asssql = " SELECT top 1 FASSIGNID  FROM t_wfr_assigndetail where FBIZOBJID = ? order by FLASTSTATETIME DESC ";
            IRowSet rsass = DbUtil.executeQuery((Context)ctx, (String)asssql, (Object[])new Object[]{billID});
            if (rsass.next()) {
                String wfrAssign = rsass.getString("FASSIGNID");
                return wfrAssign;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public void updateAccount(Context ctx, List<String> billIDList, ImageStateEnum imageState) throws BOSException {
        for (String billID : billIDList) {
            BOSObjectType bosType = BOSUuid.read((String)billID).getType();
            BillImageFacadeFactory.getLocalInstance(ctx).updateImageState(bosType.toString(), billID, imageState);
        }
    }

    public void saveImageHandleTaskState(Context ctx, BaseImageList baseList, String hasReady) throws BOSException, EASBizException {
        HashSet<String> imageNoSet = new HashSet<String>();
        for (BaseImageInfo imageInfo : baseList.getImageList()) {
            imageNoSet.add(imageInfo.getImageNo());
        }
        this.updateHandleTaskState(ctx, imageNoSet, hasReady);
    }

    private void updateHandleTaskState(Context ctx, Set imageNoSet, String hasReady) throws BOSException, EASBizException {
        String reverseHasReady = hasReady.equals("1") ? IMAGE_NOT_READY : "1";
        logger.error((Object)"*********updateHandleTaskState begin");
        String currentPid = "";
        if (null != ContextUtil.getCurrentUserInfo((Context)ctx).getPerson()) {
            currentPid = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        IImageHandleTask handTask = ImageHandleTaskFactory.getLocalInstance(ctx);
        ImageHandleTaskCollection icls = null;
        ImageHandleTaskInfo handleTaskInfo = null;
        Object handleTaskEntryInfo = null;
        ImageHandleTaskEntryCollection handleTaskEntryCollection = null;
        icls = handTask.getImageHandleTaskCollection("select *,entry.* where barcode  in" + SSCImageUtils.getStrFromSet(imageNoSet) + " and state ='" + reverseHasReady + "'");
        if (null != icls && icls.size() > 0) {
            int j = icls.size();
            for (int i = 0; i < j; ++i) {
                handleTaskInfo = icls.get(i);
                handleTaskInfo.setHandleTime(new Timestamp(System.currentTimeMillis()));
                handleTaskInfo.setState(hasReady);
                handleTaskEntryCollection = handleTaskInfo.getEntry();
                if (handleTaskEntryCollection.size() > 0) {
                    int n = handleTaskEntryCollection.size();
                    for (int m = 0; m < n; ++m) {
                        ImageHandleTaskEntryInfo entryInfo = handleTaskEntryCollection.get(m);
                        if (currentPid.equals(entryInfo.getImageHandler())) {
                            entryInfo.setIsSelfHandle(1);
                            continue;
                        }
                        entryInfo.setIsSelfHandle(0);
                    }
                }
                handTask.update((IObjectPK)new ObjectUuidPK(handleTaskInfo.getId()), (CoreBaseInfo)handleTaskInfo);
            }
        }
        logger.error((Object)"*********updateHandleTaskState end");
    }

    String invokeTaskCenterServiceDestoryJob(Context ctx, BaseImageList baseList) throws BOSException, EASBizException, RemoteException {
        logger.error((Object)"***************invokeTaskCenterServiceDestoryJob:begin");
        String res = IMAGE_NOT_READY;
        ImageStateParamInfo imageInfo2 = null;
        if (!baseList.getImageList().isEmpty()) {
            JSONArray imageArr = new JSONArray();
            for (ImageStateParamInfo imageInfo2 : baseList.getImageList()) {
                logger.error((Object)("**********imageInfo.getImageNo():" + imageInfo2.getImageNo()));
                imageArr.put((Object)SSCImageUtils.getImageJosnObj(imageInfo2.getImageNo()));
            }
            if (imageInfo2 == null) {
                logger.error((Object)"transfer input param fail,pleas check");
                throw new EASBizException(WSSCException.CUSTOM, new Object[]{"check input params"});
            }
            logger.error((Object)("invokeTaskCenterServiceDestoryJob imageNo is :" + imageArr.toString()));
            String serviceUrl = "";
            String methodName = "destoryJob";
            try {
                if (this.isWebService(ctx, WSSCUtils.getSSCNumberByImageNb(ctx, imageInfo2.getImageNo()))) {
                    logger.error((Object)"SSCImageHandler.invokeTaskCenterServiceRescan is webService!");
                    String sscNumber = WSSCUtils.getSSCNumberByImageNb(ctx, imageInfo2.getImageNo());
                    serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "createShareTaskWebServiceUrl");
                    WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                    String sessionId = servCtx.getSessionId();
                    if (StringUtils.isEmpty((String)sessionId)) {
                        logger.error((Object)"login SSC Fail!");
                        throw new BOSException("login SSC Fail!");
                    }
                    Call call = servCtx.getCall(true);
                    call.setMaintainSession(true);
                    call.setOperationName(methodName);
                    call.setTargetEndpointAddress(serviceUrl);
                    call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                    res = call.invoke(new Object[]{imageArr.toString()}).toString();
                } else {
                    logger.error((Object)"SSCImageHandler.invokeTaskCenterServiceRescan is RPC!");
                    Class<?> factoryClz = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                    Method getInsMethod = factoryClz.getMethod("getLocalInstance", Context.class);
                    Object facadeObj = getInsMethod.invoke(null, ctx);
                    Method operationMethod = facadeObj.getClass().getMethod(methodName, String.class);
                    res = (String)operationMethod.invoke(facadeObj, imageArr.toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)("invoke TaskInterFacade error! serviceUrl:[" + serviceUrl + "]  OperationName:[" + methodName + "]  param:[" + imageArr + "]"), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            logger.error((Object)("invokeTaskCenterServiceDestoryJob return :" + res));
        }
        return res;
    }

    public boolean isWebService(Context ctx, String sscNumber) {
        return DPLOY_TYPE_INDEPENDENT.equals(this.getDeployTypeFromConfig(ctx, sscNumber));
    }

    private String getDeployTypeFromConfig(Context ctx, String sscNumber) {
        String re = IMAGE_NOT_READY;
        re = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "deployType");
        return re;
    }

    public static WSContext login(Context ctx, String sscNumber) {
        String easLoginURL = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "eas.login.wsdl");
        String easLoginUser = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "userName");
        String easLoginPassword = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "password");
        String slnName = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "slnName");
        String easLoginDatacenter = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "dcName");
        String easLoginDbtype = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "dbType");
        String easLoginLanguage = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "language");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", easLoginUser);
        map.put("password", easLoginPassword);
        map.put("slnName", slnName);
        map.put("dcName", easLoginDatacenter);
        map.put("language ", easLoginLanguage);
        map.put("dbType", easLoginDbtype);
        JSONMap json = new JSONMap(map);
        String param = json.toString();
        try {
            Service s = new Service();
            Call call = (Call)s.createCall();
            call.setMaintainSession(true);
            call.setOperationName("login");
            call.setTargetEndpointAddress(easLoginURL);
            call.setReturnType(new QName("urn:client", "WSContext"));
            call.setReturnClass(WSContext.class);
            call.setReturnQName(new QName("", "loginReturn"));
            WSContext result = (WSContext)call.invoke(new Object[]{easLoginUser, easLoginPassword, slnName, easLoginDatacenter, easLoginLanguage, Integer.valueOf(easLoginDbtype)});
            result.setCall(call);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)SafeFilterUtils.vaildLog("invoke createShareTask webservice error! serviceUrl:[" + easLoginURL + "]  OperationName:[login]  param:[" + param + "]"), (Throwable)e);
            return null;
        }
    }
}

