/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.notice.api;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SSC_XTServiceConfig {
    private static Logger logger = Logger.getLogger(SSC_XTServiceConfig.class);
    private static final String CONFIGFILE = "XTServiceConfig.xml";
    private static final String CONFIGITEM_XTINFO = "XTInfo";
    private static final String CONFIGITEM_DBINFO = "DbInfo";
    private static final String CONFIGITEM_PUBACCT = "PubAcct";
    private static final String CONFIGITEM_DINGTALK = "Dingtalk";
    private static final String CONFIGITEM_WELINK = "WeLink";
    protected static SSC_XTServiceConfig instance = new SSC_XTServiceConfig();
    private static XMLConfiguration configuration;
    private static Object lock;
    private static volatile String xtMcloudUrl;
    private static volatile String kdweiboUrl;
    private static volatile String xtPushServerUrl;
    private static volatile String xtNewPushServerUrl;
    private static String reloadMode;
    long lastModified = 0L;

    protected SSC_XTServiceConfig() {
        this.load();
    }

    public static SSC_XTServiceConfig getInstance() {
        return instance;
    }

    public XMLConfiguration getConfiguration() {
        this.reload();
        return configuration;
    }

    public ConfigurationItem getConfigurationItem(String configKey) {
        this.reload();
        return configuration.getConfigItem(configKey);
    }

    public ConfigurationItem getConfigurationItemByPath(String configPath) {
        this.reload();
        return configuration.getConfigItemByPath(configPath);
    }

    public Map<String, String> getXTInfoProperties() {
        this.reload();
        try {
            return this.getConfigurationItemByPath(CONFIGITEM_XTINFO).getProperties();
        }
        catch (Exception var2) {
            logger.info((Object)"cann't find the properties:XTInfo");
            throw new RuntimeException("cann't find the properties:XTInfo");
        }
    }

    public String getContentType() {
        return this.getXTInfoProperties().get("xt.pubacct.connect.content.type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXTServerUrl() {
        if (!StringUtils.isEmpty((String)xtPushServerUrl)) {
            return xtPushServerUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtPushServerUrl)) {
                return xtPushServerUrl;
            }
            xtPushServerUrl = this.getXTInfoProperties().get("xt.pubacct.connect.server.url");
            if (StringUtils.isEmpty((String)xtPushServerUrl)) {
                xtPushServerUrl = xtMcloudUrl + "/pubacc/pubsend";
            }
        }
        return xtPushServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewXTServerUrl() {
        if (!StringUtils.isEmpty((String)xtNewPushServerUrl)) {
            return xtNewPushServerUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtNewPushServerUrl)) {
                return xtNewPushServerUrl;
            }
            xtNewPushServerUrl = this.getXTInfoProperties().get("newxt.pubacct.connect.server.url");
            if (StringUtils.isEmpty((String)xtNewPushServerUrl)) {
                xtNewPushServerUrl = xtMcloudUrl + "/gateway/newtodo/open";
            }
        }
        return xtNewPushServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXTMcloudUrl() {
        if (!StringUtils.isEmpty((String)xtMcloudUrl)) {
            return xtMcloudUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtMcloudUrl)) {
                return xtMcloudUrl;
            }
            xtMcloudUrl = this.getXTInfoProperties().get("xt.mcloud.url");
            if (StringUtils.isEmpty((String)xtMcloudUrl)) {
                xtMcloudUrl = "http://www.yunzhijia.com";
            }
        }
        return xtMcloudUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKdWeiboUrl() {
        if (!StringUtils.isEmpty((String)kdweiboUrl)) {
            return kdweiboUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)kdweiboUrl)) {
                return kdweiboUrl;
            }
            kdweiboUrl = this.getXTInfoProperties().get("xt.kdweibo.url");
            if (StringUtils.isEmpty((String)kdweiboUrl)) {
                kdweiboUrl = "http://www.yunzhijia.com";
            }
        }
        return kdweiboUrl;
    }

    public String getEidByDbCode(String dbCode) {
        this.reload();
        String eid = null;
        try {
            ConfigurationItem ct = this.getConfigurationItemByPath(CONFIGITEM_DBINFO);
            List cl = ct.getAllChildren();
            for (int i = 0; i < cl.size(); ++i) {
                ConfigurationItem item = (ConfigurationItem)cl.get(i);
                if (!dbCode.equals(item.getProperty("dbCode"))) continue;
                eid = item.getName();
                break;
            }
            return eid;
        }
        catch (Exception var7) {
            logger.info((Object)"cann't find the properties:DbMap");
            throw new RuntimeException("cann't find the properties:DbMap");
        }
    }

    public Map<String, String> getDbInfoProperties(String eid) {
        this.reload();
        try {
            return this.getConfigurationItemByPath("DbInfo/" + eid).getProperties();
        }
        catch (Exception var3) {
            logger.info((Object)"cann't find the properties:XTInfo");
            throw new RuntimeException("cann't find the properties:XTInfo");
        }
    }

    public String getDbInfoProperty(String eid, String key, String defaultValue) {
        this.reload();
        return this.getConfigurationItemByPath("DbInfo/" + eid).getProperty(key, defaultValue);
    }

    public int getDbType(String eid) {
        return Integer.parseInt(this.getDbInfoProperties(eid).get("dbType"));
    }

    public String getDbCode(String eid) {
        return this.getDbInfoProperties(eid).get("dbCode");
    }

    public String getSlnName(String eid) {
        return this.getDbInfoProperties(eid).get("slnName");
    }

    public String getLocale(String eid) {
        return this.getDbInfoProperties(eid).get("locale");
    }

    private ConfigurationItem getPubAcctProperties(String eid, String pubAcctName) {
        logger.info((Object)("getPubAcctProperties==pubAcctName" + pubAcctName));
        logger.info((Object)("getPubAcctProperties==eid" + eid));
        return this.getConfigurationItemByPath("PubAcct/" + eid + "/" + pubAcctName);
    }

    public String getPubAcctProperty(String eid, String pubAcctName, String key, String defaultValue) {
        logger.info((Object)("getPubAcctProperty==eid" + eid));
        logger.info((Object)("getPubAcctProperty==pubAcctName" + pubAcctName));
        logger.info((Object)("getPubAcctProperty==key" + key));
        return this.getPubAcctProperties(eid, pubAcctName).getProperty(key, defaultValue);
    }

    public String getPubCode(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("code");
    }

    public String getPubKey(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("pubKey");
    }

    public boolean getPubEnabled(String eid, String pubAcctName) {
        return Boolean.parseBoolean(this.getPubAcctProperties(eid, pubAcctName).getProperty("enabled"));
    }

    private void load() {
        System.out.println("-------------------reload XTServiceConfig XML");
        String propertiesPath = System.getProperty("eas.properties.dir");
        String fileName = propertiesPath + File.separator + CONFIGFILE;
        if (fileName.equals("")) {
            throw new IllegalArgumentException("\u5b89\u5168\u95ee\u9898\u6821\u9a8c\uff0c\u4e0d\u4f1a\u4e3a\u7a7a\uff0c\u5176\u5b9e\u8fd9\u91cc\u4e0d\u5224\u7aef\u4e5f\u6ca1\u5565\u95ee\u9898\u5427");
        }
        File configFile = new File(fileName);
        if (configFile.lastModified() != this.lastModified) {
            this.lastModified = configFile.lastModified();
            if (configFile.exists()) {
                configuration = XMLConfiguration.getInstance((File)configFile);
                this.loadMode();
            } else {
                throw new RuntimeException("cann't find the config file!");
            }
        }
    }

    private void loadMode() {
        String mode = this.getConfigurationItemByPath("ReadMode").getProperty("reload");
        if (!StringUtils.isEmpty((String)mode)) {
            reloadMode = mode;
        }
    }

    protected void reload() {
        if ("true".equals(reloadMode)) {
            // empty if block
        }
    }

    static {
        lock = new Object();
        xtMcloudUrl = null;
        kdweiboUrl = null;
        xtPushServerUrl = null;
        xtNewPushServerUrl = null;
    }
}

