/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.dynamicthreadpool;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.info.ExecuteRecordBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.info.ExecuteRecordInfo;
import com.kingdee.eas.base.wssc.dynamicthreadpool.threadlocal.WSSCThreadLocal;
import com.kingdee.eas.base.wssc.dynamicthreadpool.utils.ExceptionFormatUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DynamicThreadPoolExecutor
extends ThreadPoolExecutor {
    private String applicationName = "SSC";
    private String threadPoolName = "kingThreadPool";
    private String defaultTaskName = "defaultTaskName";
    private Context ctx;
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();
    private Map<String, ExecuteRecordInfo> transactionMap = new ConcurrentHashMap<String, ExecuteRecordInfo>();

    public DynamicThreadPoolExecutor(Context ctx, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.ctx = ctx;
    }

    public DynamicThreadPoolExecutor(Context ctx, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
        this.ctx = ctx;
    }

    public DynamicThreadPoolExecutor(Context ctx, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String threadPoolName, String applicationName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.threadPoolName = threadPoolName;
        this.applicationName = applicationName;
        this.ctx = ctx;
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
    }

    public void execute(Runnable command, String taskName) {
        super.execute(command);
    }

    public Future<?> submit(Runnable task, String taskName) {
        return super.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task, String taskName) {
        return super.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result, String taskName) {
        return super.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(task, result);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        String threadName = t.getId() + "";
        ExecuteRecordBuilder builder = new ExecuteRecordBuilder();
        ExecuteRecordInfo executeRecordInfo = builder.applicationName(this.applicationName).threadPoolName(this.threadPoolName).threadName(t.getName()).className(r.getClass().getName()).ctx(this.ctx).getExecuteRecordInfo();
        this.transactionMap.put(threadName, executeRecordInfo);
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ArrayBlockingQueue<ExecuteRecordInfo> queue;
        super.afterExecute(r, t);
        String threadName = Thread.currentThread().getId() + "";
        ExecuteRecordInfo executeRecordInfo = this.transactionMap.get(threadName);
        executeRecordInfo.setStatus(1);
        executeRecordInfo.setEndMem(Runtime.getRuntime().freeMemory());
        executeRecordInfo.setEndDate(new Date());
        executeRecordInfo.setThreadName(Thread.currentThread().getName());
        executeRecordInfo.setRuntimeInfos(WSSCThreadLocal.THREAD_LOCAL.get() + "");
        WSSCThreadLocal.THREAD_LOCAL.remove();
        if (t != null) {
            String exceptionMsg = ExceptionFormatUtils.getThrowableDetail(t);
            exceptionMsg = exceptionMsg != null && exceptionMsg.length() > 2000 ? exceptionMsg.substring(0, 2000) : exceptionMsg;
            executeRecordInfo.setExceptionInfo(exceptionMsg);
            executeRecordInfo.setStatus(0);
        }
        if ((queue = DynamicThreadPoolManager.getInstance().getExecuteRecodeMap().putIfAbsent(this.ctx, new ArrayBlockingQueue(5000))) == null) {
            queue = DynamicThreadPoolManager.getInstance().getExecuteRecodeMap().get(this.ctx);
        }
        if (executeRecordInfo.getStatus() == 0) {
            queue.add(executeRecordInfo);
        }
        this.transactionMap.remove(threadName);
    }
}

