/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.dynamicthreadpool;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolExecutor;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TestThreadPool {
    public static void main(String[] args) throws Exception {
        DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
        DynamicThreadPoolProperties dynamicThreadPoolProperties = manager.getDynamicThreadPoolProperties();
        TestThreadPool.create(manager, dynamicThreadPoolProperties);
        TestThreadPool.getDynamicThreadPool(manager, dynamicThreadPoolProperties);
        TestThreadPool.exec(manager);
        System.out.println("over");
        System.in.read();
    }

    public static void exec(DynamicThreadPoolManager manager) throws EASBizException, BOSException {
        int i;
        for (i = 0; i < 100; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            manager.getThreadPoolExecutor("SSC", "TestThreadPool0").execute(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Run_Thread_TestThreadPool0:" + Thread.currentThread().getName());
                }
            }, "TestTask" + i);
        }
        for (i = 0; i < 100; ++i) {
            try {
                Thread.sleep(500L);
                manager.getThreadPoolExecutor("WSSC", "TestThreadPool1").execute(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Run_Thread_TestThreadPool1:" + Thread.currentThread().getName());
                    }
                }, "TestTask" + i);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ThreadPoolProperties properties = new ThreadPoolBuilder().applicationName("WSSC").threadPoolName("TestThreadPool1").corePoolSize(8).maximumPoolSize(20).queueCapacity(100).keepAliveTime(1L).timeUnit(TimeUnit.SECONDS).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).getProperties();
                manager.refreshThreadPoolExecutor(properties);
            }
        }
    }

    public static void create(DynamicThreadPoolManager manager, DynamicThreadPoolProperties poolProperties) {
        Context ctx1;
        ThreadPoolProperties properties1;
        Context ctx2 = new Context("ctx-ssc");
        ThreadPoolProperties properties = new ThreadPoolBuilder().ctx(ctx2).applicationName("SSC").threadPoolName("TestThreadPool0").corePoolSize(2).maximumPoolSize(5).queueCapacity(40).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).getProperties();
        if (!poolProperties.exists(properties)) {
            poolProperties.getExecutors().add(properties);
        }
        if (!poolProperties.exists(properties1 = new ThreadPoolBuilder().ctx(ctx1 = new Context("ctx-wssc")).applicationName("WSSC").threadPoolName("TestThreadPool1").corePoolSize(4).maximumPoolSize(10).queueCapacity(50).keepAliveTime(2L).timeUnit(TimeUnit.SECONDS).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).getProperties())) {
            poolProperties.getExecutors().add(properties1);
        }
        manager.createThreadPoolExecutor(poolProperties);
    }

    public static void getDynamicThreadPool(final DynamicThreadPoolManager manager, final DynamicThreadPoolProperties poolProperties) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    HashMap<String, Map> result = new HashMap<String, Map>();
                    for (ThreadPoolProperties executor : poolProperties.getExecutors()) {
                        String threadPoolName = executor.getThreadPoolName();
                        DynamicThreadPoolExecutor threadPoolExecutor = manager.getThreadPoolExecutor(executor.getApplicationName(), threadPoolName);
                        Map threadPoolInfo = manager.getThreadPoolInfo(executor, threadPoolExecutor);
                        result.put(threadPoolName, threadPoolInfo);
                    }
                    System.out.println(JSON.toJSONString(result));
                    try {
                        Thread.sleep(10000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }
}

