/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.dynamicthreadpool.alarm;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DynamicThreadPoolAlarm {
    private static Logger logger = Logger.getLogger(DynamicThreadPoolAlarm.class);
    private static volatile DynamicThreadPoolAlarm instance;
    private DynamicThreadPoolManager manager;
    private DynamicThreadPoolProperties properties;
    private List<String> notifyClass = new ArrayList<String>();
    static final String sql = "insert into T_WSC_ThreadAlarm(applicationName,threadPoolName,msg,ctx,createTime) values(?,?,?,?,?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicThreadPoolAlarm getInstance() {
        if (instance != null) return instance;
        Class<DynamicThreadPoolAlarm> clazz = DynamicThreadPoolAlarm.class;
        synchronized (DynamicThreadPoolAlarm.class) {
            if (instance != null) return instance;
            instance = new DynamicThreadPoolAlarm();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DynamicThreadPoolAlarm() {
        this.manager = DynamicThreadPoolManager.getInstance();
        this.properties = this.manager.getDynamicThreadPoolProperties();
        new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                while (true) lbl-1000:
                // 5 sources

                {
                    for (ThreadPoolProperties prop : DynamicThreadPoolAlarm.access$000(DynamicThreadPoolAlarm.this).getExecutors()) {
                        threadPoolName = prop.getThreadPoolName();
                        applicationName = prop.getApplicationName();
                        threadPoolExecutor = DynamicThreadPoolAlarm.access$100(DynamicThreadPoolAlarm.this).getThreadPoolExecutor(applicationName, threadPoolName);
                        queueCapacityThreshold = prop.getQueueCapacityThreshold();
                        taskCount = threadPoolExecutor.getQueue().size();
                        if (taskCount > queueCapacityThreshold) {
                            DynamicThreadPoolAlarm.access$200(DynamicThreadPoolAlarm.this, prop, taskCount);
                        }
                        if ((rejectCount = DynamicThreadPoolAlarm.access$100(DynamicThreadPoolAlarm.this).getRejectCount(applicationName, threadPoolName)) == null || rejectCount.get() <= 0L) continue;
                        DynamicThreadPoolAlarm.access$300(DynamicThreadPoolAlarm.this, rejectCount.get(), prop);
                        DynamicThreadPoolAlarm.access$100(DynamicThreadPoolAlarm.this).clearRejectCount(applicationName, threadPoolName);
                    }
                    try {
                        Thread.sleep(DynamicThreadPoolAlarm.access$000(DynamicThreadPoolAlarm.this).getAlarmTimeInterval());
                        ** continue;
                    }
                    catch (InterruptedException e) {
                        DynamicThreadPoolAlarm.access$400().error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    private void sendRejectAlarmMessage(long rejectCount, ThreadPoolProperties prop) {
        String alarmMessage = this.getRejectCountMessage(rejectCount, prop);
        this.alarmNotify(prop, alarmMessage);
    }

    private void sendQueueCapacityThresholdAlarmMessage(ThreadPoolProperties prop, int taskCount) {
        String alarmMessage = this.getQueueCapacityThresholdMessage(prop, taskCount);
        this.alarmNotify(prop, alarmMessage);
    }

    private void alarmNotify(ThreadPoolProperties prop, String alarmMessage) {
        try {
            DbUtil.execute((Context)prop.getCtx(), (String)sql, (Object[])new Object[]{prop.getApplicationName(), prop.getThreadPoolName(), alarmMessage, prop.getCtx().toString(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getQueueCapacityThresholdMessage(ThreadPoolProperties prop, int taskCount) {
        return this.getALarmMessage("\u7ebf\u7a0b\u6c60\u51fa\u73b0\u4efb\u52a1\u5806\u79ef\u60c5\u51b5,\u961f\u5217\u5bb9\u91cf:" + prop.getQueueCapacity() + ",\u7b49\u5f85\u6267\u884c\u4efb\u52a1\u6570\u91cf:" + taskCount, prop);
    }

    private String getRejectCountMessage(long rejectCount, ThreadPoolProperties prop) {
        return this.getALarmMessage("\u7ebf\u7a0b\u6c60\u4e2d\u51fa\u73b0RejectedExecutionException\u5f02\u5e38:" + rejectCount + "\u6b21", prop);
    }

    private String getALarmMessage(String reason, ThreadPoolProperties prop) {
        StringBuilder content = new StringBuilder();
        content.append("\u544a\u8b66\u5e94\u7528:").append(prop.getApplicationName()).append("\n");
        content.append("\u7ebf\u7a0b\u6c60\u540d\u79f0:").append(prop.getThreadPoolName()).append("\n");
        content.append("\u544a\u8b66\u539f\u56e0:").append(reason).append("\n");
        content.append("\u53c2\u6570\u4fe1\u606f:").append(prop.toString());
        content.append("\u544a\u8b66\u95f4\u9694:").append(this.properties.getAlarmTimeInterval()).append("\u5206\u949f\n");
        return content.toString();
    }

    static /* synthetic */ DynamicThreadPoolProperties access$000(DynamicThreadPoolAlarm x0) {
        return x0.properties;
    }

    static /* synthetic */ DynamicThreadPoolManager access$100(DynamicThreadPoolAlarm x0) {
        return x0.manager;
    }

    static /* synthetic */ void access$200(DynamicThreadPoolAlarm x0, ThreadPoolProperties x1, int x2) {
        x0.sendQueueCapacityThresholdAlarmMessage(x1, x2);
    }

    static /* synthetic */ void access$300(DynamicThreadPoolAlarm x0, long x1, ThreadPoolProperties x2) {
        x0.sendRejectAlarmMessage(x1, x2);
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }
}

