/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.image;

import java.io.FileInputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class MapUtil {
    private static Logger logger = Logger.getLogger(MapUtil.class);
    private static Properties properties = new Properties();

    public static String getValue(String key) {
        return properties.getProperty(key);
    }

    @Deprecated
    public static void load(String fileName) {
        try (FileInputStream fileInputStream = new FileInputStream(fileName);){
            properties.load(fileInputStream);
            MapUtil.compositeProp(properties);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void clearCache() {
        properties.clear();
    }

    public static void refresh(String fileName) {
        Properties prop = new Properties();
        try (FileInputStream stream = new FileInputStream(fileName);){
            prop.load(stream);
            MapUtil.setProperties(prop);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void setProperties(Properties prop) {
        if (prop == null || prop.isEmpty()) {
            return;
        }
        MapUtil.compositeProp(prop);
        Set<Object> keys = prop.keySet();
        if (keys != null) {
            for (String string : keys) {
                properties.setProperty(string, prop.getProperty(string));
            }
        }
    }

    public static void compositeProp(Properties ori) {
        String erpIp = ori.getProperty("erp.ip");
        String erpPort = ori.getProperty("erp.port");
        String imageIp = ori.getProperty("image.ip");
        String imagePort = ori.getProperty("image.port");
        if (erpIp != null) {
            ori.put("eas.login.wsdl", "http://" + erpIp + ":" + erpPort + "/ormrpc/services/EASLogin?wsdl");
            ori.put("sharetaskaddress", "http://" + erpIp + ":" + erpPort + "/ormrpc/services/WSTaskInterFacede?wsdl");
            ori.put("createShareTaskWebServiceUrl", "http://" + erpIp + ":" + erpPort + "/ormrpc/services/WSTaskInterFacede?wsdl");
        }
        if (imageIp != null) {
            String imageSystem = ori.getProperty("image.system.type");
            String imageWsdl = "/X-Smart.WebService/services/IScanWebServiceImplService.asmx?WSDL";
            String imageHttpUrl = "/X-Smart.WebService/services/IScanWebServiceBatchUploadImage.ashx?";
            if ("GXHC".equals(imageSystem)) {
                imageWsdl = "/SiitFrameWs/services/AutoImageCenter.ws?wsdl";
                ori.put("image", "http://" + imageIp + ":" + imagePort + imageWsdl);
                imageHttpUrl = "/HSImage/servlet/HttpJsonUpload?";
                ori.put("voucher.file.image.url", "http://" + imageIp + ":" + imagePort + "/SiitFrameWs/services/AutoImageCenter.ws?wsdl");
            }
            if ("TCZT".equals(imageSystem)) {
                imageWsdl = "/TIMS-Server/services/ImageForCommonService";
                imageHttpUrl = "/TIMS-Server/services/ImageForCommonService";
                ori.put("image", "http://" + imageIp + ":" + imagePort + imageWsdl);
            } else {
                ori.put("image", "http://" + imageIp + ":" + imagePort + imageWsdl);
            }
            ori.put("image.system.http.url", "http://" + imageIp + ":" + imagePort + imageHttpUrl);
        }
        ori.put("createTaskProcessVarableName", "shareCenter");
        ori.put("createTaskMethodName", "createJob");
    }
}

