/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.image;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ViewSavedPhtotoResultInfo {
    private final boolean useStream;
    private String billID;
    private String phonePhotoCacheID;
    private List<InnerInfo> photos = new ArrayList<InnerInfo>(2);

    public ViewSavedPhtotoResultInfo() {
        this.useStream = true;
    }

    public ViewSavedPhtotoResultInfo(boolean useStream) {
        this.useStream = useStream;
    }

    public boolean isUseStream() {
        return this.useStream;
    }

    public void setBillID(String billID) {
        this.billID = billID;
    }

    public List<InnerInfo> getPhotos() {
        return this.photos;
    }

    public String getPhonePhotoCacheID() {
        return this.phonePhotoCacheID;
    }

    public void setPhonePhotoCacheID(String phonePhotoCacheID) {
        this.phonePhotoCacheID = phonePhotoCacheID;
    }

    public void setPhotos(List<InnerInfo> photos) {
        this.photos = photos;
    }

    public InputStream getInputStreamByPixel(String pixel) {
        if (!this.useStream) {
            throw new IllegalArgumentException("\u5f53\u524d\u67e5\u770b\u6682\u5b58\u5f71\u50cf,\u4f7f\u7528\u7684\u662fbyte[]\u65b9\u5f0f\u4f20\u9012\u6570\u636e.\u8bf7\u4f7f\u7528getBytsByPixel\u65b9\u6cd5.");
        }
        if (this.photos == null || this.photos.isEmpty()) {
            return null;
        }
        int length = this.photos.size();
        for (int i = 0; i < length; ++i) {
            InnerInfo info = this.photos.get(i);
            if (!pixel.equals(info.getPixel())) continue;
            return info.getInputStream();
        }
        return null;
    }

    public InputStream getInputStreamByName(String name) {
        if (!this.useStream) {
            throw new IllegalArgumentException("\u5f53\u524d\u67e5\u770b\u6682\u5b58\u5f71\u50cf,\u4f7f\u7528\u7684\u662fbyte[]\u65b9\u5f0f\u4f20\u9012\u6570\u636e.\u8bf7\u4f7f\u7528getBytsByName\u65b9\u6cd5.");
        }
        if (this.photos == null || this.photos.isEmpty()) {
            return null;
        }
        int length = this.photos.size();
        for (int i = 0; i < length; ++i) {
            InnerInfo info = this.photos.get(i);
            if (!name.equals(info.getName())) continue;
            return info.getInputStream();
        }
        return null;
    }

    public byte[] getBytsByPixel(String pixel) {
        if (this.useStream) {
            throw new IllegalArgumentException("\u5f53\u524d\u67e5\u770b\u6682\u5b58\u5f71\u50cf,\u4f7f\u7528\u7684\u662fOutputStream\u65b9\u5f0f\u4f20\u9012\u6570\u636e.\u8bf7\u4f7f\u7528getInputStreamByPixel\u65b9\u6cd5.");
        }
        if (this.photos == null || this.photos.isEmpty()) {
            return null;
        }
        int length = this.photos.size();
        for (int i = 0; i < length; ++i) {
            InnerInfo info = this.photos.get(i);
            if (!pixel.equals(info.getPixel())) continue;
            return info.getBytes();
        }
        return null;
    }

    public byte[] getBytsByName(String name) {
        if (this.useStream) {
            throw new IllegalArgumentException("\u5f53\u524d\u67e5\u770b\u6682\u5b58\u5f71\u50cf,\u4f7f\u7528\u7684\u662fOutputStream\u65b9\u5f0f\u4f20\u9012\u6570\u636e.\u8bf7\u4f7f\u7528getInputStreamByName\u65b9\u6cd5.");
        }
        if (this.photos == null || this.photos.isEmpty()) {
            return null;
        }
        int length = this.photos.size();
        for (int i = 0; i < length; ++i) {
            InnerInfo info = this.photos.get(i);
            if (!name.equals(info.getName())) continue;
            return info.getBytes();
        }
        return null;
    }

    public int getSizeByPixel(String pixel) {
        if (this.photos == null || this.photos.isEmpty()) {
            return -1;
        }
        int length = this.photos.size();
        for (int i = 0; i < length; ++i) {
            InnerInfo info = this.photos.get(i);
            if (!pixel.equals(info.getPixel())) continue;
            return info.getSize();
        }
        return -1;
    }

    public int getSizeByName(String name) {
        if (this.photos == null || this.photos.isEmpty()) {
            return -1;
        }
        int length = this.photos.size();
        for (int i = 0; i < length; ++i) {
            InnerInfo info = this.photos.get(i);
            if (!name.equals(info.getName())) continue;
            return info.getSize();
        }
        return -1;
    }

    public String getBillID() {
        return this.billID;
    }

    public String toString() {
        StringBuilder sbu = new StringBuilder();
        sbu.append(this.getClass()).append("{").append("billID:" + this.billID).append(",").append("phonePhotoCacheID:" + this.phonePhotoCacheID).append(",").append("useStream:" + this.useStream).append(",").append("photos:" + this.photos).append("}");
        return sbu.toString();
    }

    public class InnerInfo {
        private InputStream inputStream;
        private byte[] bytes;
        private int size = -1;
        private String pixel;
        private String name;

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String getPixel() {
            return this.pixel;
        }

        public void setPixel(String pixel) {
            this.pixel = pixel;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuilder sbu = new StringBuilder();
            sbu.append(this.getClass()).append("{").append("pixel:" + this.pixel).append(",").append("name:" + this.name).append(",").append("size:" + this.size).append("}");
            return sbu.toString();
        }
    }
}

