/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.imageNew.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.wssc.MultiImageServiceFacadeFactory;
import com.kingdee.eas.base.wssc.OrgImageMapCollection;
import com.kingdee.eas.base.wssc.OrgImageMapFactory;
import com.kingdee.eas.base.wssc.OrgImageMapInfo;
import com.kingdee.eas.base.wssc.ShareCenterCfgCollection;
import com.kingdee.eas.base.wssc.ShareCenterCfgFactory;
import com.kingdee.eas.base.wssc.ShareCenterCfgInfo;
import com.kingdee.eas.base.wssc.ShareCenterCollection;
import com.kingdee.eas.base.wssc.ShareCenterFactory;
import com.kingdee.eas.base.wssc.ShareCenterInfo;
import com.kingdee.eas.base.wssc.imageNew.pojo.BillFiledOrgTypeInfo;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WSSCImageUtils {
    private static Logger logger = Logger.getLogger(WSSCImageUtils.class);

    public static Map<String, ShareCenterCfgInfo> getPrototypeMap(Context ctx) throws BOSException {
        HashMap<String, ShareCenterCfgInfo> map = new HashMap<String, ShareCenterCfgInfo>();
        ShareCenterCfgCollection coll = ShareCenterCfgFactory.getLocalInstance(ctx).getShareCenterCfgCollection();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                ShareCenterCfgInfo info = coll.get(i);
                map.put(info.getKey(), info);
            }
        }
        return map;
    }

    public static Map<String, String> getPrototypeDefaultValueMap(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        ShareCenterCfgCollection coll = ShareCenterCfgFactory.getLocalInstance(ctx).getShareCenterCfgCollection();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                ShareCenterCfgInfo info = coll.get(i);
                map.put(info.getKey(), info.getDefaultValue());
            }
        }
        return map;
    }

    public static String getPrototypeDefaultValue(Context ctx, String protoTypeKey) throws BOSException {
        Map<String, String> map = WSSCImageUtils.getPrototypeDefaultValueMap(ctx);
        return map.get(protoTypeKey);
    }

    public static Map getBillShortCodeMap(Context ctx, String billShortCode) {
        if (StringUtils.isEmpty((String)billShortCode)) {
            return new HashMap();
        }
        String[] ShortCodes = billShortCode.split("#");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String shortCode : ShortCodes) {
            String[] codes = shortCode.split("!");
            if (codes == null || codes.length <= 1) continue;
            String bosType = codes[0];
            String simple = codes[1];
            map.put(bosType, simple);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BillFiledOrgTypeInfo getBillFiledOrgType(Context ctx, String bosType, IObjectValue iObjectValue, String simpleCode) throws BOSException {
        Object code;
        String filed = "";
        String orgType = "";
        String[] codes = simpleCode.split("#");
        for (int i = 0; i < codes.length; ++i) {
            code = codes[i];
            if (!((String)code).contains(bosType)) continue;
            String[] billOrgType = ((String)code).split("!");
            filed = billOrgType[1];
            orgType = billOrgType[2];
        }
        if (StringUtils.isEmpty((String)filed) || StringUtils.isEmpty((String)orgType)) {
            Object id = iObjectValue.get("id");
            if (id != null) {
                code = WSSCImageUtils.class;
                synchronized (WSSCImageUtils.class) {
                    try {
                        OrgType anEnum;
                        Map epMap;
                        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSUuid.getBOSObjectType((String)id.toString(), (boolean)true));
                        Object type = entityObjectInfo.get("bosType");
                        String billBosType = type.toString();
                        String orgTypeEnumName = entityObjectInfo.getExtendedProperty("OrgType");
                        String objectValueClass = entityObjectInfo.getObjectValueClass();
                        Class<?> aClass = Class.forName(objectValueClass);
                        Object o = aClass.newInstance();
                        Method method = aClass.getMethod("getBizOrgPropertyName", new Class[0]);
                        Object invoke = method.invoke(o, null);
                        String mainBizOrgField = null;
                        if (invoke != null) {
                            mainBizOrgField = invoke.toString();
                        }
                        if (org.apache.commons.lang3.StringUtils.isEmpty(mainBizOrgField)) {
                            PropertyCollection entityProperties = entityObjectInfo.getEntityProperties();
                            for (int i = 0; i < entityProperties.size(); ++i) {
                                PropertyInfo propertyInfo = entityProperties.get(i);
                                String isMainBizOrg = propertyInfo.getExtendedProperty("isMainBizOrg");
                                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)isMainBizOrg) || !Boolean.parseBoolean(isMainBizOrg)) continue;
                                mainBizOrgField = propertyInfo.getName();
                                break;
                            }
                        }
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mainBizOrgField) && (epMap = entityObjectInfo.getExtendedProperties()) != null && epMap.size() > 0 && epMap.containsKey("MainOrgFieldName") && epMap.get("MainOrgFieldName") != null) {
                            mainBizOrgField = epMap.get("MainOrgFieldName").toString();
                        }
                        if ((anEnum = OrgType.getEnum((String)orgTypeEnumName)) == null) {
                            anEnum = OrgType.Company;
                        }
                        filed = mainBizOrgField;
                        orgType = anEnum.getValue() + "";
                        MultiImageServiceFacadeFactory.getLocalInstance(ctx).updateBillOrgCode(billBosType, mainBizOrgField, anEnum.getValue());
                    }
                    catch (Throwable e) {
                        logger.error((Object)e.getMessage(), e);
                    }
                }
            }
            filed = "company";
            orgType = "1";
        }
        {
            if (null != filed && filed.contains(".")) {
                BOSObjectType type = BOSObjectType.create((String)bosType);
                String billID = iObjectValue.get("id").toString();
                SelectorItemCollection selColl = new SelectorItemCollection();
                selColl.add(new SelectorItemInfo("*"));
                selColl.add(new SelectorItemInfo(filed));
                IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(billID), selColl);
                BillFiledOrgTypeInfo info = new BillFiledOrgTypeInfo(null, orgType);
                WSSCImageUtils.getBillFiledOrgTypeInfo(ctx, info, billValue, filed.split("\\."));
                return info;
            }
            Object obj = iObjectValue.get(filed);
            String filedValue = "";
            filedValue = obj instanceof IObjectValue ? ((IObjectValue)obj).get("id") + "" : obj + "";
            BillFiledOrgTypeInfo info = new BillFiledOrgTypeInfo(filedValue, orgType);
            return info;
        }
    }

    private static void getBillFiledOrgTypeInfo(Context ctx, BillFiledOrgTypeInfo info, IObjectValue billValue, String[] fileds) {
        if (billValue != null) {
            if (fileds == null || fileds.length == 0) {
                logger.error((Object)"getBillFiledOrgTypeInfo fileds is null or length 0");
                return;
            }
            if (fileds != null && fileds.length == 1) {
                String filedValue = "";
                if (billValue instanceof IObjectValue) {
                    filedValue = billValue.get("id") + "";
                } else {
                    filedValue = billValue + "";
                    logger.error((Object)"getBillFiledOrgTypeInfo \u7ec4\u7ec7\u5b57\u6bb5\u4e3a\u81ea\u6709\u5c5e\u6027");
                }
                info.setOrgFiledValue(filedValue);
            } else if (billValue instanceof IObjectValue) {
                billValue = (IObjectValue)billValue.get(fileds[0]);
                WSSCImageUtils.getBillFiledOrgTypeInfo(ctx, info, billValue, WSSCImageUtils.removeStringArrFrist(fileds));
            } else {
                info.setOrgFiledValue(billValue + "");
                logger.error((Object)"getBillFiledOrgTypeInfo \u975e\u5173\u8054\u5c5e\u6027\u4e0d\u80fd\u7528\u70b9\u53d6\u503c");
            }
        } else {
            info.setOrgFiledValue(billValue + "");
            logger.error((Object)"getBillFiledOrgTypeInfo billValue \u662f\u7a7a\u7684");
        }
    }

    private static String[] removeStringArrFrist(String[] keys) {
        String[] arrNew = new String[keys.length - 1];
        for (int i = 1; i < keys.length; ++i) {
            arrNew[i - 1] = keys[i];
        }
        return arrNew;
    }

    public static String getImageSysByOrg(Context ctx, String orgId, String orgType, boolean isAddCurrentOrg) throws BOSException {
        ShareCenterCollection shareCenterColl = ShareCenterFactory.getLocalInstance(ctx).getShareCenterCollection("select id where cfgType = 'IMAGE'");
        if (shareCenterColl.size() == 0) {
            logger.error((Object)"******\u672a\u627e\u5230\u4efb\u4f55\u5f71\u50cf\u7cfb\u7edf*****");
            throw new BOSException("\u672a\u627e\u5230\u4efb\u4f55\u5f71\u50cf\u7cfb\u7edf");
        }
        if (shareCenterColl.size() == 1) {
            return shareCenterColl.get(0).getId().toString();
        }
        if (StringUtils.isEmpty((String)orgId)) {
            logger.error((Object)"getImageSysByOrg orgId is null");
            return Configure.getDefImage(ctx);
        }
        OrgImageMapCollection coll1 = OrgImageMapFactory.getLocalInstance(ctx).getOrgImageMapCollection("where orgID = '" + orgId + "'");
        if (coll1.size() > 0) {
            return coll1.get(0).getImageSysID().getId().toString();
        }
        String orgTypeId = "";
        try {
            if (!StringUtils.isEmpty((String)orgType)) {
                Integer.parseInt(orgType);
                OrgTreeCollection coll = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection("where type = " + orgType);
                if (coll.size() > 0) {
                    OrgTreeInfo orgTreeInfo = coll.get(0);
                    orgTypeId = orgTreeInfo.getId().toString();
                }
            }
        }
        catch (Exception coll) {
            // empty catch block
        }
        ArrayList<String> parents = new ArrayList<String>();
        WSSCImageUtils.getParentsByOrgType(ctx, parents, orgId, orgTypeId);
        if (parents.size() < 1) {
            logger.error((Object)("*****orgId:" + orgId + "**\u672a\u627e\u5230\u5bf9\u5e94\u5f71\u50cf\u7cfb\u7edf**"));
            return Configure.getDefImage(ctx);
        }
        for (int i = 0; i < parents.size(); ++i) {
            OrgImageMapCollection coll2 = OrgImageMapFactory.getLocalInstance(ctx).getOrgImageMapCollection("where orgID = '" + (String)parents.get(i) + "'");
            if (coll2.size() <= 0) continue;
            String imageSysID = coll2.get(0).getImageSysID().getId().toString();
            if (isAddCurrentOrg) {
                ShareCenterInfo imageSys = new ShareCenterInfo();
                imageSys.setId(BOSUuid.read((String)imageSysID));
                OrgImageMapInfo orgImageMapInfo = new OrgImageMapInfo();
                orgImageMapInfo.setImageSysID(imageSys);
                orgImageMapInfo.setOrgID(orgId);
                orgImageMapInfo.setId(BOSUuid.create((String)"6F2F242E"));
                if (!StringUtils.isEmpty((String)orgTypeId)) {
                    orgImageMapInfo.setOrgType(orgTypeId);
                }
                try {
                    OrgImageMapFactory.getLocalInstance(ctx).addnew(orgImageMapInfo);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return imageSysID;
        }
        logger.error((Object)"\u7ec4\u7ec7\u672a\u5206\u914d\uff1f\u5347\u7ea7\u8fc7\u7a0b\u5230\u54ea\u53bb\u4e86...");
        return Configure.getDefImage(ctx);
    }

    private static void getParentsByOrgType(Context ctx, List<String> parents, String orgId, String orgTypeId) {
        if (StringUtils.isEmpty((String)orgId)) {
            return;
        }
        String sql = StringUtils.isEmpty((String)orgTypeId) ? "SELECT FParentID FROM T_ORG_BaseUnit WHERE FID = '" + orgId + "'" : "SELECT FParentID FROM T_ORG_Structure WHERE FUnitID = '" + orgId + "' AND FTreeID = '" + orgTypeId + "'";
        String parentId = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                parentId = rs.getString(1);
            }
            if (!StringUtils.isEmpty(parentId)) {
                if (!StringUtils.isEmpty((String)orgTypeId)) {
                    OrgStructureCollection orgStructureColl = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("where id = '" + parentId + "'");
                    if (orgStructureColl.size() > 0) {
                        parentId = orgStructureColl.get(0).getUnit().getId().toString();
                    }
                    if (StringUtils.isEmpty((String)parentId)) {
                        return;
                    }
                }
                parents.add(parentId);
                WSSCImageUtils.getParentsByOrgType(ctx, parents, parentId, orgTypeId);
            }
            return;
        }
        catch (Exception e) {
            logger.error((Object)"getParentIDs error", (Throwable)e);
            return;
        }
    }

    public static Map<String, String> getPhoneAndEmailAndName(Context ctx, String creatorId) {
        String sqlPM = "SELECT FCELL,FEMAIL,FPERSONID,FNAME_L2,FNUMBER FROM t_pm_user where fid = '" + creatorId + "'";
        HashMap<String, String> map = new HashMap<String, String>();
        String personId = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlPM);
            if (rs.next()) {
                String cellNumber = rs.getString(1);
                map.put("cellNumber", cellNumber);
                String email = rs.getString(2);
                map.put("email", email);
                personId = rs.getString(3);
                map.put("createName", rs.getString(4));
                map.put("createNumber", rs.getString(5));
            }
        }
        catch (Exception e) {
            logger.error((Object)"get phonenumber And Eamil From t_pm_uer fail", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)((String)map.get("cellNumber"))) || StringUtils.isEmpty((String)((String)map.get("email")))) {
            String sqlbdperson = "SELECT FCELL,FEMAIL,FNAME_L2,fnumber FROM t_bd_person where fid = '" + personId + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbdperson);
                if (rs.next()) {
                    String email;
                    String cellNumber = rs.getString(1);
                    if (!StringUtils.isEmpty((String)cellNumber)) {
                        map.put("cellNumber", cellNumber);
                    }
                    if (!StringUtils.isEmpty((String)(email = rs.getString(2)))) {
                        map.put("email", email);
                    }
                    map.put("createName", rs.getString(3));
                    map.put("createNumber", rs.getString(4));
                }
            }
            catch (Exception e) {
                logger.error((Object)"get phonenumber And Eamil From t_bd_person fail", (Throwable)e);
            }
            return map;
        }
        return map;
    }

    public static String getBillCreatorID(Context ctx, IObjectValue iObjectValue, String creatorCode, String filed) {
        Object o = iObjectValue.get(filed = WSSCImageUtils.getBillRelativeCode(ctx, iObjectValue, creatorCode, filed));
        if (o instanceof IObjectValue) {
            Object id = ((IObjectValue)o).get("id");
            return id == null ? "" : id.toString();
        }
        return o == null ? "" : o.toString();
    }

    public static String getBillRelativeCode(Context ctx, IObjectValue iObjectValue, String creatorCode, String filed) {
        if (StringUtils.isEmpty((String)creatorCode)) {
            return filed;
        }
        String bosType = iObjectValue.getBOSType().toString();
        String[] codes = creatorCode.split("#");
        for (int i = 0; i < codes.length; ++i) {
            String code = codes[i];
            if (!code.contains(bosType)) continue;
            String[] billOrgType = code.split("!");
            filed = billOrgType[1];
        }
        return filed;
    }
}

