/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.know.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.KnowledgeProInfo;
import com.kingdee.eas.base.wssc.KnowledgeProOrgCollection;
import com.kingdee.eas.base.wssc.know.constant.AiConstant;
import com.kingdee.eas.base.wssc.know.info.base.AnswerInfo;
import com.kingdee.eas.base.wssc.know.info.base.AttachmentInfo;
import com.kingdee.eas.base.wssc.know.info.base.KeywordInfo;
import com.kingdee.eas.base.wssc.know.info.base.OrgInfo;
import com.kingdee.eas.base.wssc.know.info.base.QuestionInfo;
import com.kingdee.eas.base.wssc.know.info.base.SynonymInfo;
import com.kingdee.eas.base.wssc.know.info.inf.AddQuestionGroupInfo;
import com.kingdee.eas.base.wssc.know.info.inf.AddSynonymInfo;
import com.kingdee.eas.base.wssc.know.info.inf.DelSynonymInfo;
import com.kingdee.eas.base.wssc.know.info.inf.DomainInfo;
import com.kingdee.eas.base.wssc.know.info.inf.QuestionGroupInfo;
import com.kingdee.eas.base.wssc.know.info.inf.SaveKeywordInfo;
import com.kingdee.eas.base.wssc.know.info.inf.SkillInfo;
import com.kingdee.eas.base.wssc.know.util.AiHttpUtil;
import com.kingdee.eas.base.wssc.util.ConfigUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class KnowUtil
implements AiConstant {
    public static void main(String[] args) throws EASBizException {
        String token = KnowUtil.getToken(null);
        DomainInfo domainInfo = new DomainInfo();
        domainInfo.setToken(token);
        domainInfo.setId("1500233663162880");
        AddQuestionGroupInfo addQuestionGroupInfo = new AddQuestionGroupInfo();
        addQuestionGroupInfo.setToken(token);
        QuestionGroupInfo questionGroupInfo = new QuestionGroupInfo();
        questionGroupInfo.setAnswer(new AnswerInfo("\u7b54\u6848"));
        questionGroupInfo.setKeyword(new KeywordInfo("id"));
        questionGroupInfo.setDomainId("1500204694448640");
        ArrayList<QuestionInfo> questionList = new ArrayList<QuestionInfo>();
        QuestionInfo questionInfo1 = new QuestionInfo("\u8fd9\u662f\u95ee\u98981");
        QuestionInfo questionInfo2 = new QuestionInfo("\u8fd9\u662f\u95ee\u98982");
        QuestionInfo questionInfo3 = new QuestionInfo("\u8fd9\u662f\u95ee\u98983");
        questionList.add(questionInfo1);
        questionList.add(questionInfo2);
        questionList.add(questionInfo3);
        ArrayList<AttachmentInfo> attachmentList = new ArrayList<AttachmentInfo>();
        AttachmentInfo AttachmentInfo2 = new AttachmentInfo();
        attachmentList.add(AttachmentInfo2);
        questionGroupInfo.setAttachments(attachmentList);
        questionGroupInfo.setQuestions(questionList);
        addQuestionGroupInfo.setQuestionGroup(questionGroupInfo);
        questionGroupInfo = new QuestionGroupInfo();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("1501252496058880");
        questionGroupInfo.setToken(token);
        questionGroupInfo.setGroupIds(groupIds);
        KeywordInfo keywordInfo = new KeywordInfo();
        keywordInfo.setKeyword("\u5173\u952e\u8bcd3");
        SaveKeywordInfo saveKeywordInfo = new SaveKeywordInfo("1488974809032960", keywordInfo);
        saveKeywordInfo.setToken(token);
        SynonymInfo synonymInfo1 = new SynonymInfo("\u540c\u4e49\u8bcd12");
        SynonymInfo synonymInfo2 = new SynonymInfo("\u540c\u4e49\u8bcd22");
        ArrayList<SynonymInfo> synonymInfoList = new ArrayList<SynonymInfo>();
        synonymInfoList.add(synonymInfo1);
        synonymInfoList.add(synonymInfo2);
        AddSynonymInfo addSynonymInfo = new AddSynonymInfo();
        addSynonymInfo.setToken(token);
        addSynonymInfo.setSkillId("1488974809032960");
        addSynonymInfo.setKeywordId("1523955730098944");
        addSynonymInfo.setData(synonymInfoList);
        ArrayList<String> delSynonymInfoList = new ArrayList<String>();
        delSynonymInfoList.add("1523936189967104");
        delSynonymInfoList.add("1523936189967105");
        DelSynonymInfo delSynonymInfo = new DelSynonymInfo(delSynonymInfoList);
        delSynonymInfo.setToken(token);
    }

    public static String getToken(Context ctx) throws EASBizException {
        return KnowUtil.getToken(ctx, null);
    }

    public static String getToken(Context ctx, String skillNumber) throws EASBizException {
        String path = ConfigUtil.get(ctx, "ai_path_token");
        String key = ConfigUtil.get(ctx, "ai_key");
        long ts = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)skillNumber)) {
            skillNumber = ConfigUtil.get(ctx, "AiConfig");
        }
        if (StringUtils.isEmpty((String)skillNumber)) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u8bf7\u914d\u7f6e\u6280\u80fd\u7f16\u7801"));
        }
        String nonce = Hashing.sha256().hashString((CharSequence)(skillNumber + key + ts), Charsets.UTF_8).toString();
        String result = AiHttpUtil.get(ctx, path, "skillNumber=" + skillNumber + "&nonce=" + nonce + "&ts=" + ts);
        JSONObject obj = JSONObject.parseObject((String)result);
        if (null != obj && "0".equals(obj.getString("code"))) {
            return obj.getString("token");
        }
        if (null != obj && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
        return null;
    }

    public static String getSkillByNumber(Context ctx, String number) throws EASBizException {
        SkillInfo skillInfo = new SkillInfo();
        skillInfo.setToken(KnowUtil.getToken(ctx, number));
        skillInfo.setNumber(number);
        return KnowUtil.getSkillByNumber(ctx, skillInfo);
    }

    public static String getSkillByNumber(Context ctx, SkillInfo skillInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == skillInfo.getToken()) {
            skillInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_getSkillByNumber"), param = JSONObject.toJSONString((Object)skillInfo))))) && "0".equals(obj.getString("code"))) {
            JSONObject data = obj.getJSONObject("data");
            return data.getString("id");
        }
        if ("true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
        return null;
    }

    public static String addDomain(Context ctx, KnowledgeProInfo info) throws EASBizException {
        DomainInfo domainInfo = new DomainInfo();
        domainInfo.setSkillId(ConfigUtil.get(ctx, "ai_skillId"));
        domainInfo.setSolutionName(info.getName());
        KnowledgeProOrgCollection colls = info.getOrg();
        if (null == colls || colls.isEmpty()) {
            ArrayList<OrgInfo> orgList = new ArrayList<OrgInfo>();
            orgList.add(new OrgInfo("no_orgId"));
            domainInfo.setPermissionOrgans(orgList);
        } else {
            ArrayList<OrgInfo> orgList = new ArrayList<OrgInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                orgList.add(new OrgInfo(colls.get(i).getOrg().getId().toString()));
                domainInfo.setPermissionOrgans(orgList);
            }
        }
        return KnowUtil.addDomain(ctx, domainInfo);
    }

    public static String addDomain(Context ctx, DomainInfo domainInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == domainInfo.getToken()) {
            domainInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_addDomain"), param = JSONObject.toJSONString((Object)domainInfo))))) && "0".equals(obj.getString("code"))) {
            JSONObject data = obj.getJSONObject("data");
            return data.getString("id");
        }
        if (null != obj && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
        return null;
    }

    public static void updateDomain(Context ctx, KnowledgeProInfo info) throws EASBizException {
        DomainInfo domainInfo = new DomainInfo();
        domainInfo.setSkillId(ConfigUtil.get(ctx, "ai_skillId"));
        domainInfo.setSolutionName(info.getName());
        domainInfo.setId(info.getSourceId());
        KnowledgeProOrgCollection colls = info.getOrg();
        if (null == colls || colls.isEmpty()) {
            ArrayList<OrgInfo> orgList = new ArrayList<OrgInfo>();
            orgList.add(new OrgInfo("no_orgId"));
            domainInfo.setPermissionOrgans(orgList);
        } else {
            ArrayList<OrgInfo> orgList = new ArrayList<OrgInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                orgList.add(new OrgInfo(colls.get(i).getOrg().getId().toString()));
                domainInfo.setPermissionOrgans(orgList);
            }
        }
        KnowUtil.updateDomain(ctx, domainInfo);
    }

    public static void updateDomain(Context ctx, DomainInfo domainInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == domainInfo.getToken()) {
            domainInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_updateDomain"), param = JSONObject.toJSONString((Object)domainInfo))))) && !"0".equals(obj.getString("code")) && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
    }

    public static void delDomainById(Context ctx, KnowledgeProInfo knowledgeProInfo) throws EASBizException {
        DomainInfo domainInfo = new DomainInfo();
        domainInfo.setToken(KnowUtil.getToken(ctx));
        domainInfo.setId(knowledgeProInfo.getSourceId());
        KnowUtil.delDomainById(ctx, domainInfo);
    }

    public static void delDomainById(Context ctx, DomainInfo domainInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == domainInfo.getToken()) {
            domainInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_delDomainById"), param = JSONObject.toJSONString((Object)domainInfo))))) && !"0".equals(obj.getString("code")) && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
    }

    public static void enableDomain(Context ctx, KnowledgeProInfo knowledgeProInfo) throws EASBizException {
        DomainInfo domainInfo = new DomainInfo();
        domainInfo.setToken(KnowUtil.getToken(ctx));
        domainInfo.setId(knowledgeProInfo.getSourceId());
        domainInfo.setEnable(1);
        KnowUtil.enableDomain(ctx, domainInfo);
    }

    public static void disableDomain(Context ctx, KnowledgeProInfo knowledgeProInfo) throws EASBizException {
        DomainInfo domainInfo = new DomainInfo();
        domainInfo.setToken(KnowUtil.getToken(ctx));
        domainInfo.setId(knowledgeProInfo.getSourceId());
        domainInfo.setEnable(0);
        KnowUtil.enableDomain(ctx, domainInfo);
    }

    public static void enableDomain(Context ctx, DomainInfo domainInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == domainInfo.getToken()) {
            domainInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_enableDomain"), param = JSONObject.toJSONString((Object)domainInfo))))) && !"0".equals(obj.getString("code")) && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
    }

    public static String addQuestionGroup(Context ctx, AddQuestionGroupInfo questionGroupInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == questionGroupInfo.getToken()) {
            questionGroupInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_addQuestionGroup"), param = JSONObject.toJSONString((Object)questionGroupInfo))))) && "0".equals(obj.getString("code"))) {
            JSONObject data = obj.getJSONObject("data");
            return data.getString("id");
        }
        if ("true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
        return null;
    }

    public static void editQuestionGroup(Context ctx, QuestionGroupInfo questionGroupInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == questionGroupInfo.getToken()) {
            questionGroupInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_editQuestionGroup"), param = JSONObject.toJSONString((Object)questionGroupInfo))))) && !"0".equals(obj.getString("code")) && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
    }

    public static void delQuestionGroupByIds(Context ctx, QuestionGroupInfo questionGroupInfo) throws EASBizException {
        String param;
        String path;
        String result;
        JSONObject obj;
        if (null == questionGroupInfo.getToken()) {
            questionGroupInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null != (obj = JSONObject.parseObject((String)(result = AiHttpUtil.post(ctx, path = ConfigUtil.get(ctx, "ai_path_delQuestionGroupByIds"), param = JSONObject.toJSONString((Object)questionGroupInfo))))) && !"0".equals(obj.getString("code")) && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
    }

    public static String saveKeyWord(Context ctx, SaveKeywordInfo saveKeywordInfo) throws EASBizException {
        if (null == saveKeywordInfo.getToken()) {
            saveKeywordInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null == saveKeywordInfo.getSkillId()) {
            saveKeywordInfo.setSkillId(ConfigUtil.get(ctx, "ai_skillId"));
        }
        String path = ConfigUtil.get(ctx, "ai_path_saveKeyWord");
        String param = JSONObject.toJSONString((Object)saveKeywordInfo);
        String result = AiHttpUtil.post(ctx, path, param);
        System.out.println(result);
        JSONObject obj = JSONObject.parseObject((String)result);
        if (null != obj && "0".equals(obj.getString("code"))) {
            JSONObject data = obj.getJSONObject("data");
            return data.getString("id");
        }
        if ("true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
        return null;
    }

    public static List<String> addSynonym(Context ctx, AddSynonymInfo addSynonymInfo) throws EASBizException {
        if (null == addSynonymInfo.getToken()) {
            addSynonymInfo.setToken(KnowUtil.getToken(ctx));
        }
        if (null == addSynonymInfo.getSkillId()) {
            addSynonymInfo.setSkillId(ConfigUtil.get(ctx, "ai_skillId"));
        }
        String path = ConfigUtil.get(ctx, "ai_path_addSynonym");
        String param = JSONObject.toJSONString((Object)addSynonymInfo);
        String result = AiHttpUtil.post(ctx, path, param);
        System.out.println(result);
        ArrayList<String> synonymIds = new ArrayList<String>();
        JSONObject obj = JSONObject.parseObject((String)result);
        if (null != obj && "0".equals(obj.getString("code"))) {
            JSONArray data = obj.getJSONArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JSONObject temp = data.getJSONObject(i);
                synonymIds.add(temp.getString("id"));
            }
            return synonymIds;
        }
        if ("true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
        return null;
    }

    public static void delSynonym(Context ctx, DelSynonymInfo delSynonymInfo) throws EASBizException {
        if (null == delSynonymInfo.getToken()) {
            delSynonymInfo.setToken(KnowUtil.getToken(ctx));
        }
        String path = ConfigUtil.get(ctx, "ai_path_delSynonym");
        String param = JSONObject.toJSONString((Object)delSynonymInfo);
        System.out.println(param);
        String result = AiHttpUtil.post(ctx, path, param);
        System.out.println(result);
        JSONObject obj = JSONObject.parseObject((String)result);
        if (null != obj && !"0".equals(obj.getString("code")) && "true".equalsIgnoreCase(ConfigUtil.get(ctx, "ai_exception_interrupt", "false"))) {
            throw new EASBizException(new NumericExceptionSubItem("", obj.getString("msg")));
        }
    }
}

