/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.ConfigFactory;
import com.kingdee.eas.base.wssc.ConfigInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class ConfigUtil {
    private static Cache<String, Object> cache = CacheBuilder.newBuilder().maximumSize(15L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public static String get(Context ctx, String key) {
        if (cache.getIfPresent((Object)key) != null) {
            return (String)cache.getIfPresent((Object)key);
        }
        try {
            String sql = "where name='" + key + "'";
            if (ConfigFactory.getLocalInstance(ctx).exists(sql)) {
                ConfigInfo info = (ConfigInfo)ConfigFactory.getLocalInstance(ctx).getValue(sql);
                ConfigUtil.putCache(key, info.getValue());
                return info.getValue();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String get(Context ctx, String key, String defaultValue) {
        if (cache.getIfPresent((Object)key) != null) {
            return (String)cache.getIfPresent((Object)key);
        }
        try {
            String sql = "where name='" + key + "'";
            if (ConfigFactory.getLocalInstance(ctx).exists(sql)) {
                ConfigInfo info = (ConfigInfo)ConfigFactory.getLocalInstance(ctx).getValue(sql);
                if (StringUtils.isBlank((String)info.getValue())) {
                    return defaultValue;
                }
                ConfigUtil.putCache(key, info.getValue());
                return info.getValue();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void set(Context ctx, String key, String value) {
        try {
            String sql = "where name='" + key + "'";
            if (ConfigFactory.getLocalInstance(ctx).exists(sql)) {
                ConfigInfo info = (ConfigInfo)ConfigFactory.getLocalInstance(ctx).getValue(sql);
                info.setValue(value);
                ConfigFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            } else {
                ConfigInfo info = new ConfigInfo();
                info.setName(key);
                info.setValue(value);
                ConfigFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        ConfigUtil.putCache(key, value);
    }

    private static void putCache(String key, String value) {
        if (null == value) {
            return;
        }
        cache.put((Object)key, (Object)value);
    }
}

