/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.service.invoker;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.buffalo.protocal.BuffaloCall;
import net.buffalo.protocal.BuffaloProtocal;
import net.buffalo.protocal.Signature;
import net.buffalo.protocal.util.ClassUtil;
import net.buffalo.service.ServiceInvocationException;
import net.buffalo.service.invoker.MatchedResult;
import net.buffalo.service.invoker.ServiceInvoker;

public class BuffaloInvoker
implements ServiceInvoker {
    private Map methodCache = new HashMap();
    private static BuffaloInvoker instance;

    private BuffaloInvoker() {
    }

    public static BuffaloInvoker getInstance() {
        if (instance == null) {
            instance = new BuffaloInvoker();
        }
        return instance;
    }

    public void invoke(Object service, InputStream inputStream, Writer writer) {
        this.invoke0(service, writer, BuffaloProtocal.getInstance().unmarshall(inputStream));
    }

    @Override
    public void invoke(Object service, Reader reader, Writer writer) {
        this.invoke0(service, writer, BuffaloProtocal.getInstance().unmarshall(reader));
    }

    private void invoke0(Object service, Writer writer, BuffaloCall call) {
        Signature signature = new Signature(service.getClass(), call.getMethodName(), call.getArgumentTypes());
        Method method = null;
        method = this.methodCache.get(signature) != null ? (Method)this.methodCache.get(signature) : this.lookupMethod(service, call, signature);
        if (method == null) {
            throw new ServiceInvocationException("cannot find the method " + call + " for " + service.getClass().getName());
        }
        Object result = null;
        try {
            result = ClassUtil.invokeMethod(service, method, call.getArguments());
        }
        catch (IllegalArgumentException e) {
            throw new ServiceInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceInvocationException(e);
        }
        catch (InvocationTargetException e) {
            result = e.getTargetException();
        }
        BuffaloProtocal.getInstance().marshall(result, writer);
    }

    private Method lookupMethod(Object service, BuffaloCall call, Signature signature) {
        Method[] methods = service.getClass().getMethods();
        ArrayList<MatchedResult> matchedResults = new ArrayList<MatchedResult>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(call.getMethodName())) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            int matched = 0;
            int weight = 0;
            if (parameterTypes.length == call.getArguments().length) {
                for (int j = 0; j < parameterTypes.length; ++j) {
                    int matchWeight = this.parameterAssignable(parameterTypes[j], call.getArguments()[j].getClass());
                    if (matchWeight <= 0) continue;
                    ++matched;
                    weight += matchWeight;
                }
            }
            if (matched != parameterTypes.length) continue;
            this.methodCache.put(signature, method);
            matchedResults.add(new MatchedResult(weight, method));
        }
        if (matchedResults.size() == 0) {
            return null;
        }
        if (matchedResults.size() == 1) {
            this.methodCache.put(signature, ((MatchedResult)matchedResults.get(0)).getMethod());
            return ((MatchedResult)matchedResults.get(0)).getMethod();
        }
        Collections.sort(matchedResults);
        this.methodCache.put(signature, ((MatchedResult)matchedResults.get(0)).getMethod());
        return ((MatchedResult)matchedResults.get(0)).getMethod();
    }

    private int parameterAssignable(Class targetType, Class sourceType) {
        if (targetType.equals(sourceType)) {
            return 6;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return 5;
        }
        if (targetType.isPrimitive()) {
            targetType = ClassUtil.getWrapperClass(targetType);
        }
        if (targetType.equals(sourceType)) {
            return 4;
        }
        if (Number.class.isAssignableFrom(targetType) && Number.class.isAssignableFrom(sourceType)) {
            return 3;
        }
        return 0;
    }
}

