/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.web.servlet;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.buffalo.request.AbstractRequestWorker;
import net.buffalo.request.RequestContext;
import net.buffalo.request.RequestContextUtil;
import net.buffalo.request.ValidationException;
import net.buffalo.service.BuffaloWorker;
import net.buffalo.service.DefaultServiceRepository;
import net.buffalo.service.ServiceRepository;
import net.buffalo.view.ViewWorker;
import net.buffalo.web.RequestUtils;
import net.buffalo.web.upload.UploadWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationServlet
extends HttpServlet {
    private static final long serialVersionUID = 7531914733078063390L;
    private static final Log LOG = LogFactory.getLog(ApplicationServlet.class);
    private static final String LOCALE_COOKIE_NAME = "net.buffalo.web.locale";
    private static String fileFullNameRegex = "(^buffalo-service).*(.properties$)";
    private static String configFileDirName = "WEB-INF";

    public String getServletInfo() {
        return "Buffalo Application Gateway Servlet";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config.getInitParameter("fileFullNameRegex") != null) {
            fileFullNameRegex = config.getInitParameter("fileFullNameRegex");
        }
        String contextPath = config.getServletContext().getRealPath(File.separator + configFileDirName);
        this.getServletContext().setAttribute("fileFullNameRegex", (Object)fileFullNameRegex);
        this.getServletContext().setAttribute("fileContextPath", (Object)contextPath);
        this.initServiceRepository();
    }

    protected void initServiceRepository() {
        if (this.getServletContext().getAttribute(ServiceRepository.WEB_CONTEXT_KEY) == null) {
            LOG.info((Object)"initialize the service repository");
            DefaultServiceRepository repository = new DefaultServiceRepository(this.getServletContext());
            this.getServletContext().setAttribute(ServiceRepository.WEB_CONTEXT_KEY, (Object)repository);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestContextUtil.createRequestContext(this.getServletContext(), request, response);
        String pathInfo = request.getPathInfo();
        LOG.debug((Object)("request path info: " + pathInfo));
        AbstractRequestWorker worker = null;
        if (pathInfo == null || pathInfo.equals("/")) {
            worker = new ViewWorker();
        } else if (pathInfo.startsWith("/view/")) {
            worker = new ViewWorker();
        } else if (pathInfo.startsWith("/buffalo/")) {
            worker = new BuffaloWorker();
        } else if (pathInfo.startsWith("/upload/")) {
            worker = new UploadWorker();
        } else {
            throw new ServletException("Cannot find the request worker!");
        }
        try {
            worker.validate(request, response);
        }
        catch (ValidationException ex) {
            throw new ServletException("Service validation error", (Throwable)ex);
        }
        worker.processRequest(request, response);
    }

    protected Locale getLocaleFromRequest() throws ServletException {
        Cookie cookie = (Cookie)RequestContext.getContext().getCookie().get(LOCALE_COOKIE_NAME);
        if (cookie != null) {
            return RequestUtils.getLocale(cookie.getValue());
        }
        return RequestContext.getContext().getHttpRequest().getLocale();
    }
}

