/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import com.kingdee.bos.ctrl.common.CtrlPropertyConfig;
import java.awt.Dimension;
import java.awt.Toolkit;

public class KDToolkit {
    private static int currentDpi = -1;
    private static int useCustomArraycopy = -1;
    private static final int MAX_DPI = 384;

    public static int getCurrentDpi() {
        if (currentDpi == -1) {
            try {
                currentDpi = Toolkit.getDefaultToolkit().getScreenResolution();
                if (currentDpi > 384) {
                    currentDpi = 96;
                }
            }
            catch (Throwable e) {
                currentDpi = 96;
            }
        }
        return currentDpi;
    }

    public static Dimension getScreenSize() {
        Dimension d;
        try {
            d = Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (Throwable e) {
            d = new Dimension(1024, 768);
        }
        return d;
    }

    private static boolean isUseCustomArraycopy() {
        if (useCustomArraycopy == -1) {
            CtrlPropertyConfig property = new CtrlPropertyConfig("/client/PrintConfig.properties");
            String s = property.getProperty("CustomArraycopy");
            useCustomArraycopy = "true".equalsIgnoreCase(s) ? 1 : 0;
        }
        return useCustomArraycopy == 1;
    }

    public static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        if (KDToolkit.isUseCustomArraycopy()) {
            if (src == dest) {
                if (srcPos < destPos) {
                    for (int i = length - 1; i >= 0; --i) {
                        dest[destPos + i] = src[srcPos + i];
                    }
                } else if (srcPos > destPos) {
                    for (int i = 0; i < length; ++i) {
                        dest[destPos + i] = src[srcPos + i];
                    }
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }
}

