/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.layout.table;

import com.kingdee.bos.ctrl.common.layout.table.ACell;
import com.kingdee.bos.ctrl.common.layout.table.ICellContent;
import com.kingdee.bos.ctrl.common.layout.table.Style;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import java.awt.Dimension;

public class Cell
extends ACell {
    protected int _row;
    protected int _col;
    protected boolean _isSubTable = false;
    protected ICellContent _content;

    protected Cell(int row, int col) {
        this._row = row;
        this._col = col;
    }

    public Table getSubTable() {
        return this._isSubTable ? (Table)this._content : null;
    }

    public Table setSubTable(int rows, int cols) {
        this._isSubTable = true;
        this._content = new Table(rows, cols);
        return (Table)this._content;
    }

    public Table split(int rows, int cols) {
        Table subTable = this.setSubTable(rows, cols);
        subTable.style().setSize(-100, -100);
        return subTable;
    }

    public Table splitRow(int rows) {
        return this.split(rows, 1);
    }

    public Table splitCol(int cols) {
        return this.split(1, cols);
    }

    public void setContent(ICellContent content) {
        this._isSubTable = false;
        this._content = content;
    }

    protected void makeOutStyle(Style colStyle, Style rowStyle, Style defaultStyle) {
        super.initOutStyle();
        if (colStyle != null) {
            this._outStyle.makeFields(colStyle);
        }
        if (rowStyle != null) {
            this._outStyle.makeFields(rowStyle);
        }
        this._outStyle.makeFields(defaultStyle);
    }

    protected boolean makeOutStyleByContent() {
        Dimension size;
        boolean isNoY;
        if (this._content == null) {
            this._outStyle.setWidth(0);
            this._outStyle.setHeight(0);
            this._outStyle.setMinWidth(0);
            this._outStyle.setMinHeight(0);
            this._outStyle.setMaxWidth(0);
            this._outStyle.setMaxHeight(0);
            return false;
        }
        boolean isAdjusted = true;
        if (this._isSubTable) {
            isAdjusted = ((Table)this._content).fitSpace(-1, -1);
        }
        int marginX = this._outStyle.getMarginLeft() + this._outStyle.getMarginRight();
        int marginY = this._outStyle.getMarginTop() + this._outStyle.getMarginBottom();
        boolean isNoX = !this._outStyle.has(256);
        boolean bl = isNoY = !this._outStyle.has(1);
        if (isNoX || isNoY) {
            size = this._content.getPreferredSize();
            if (isNoX) {
                this._outStyle.setWidth(size.width + marginX);
            }
            if (isNoY) {
                this._outStyle.setHeight(size.height + marginY);
            }
        }
        isNoX = !this._outStyle.has(512);
        boolean bl2 = isNoY = !this._outStyle.has(2);
        if (isNoX || isNoY) {
            size = this._content.getMinimumSize();
            if (isNoX) {
                this._outStyle.setMinWidth(size.width + marginX);
            }
            if (isNoY) {
                this._outStyle.setMinHeight(size.height + marginY);
            }
        }
        isNoX = !this._outStyle.has(1024);
        boolean bl3 = isNoY = !this._outStyle.has(4);
        if (isNoX || isNoY) {
            size = this._content.getMaximumSize();
            if (isNoX) {
                this._outStyle.setMaxWidth(size.width + marginX);
            }
            if (isNoY) {
                this._outStyle.setMaxHeight(size.height + marginY);
            }
        }
        return isAdjusted;
    }

    protected void setBounds(int left, int top, int width, int height) {
        this._left = left + this._outStyle.getMarginLeft();
        this._top = top + this._outStyle.getMarginTop();
        this._width = width - this._outStyle.getMarginLeft() - this._outStyle.getMarginRight();
        this._height = height - this._outStyle.getMarginTop() - this._outStyle.getMarginBottom();
        if (this._content == null) {
            return;
        }
        if (!this._outStyle.isVisible()) {
            this.hideContent();
            return;
        }
        Dimension size = this._content.getPreferredSize();
        if (size.width >= this._width) {
            left = this._left;
            width = this._width;
        } else {
            switch (this._outStyle.getAlignmentX()) {
                case 0: {
                    left = this._left;
                    width = this._width;
                    break;
                }
                case 2: {
                    left = this._left + this._width - size.width;
                    width = size.width;
                    break;
                }
                case 4: {
                    left = this._left + (this._width - size.width) / 2;
                    width = size.width;
                    break;
                }
                default: {
                    left = this._left;
                    width = size.width;
                }
            }
        }
        if (size.height >= this._height) {
            top = this._top;
            height = this._height;
        } else {
            switch (this._outStyle.getAlignmentY()) {
                case 0: {
                    top = this._top;
                    height = this._height;
                    break;
                }
                case 2: {
                    top = this._top + this._height - size.height;
                    height = size.height;
                    break;
                }
                case 4: {
                    top = this._top + (this._height - size.height) / 2;
                    height = size.height;
                    break;
                }
                default: {
                    top = this._top;
                    height = size.height;
                }
            }
        }
        if (this._isSubTable) {
            ((Table)this._content).layout(left, top);
        } else {
            this._content.setBounds(left, top, width, height);
        }
    }

    protected void hideContent() {
        if (this._isSubTable) {
            ((Table)this._content).hide();
        } else if (this._content != null) {
            this._content.setBounds(0, 0, 0, 0);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this._style != null) {
            s.append("\r\n<Style>" + this._style.toString() + "</Style>");
        }
        s.append("\r\n<OutStyle>" + this._outStyle.toString() + "</OutStyle>");
        if (this._content != null) {
            s.append("\r\n<Content>");
            Dimension size = this._content.getPreferredSize();
            s.append(" size=" + size.width + "x" + size.height);
            size = this._content.getMinimumSize();
            s.append(", minSize=" + size.width + "x" + size.height);
            size = this._content.getMaximumSize();
            s.append(", maxSize=" + size.width + "x" + size.height);
            s.append(" </Content>");
            if (this._isSubTable) {
                s.append("\r\n\r\n<SubTable>\r\n" + ((Table)this._content).toString() + "\r\n</SubTable>");
            }
        }
        return s.toString();
    }
}

