/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.tool;

import com.kingdee.bos.ctrl.common.tool.CodeGenerator;
import com.kingdee.bos.ctrl.common.tool.TestingFrame;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class EventTestGenerator
extends TestingFrame {
    private static final long serialVersionUID = -5200999511026562624L;
    private static final String TESTCLASSNAME = "Test";
    private JList tree;
    private JScrollPane ptree;
    private JTextArea ta;
    private JScrollPane pta;
    private JTextField tf;
    private JTextField test;
    private JButton bmaster;
    private JButton btest;
    private JButton bclass;
    private static final Font CODEFONT = new Font("Courier New", 0, 12);
    private Class target = null;
    private Object[] NULLDATA = new Object[0];
    private static final int CLASS_CODE = 0;
    private static final int TEST_CODE = 1;

    public EventTestGenerator() {
        this.initui();
        this.initlistener();
    }

    protected void initlistener() {
        ClassAction h = new ClassAction();
        this.bmaster.addActionListener(h);
        this.btest.addActionListener(h);
        this.bclass.addActionListener(h);
    }

    protected void initui() {
        this.tree = new JList();
        this.ptree = new JScrollPane(this.tree);
        this.ta = new JTextArea();
        this.pta = new JScrollPane(this.ta);
        this.tf = new JTextField("javax.swing.JSpinner");
        this.test = new JTextField(TESTCLASSNAME);
        this.bmaster = new JButton("Events");
        this.btest = new JButton("Invisible Test");
        this.bclass = new JButton("Visible Test");
        this.tf.setSize(500, 20);
        this.cp.add(this.tf);
        this.bmaster.setSize(160, 20);
        this.cp.add(this.bmaster);
        this.ptree.setSize(500, 200);
        this.cp.add(this.ptree);
        this.test.setSize(160, 20);
        this.cp.add(this.test);
        this.btest.setSize(160, 20);
        this.cp.add(this.btest);
        this.bclass.setSize(160, 20);
        this.cp.add(this.bclass);
        this.pta.setSize(500, 350);
        this.cp.add(this.pta);
        this.setLocation(200, 10);
        this.setSize(520, 720);
        this.ta.setFont(CODEFONT);
        this.ta.setTabSize(4);
    }

    protected void updateClass() {
        String name = this.tf.getText();
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            name = name + "?!";
            this.tf.setText(name);
        }
        this.target = cls;
        EventSetDescriptor[] es = null;
        try {
            es = CodeGenerator.getEventList(cls);
        }
        catch (IntrospectionException e1) {
            es = null;
        }
        this.tree.setListData(this.NULLDATA);
        if (es != null && es.length > 0) {
            ListItem[] items = new ListItem[es.length];
            for (int i = 0; i < items.length; ++i) {
                items[i] = new ListItem(es[i]);
            }
            this.tree.setListData(items);
        }
        if (cls != null) {
            name = cls.getName();
            int i = name.lastIndexOf(46);
            if (i != -1) {
                name = name.substring(i + 1);
            }
            this.test.setText(name + "EventTest");
        }
    }

    protected void generateCode(int type) {
        Object[] selection;
        String str = this.test.getText();
        if (str == null || str.length() == 0) {
            str = TESTCLASSNAME;
            this.test.setText(str);
        }
        if ((selection = this.tree.getSelectedValues()) == null || selection.length == 0) {
            selection = EventTestGenerator.getListData(this.tree);
        }
        EventSetDescriptor[] es = new EventSetDescriptor[selection.length];
        for (int i = 0; i < es.length; ++i) {
            es[i] = ((ListItem)selection[i]).getEvent();
        }
        CodeGenerator g = new CodeGenerator();
        if (type == 0) {
            str = g.generateBlackAll(this.target, es, str);
        } else if (type == 1) {
            str = g.generateAll(this.target, es, str);
        }
        this.ta.setText(str);
    }

    private static Object[] getListData(JList list) {
        ListModel m = list.getModel();
        int count = m.getSize();
        Object[] ret = new Object[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = m.getElementAt(i);
        }
        return ret;
    }

    public static void main(String[] args) {
        EventTestGenerator test = new EventTestGenerator();
        test.setVisible(true);
    }

    static class ListItem {
        private EventSetDescriptor event;

        public ListItem(EventSetDescriptor evt) {
            this.event = evt;
        }

        public String toString() {
            return this.event.getListenerType().getName();
        }

        public EventSetDescriptor getEvent() {
            return this.event;
        }
    }

    class ClassAction
    implements ActionListener {
        ClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object comp = e.getSource();
            if (comp == EventTestGenerator.this.bmaster) {
                EventTestGenerator.this.updateClass();
            } else if (comp == EventTestGenerator.this.btest) {
                EventTestGenerator.this.generateCode(1);
            } else if (comp == EventTestGenerator.this.bclass) {
                EventTestGenerator.this.generateCode(0);
            }
        }
    }
}

