/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

public class Queue {
    private QueueEntry first = null;
    private QueueEntry last = null;

    public synchronized boolean isEmpty() {
        return this.first == null;
    }

    public synchronized void enqueue(Object obj) {
        QueueEntry entry = new QueueEntry(obj);
        if (this.first == null) {
            entry.next = null;
            this.last = this.first = entry;
        } else {
            this.last.next = entry;
            this.last = entry;
        }
    }

    public synchronized Object dequeue() {
        if (this.first == null) {
            return null;
        }
        Object obj = this.first.value;
        this.first = this.first.next;
        return obj;
    }

    public synchronized Object front() {
        return this.first == null ? null : this.first.value;
    }

    public synchronized boolean forceDequeue(Object obj) {
        if (this.first != null) {
            QueueEntry visitor = this.first;
            if (visitor.value.equals(obj)) {
                this.first = this.first.next;
                return true;
            }
            if (visitor.next != null) {
                while (visitor.next != null) {
                    if (visitor.next.value.equals(obj)) {
                        visitor.next = visitor.next.next;
                        return true;
                    }
                    visitor = visitor.next;
                }
            } else if (this.first.value.equals(obj)) {
                this.first = null;
                this.last = null;
                return true;
            }
        }
        return false;
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        QueueEntry visitor = this.first;
        while (visitor != null) {
            buffer.append(visitor + ",");
            visitor = visitor.next;
        }
        return buffer.toString();
    }

    public synchronized void clear() {
        QueueEntry x = this.first;
        while (x != null) {
            QueueEntry next = x.next;
            x.value = null;
            x.next = null;
            x = next;
        }
        this.last = null;
        this.first = null;
    }

    class QueueEntry {
        QueueEntry next;
        Object value;

        QueueEntry(Object value) {
            this.value = value;
        }

        public String toString() {
            return "[" + this.value == null ? "null" : this.value.toString() + "]";
        }
    }
}

