/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class Xml2ObjectUtil {
    public static final Logger log = LogUtil.getLogger(Xml2ObjectUtil.class);

    public static Object loadObject(File xmlFile, Class xml2ObjectClass) {
        try {
            return Xml2ObjectUtil.loadObject(XmlUtil.loadXmlFile(xmlFile), xml2ObjectClass);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    public static Object loadObject(InputStream stream, Class xml2ObjectClass) {
        try {
            return Xml2ObjectUtil.loadObject(XmlUtil.loadXmlStream(stream), xml2ObjectClass);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    public static Object loadObject(Element e, Class xml2ObjectClass) {
        try {
            Method m = xml2ObjectClass.getMethod("toObject", Element.class);
            return m.invoke(null, e);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    public static Object loadObject(String filePath, Class xml2ObjectClass) {
        return Xml2ObjectUtil.loadObject(new File(filePath), xml2ObjectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadObject(Class relativeClass, String resName, Class xml2ObjectClass) {
        InputStream stream = StreamUtil.loadResource(relativeClass, resName);
        try {
            Object object = Xml2ObjectUtil.loadObject(stream, xml2ObjectClass);
            return object;
        }
        finally {
            StreamUtil.closeStream(stream);
        }
    }
}

