/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta.io;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import java.util.List;
import java.util.Locale;
import org.jdom2.Element;

public class Kdm2Meta {
    private static final String T_INFO = "Info";
    private static final String T_DATABASE = "DataBase";
    private static final String T_TYPE = "Type";
    private static final String T_NAME = "Name";
    private static final String T_ALIAS = "Alias";
    private static final String T_DESCRIPTION = "Description";
    private static final String T_TABLES = "Tables";
    private static final String T_TABLE = "Table";
    private static final String T_FIELDS = "Fields";
    private static final String T_FIELD = "Field";
    private static final String A_TYPE = "type";
    private static final String V_BOOLEAN = "BOOLEAN";
    private static final String V_CHAR = "CHAR";
    private static final String V_BYTE = "BYTE";
    private static final String V_SHORT = "SHORT";
    private static final String V_INTEGER = "INTEGER";
    private static final String V_LONG = "LONG";
    private static final String V_FLOAT = "FLOAT";
    private static final String V_DOUBLE = "DOUBLE";
    private static final String V_STRING = "STRING";
    private static final String V_DATETIME = "DATETIME";
    private static final String V_CURRENCY = "CURRENCY";
    private static final String V_BINARY = "BINARY";
    private static final String V_QUERY = "query";
    private static final String V_VIEW = "view";

    public static DataDefType toDataObjType(String val) {
        if (V_QUERY.equals(val)) {
            return DataDefType.BOS_QUERY;
        }
        if (V_VIEW.equals(val)) {
            return DataDefType.DB_VIEW;
        }
        return DataDefType.DB_TABLE;
    }

    public static DataType toDataType(String val) {
        if (V_BOOLEAN.equals(val)) {
            return DataType.BOOLEAN;
        }
        if (V_BYTE.equals(val)) {
            return DataType.BYTE;
        }
        if (V_SHORT.equals(val)) {
            return DataType.SHORT;
        }
        if (V_INTEGER.equals(val)) {
            return DataType.INTEGER;
        }
        if (V_LONG.equals(val)) {
            return DataType.LONG;
        }
        if (V_FLOAT.equals(val)) {
            return DataType.FLOAT;
        }
        if (V_DOUBLE.equals(val)) {
            return DataType.DOUBLE;
        }
        if (V_STRING.equals(val)) {
            return DataType.STRING;
        }
        if (V_DATETIME.equals(val)) {
            return DataType.DATETIME;
        }
        if (V_CURRENCY.equals(val)) {
            return DataType.DECIMAL;
        }
        if (V_BINARY.equals(val)) {
            return DataType.BLOB;
        }
        if (V_CHAR.equals(val)) {
            return DataType.STRING;
        }
        return DataType.NULL;
    }

    public static MetaLibrary parseDBMeta(Element xmlDBMeta) {
        MetaLibrary ml = new MetaLibrary();
        Element xmlInfo = xmlDBMeta.getChild(T_INFO);
        ml.setName(xmlInfo.getChildText(T_NAME));
        ml.setAlias(xmlInfo.getChildText(T_ALIAS));
        ml.setDesc(xmlInfo.getChildText(T_DESCRIPTION));
        Element xmlDB = xmlDBMeta.getChild(T_DATABASE);
        Kdm2Meta.parseDataBase(ml, xmlDB);
        return ml;
    }

    public static void parseDataBase(MetaLibrary ml, Element xmlDB) {
        ml.setName(xmlDB.getChildText(T_NAME));
        ml.setAlias(xmlDB.getChildText(T_ALIAS));
        ml.setDesc(xmlDB.getChildText(T_DESCRIPTION));
        Element xmlTables = xmlDB.getChild(T_TABLES);
        Kdm2Meta.parseTables(ml.getRootPackage(), xmlTables);
    }

    public static void parseTables(MetaPackage pkg, Element xmlTables) {
        List xmlTableList = xmlTables.getChildren(T_TABLE);
        int len = xmlTableList.size();
        for (int i = 0; i < len; ++i) {
            Element xmlTable = (Element)xmlTableList.get(i);
            pkg.addClass(Kdm2Meta.parseTable(xmlTable));
        }
    }

    public static MetaClass parseTable(Element xmlTable) {
        String desc;
        MetaClass mc = new MetaClass();
        mc.setNamex(xmlTable.getChildText(T_NAME), Kdm2Meta.toDataObjType(xmlTable.getAttributeValue(A_TYPE)).getName());
        String alias = xmlTable.getChildText(T_ALIAS);
        if (alias != null) {
            mc.setAlias(alias, Locale.SIMPLIFIED_CHINESE);
            mc.setAlias(STConverter.sc2tc(alias), Locale.TRADITIONAL_CHINESE);
        }
        if ((desc = xmlTable.getChildText(T_DESCRIPTION)) != null) {
            mc.setDesc(desc, Locale.SIMPLIFIED_CHINESE);
            mc.setDesc(STConverter.sc2tc(desc), Locale.TRADITIONAL_CHINESE);
        }
        mc.setExpr(mc.getName());
        Element xmlFields = xmlTable.getChild(T_FIELDS);
        Kdm2Meta.parseFields(mc, xmlFields);
        return mc;
    }

    public static void parseFields(MetaClass cls, Element xmlFields) {
        List xmlFieldList = xmlFields.getChildren(T_FIELD);
        int len = xmlFieldList.size();
        for (int i = 0; i < len; ++i) {
            Element xmlField = (Element)xmlFieldList.get(i);
            cls.addField(Kdm2Meta.parseField(xmlField));
        }
    }

    public static MetaField parseField(Element xmlField) {
        String desc;
        MetaField mf = new MetaField();
        mf.setName(xmlField.getChildText(T_NAME));
        String alias = xmlField.getChildText(T_ALIAS);
        if (alias != null) {
            mf.setAlias(alias, Locale.SIMPLIFIED_CHINESE);
            mf.setAlias(STConverter.sc2tc(alias), Locale.TRADITIONAL_CHINESE);
        }
        if ((desc = xmlField.getChildText(T_DESCRIPTION)) != null) {
            mf.setDesc(desc, Locale.SIMPLIFIED_CHINESE);
            mf.setDesc(STConverter.sc2tc(desc), Locale.TRADITIONAL_CHINESE);
        }
        String s = xmlField.getChildText(T_TYPE);
        mf.setType(Kdm2Meta.toDataType(s));
        mf.setExpr(mf.getName());
        return mf;
    }
}

