/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta.io;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import java.util.List;
import java.util.Locale;
import org.jdom2.Element;

public class Kdr2Meta {
    private static final String T_FILE = "FILE";
    private static final String T_TYPE = "TYPE";
    private static final String T_DATABASE = "DATABASE";
    private static final String T_NAME = "NAME";
    private static final String T_NOTE = "NOTE";
    private static final String T_GROUP = "GROUP";
    private static final String T_TABLE = "TABLE";
    private static final String T_FIELD = "FIELD";
    private static final String T_TABLE_NAME = "TABLE_NAME";
    private static final String T_FIELD_NAME = "FIELD_NAME";
    private static final String T_DATA_TYPE = "DATA_TYPE";
    private static final String T_SUB = "SUB";
    private static final String V_INTEGER = "INTEGER";
    private static final String V_DOUBLE = "DOUBLE";
    private static final String V_STRING = "STRING";
    private static final String V_DATETIME = "DATETIME";
    private static final String V_CURRENCY = "CURRENCY";
    private static final String V_TABLE = "TABLE";
    private static final String V_VIEW = "VIEW";
    private static final String V_DATA = "DATA";

    public static DataDefType toDataObjType(String val) {
        if ("TABLE".equals(val)) {
            return DataDefType.DB_TABLE;
        }
        if (V_VIEW.equals(val)) {
            return DataDefType.DB_VIEW;
        }
        return DataDefType.DB_TABLE;
    }

    public static DataType toDataType(String val) {
        if (V_INTEGER.equals(val)) {
            return DataType.INTEGER;
        }
        if (V_DOUBLE.equals(val)) {
            return DataType.DOUBLE;
        }
        if (V_STRING.equals(val)) {
            return DataType.STRING;
        }
        if (V_DATETIME.equals(val)) {
            return DataType.DATETIME;
        }
        if (V_CURRENCY.equals(val)) {
            return DataType.DECIMAL;
        }
        return DataType.NULL;
    }

    public MetaLibrary transform(Element xmlRoot) {
        MetaLibrary lib = new MetaLibrary();
        this.parseKDReport(lib, xmlRoot);
        return lib;
    }

    public void parseKDReport(MetaLibrary lib, Element xmlKDReport) {
        Element xmlInfo = xmlKDReport.getChild(T_FILE);
        assert (V_DATA.equals(xmlInfo.getChild(T_TYPE)));
        lib.setAlias(xmlInfo.getChildText(T_NAME) + ".KDR");
        lib.setDesc(xmlInfo.getChildText(T_NOTE));
        Element xmlDB = xmlKDReport.getChild(T_DATABASE);
        this.parseDataBase(lib, xmlDB);
    }

    public void parseDataBase(MetaLibrary ml, Element xmlDB) {
        List xmlGroupList = xmlDB.getChildren(T_GROUP);
        ml.setAlias(xmlDB.getChildText(T_NAME));
        ml.setDesc(xmlDB.getChildText(T_NOTE));
        int len = xmlGroupList.size();
        MetaPackage mpRoot = ml.getRootPackage();
        for (int i = 0; i < len; ++i) {
            Element xmlGroup = (Element)xmlGroupList.get(i);
            mpRoot.addPackage(this.parseGroup(xmlGroup));
        }
    }

    public MetaPackage parseGroup(Element xmlGroup) {
        MetaPackage pkg = new MetaPackage();
        pkg.setName(xmlGroup.getChildText(T_NAME));
        pkg.setAlias(xmlGroup.getChildText(T_NAME));
        pkg.setDesc(xmlGroup.getChildText(T_NOTE));
        DataDefType type = Kdr2Meta.toDataObjType(xmlGroup.getChildText(T_SUB));
        List xmlTableList = xmlGroup.getChildren("TABLE");
        int len = xmlTableList.size();
        for (int i = 0; i < len; ++i) {
            Element xmlTable = (Element)xmlTableList.get(i);
            pkg.addClass(this.parseTable(xmlTable, type));
        }
        return pkg;
    }

    public MetaClass parseTable(Element xmlTable, DataDefType type) {
        String desc;
        MetaClass mc = new MetaClass();
        mc.setNamex(xmlTable.getChildText(T_TABLE_NAME), type.getName());
        String alias = xmlTable.getChildText(T_NAME);
        if (alias != null) {
            mc.setAlias(alias, Locale.SIMPLIFIED_CHINESE);
            mc.setAlias(STConverter.sc2tc(alias), Locale.TRADITIONAL_CHINESE);
        }
        if ((desc = xmlTable.getChildText(T_NOTE)) != null) {
            mc.setDesc(desc, Locale.SIMPLIFIED_CHINESE);
            mc.setDesc(STConverter.sc2tc(desc), Locale.TRADITIONAL_CHINESE);
        }
        mc.setExpr(mc.getName());
        List xmlFieldList = xmlTable.getChildren(T_FIELD);
        int len = xmlFieldList.size();
        for (int i = 0; i < len; ++i) {
            Element xmlField = (Element)xmlFieldList.get(i);
            mc.addField(this.parseField(xmlField));
        }
        return mc;
    }

    public MetaField parseField(Element xmlField) {
        String desc;
        MetaField mf = new MetaField();
        mf.setName(xmlField.getChildText(T_FIELD_NAME));
        String alias = xmlField.getChildText(T_NAME);
        if (alias != null) {
            mf.setAlias(alias, Locale.SIMPLIFIED_CHINESE);
            mf.setAlias(STConverter.sc2tc(alias), Locale.TRADITIONAL_CHINESE);
        }
        if ((desc = xmlField.getChildText(T_NOTE)) != null) {
            mf.setDesc(desc, Locale.SIMPLIFIED_CHINESE);
            mf.setDesc(STConverter.sc2tc(desc), Locale.TRADITIONAL_CHINESE);
        }
        String s = xmlField.getChildText(T_DATA_TYPE);
        mf.setType(Kdr2Meta.toDataType(s));
        mf.setExpr(mf.getName());
        return mf;
    }
}

