/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.CellBlock;
import com.kingdee.bos.ctrl.kdf.expr.CellPosition;
import com.kingdee.bos.ctrl.kdf.expr.ExprError;
import com.kingdee.bos.ctrl.kdf.expr.IElement;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_ABS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_ACOS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_AND;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_ASIN;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_ATAN;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_COS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_DATEVALUE;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_DAY;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_DAYS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_DEC2HEX;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_DEGREES;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_EXP;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_FALSE;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_FIX;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_HOUR;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_HOURS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_IF;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_INT;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_LEFT;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_LEN;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_LN;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_LOG;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_LOG10;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_MILLISECONDS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_MINUTE;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_MINUTES;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_MOD;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_MONTH;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_NOT;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_NOW;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_OR;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_PI;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_POWER;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_RADIANS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_RAND;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_REPT;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_RIGHT;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_ROUND;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_SECOND;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_SECONDS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_SIN;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_SQRT;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TAN;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TICKS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TOTALDAYS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TOTALHOURS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TOTALMILLISECONDS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TOTALMINUTES;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TOTALSECONDS;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TRIM;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_TRUE;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_WEEKDAY;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_YEAR;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction_YEARDAY;
import com.kingdee.bos.ctrl.kdf.expr.ParserHelperListener;
import com.kingdee.bos.ctrl.kdf.expr.ParserState;
import com.kingdee.bos.ctrl.kdf.expr.RelationNode;
import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Parser {
    private static long[] quickTokens = new long[128];
    private static HashMap consts;
    private static HashMap funcs;
    private String formula;
    private long currentToken;
    private int currentTokenPos;
    private int currentTokenLength;
    private int formulaLength;
    private String comment = "";
    private ParserHelperListener helperListener;
    private ArrayList defaultFunctionProviders = new ArrayList();
    private ArrayList defaultFuncNames = new ArrayList();
    private HashMap defaultMethods = new HashMap();
    private Object depOwner;
    private boolean supportCellName = false;
    protected CellPosition cp = new CellPosition(0, 0);
    private boolean syntaxCheck = false;

    public Parser(IElement owner, String formula) {
        this.prepare(owner, formula);
    }

    public Object getOwner() {
        return this.depOwner;
    }

    public void setOwner(Object depOwner) {
        this.depOwner = depOwner;
    }

    public boolean isSupportCellName() {
        return this.supportCellName;
    }

    public void setSupportCellName(boolean supportCellName) {
        this.supportCellName = supportCellName;
    }

    public ParserState getParserState() {
        return new ParserState(this.currentTokenPos, this.currentTokenLength, this.currentToken);
    }

    public void setParserState(ParserState state) {
        this.currentTokenPos = state.getTokenPos();
        this.currentTokenLength = state.getTokenLen();
        this.currentToken = state.getToken();
    }

    public final char charAt(int index) {
        return index < this.formulaLength ? this.formula.charAt(index) : (char)'\u0000';
    }

    public int getFormulaLength() {
        return this.formulaLength;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getCurrentWord() throws SyntaxErrorException {
        String word = null;
        if (this.formula.charAt(this.currentTokenPos) == '[') {
            word = this.formula.substring(this.currentTokenPos + 1, this.currentTokenPos + this.currentTokenLength - 1);
            if (word.length() == 0) {
                ExprError.goError(512L, "[]");
            }
        } else {
            word = this.formula.substring(this.currentTokenPos, this.currentTokenPos + this.currentTokenLength);
        }
        return word;
    }

    public boolean isSyntaxCheck() {
        return this.syntaxCheck;
    }

    public void setSyntaxCheck(boolean check) {
        this.syntaxCheck = check;
    }

    public ArrayList getDefaultFunctionProvider() {
        return (ArrayList)this.defaultFunctionProviders.clone();
    }

    public void setDefaultFunctionProvider(ArrayList functionProviders) {
        if (functionProviders == null) {
            this.defaultFunctionProviders.clear();
            this.defaultFuncNames.clear();
            this.defaultMethods.clear();
        } else {
            Iterator it = functionProviders.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj != null) continue;
                it.remove();
            }
            if (this.defaultFunctionProviders.size() == functionProviders.size()) {
                boolean isEqual = true;
                for (int i = this.defaultFunctionProviders.size() - 1; i >= 0; --i) {
                    if (this.defaultFunctionProviders.get(i) == functionProviders.get(i)) continue;
                    isEqual = false;
                    break;
                }
                if (isEqual) {
                    return;
                }
            }
            this.defaultFunctionProviders = (ArrayList)functionProviders.clone();
        }
        this.defaultFuncNames.clear();
        this.defaultMethods.clear();
        for (int i = 0; i < this.defaultFunctionProviders.size(); ++i) {
            HashMap<String, String> methodNames = new HashMap<String, String>();
            Object provider = this.defaultFunctionProviders.get(i);
            Class<?> cls = provider.getClass();
            Method[] methods = cls.getMethods();
            for (int j = methods.length - 1; j >= 0; --j) {
                String methodName = methods[j].getName().toUpperCase();
                methodNames.put(methodName, methodName);
            }
            this.defaultMethods.put(cls, methods);
            this.defaultFuncNames.add(methodNames);
        }
    }

    public void setDefaultFunctionProvider(Object functionProvider) {
        if (functionProvider == null) {
            return;
        }
        ArrayList<Object> array = new ArrayList<Object>(1);
        array.add(functionProvider);
        this.setDefaultFunctionProvider(array);
    }

    public void addParserHelperListener(ParserHelperListener helperListener) {
        this.helperListener = helperListener;
    }

    public final long prepare(Object depOwner, String formula) {
        this.depOwner = depOwner;
        this.formula = formula;
        this.currentTokenPos = 0;
        this.currentTokenLength = 0;
        if (StringUtil.isEmptyString(formula)) {
            this.formulaLength = 0;
            this.currentToken = 0x1000000000000000L;
        } else {
            this.formulaLength = formula.length();
            this.currentToken = 0x100000000L;
        }
        return this.currentToken;
    }

    public final boolean meet(long token) {
        return this.currentToken == token;
    }

    public final void advance() throws SyntaxErrorException {
        this.currentToken = this.lex();
    }

    public Variant parse() {
        Variant var = new Variant(0.0);
        try {
            this.advance();
            if (!this.meet(0x1000000000000000L)) {
                this.statement(var);
                if (!this.meet(0x1000000000000000L)) {
                    ExprError.goError(4096L, this.getCurrentWord());
                }
            }
        }
        catch (SyntaxErrorException e) {
            var.setObject(e, 16);
        }
        catch (Exception e) {
            var.setObject(new SyntaxErrorException(64L, (Object)e), 16);
        }
        return var;
    }

    public void statement(Variant rvarResult) throws SyntaxErrorException {
        this.condition(rvarResult);
    }

    public void condition(Variant rvarResult) throws SyntaxErrorException {
        this.andList(rvarResult);
        while (this.touchToken(0x28000000000L)) {
            long oldToken = this.currentToken;
            this.advance();
            Variant varOp2 = Variant.getNewEmptyVariant();
            this.andList(varOp2);
            if (this.syntaxCheck) continue;
            if (oldToken == 0x8000000000L) {
                rvarResult.or(varOp2);
                continue;
            }
            rvarResult.xor(varOp2);
        }
    }

    public final boolean touchFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public final boolean touchToken(long tokens) {
        return this.touchFlag(this.currentToken, tokens);
    }

    public final String getComment() {
        return this.comment;
    }

    private boolean isOwnerDefinedOperator() {
        return this.currentToken < 0x100000000L;
    }

    private final long ident(int pos) throws SyntaxErrorException {
        long token;
        char ch = this.charAt(pos);
        if (Character.isDigit(ch) || ch == '.') {
            boolean sawDot;
            boolean bl = sawDot = ch == '.';
            do {
                if ((ch = this.charAt(++pos)) != '.') continue;
                if (sawDot) {
                    this.currentTokenPos = pos;
                    ExprError.goError(1024L, this.getCurrentWord());
                    continue;
                }
                sawDot = true;
            } while (Character.isDigit(ch) || ch == '.');
            if (ch == 'e' || ch == 'E') {
                sawDot = true;
                if ((ch = this.charAt(++pos)) == '-' || ch == '+') {
                    ch = this.charAt(++pos);
                }
                if (!Character.isDigit(ch)) {
                    this.currentTokenPos = pos;
                    ExprError.goError(2048L, "DIGIT");
                }
                while (Character.isDigit(this.charAt(++pos))) {
                }
            }
            this.currentTokenLength = pos - this.currentTokenPos;
            if (sawDot) {
                return 0x40000000000000L;
            }
            return 0x80000000000000L;
        }
        if (Character.isJavaIdentifierStart(ch)) {
            long token2;
            while (this.isFunctionChar(this.charAt(++pos))) {
            }
            this.currentTokenLength = pos - this.currentTokenPos;
            while (Character.isWhitespace(this.charAt(pos))) {
                ++pos;
            }
            ch = this.charAt(pos);
            if (this.supportCellName && this.isCell(this.currentTokenPos)) {
                if (ch == '(' || ch == '!' || ch == '.') {
                    return 0x100000000000000L;
                }
                return 0x200000000000000L;
            }
            if (this.helperListener != null && ch != '(' && (token2 = this.helperListener.parseToken(this)) != 0x400000000L) {
                return token2;
            }
            return 0x100000000000000L;
        }
        if (this.helperListener != null && (token = this.helperListener.parseToken(this)) != 0x400000000L) {
            return token;
        }
        ExprError.goError(256L, this.getCurrentWord() + "-" + ch);
        return 0x1000000000000000L;
    }

    private boolean isFunctionChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '$' || ch > '\u00ff';
    }

    private final boolean isCell(int pos) {
        if (this.depOwner == null) {
            return false;
        }
        char ch = this.charAt(pos);
        if (ch == '$') {
            ch = this.charAt(++pos);
        }
        this.cp.col = 0;
        while (Character.isLetter(ch)) {
            this.cp.col = this.cp.col * 26 + (Character.toUpperCase(ch) - 65 + 1);
            ch = this.charAt(++pos);
        }
        if (this.cp.col == 0) {
            return false;
        }
        if (ch == '$') {
            ch = this.charAt(++pos);
        }
        this.cp.row = 0;
        while (Character.isDigit(ch)) {
            this.cp.row = this.cp.row * 10 + (Character.toUpperCase(ch) - 48);
            ch = this.charAt(++pos);
        }
        if (this.cp.row == 0) {
            return false;
        }
        if (Character.isJavaIdentifierPart(ch) && ch != '\u0000') {
            return false;
        }
        this.currentTokenLength = pos - this.currentTokenPos;
        --this.cp.row;
        --this.cp.col;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final long lex() throws SyntaxErrorException {
        char ch;
        int pos;
        block43: {
            block42: {
                this.comment = "";
                pos = this.currentTokenPos + this.currentTokenLength;
                block14: while (true) {
                    block41: {
                        int startPos;
                        block44: {
                            block45: {
                                long extToken;
                                block46: {
                                    if (pos >= this.formulaLength) {
                                        return 0x1000000000000000L;
                                    }
                                    this.currentTokenPos = pos;
                                    this.currentTokenLength = 1;
                                    ch = this.formula.charAt(pos);
                                    if (ch >= '\u0080' || ch < '\u0000') break block45;
                                    long token = quickTokens[ch];
                                    if (token < 0x100000000L) break block46;
                                    if (token > 0x200000000L) {
                                        return token;
                                    }
                                    if (token != 0x100000000L) break block45;
                                    break block41;
                                }
                                if (this.helperListener != null && (extToken = this.helperListener.parseToken(this)) != 0x400000000L) {
                                    return extToken;
                                }
                                ExprError.goError(256L, this.getCurrentWord() + "-" + ch);
                            }
                            switch (ch) {
                                case '/': {
                                    startPos = pos;
                                    ch = this.charAt(pos + 1);
                                    if (ch == '*') {
                                        ++pos;
                                        break;
                                    }
                                    if (ch != '/') {
                                        return 0x4000000000L;
                                    }
                                    do {
                                        if ((ch = this.charAt(++pos)) != '\r' && ch != '\n') continue;
                                        ++pos;
                                        break block41;
                                    } while (pos < this.formulaLength);
                                    break block41;
                                }
                                case '.': {
                                    if (Character.isDigit(this.charAt(pos + 1))) {
                                        return this.ident(pos);
                                    }
                                    return 0x10000000000000L;
                                }
                                case '\"': {
                                    break block14;
                                }
                                case '>': {
                                    if (this.charAt(pos + 1) == '=') {
                                        ++this.currentTokenLength;
                                    }
                                    return 0x400000000000L;
                                }
                                case '<': {
                                    char chNext = this.charAt(pos + 1);
                                    if (chNext == '=' || chNext == '>') {
                                        ++this.currentTokenLength;
                                    }
                                    return 0x400000000000L;
                                }
                                case '=': {
                                    if (this.charAt(pos + 1) == '=') {
                                        ++this.currentTokenLength;
                                        return 0x100000000000L;
                                    }
                                    return 0x80000000000L;
                                }
                                case '[': {
                                    break block42;
                                }
                                case '\'': {
                                    break block43;
                                }
                                case '!': {
                                    if (this.charAt(pos + 1) == '=') {
                                        ++this.currentTokenLength;
                                        return 0x200000000000L;
                                    }
                                    return 0x40000000000L;
                                }
                                case '|': {
                                    if (this.charAt(pos + 1) == '|') {
                                        ++this.currentTokenLength;
                                        return 0x8000000000L;
                                    }
                                    return 0x10000000L;
                                }
                                case '&': {
                                    if (this.charAt(pos + 1) == '&') {
                                        ++this.currentTokenLength;
                                        return 0x10000000000L;
                                    }
                                    return 0x40000000L;
                                }
                                case '\ufeff': {
                                    break block41;
                                }
                                default: {
                                    return this.ident(pos);
                                }
                            }
                            do {
                                if (++pos < this.formulaLength) continue;
                                ch = '\u0000';
                                break block44;
                            } while ((ch = this.formula.charAt(pos)) != '*' || (ch = this.charAt(pos + 1)) != '/');
                            ++pos;
                        }
                        if (ch != '/') {
                            ExprError.goError(16384L, "*/");
                        }
                        this.comment = this.formula.substring(startPos, pos + 1);
                    }
                    ++pos;
                }
                do {
                    if (++pos >= this.formulaLength) {
                        ch = '\u0000';
                        break;
                    }
                    ch = this.formula.charAt(pos);
                    if (ch != '\"' || pos <= 0 || this.charAt(pos - 1) != '\\') continue;
                    ch = this.charAt(++pos);
                } while (ch != '\"');
                if (ch == '\"') {
                    ++pos;
                } else {
                    ExprError.goError(16384L, "\"");
                }
                this.currentTokenLength = pos - this.currentTokenPos;
                return 0x20000000000000L;
            }
            do {
                if (++pos < this.formulaLength) continue;
                ch = '\u0000';
                break;
            } while ((ch = this.formula.charAt(pos)) != ']');
            if (ch == ']') {
                ++pos;
            } else {
                ExprError.goError(16384L, "]");
            }
            this.currentTokenLength = pos - this.currentTokenPos;
            return 0x100000000000000L;
        }
        do {
            if (++pos < this.formulaLength) continue;
            ch = '\u0000';
            break;
        } while ((ch = this.formula.charAt(pos)) != '\'');
        if (ch == '\'') {
            ++pos;
        } else {
            ExprError.goError(16384L, "'");
        }
        this.currentTokenLength = pos - this.currentTokenPos;
        if (this.depOwner != null) {
            return 0x400000000000000L;
        }
        return 0x20000000000000L;
    }

    private final void andList(Variant rvarResult) throws SyntaxErrorException {
        this.relExpr(rvarResult);
        while (this.meet(0x10000000000L)) {
            this.advance();
            Variant varOp2 = Variant.getNewEmptyVariant();
            this.andList(varOp2);
            if (this.syntaxCheck) continue;
            rvarResult.and(varOp2);
        }
    }

    private final void relExpr(Variant rvarResult) throws SyntaxErrorException {
        this.expression(rvarResult);
        while (this.touchToken(0x700000000000L)) {
            long oldToken = this.currentToken;
            int oldTokenPos = this.currentTokenPos;
            int oldTokenLen = this.currentTokenLength;
            this.advance();
            Variant varOp2 = Variant.getNewEmptyVariant();
            this.expression(varOp2);
            if (this.syntaxCheck) continue;
            this.checkOperationFactor(rvarResult);
            this.checkOperationFactor(varOp2);
            if (oldToken == 0x100000000000L) {
                rvarResult.setBoolean(rvarResult.equals(varOp2));
                continue;
            }
            if (oldToken == 0x200000000000L) {
                rvarResult.setBoolean(!rvarResult.equals(varOp2));
                continue;
            }
            if (this.formula.charAt(oldTokenPos) == '>') {
                if ((long)oldTokenLen == 1L) {
                    rvarResult.setBoolean(rvarResult.greaterThan(varOp2));
                    continue;
                }
                rvarResult.setBoolean(rvarResult.notLessThan(varOp2));
                continue;
            }
            if ((long)oldTokenLen == 1L) {
                rvarResult.setBoolean(rvarResult.lessThan(varOp2));
                continue;
            }
            rvarResult.setBoolean(rvarResult.notGreaterThan(varOp2));
        }
    }

    private final void expression(Variant rvarResult) throws SyntaxErrorException {
        this.term(rvarResult);
        while (this.touchToken(0x1800000000L)) {
            long oldToken = this.currentToken;
            this.advance();
            Variant varOp2 = Variant.getNewEmptyVariant();
            this.term(varOp2);
            if (this.syntaxCheck) continue;
            this.checkOperationFactor(rvarResult);
            this.checkOperationFactor(varOp2);
            try {
                if (oldToken == 0x800000000L) {
                    rvarResult.add(varOp2);
                    continue;
                }
                rvarResult.subtract(varOp2);
            }
            catch (NumberFormatException e) {
                ExprError.goError(64L, e);
            }
        }
    }

    private final void term(Variant rvarResult) throws SyntaxErrorException {
        this.sign(rvarResult);
        while (this.touchToken(0x6000000000L)) {
            long oldToken = this.currentToken;
            this.advance();
            Variant varOp2 = Variant.getNewEmptyVariant();
            this.sign(varOp2);
            if (this.syntaxCheck) continue;
            this.checkOperationFactor(rvarResult);
            this.checkOperationFactor(varOp2);
            try {
                if (oldToken == 0x2000000000L) {
                    rvarResult.multiply(varOp2);
                    continue;
                }
                rvarResult.divide(varOp2);
            }
            catch (NumberFormatException e) {
                ExprError.goError(64L, e);
            }
        }
    }

    private final void sign(Variant rvarResult) throws SyntaxErrorException {
        this.factor(rvarResult);
        while (this.meet(0x800000000000L)) {
            this.advance();
            Variant varOp2 = Variant.getNewEmptyVariant();
            this.factor(varOp2);
            if (this.syntaxCheck) continue;
            ArrayList<Variant> params = new ArrayList<Variant>();
            params.add(rvarResult);
            params.add(varOp2);
            InnerFunction_POWER func = (InnerFunction_POWER)funcs.get("MOD");
            func.invoke(this, params, rvarResult);
        }
    }

    private final ArrayList getParams() throws SyntaxErrorException {
        if (!this.meet(0x1000000000000L)) {
            ExprError.goError(16384L, "(");
        }
        this.advance();
        ArrayList<Variant> params = new ArrayList<Variant>();
        if (!this.meet(0x2000000000000L)) {
            Variant varParam = Variant.getNewEmptyVariant();
            this.statement(varParam);
            params.add(varParam);
            while (this.meet(0x4000000000000L)) {
                this.advance();
                varParam = Variant.getNewEmptyVariant();
                this.statement(varParam);
                params.add(varParam);
            }
        }
        if (!this.meet(0x2000000000000L)) {
            ExprError.goError(16384L, ")");
        }
        this.advance();
        return params;
    }

    private final boolean isNumericClsType(Class cls) {
        return cls.equals(Integer.TYPE) || cls.equals(Long.TYPE) || cls.equals(Float.TYPE) || cls.equals(Double.TYPE) || cls.equals(Character.TYPE) || cls.equals(Byte.TYPE) || cls.equals(Integer.class) || cls.equals(Character.class) || cls.equals(Short.class) || cls.equals(Variant.class);
    }

    private final Object getProperArg(Variant var, Class cls) throws SyntaxErrorException {
        Variant varNumber;
        Object obj = var.getValue();
        if (var.isNumber()) {
            if (cls.equals(Integer.TYPE)) {
                obj = new Integer(var.intValue());
            } else if (cls.equals(Long.TYPE)) {
                obj = new Long(var.longValue());
            } else if (cls.equals(Float.TYPE)) {
                obj = new Float(var.floatValue());
            } else if (cls.equals(Double.TYPE)) {
                obj = new Double(var.doubleValue());
            } else if (cls.equals(Character.TYPE)) {
                obj = new Character(var.charValue());
            } else if (cls.equals(Byte.TYPE)) {
                obj = new Byte(var.byteValue());
            } else if (cls.equals(Integer.class)) {
                obj = new Integer(var.intValue());
            } else if (cls.equals(Character.class)) {
                obj = new Character(var.charValue());
            } else if (cls.equals(Short.class)) {
                obj = new Short(var.shortValue());
            } else if (cls.equals(Variant.class)) {
                obj = var;
            }
        } else if (var.getVt() == 11 && this.isNumericClsType(cls) && var.isNumeric(varNumber = Variant.getNewEmptyVariant())) {
            return this.getProperArg(varNumber, cls);
        }
        return obj;
    }

    private final void reflectCalls(String functionName, Variant rvarResult) throws SyntaxErrorException {
        do {
            boolean meetDot;
            if (meetDot = this.meet(0x10000000000000L)) {
                this.advance();
            }
            if (meetDot && !this.meet(0x100000000000000L)) {
                ExprError.goError(16384L, "Properties or Methods");
                continue;
            }
            Variant varObject = null;
            if (rvarResult.isNull()) {
                if (this.helperListener != null) {
                    varObject = this.helperListener.getObjectInstance(this, functionName);
                }
            } else {
                varObject = new Variant(rvarResult.getValue(), 17);
            }
            if (varObject == null) {
                ExprError.goError(512L, functionName);
            }
            if (meetDot) {
                functionName = this.getCurrentWord();
                this.advance();
            }
            if (this.meet(0x1000000000000L)) {
                ArrayList params = this.getParams();
                this.reflectCallFunction(varObject, functionName, params, rvarResult);
                continue;
            }
            this.reflectCallFunction(varObject, functionName, null, rvarResult);
        } while (this.meet(0x10000000000000L));
    }

    private final boolean reflectCallFunction(Variant varObj, String funcName, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
        try {
            int i;
            Object objOwner = varObj.getValue();
            assert (objOwner != null);
            Class<?> objCls = objOwner.getClass();
            funcName = this.helperListener.getMethodName(funcName);
            Method method = null;
            Class<?>[] argTypes = null;
            if (params == null) {
                StringBuffer sbMethodName = new StringBuffer(funcName);
                sbMethodName.replace(0, 1, "get" + Character.toUpperCase(sbMethodName.charAt(0)));
                method = objCls.getMethod(sbMethodName.toString(), new Class[0]);
            } else {
                Method[] methods = (Method[])this.defaultMethods.get(objCls);
                if (methods == null) {
                    methods = objCls.getMethods();
                }
                for (i = 0; i < methods.length; ++i) {
                    if (methods[i].getName().compareToIgnoreCase(funcName) != 0 || (argTypes = methods[i].getParameterTypes()).length != params.size()) continue;
                    method = methods[i];
                    break;
                }
                if (method == null) {
                    throw new NoSuchMethodException(funcName);
                }
            }
            Object[] args = null;
            if (params != null) {
                args = new Object[argTypes.length];
                for (i = 0; i < argTypes.length; ++i) {
                    args[i] = this.getProperArg((Variant)params.get(i), argTypes[i]);
                }
            }
            rvarResult.setObject(method.invoke(objOwner, args));
        }
        catch (Exception e) {
            Throwable trw = e;
            if (e instanceof InvocationTargetException) {
                trw = ((InvocationTargetException)e).getTargetException();
            }
            ExprError.goError(128L, trw.getMessage());
        }
        return true;
    }

    private final void factor(Variant rvarResult) throws SyntaxErrorException {
        long unary = 0x100000000L;
        if (this.touchToken(4501125726208L)) {
            unary = this.currentToken;
            this.advance();
        }
        if (this.meet(0x100000000000000L)) {
            String word = this.getCurrentWord();
            this.advance();
            if (this.meet(0x1000000000000L)) {
                this.callFunction(word, rvarResult);
            } else if (this.meet(0x10000000000000L)) {
                rvarResult.setObject(null);
                this.reflectCalls(word, rvarResult);
            } else if (this.meet(0x40000000000L)) {
                if (this.depOwner != null && this.depOwner instanceof RelationNode) {
                    RelationsListener listener = ((RelationNode)this.depOwner).getRelationKey().getRelationsListener();
                    if (!listener.queryRelationsListener(word, rvarResult) || !(rvarResult.getValue() instanceof RelationsListener)) {
                        ExprError.goError(512L, "Sheet " + word);
                    }
                    listener = (RelationsListener)rvarResult.getValue();
                    this.advance();
                    if (!this.meet(0x200000000000000L)) {
                        ExprError.goError(16384L, "Cell");
                    }
                    this.parseCell(listener, rvarResult);
                } else {
                    this.advance();
                }
            } else {
                Object obj = consts.get(word.toUpperCase());
                if (obj != null) {
                    rvarResult.setObject(obj);
                } else if (this.helperListener != null) {
                    this.helperListener.parseID(this, word, rvarResult);
                } else {
                    ExprError.goError(131072L, word);
                }
            }
        } else if (this.meet(0x200000000000000L)) {
            RelationsListener listener = ((RelationNode)this.depOwner).getRelationKey().getRelationsListener();
            this.parseCell(listener, rvarResult);
        } else if (this.meet(0x400000000000000L)) {
            if (this.depOwner != null && this.depOwner instanceof RelationNode) {
                String word = this.getCurrentWord();
                word = word.substring(1, word.length() - 1);
                RelationsListener listener = ((RelationNode)this.depOwner).getRelationKey().getRelationsListener();
                if (!listener.queryRelationsListener(word, rvarResult) || !(rvarResult.getValue() instanceof RelationsListener)) {
                    ExprError.goError(512L, "Sheet " + word);
                }
                listener = (RelationsListener)rvarResult.getValue();
                this.advance();
                if (!this.meet(0x40000000000L)) {
                    ExprError.goError(16384L, "!");
                }
                this.advance();
                if (!this.meet(0x200000000000000L)) {
                    ExprError.goError(16384L, "Cell");
                }
                this.parseCell(listener, rvarResult);
            } else {
                this.advance();
            }
        } else if (this.touchToken(0xC0000000000000L)) {
            this.identifyNumber(this.getCurrentWord(), this.currentToken == 0x40000000000000L, rvarResult);
            this.advance();
        } else if (this.meet(0x1000000000000L)) {
            this.advance();
            this.statement(rvarResult);
            if (!this.meet(0x2000000000000L)) {
                ExprError.goError(16384L, ")");
            }
            this.advance();
        } else if (this.meet(0x20000000000000L)) {
            rvarResult.setObject(this.parseString(), 11);
            this.advance();
        } else if (this.isOwnerDefinedOperator()) {
            assert (this.helperListener != null);
            this.helperListener.processExt(this, rvarResult);
        } else {
            ExprError.goError(8192L, this.getCurrentWord());
        }
        if (unary != 0x100000000L && !this.syntaxCheck) {
            if (unary == 0x1000000000L) {
                rvarResult.negate();
            } else if (unary == 0x40000000000L) {
                rvarResult.not();
            }
        }
    }

    void checkOperationFactor(Variant v) {
        if (v.isNull()) {
            v.setInt(0);
        }
    }

    public final String parseString() {
        boolean matchBacklash = false;
        StringBuffer sb = new StringBuffer(this.currentTokenLength - 2);
        int end = this.currentTokenPos + 1 + this.currentTokenLength - 2;
        for (int i = this.currentTokenPos + 1; i < end; ++i) {
            char ch = this.formula.charAt(i);
            if (ch == '\\') {
                if (matchBacklash) {
                    sb.append(ch);
                    matchBacklash = false;
                    continue;
                }
                matchBacklash = true;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private final void parseCell(RelationsListener cellOwnerListener, Variant rvarResult) throws SyntaxErrorException {
        int row = this.cp.row;
        int col = this.cp.col;
        this.advance();
        if (this.meet(0x8000000000000L)) {
            this.advance();
            if (!this.meet(0x200000000000000L)) {
                ExprError.goError(16384L, "Cell");
            }
            CellBlock cb = CellBlock.getNewCellBlock(cellOwnerListener, row, col, this.cp.row, this.cp.col);
            rvarResult.setObject(cb, 17);
            this.advance();
        } else if (!this.helperListener.queryCell(this, cellOwnerListener, row, col, rvarResult)) {
            ExprError.goError(512L, "Cell(" + row + ", " + col + ")");
        }
    }

    private final void identifyNumber(String numberString, boolean isFloat, Variant rvarResult) {
        if (isFloat) {
            BigDecimal big = new BigDecimal(numberString);
            rvarResult.setObject(big, 10);
        } else {
            try {
                rvarResult.setObject(Long.valueOf(numberString), 4);
            }
            catch (Exception e) {
                BigDecimal big = new BigDecimal(numberString);
                rvarResult.setObject(big, 10);
            }
        }
    }

    private final void callFunction(String funcName, Variant rvarResult) throws SyntaxErrorException {
        String upperFuncName = funcName.toUpperCase();
        Object objFunc = funcs.get(upperFuncName);
        if (objFunc != null) {
            ArrayList params = this.getParams();
            InnerFunction func = (InnerFunction)objFunc;
            if (params.size() < func.getMinArgs() || params.size() > func.getMaxArgs()) {
                ExprError.goError(8L, params.size() + ", MinMax[" + func.getMinArgs() + "," + func.getMaxArgs() + "]");
            }
            if (!this.syntaxCheck) {
                func.invoke(this, params, rvarResult);
            }
        } else {
            HashMap funcNames;
            int i;
            for (i = this.defaultFuncNames.size() - 1; i >= 0 && !(funcNames = (HashMap)this.defaultFuncNames.get(i)).containsKey(upperFuncName); --i) {
            }
            if (i >= 0) {
                rvarResult.setObject(this.defaultFunctionProviders.get(i), 17);
                this.reflectCalls(upperFuncName, rvarResult);
            } else {
                ArrayList params;
                if (this.helperListener != null && this.helperListener.externalMethod(this, funcName, params = this.getParams(), rvarResult)) {
                    if (this.meet(0x10000000000000L)) {
                        this.reflectCalls(null, rvarResult);
                    }
                    return;
                }
                ExprError.goError(128L, funcName);
            }
        }
    }

    static {
        for (int i = 0; i < 128; ++i) {
            Parser.quickTokens[i] = 0x200000000L;
        }
        Parser.quickTokens[43] = 0x800000000L;
        Parser.quickTokens[45] = 0x1000000000L;
        Parser.quickTokens[42] = 0x2000000000L;
        Parser.quickTokens[40] = 0x1000000000000L;
        Parser.quickTokens[41] = 0x2000000000000L;
        Parser.quickTokens[44] = 0x4000000000000L;
        Parser.quickTokens[37] = 0x1000000000L;
        Parser.quickTokens[94] = 0x20000000000L;
        Parser.quickTokens[58] = 0x8000000000000L;
        Parser.quickTokens[32] = 0x100000000L;
        Parser.quickTokens[9] = 0x100000000L;
        Parser.quickTokens[10] = 0x100000000L;
        Parser.quickTokens[13] = 0x100000000L;
        Parser.quickTokens[35] = 0x2000000L;
        Parser.quickTokens[126] = 0x20000000L;
        Parser.quickTokens[96] = 0x8000000L;
        Parser.quickTokens[64] = 0x4000000L;
        Parser.quickTokens[92] = 0x800000L;
        Parser.quickTokens[123] = 0x400000L;
        Parser.quickTokens[125] = 0x200000L;
        Parser.quickTokens[59] = 0x100000L;
        Parser.quickTokens[63] = 0x80000000L;
        consts = new HashMap();
        consts.put("TRUE", Boolean.TRUE);
        consts.put("FALSE", Boolean.FALSE);
        funcs = new HashMap(127);
        String strClass = "Inner.Logic";
        funcs.put("IF", new InnerFunction_IF(3, 3, strClass));
        funcs.put("NOT", new InnerFunction_NOT(1, 1, strClass));
        funcs.put("TRUE", new InnerFunction_TRUE(0, 0, strClass));
        funcs.put("FALSE", new InnerFunction_FALSE(0, 0, strClass));
        funcs.put("AND", new InnerFunction_AND(1, 1000, strClass));
        funcs.put("OR", new InnerFunction_OR(1, 1000, strClass));
        strClass = "Inner.Time";
        funcs.put("NOW", new InnerFunction_NOW(0, 0, strClass));
        funcs.put("YEAR", new InnerFunction_YEAR(1, 1, strClass));
        funcs.put("MONTH", new InnerFunction_MONTH(1, 1, strClass));
        funcs.put("DAY", new InnerFunction_DAY(1, 1, strClass));
        funcs.put("HOUR", new InnerFunction_HOUR(1, 1, strClass));
        funcs.put("MINUTE", new InnerFunction_MINUTE(1, 1, strClass));
        funcs.put("SECOND", new InnerFunction_SECOND(1, 1, strClass));
        funcs.put("YEARDAY", new InnerFunction_YEARDAY(1, 1, strClass));
        funcs.put("WEEKDAY", new InnerFunction_WEEKDAY(1, 1, strClass));
        funcs.put("DATEVALUE", new InnerFunction_DATEVALUE(1, 1, strClass));
        funcs.put("DAYS", new InnerFunction_DAYS(1, 1, strClass));
        funcs.put("HOURS", new InnerFunction_HOURS(1, 1, strClass));
        funcs.put("MILLISECONDS", new InnerFunction_MILLISECONDS(1, 1, strClass));
        funcs.put("MINUTES", new InnerFunction_MINUTES(1, 1, strClass));
        funcs.put("SECONDS", new InnerFunction_SECONDS(1, 1, strClass));
        funcs.put("TICKS", new InnerFunction_TICKS(1, 1, strClass));
        funcs.put("TOTALDAYS", new InnerFunction_TOTALDAYS(1, 1, strClass));
        funcs.put("TOTALHOURS", new InnerFunction_TOTALHOURS(1, 1, strClass));
        funcs.put("TOTALMILLISECONDS", new InnerFunction_TOTALMILLISECONDS(1, 1, strClass));
        funcs.put("TOTALMINUTES", new InnerFunction_TOTALMINUTES(1, 1, strClass));
        funcs.put("TOTALSECONDS", new InnerFunction_TOTALSECONDS(1, 1, strClass));
        strClass = "Inner.Math";
        funcs.put("ABS", new InnerFunction_ABS(1, 1, strClass));
        funcs.put("ROUND", new InnerFunction_ROUND(2, 2, strClass));
        funcs.put("FIX", new InnerFunction_FIX(1, 2, strClass));
        funcs.put("SQRT", new InnerFunction_SQRT(1, 1, strClass));
        funcs.put("INT", new InnerFunction_INT(1, 1, strClass));
        funcs.put("LN", new InnerFunction_LN(1, 1, strClass));
        funcs.put("LOG", new InnerFunction_LOG(2, 2, strClass));
        funcs.put("LOG10", new InnerFunction_LOG10(1, 1, strClass));
        funcs.put("EXP", new InnerFunction_EXP(1, 1, strClass));
        funcs.put("POWER", new InnerFunction_POWER(2, 2, strClass));
        funcs.put("MOD", new InnerFunction_MOD(2, 2, strClass));
        funcs.put("PI", new InnerFunction_PI(0, 0, strClass));
        funcs.put("RAND", new InnerFunction_RAND(0, 0, strClass));
        funcs.put("DEGREES", new InnerFunction_DEGREES(1, 1, strClass));
        funcs.put("RADIANS", new InnerFunction_RADIANS(1, 1, strClass));
        funcs.put("SIN", new InnerFunction_SIN(1, 1, strClass));
        funcs.put("ASIN", new InnerFunction_ASIN(1, 1, strClass));
        funcs.put("COS", new InnerFunction_COS(1, 1, strClass));
        funcs.put("ACOS", new InnerFunction_ACOS(1, 1, strClass));
        funcs.put("TAN", new InnerFunction_TAN(1, 1, strClass));
        funcs.put("ATAN", new InnerFunction_ATAN(1, 1, strClass));
        strClass = "Inner.String";
        funcs.put("LEN", new InnerFunction_LEN(1, 1, strClass));
        funcs.put("TRIM", new InnerFunction_TRIM(1, 1, strClass));
        funcs.put("LEFT", new InnerFunction_LEFT(2, 2, strClass));
        funcs.put("RIGHT", new InnerFunction_RIGHT(2, 2, strClass));
        funcs.put("REPT", new InnerFunction_REPT(2, 2, strClass));
        funcs.put("DEC2HEX", new InnerFunction_DEC2HEX(1, 2, strClass));
    }
}

