/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1;

import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DEROutputStream;
import com.kingdee.bos.ctrl.cipher.util.Arrays;
import java.io.IOException;

public class DERUnknownTag
extends DERObject {
    private boolean isConstructed;
    private int tag;
    private byte[] data;

    public DERUnknownTag(int tag, byte[] data) {
        this(false, tag, data);
    }

    public DERUnknownTag(boolean isConstructed, int tag, byte[] data) {
        this.isConstructed = isConstructed;
        this.tag = tag;
        this.data = data;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(this.isConstructed ? 32 : 0, this.tag, this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DERUnknownTag)) {
            return false;
        }
        DERUnknownTag other = (DERUnknownTag)o;
        return this.isConstructed == other.isConstructed && this.tag == other.tag && Arrays.areEqual(this.data, other.data);
    }

    @Override
    public int hashCode() {
        return (this.isConstructed ? -1 : 0) ^ this.tag ^ Arrays.hashCode(this.data);
    }
}

