/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERGeneralizedTime;
import com.kingdee.bos.ctrl.cipher.asn1.DERTaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.DeclarationOfMajority;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import java.io.IOException;

public class DeclarationOfMajorityUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "DeclarationOfMajority";
    }

    @Override
    public void performTest() throws Exception {
        DERGeneralizedTime dateOfBirth = new DERGeneralizedTime("20070315173729Z");
        DeclarationOfMajority decl = new DeclarationOfMajority(dateOfBirth);
        this.checkConstruction(decl, 2, dateOfBirth, -1);
        decl = new DeclarationOfMajority(6);
        this.checkConstruction(decl, 0, null, 6);
        decl = DeclarationOfMajority.getInstance(null);
        if (decl != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            DeclarationOfMajority.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(DeclarationOfMajority decl, int type, DERGeneralizedTime dateOfBirth, int notYoungerThan) throws IOException {
        this.checkValues(decl, type, dateOfBirth, notYoungerThan);
        decl = DeclarationOfMajority.getInstance(decl);
        this.checkValues(decl, type, dateOfBirth, notYoungerThan);
        ASN1InputStream aIn = new ASN1InputStream(decl.toASN1Object().getEncoded());
        DERTaggedObject info = (DERTaggedObject)aIn.readObject();
        decl = DeclarationOfMajority.getInstance(info);
        this.checkValues(decl, type, dateOfBirth, notYoungerThan);
    }

    private void checkValues(DeclarationOfMajority decl, int type, DERGeneralizedTime dateOfBirth, int notYoungerThan) {
        this.checkMandatoryField("type", type, decl.getType());
        this.checkOptionalField("dateOfBirth", dateOfBirth, decl.getDateOfBirth());
        if (notYoungerThan != -1 && notYoungerThan != decl.notYoungerThan()) {
            this.fail("notYoungerThan mismatch");
        }
    }

    public static void main(String[] args) {
        DeclarationOfMajorityUnitTest.runTest(new DeclarationOfMajorityUnitTest());
    }
}

