/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPair;
import com.kingdee.bos.ctrl.cipher.crypto.agreement.DHAgreement;
import com.kingdee.bos.ctrl.cipher.crypto.agreement.DHBasicAgreement;
import com.kingdee.bos.ctrl.cipher.crypto.generators.DHBasicKeyPairGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.generators.DHKeyPairGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.generators.DHParametersGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHKeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHPublicKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithRandom;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DHTest
extends SimpleTest {
    private BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
    private BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
    private BigInteger g768 = new BigInteger("7c240073c1316c621df461b71ebb0cdcc90a6e5527e5e126633d131f87461c4dc4afc60c2cb0f053b6758871489a69613e2a8b4c8acde23954c08c81cbd36132cfd64d69e4ed9f8e51ed6e516297206672d5c0a69135df0a5dcf010d289a9ca1", 16);
    private BigInteger p768 = new BigInteger("8c9dd223debed1b80103b8b309715be009d48860ed5ae9b9d5d8159508efd802e3ad4501a7f7e1cfec78844489148cd72da24b21eddd01aa624291c48393e277cfc529e37075eccef957f3616f962d15b44aeab4039d01b817fde9eaa12fd73f", 16);
    private BigInteger g1024 = new BigInteger("1db17639cdf96bc4eabba19454f0b7e5bd4e14862889a725c96eb61048dcd676ceb303d586e30f060dbafd8a571a39c4d823982117da5cc4e0f89c77388b7a08896362429b94a18a327604eb7ff227bffbc83459ade299e57b5f77b50fb045250934938efa145511166e3197373e1b5b1e52de713eb49792bedde722c6717abf", 16);
    private BigInteger p1024 = new BigInteger("a00e283b3c624e5b2b4d9fbc2653b5185d99499b00fd1bf244c6f0bb817b4d1c451b2958d62a0f8a38caef059fb5ecd25d75ed9af403f5b5bdab97a642902f824e3c13789fed95fa106ddfe0ff4a707c85e2eb77d49e68f2808bcea18ce128b178cd287c6bc00efa9a1ad2a673fe0dceace53166f75b81d6709d5f8af7c66bb7", 16);

    @Override
    public String getName() {
        return "DH";
    }

    private void testDH(int size, BigInteger g, BigInteger p) {
        DHKeyPairGenerator kpGen = this.getDHKeyPairGenerator(g, p);
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu1 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv1 = (DHPrivateKeyParameters)pair.getPrivate();
        pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu2 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv2 = (DHPrivateKeyParameters)pair.getPrivate();
        DHAgreement e1 = new DHAgreement();
        DHAgreement e2 = new DHAgreement();
        e1.init(pv1);
        e2.init(pv2);
        BigInteger m1 = e1.calculateMessage();
        BigInteger m2 = e2.calculateMessage();
        BigInteger k1 = e1.calculateAgreement(pu2, m2);
        BigInteger k2 = e2.calculateAgreement(pu1, m1);
        if (!k1.equals(k2)) {
            this.fail(size + " bit 2-way test failed");
        }
    }

    private void testDHBasic(int size, int privateValueSize, BigInteger g, BigInteger p) {
        DHBasicKeyPairGenerator kpGen = this.getDHBasicKeyPairGenerator(g, p, privateValueSize);
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu1 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv1 = (DHPrivateKeyParameters)pair.getPrivate();
        this.checkKeySize(privateValueSize, pv1);
        pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu2 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv2 = (DHPrivateKeyParameters)pair.getPrivate();
        this.checkKeySize(privateValueSize, pv2);
        DHBasicAgreement e1 = new DHBasicAgreement();
        DHBasicAgreement e2 = new DHBasicAgreement();
        e1.init(pv1);
        e2.init(pv2);
        BigInteger k1 = e1.calculateAgreement(pu2);
        BigInteger k2 = e2.calculateAgreement(pu1);
        if (!k1.equals(k2)) {
            this.fail("basic " + size + " bit 2-way test failed");
        }
    }

    private void checkKeySize(int privateValueSize, DHPrivateKeyParameters priv) {
        if (privateValueSize != 0 && priv.getX().bitLength() != privateValueSize) {
            this.fail("limited key check failed for key size " + privateValueSize);
        }
    }

    private void testGPWithRandom(DHKeyPairGenerator kpGen) {
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu1 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv1 = (DHPrivateKeyParameters)pair.getPrivate();
        pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu2 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv2 = (DHPrivateKeyParameters)pair.getPrivate();
        DHAgreement e1 = new DHAgreement();
        DHAgreement e2 = new DHAgreement();
        e1.init(new ParametersWithRandom(pv1, new SecureRandom()));
        e2.init(new ParametersWithRandom(pv2, new SecureRandom()));
        BigInteger m1 = e1.calculateMessage();
        BigInteger m2 = e2.calculateMessage();
        BigInteger k1 = e1.calculateAgreement(pu2, m2);
        BigInteger k2 = e2.calculateAgreement(pu1, m1);
        if (!k1.equals(k2)) {
            this.fail("basic with random 2-way test failed");
        }
    }

    private void testSimpleWithRandom(DHBasicKeyPairGenerator kpGen) {
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu1 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv1 = (DHPrivateKeyParameters)pair.getPrivate();
        pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu2 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv2 = (DHPrivateKeyParameters)pair.getPrivate();
        DHBasicAgreement e1 = new DHBasicAgreement();
        DHBasicAgreement e2 = new DHBasicAgreement();
        e1.init(new ParametersWithRandom(pv1, new SecureRandom()));
        e2.init(new ParametersWithRandom(pv2, new SecureRandom()));
        BigInteger k1 = e1.calculateAgreement(pu2);
        BigInteger k2 = e2.calculateAgreement(pu1);
        if (!k1.equals(k2)) {
            this.fail("basic with random 2-way test failed");
        }
    }

    private DHBasicKeyPairGenerator getDHBasicKeyPairGenerator(BigInteger g, BigInteger p, int privateValueSize) {
        DHParameters dhParams = new DHParameters(p, g, null, privateValueSize);
        DHKeyGenerationParameters params = new DHKeyGenerationParameters(new SecureRandom(), dhParams);
        DHBasicKeyPairGenerator kpGen = new DHBasicKeyPairGenerator();
        kpGen.init(params);
        return kpGen;
    }

    private DHKeyPairGenerator getDHKeyPairGenerator(BigInteger g, BigInteger p) {
        DHParameters dhParams = new DHParameters(p, g);
        DHKeyGenerationParameters params = new DHKeyGenerationParameters(new SecureRandom(), dhParams);
        DHKeyPairGenerator kpGen = new DHKeyPairGenerator();
        kpGen.init(params);
        return kpGen;
    }

    private void testGeneration(int size) {
        DHParametersGenerator pGen = new DHParametersGenerator();
        pGen.init(size, 10, new SecureRandom());
        DHParameters dhParams = pGen.generateParameters();
        if (dhParams.getL() != 0) {
            this.fail("DHParametersGenerator failed to set J to 0 in generated DHParameters");
        }
        DHKeyGenerationParameters params = new DHKeyGenerationParameters(new SecureRandom(), dhParams);
        DHBasicKeyPairGenerator kpGen = new DHBasicKeyPairGenerator();
        kpGen.init(params);
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu1 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv1 = (DHPrivateKeyParameters)pair.getPrivate();
        params = new DHKeyGenerationParameters(new SecureRandom(), pu1.getParameters());
        kpGen.init(params);
        pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu2 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv2 = (DHPrivateKeyParameters)pair.getPrivate();
        DHBasicAgreement e1 = new DHBasicAgreement();
        DHBasicAgreement e2 = new DHBasicAgreement();
        e1.init(new ParametersWithRandom(pv1, new SecureRandom()));
        e2.init(new ParametersWithRandom(pv2, new SecureRandom()));
        BigInteger k1 = e1.calculateAgreement(pu2);
        BigInteger k2 = e2.calculateAgreement(pu1);
        if (!k1.equals(k2)) {
            this.fail("basic with " + size + " bit 2-way test failed");
        }
    }

    @Override
    public void performTest() {
        this.testDHBasic(512, 0, this.g512, this.p512);
        this.testDHBasic(768, 0, this.g768, this.p768);
        this.testDHBasic(1024, 0, this.g1024, this.p1024);
        this.testDHBasic(512, 64, this.g512, this.p512);
        this.testDHBasic(768, 128, this.g768, this.p768);
        this.testDHBasic(1024, 256, this.g1024, this.p1024);
        this.testDH(512, this.g512, this.p512);
        this.testDH(768, this.g768, this.p768);
        this.testDH(1024, this.g1024, this.p1024);
        this.testGeneration(256);
        DHBasicKeyPairGenerator kpBasicGen = this.getDHBasicKeyPairGenerator(this.g512, this.p512, 0);
        this.testSimpleWithRandom(kpBasicGen);
        DHKeyPairGenerator kpGen = this.getDHKeyPairGenerator(this.g512, this.p512);
        this.testGPWithRandom(kpGen);
        DHAgreement dh = new DHAgreement();
        AsymmetricCipherKeyPair dhPair = kpGen.generateKeyPair();
        try {
            dh.init(dhPair.getPublic());
            this.fail("DHAgreement key check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DHKeyPairGenerator kpGen768 = this.getDHKeyPairGenerator(this.g768, this.p768);
        try {
            dh.init(dhPair.getPrivate());
            dh.calculateAgreement((DHPublicKeyParameters)kpGen768.generateKeyPair().getPublic(), BigInteger.valueOf(100L));
            this.fail("DHAgreement agreement check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DHBasicAgreement dhBasic = new DHBasicAgreement();
        AsymmetricCipherKeyPair dhBasicPair = kpBasicGen.generateKeyPair();
        try {
            dhBasic.init(dhBasicPair.getPublic());
            this.fail("DHBasicAgreement key check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DHBasicKeyPairGenerator kpBasicGen768 = this.getDHBasicKeyPairGenerator(this.g768, this.p768, 0);
        try {
            dhBasic.init(dhPair.getPrivate());
            dhBasic.calculateAgreement((DHPublicKeyParameters)kpBasicGen768.generateKeyPair().getPublic());
            this.fail("DHBasicAgreement agreement check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        DHTest.runTest(new DHTest());
    }
}

