/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.math.ec;

import com.kingdee.bos.ctrl.cipher.math.ec.ECCurve;
import com.kingdee.bos.ctrl.cipher.math.ec.ECPoint;
import java.math.BigInteger;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint P, BigInteger a, ECPoint Q, BigInteger b) {
        ECCurve c = P.getCurve();
        if (!c.equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P, a, Q, b);
    }

    public static ECPoint shamirsTrick(ECPoint P, BigInteger k, ECPoint Q, BigInteger l) {
        if (!P.getCurve().equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P, k, Q, l);
    }

    private static ECPoint implShamirsTrick(ECPoint P, BigInteger k, ECPoint Q, BigInteger l) {
        int m = Math.max(k.bitLength(), l.bitLength());
        ECPoint Z = P.add(Q);
        ECPoint R = P.getCurve().getInfinity();
        for (int i = m - 1; i >= 0; --i) {
            R = R.twice();
            if (k.testBit(i)) {
                if (l.testBit(i)) {
                    R = R.add(Z);
                    continue;
                }
                R = R.add(P);
                continue;
            }
            if (!l.testBit(i)) continue;
            R = R.add(Q);
        }
        return R;
    }
}

