/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil;

import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

class ExportChooserDialog
extends KDDialog {
    private static final long serialVersionUID = 1L;
    private KDPanel pnlMain;
    private KDPanel pnlContent;
    private KDPanel pnlFormat;
    private KDCheckBox checkBoxExportMeger;
    private KDCheckBox checkBoxOpenRightNow;
    private boolean isMegerExport = true;
    private KDButtonGroup group;
    private KDTextField txtfile;
    private String savePath;
    private String saveFileName;
    private String reportName;
    private String suffixName;
    private String dateFormat;
    private KDLabel label;
    private KDWorkButton btnSelector;
    private KDFileChooser fileChooser;
    private KDButton btnImport;
    private KDButton btnCancel;
    private SimpleFileFilter simpleFileFilter;
    private int isImport;
    private final SimpleFileFilter Filter_KDS = new SimpleFileFilter("kds", "kds" + ExtGuiExecutor.getLocalText("file"));
    private final SimpleFileFilter Filter_Excel = new SimpleFileFilter("xls", "MS Excel" + ExtGuiExecutor.getLocalText("file"));
    private final SimpleFileFilter Filter_PDF = new SimpleFileFilter("pdf", "pdf" + ExtGuiExecutor.getLocalText("file"));
    private final SimpleFileFilter Filter_Excel2007 = new SimpleFileFilter("xlsx", " MS Excel2007" + ExtGuiExecutor.getLocalText("file"));
    private int leftMargin = 8;
    private int rightMargin = 10;
    private int topMargin = 7;
    private int bottomMargin = 10;
    private int width = 640;
    private int height = 480;
    private final String propertyPath = "com.kingdee.bos.ctrl.ext.fulfil.savePath";

    public ExportChooserDialog(Window parent, String reportName) {
        super((Frame)parent, true);
        this.reportName = reportName;
        this.saveFileName = reportName;
        this.setLayout(null);
        this.setSize(this.width, this.height);
        this.setResizable(false);
        this.isImport = 0;
        this.simpleFileFilter = this.Filter_Excel2007;
        this.pnlMain = new KDPanel();
        this.pnlMain.setLayout(null);
        this.pnlMain.setBounds(0, 0, this.width, this.height);
        this.pnlContent = new KDPanel();
        this.pnlContent.setLayout(null);
        this.pnlContent.setBounds(0, 0, this.width, 330);
        this.pnlFormat = new KDPanel(null);
        int contentWidth = this.width - this.leftMargin - this.rightMargin - 3;
        this.pnlFormat.setBounds(this.leftMargin, this.topMargin, contentWidth, 143);
        this.group = new KDButtonGroup();
        this.addRadioButton("(\u4e0d\u63a8\u8350)MS Excel\u6587\u4ef6(.xls)", this.Filter_Excel, 0);
        this.addRadioButton("MS Excel2007\u6587\u4ef6(.xlsx)", this.Filter_Excel2007, 1);
        this.addRadioButton("pdf\u6587\u4ef6(.pdf)", this.Filter_PDF, 2);
        this.addRadioButton("kds\u6587\u4ef6(.kds)", this.Filter_KDS, 3);
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u5bfc\u51fa\u6587\u4ef6\u683c\u5f0f");
        this.pnlFormat.setBorder((Border)title);
        this.pnlContent.add((Component)this.pnlFormat);
        this.checkBoxExportMeger = new KDCheckBox("\u4fdd\u6301\u5408\u5e76\u884c\u72b6\u6001");
        this.checkBoxExportMeger.setSelected(true);
        this.checkBoxExportMeger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportChooserDialog.this.setMegerExport(ExportChooserDialog.this.checkBoxExportMeger.isSelected());
            }
        });
        this.checkBoxOpenRightNow = new KDCheckBox("\u5bfc\u51fa\u5b8c\u6210\u540e\u7acb\u5373\u6253\u5f00\u6587\u4ef6");
        this.checkBoxOpenRightNow.setSelected(true);
        this.label = new KDLabel("\u6587\u4ef6\u5b58\u653e\u4f4d\u7f6e\uff1a");
        this.label.setBounds(this.leftMargin + 2, 240, 500, 20);
        this.pnlContent.add((Component)this.label);
        this.txtfile = new KDTextField(50);
        this.txtfile.setEditable(false);
        this.suffixName = ".xlsx";
        this.btnSelector = new KDWorkButton("\u9009\u62e9");
        this.refresh();
        this.btnSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int intRetVal;
                ExportChooserDialog.this.fileChooser = new KDFileChooser();
                ExportChooserDialog.this.fileChooser.setDialogTitle(ExtGuiExecutor.getLocalText("export"));
                ExportChooserDialog.this.fileChooser.setAcceptAllFileFilterUsed(false);
                ExportChooserDialog.this.fileChooser.addChoosableFileFilter((FileFilter)ExportChooserDialog.this.getSimpleFileFilter());
                ExportChooserDialog.this.fileChooser.setSelectedFile(new File(ExportChooserDialog.this.txtfile.getText()));
                if (e.getSource() == ExportChooserDialog.this.btnSelector && (intRetVal = ExportChooserDialog.this.fileChooser.showSaveDialog((Component)((Object)ExportChooserDialog.this))) == 0) {
                    if (ExportChooserDialog.this.fileChooser.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(ExportChooserDialog.this.suffixName.toLowerCase())) {
                        ExportChooserDialog.this.txtfile.setText(ExportChooserDialog.this.fileChooser.getSelectedFile().getAbsolutePath());
                        ExportChooserDialog.this.savePath = ExportChooserDialog.this.fileChooser.getSelectedFile().getParent() + File.separator;
                        ExportChooserDialog.this.saveFileName = ExportChooserDialog.this.fileChooser.getSelectedFile().getName();
                        ExportChooserDialog.this.saveFileName = ExportChooserDialog.this.saveFileName.split("\\.")[0];
                        System.setProperty("com.kingdee.bos.ctrl.ext.fulfil.savePath", ExportChooserDialog.this.savePath);
                    } else {
                        ExportChooserDialog.this.txtfile.setText(ExportChooserDialog.this.fileChooser.getSelectedFile().getAbsolutePath() + ExportChooserDialog.this.suffixName);
                        ExportChooserDialog.this.savePath = ExportChooserDialog.this.fileChooser.getSelectedFile().getParent() + File.separator;
                        ExportChooserDialog.this.saveFileName = ExportChooserDialog.this.fileChooser.getSelectedFile().getName();
                        System.setProperty("com.kingdee.bos.ctrl.ext.fulfil.savePath", ExportChooserDialog.this.savePath);
                    }
                }
            }
        });
        this.txtfile.setBounds(this.leftMargin + 2, 260, 558, 20);
        this.pnlContent.add((Component)this.txtfile);
        this.btnSelector.setBounds(574, 260, 50, 20);
        this.pnlContent.add((Component)this.btnSelector);
        this.btnImport = new KDButton("\u5bfc\u51fa");
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportChooserDialog.this.setIsImport(1);
                ExportChooserDialog.this.setVisible(false);
            }
        });
        this.btnCancel = new KDButton("\u5173\u95ed");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportChooserDialog.this.setIsImport(0);
                ExportChooserDialog.this.dispose();
            }
        });
        this.checkBoxExportMeger.setBounds(this.leftMargin + 2, 170, 200, 19);
        this.checkBoxExportMeger.setCustomInsets(new Insets(0, 0, 0, 0));
        this.pnlContent.add((Component)this.checkBoxExportMeger);
        this.checkBoxOpenRightNow.setBounds(this.leftMargin + 2, 195, 200, 19);
        this.checkBoxOpenRightNow.setCustomInsets(new Insets(0, 0, 0, 0));
        this.pnlContent.add((Component)this.checkBoxOpenRightNow);
        this.btnImport.setBounds(460, 422, 80, 19);
        this.pnlMain.add((Component)this.btnImport);
        this.btnCancel.setBounds(545, 422, 80, 19);
        this.pnlMain.add((Component)this.btnCancel);
        this.pnlMain.add((Component)this.pnlContent);
        KDSeparator s = new KDSeparator();
        s.setBounds(0, this.height - this.bottomMargin - 60, this.width, 1);
        this.pnlMain.add((Component)s);
        this.getContentPane().add((Component)this.pnlMain);
    }

    public File getFilePath() {
        String importFilePath = this.txtfile.getText();
        if (importFilePath == null || importFilePath == "") {
            return null;
        }
        return new File(importFilePath);
    }

    public void refresh() {
        this.setIsImport(0);
        FileSystemView fsv = FileSystemView.getFileSystemView();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        this.dateFormat = simpleDateFormat.format(new Date());
        String tempPath = fsv.getDefaultDirectory().toString() + File.separator;
        this.saveFileName = this.reportName == "" || this.reportName == null ? "\u6269\u5c55\u62a5\u8868\u9884\u89c8" + this.dateFormat : this.reportName + this.dateFormat;
        if (System.getProperty("com.kingdee.bos.ctrl.ext.fulfil.savePath") == null) {
            this.txtfile.setText(tempPath + this.saveFileName + this.suffixName);
            System.setProperty("com.kingdee.bos.ctrl.ext.fulfil.savePath", tempPath);
        } else {
            this.txtfile.setText(System.getProperty("com.kingdee.bos.ctrl.ext.fulfil.savePath") + this.saveFileName + this.suffixName);
        }
    }

    public void addRadioButton(String name, final SimpleFileFilter simpleFileFilter, int index) {
        boolean selected = this.simpleFileFilter == simpleFileFilter;
        KDRadioButton button = new KDRadioButton(name, selected);
        button.setBounds(10, 26 * index + 30, 200, 20);
        this.group.add((AbstractButton)button);
        this.pnlFormat.add((Component)button);
        if (selected) {
            SwingUtilities.invokeLater(() -> button.requestFocus());
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExportChooserDialog.this.Filter_Excel == simpleFileFilter || ExportChooserDialog.this.Filter_Excel2007 == simpleFileFilter) {
                    ExportChooserDialog.this.checkBoxOpenRightNow.setVisible(true);
                    ExportChooserDialog.this.checkBoxExportMeger.setVisible(true);
                    if (ExportChooserDialog.this.Filter_Excel == simpleFileFilter) {
                        ExportChooserDialog.this.suffixName = ".xls";
                    } else {
                        ExportChooserDialog.this.suffixName = ".xlsx";
                    }
                } else {
                    ExportChooserDialog.this.checkBoxExportMeger.setSelected(true);
                    ExportChooserDialog.this.checkBoxExportMeger.setVisible(false);
                    ExportChooserDialog.this.checkBoxOpenRightNow.setSelected(false);
                    ExportChooserDialog.this.checkBoxOpenRightNow.setVisible(false);
                    if (ExportChooserDialog.this.Filter_PDF == simpleFileFilter) {
                        ExportChooserDialog.this.suffixName = ".pdf";
                    } else {
                        ExportChooserDialog.this.suffixName = ".kds";
                    }
                }
                ExportChooserDialog.this.txtfile.setText(System.getProperty("com.kingdee.bos.ctrl.ext.fulfil.savePath") + ExportChooserDialog.this.saveFileName + ExportChooserDialog.this.suffixName);
                ExportChooserDialog.this.setSimpleFileFilter(simpleFileFilter);
            }
        };
        button.addActionListener(listener);
    }

    public void setSimpleFileFilter(SimpleFileFilter simpleFileFilter) {
        this.simpleFileFilter = simpleFileFilter;
    }

    public SimpleFileFilter getSimpleFileFilter() {
        return this.simpleFileFilter;
    }

    public void setMegerExport(boolean isMegerExport) {
        this.isMegerExport = isMegerExport;
    }

    public boolean isMegerExport() {
        return this.isMegerExport;
    }

    public void setOpenRightNow(boolean openRightNow) {
        this.checkBoxOpenRightNow.setSelected(openRightNow);
    }

    public boolean isOpenRightNow() {
        return this.checkBoxOpenRightNow.isSelected();
    }

    public KDFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public int getIsImport() {
        return this.isImport;
    }

    public void setIsImport(int isImport) {
        this.isImport = isImport;
    }
}

