/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil;

import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;

public class ExportUtil {
    public static void removeHideSheet(Book tempBook, KDSBook kdsbook) {
        UserObject uo = tempBook.getUserObject("EXPORT_HIDE_SHEETS");
        if (uo != null && !"true".equalsIgnoreCase(uo.getValue().toString())) {
            for (int i = 0; i < kdsbook.getSheetCount(); ++i) {
                if (!kdsbook.getSheet((Object)new Integer(i)).getSheetStyleAttributes().isHided()) continue;
                kdsbook.remove((Object)new Integer(i));
                --i;
            }
        }
    }

    public static void setEmbedModel(Book tempBook, Book srcBook) throws SyntaxErrorException {
        int sheetCount = tempBook.getSheetCount();
        for (int sh = 0; sh < sheetCount; ++sh) {
            Sheet oldSheet = srcBook.getSheetByName(tempBook.getSheetName(sh));
            Sheet sheet = tempBook.getSheet(sh);
            ExportUtil.calcDisplayValue(oldSheet, sheet);
            EmbedhLayer oldLayer = oldSheet.getEmbedments(false);
            if (oldLayer == null) continue;
            EmbedhLayer newLayer = sheet.getEmbedments(false);
            for (int i = 0; i < newLayer.size(); ++i) {
                EmbedObject eo = newLayer.getEmbed(i);
                if (eo instanceof FlashChart) {
                    ((FlashChart)eo).setModel(((FlashChart)oldLayer.getEmbed(i)).getModel());
                    ((FlashChart)eo).setCachedImg(((FlashChart)oldLayer.getEmbed(i)).getCachedImg());
                    ((FlashChart)eo).setSrc((FlashChart)oldLayer.getEmbed(i));
                    continue;
                }
                if (eo instanceof EmbedImage && ((EmbedImage)eo).getModel() == null) {
                    ((EmbedImage)eo).setModel(((EmbedImage)oldLayer.getEmbed(i)).getModel());
                    continue;
                }
                if (eo instanceof Chart) {
                    ((Chart)eo).setSrc((Chart)oldLayer.getEmbed(i));
                    continue;
                }
                if (!(eo instanceof SubReportEmbed)) continue;
                ((SubReportEmbed)eo).setImage(((SubReportEmbed)oldLayer.getEmbed(i)).getImage());
            }
        }
    }

    private static void calcDisplayValue(Sheet oldSheet, Sheet sheet) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, 1048575, 65535, false, true);
        while (iter.hasNext()) {
            SortedExtPropFormulasArray formulas;
            Cell cell = iter.next();
            ExtProps props = cell.getExtProps(false);
            if (props == null || (formulas = props.getFormulas(false)) == null || formulas.get(ExtConst.FORMULA_DISP_VALUE) == null) continue;
            cell.setFormula(oldSheet.getCell(cell.getRow(), cell.getCol(), false).getText());
        }
    }

    public static boolean hasFlashChart(Book book) {
        for (int sheetCount = book.getSheetCount() - 1; sheetCount >= 0; --sheetCount) {
            EmbedhLayer layer = book.getSheet(sheetCount).getEmbedments(false);
            if (layer == null) continue;
            for (int i = 0; i < layer.size(); ++i) {
                EmbedObject object = layer.getEmbed(i);
                if (!(object instanceof FlashChart)) continue;
                return true;
            }
        }
        return false;
    }
}

