/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil.mobile.jetty;

import com.kingdee.bos.ctrl.ext.fulfil.mobile.jetty.event.JettyServerStateChangedEvent;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.jetty.event.JettyServerStateChangedListener;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.install.ZipFile;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.net.BindException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyServer {
    public static final int FAILED = -1;
    public static final int STOPPED = 0;
    public static final int STARTING = 1;
    public static final int STARTED = 2;
    public static final int STOPPING = 3;
    public static final String CLIENT_CACHE_ID = "reportId";
    public static final int DEFAULT_SERVER_PORT = 8081;
    public static final String LOCALHOST = "127.0.0.1";
    private static final String CONFIG_PATH = ZipFile.EAS_HOME + File.separator + "client" + File.separator + "deploy" + File.separator + "client" + File.separator + "ctrlhome" + File.separator + "etc" + File.separator;
    private static final String JETTY_HOME = ZipFile.EAS_HOME + "/client";
    private static JettyServer jtServer;
    private static Server server;
    private ArrayList listenerList = new ArrayList();
    private int serverPort = 8081;
    private static HashMap clientCache;

    private JettyServer() {
        clientCache = new HashMap();
    }

    public static JettyServer getInstance() {
        if (jtServer == null) {
            jtServer = new JettyServer();
        }
        return jtServer;
    }

    public void stop() throws Exception {
        if (JettyServer.isStarted()) {
            server.stop();
            server.destroy();
            server = null;
            jtServer = null;
            clientCache.clear();
        }
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JettyServer.this.startServer(8081);
            }
        }).start();
    }

    private void startServer(int port) {
        if (port == 8081) {
            server = new Server();
            server.addLifeCycleListener((LifeCycle.Listener)new LifeCycleAdapter());
            this.readXmlConfig(server);
        }
        try {
            server.start();
            server.join();
        }
        catch (BindException e1) {
            e1.printStackTrace();
            this.startServer(this.serverPort + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fireStateChangedEvents(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXmlConfig(Server server) {
        Resource resource = null;
        try {
            File file = new File(FilenameUtils.normalize((String)(CONFIG_PATH + "jetty.xml")));
            resource = Resource.newResource((File)file);
            XmlConfiguration configuration = new XmlConfiguration(resource);
            configuration.getProperties().put("jetty.home", JETTY_HOME);
            configuration.configure((Object)server);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{resource});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{resource});
        }
        CloseUtil.close((Closeable[])new Closeable[]{resource});
    }

    public void addStateChangedListener(JettyServerStateChangedListener l) {
        HashMap<Class<JettyServerStateChangedListener>, JettyServerStateChangedListener> listenerMap = new HashMap<Class<JettyServerStateChangedListener>, JettyServerStateChangedListener>();
        listenerMap.put(JettyServerStateChangedListener.class, l);
        this.listenerList.add(listenerMap);
    }

    public void fireStateChangedEvents(int stateType) {
        for (HashMap listenerMap : this.listenerList) {
            EventListener listener = (EventListener)listenerMap.get(JettyServerStateChangedListener.class);
            if (listener == null) continue;
            JettyServerStateChangedEvent e = new JettyServerStateChangedEvent(this, stateType);
            ((JettyServerStateChangedListener)listener).stateChange(e);
        }
    }

    public void removeAllListener() {
        this.listenerList.clear();
    }

    public static boolean isStarted() {
        return server != null && server.isStarted();
    }

    public boolean isStarting() {
        return server != null && server.isStarting();
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Object getClientCache(String cacheId) {
        return clientCache.get(cacheId);
    }

    public void putClientCache(String cacheId, Object o) {
        clientCache.put(cacheId, o);
    }

    public static void removeClientCache(String cacheId) {
        clientCache.remove(cacheId);
    }

    public static void clearClientCache() {
        clientCache.clear();
    }

    public Server getServer() {
        return server;
    }

    class LifeCycleAdapter
    implements LifeCycle.Listener {
        LifeCycleAdapter() {
        }

        public void lifeCycleStarted(LifeCycle arg0) {
            JettyServer.this.fireStateChangedEvents(2);
        }

        public void lifeCycleFailure(LifeCycle arg0, Throwable arg1) {
            JettyServer.this.fireStateChangedEvents(-1);
        }

        public void lifeCycleStarting(LifeCycle arg0) {
            JettyServer.this.fireStateChangedEvents(1);
        }

        public void lifeCycleStopped(LifeCycle arg0) {
            JettyServer.this.fireStateChangedEvents(0);
        }

        public void lifeCycleStopping(LifeCycle arg0) {
            JettyServer.this.fireStateChangedEvents(3);
        }
    }
}

