/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pe.beans.editor;

import com.kingdee.bos.ctrl.ext.pe.beans.editor.AbstractPropertyEditor;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.formula.FormulaComposer;
import com.kingdee.bos.ctrl.ext.pe.beans.value.StringVFPair;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class StylePropertyEditor
extends AbstractPropertyEditor {
    private StyleEditPanel styleEditPanel = new StyleEditPanel();
    private FormulaComposer formulaEditPanel = new FormulaComposer();

    public StylePropertyEditor() {
        this.editor.addEditor((JComponent)((Object)this.styleEditPanel));
        this.editor.addEditor((JComponent)((Object)this.formulaEditPanel));
    }

    @Override
    public Object getValue() {
        StringVFPair vfp = new StringVFPair();
        if (this.styleEditPanel.isDisplayable()) {
            vfp.setValue(this.styleEditPanel.getText());
        } else {
            vfp.setFormula(this.formulaEditPanel.getFormula());
            vfp.setGlobalFormula(this.editor.getClientProperty("GlobalFormula") != null);
        }
        return vfp;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof StringVFPair) {
            StringVFPair vfp = (StringVFPair)value;
            if (vfp.hasFormula()) {
                this.formulaEditPanel.setFormula(vfp.getFormula());
                this.editor.switchEditor();
            } else {
                this.styleEditPanel.setText((String)vfp.getValue());
            }
        }
    }

    private class StyleEditPanel
    extends KDPanel {
        KDTextField textField;
        LazyStyleDesigner sd;
        KDWorkButton style_pop;

        StyleEditPanel() {
            this.setLayout(new StyleEditPanelLayout());
            this.textField = new KDTextField();
            this.style_pop = new KDWorkButton();
            this.style_pop.setOpaque(false);
            this.style_pop.setBorder(null);
            this.style_pop.setIcon((Icon)ResourceManager.getImageIcon("style_popuo.gif"));
            this.add((Component)this.textField);
            this.add((Component)this.style_pop);
            this.initListeners();
        }

        public void requestFocus() {
            this.textField.requestFocus();
        }

        private void initListeners() {
            this.textField.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        StyleEditPanel.this.style_pop.doClick();
                    }
                }
            });
            this.style_pop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StyleEditPanel.this.sd == null) {
                        Window w = SwingUtilities.getWindowAncestor((Component)((Object)StyleEditPanel.this));
                        if (w instanceof Frame) {
                            StyleEditPanel.this.sd = new LazyStyleDesigner((Frame)w);
                        } else if (w instanceof Dialog) {
                            StyleEditPanel.this.sd = new LazyStyleDesigner((Dialog)w);
                        }
                        StyleEditPanel.this.sd.setPanels(new String[]{"digitFormat"});
                        StyleEditPanel.this.sd.setTitle(MultiLanguageKeys.getLocalText("KEY_CELLSTYLE", "\u5355\u5143\u683c\u683c\u5f0f:"));
                        StyleEditPanel.this.sd.setLocationRelativeTo((Component)w);
                    }
                    StyleAttributes sa = Styles.getDefaultSA();
                    sa.setNumberFormat(StyleEditPanel.this.textField.getText());
                    StyleEditPanel.this.sd.setSA(sa);
                    StyleEditPanel.this.sd.showDialog();
                    if (StyleEditPanel.this.sd.isChanged()) {
                        Object o = StyleEditPanel.this.sd.getSA().get(ShareStyleAttributes.NUMBER_FORMAT);
                        if (o != null) {
                            StyleEditPanel.this.textField.setText((String)o);
                        } else {
                            StyleEditPanel.this.textField.setText("");
                        }
                    }
                    StyleEditPanel.this.sd.dispose();
                }
            });
        }

        void setText(String text) {
            this.textField.setText(text);
        }

        String getText() {
            return this.textField.getText();
        }

        private class StyleEditPanelLayout
        implements LayoutManager {
            private StyleEditPanelLayout() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                int width = parent.getWidth();
                int height = parent.getHeight();
                int btnSize = width / 2 > 16 ? 16 : width / 2;
                StyleEditPanel.this.style_pop.setBounds(width - btnSize, 0, btnSize, height);
                StyleEditPanel.this.textField.setBounds(0, 0, width - btnSize, height);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return null;
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return null;
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        }
    }
}

