/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting.dirty;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.reporting.dirty.ExtReportingDirtyManager;
import com.kingdee.bos.ctrl.ext.reporting.dirty.OffsetRange;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.DeleteDataPlan;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.InsertDataPlan;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction_InsDel;
import com.kingdee.bos.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public class DeleteDataPlanCreator {
    private static Logger logger = CommonLogger.getLogger(DeleteDataPlanCreator.class);
    private ExtReportingDirtyManager _manager;
    private Sheet _activeSheet;
    private Cell _activeCll;

    public DeleteDataPlanCreator(ExtReportingDirtyManager manager) {
        this._manager = manager;
    }

    public void addDeleteDataPlan(Cell hotSpot) {
        this._activeCll = hotSpot;
        this._activeSheet = hotSpot.getSheet();
        ExtProps props = hotSpot.getExtProps(false);
        if (props == null) {
            return;
        }
        Cell srcCll = props.getSource().getCell();
        IUpdateConstraint[] constraints = this._manager._cell2ConstraintMap.get(srcCll);
        OffsetRange range = new OffsetRange();
        ExtProps activeProps = this._activeCll.getExtProps(true);
        ExtProps head = activeProps.getSource().getHead(true, false);
        if (head == null || head.isCell00()) {
            head = activeProps;
        }
        range.direction = head.getExtensible(false) != 1;
        boolean isNew = false;
        for (int i = 0; i < constraints.length; ++i) {
            List usedCellList = constraints[i].getUsedCellList(false);
            this.calcRemovedAllBrotherCells(range, constraints[i]);
            Cell[] all = this._manager.findAllBrotherCells(range.rowOffset, range.colOffset, usedCellList);
            ExecutionPlan plan = this._manager.searchSameRecord(all);
            if (plan instanceof DeleteDataPlan) {
                return;
            }
            isNew = plan instanceof InsertDataPlan;
            if (isNew) {
                // empty if block
            }
            this._manager._records.remove(plan);
            if (!isNew) {
                plan = new DeleteDataPlan(UUID.randomUUID().toString(), all, constraints[i]);
                plan.generateSQL();
                this._manager._records.add(plan);
                continue;
            }
            this.shrinkVerifyArea(range.activeRange, range.direction);
        }
        if (isNew) {
            this.doRemove(range);
        } else {
            CellBlock cb = range.activeRange.getBlock(0);
            Sheet.ICellsIterator iter = this._activeSheet.getCellsIterator(cb, true, false);
            ArrayList<ExtProps> reportingPropsList = new ArrayList<ExtProps>();
            while (activeProps != null && !activeProps.isCell00() && !activeProps.isReportingGroupRootProps()) {
                activeProps = activeProps.getHead(range.direction, false);
            }
            while (iter.hasNext()) {
                Cell cll = iter.next();
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                sa.setStrikeThrough(true);
                cll.setSSA((ShareStyleAttributes)sa);
                props = cll.getExtProps(true);
                if (!props.isReportingGroupRootProps() || props == activeProps) continue;
                reportingPropsList.add(props);
            }
            ExtProps[] reportingPropsArray = new ExtProps[reportingPropsList.size()];
            reportingPropsList.toArray(reportingPropsArray);
            this.doSubsRemove(reportingPropsArray);
        }
        this._manager._book.fireBookPropertyChange(null, null, "Global_Repaint");
    }

    private void calcRemovedAllBrotherCells(OffsetRange range, IUpdateConstraint constraints) {
        ExtProps activeProps = this._activeCll.getExtProps(true);
        CellBlock removeCB = this.calcSubsBound(activeProps, range);
        if (removeCB == null) {
            return;
        }
        if (range.activeRange == null) {
            range.activeRange = new Range(this._manager._book, this._activeSheet, removeCB);
        } else {
            CellBlock lastBlock = range.activeRange.getBlock(0);
            int row = Math.min(lastBlock.getRow(), removeCB.getRow());
            int col = Math.min(lastBlock.getCol(), removeCB.getCol());
            int row2 = Math.max(lastBlock.getRow2(), removeCB.getRow2());
            int col2 = Math.max(lastBlock.getCol2(), removeCB.getCol2());
            lastBlock.setRowCol(row, col, row2, col2);
        }
    }

    private CellBlock calcSubsBound(ExtProps activeProps, OffsetRange offset) {
        CellBlock[] reportingTemplateBlocks;
        while (activeProps != null && !activeProps.isCell00() && !activeProps.isReportingGroupRootProps()) {
            activeProps = activeProps.getHead(offset.direction, false);
        }
        if (activeProps.isCell00()) {
            activeProps = this._activeCll.getExtProps(true);
        }
        if ((reportingTemplateBlocks = this._manager.getReportingTemplateCellBlock(activeProps.getSource())) == null || reportingTemplateBlocks.length == 0) {
            return null;
        }
        CellBlock srcBlock = reportingTemplateBlocks[0];
        activeProps.clearSubsBounds();
        CellBlock activeBlock = activeProps.getSubsBound();
        offset.rowOffset = offset.direction ? activeBlock.getRow() - srcBlock.getRow() : 0;
        offset.colOffset = offset.direction ? 0 : activeBlock.getCol() - srcBlock.getCol();
        return activeBlock;
    }

    private void doRemove(OffsetRange range) {
        ExtProps activeProps;
        if (range.activeRange == null) {
            return;
        }
        Sheet.ICellsIterator iter = this._activeSheet.getCellsIterator(range.activeRange.getBlock(0), true, false);
        ArrayList<ExtProps> reportingPropsList = new ArrayList<ExtProps>();
        for (activeProps = this._activeCll.getExtProps(true); activeProps != null && !activeProps.isCell00() && !activeProps.isReportingGroupRootProps(); activeProps = activeProps.getHead(range.direction, false)) {
        }
        activeProps.getHead(range.direction, false).clearHead(range.direction);
        while (iter.hasNext()) {
            Cell cll = iter.next();
            ExtProps props = cll.getExtProps(true);
            if (props.isReportingGroupRootProps() && props != activeProps) {
                reportingPropsList.add(props);
                continue;
            }
            props.clearHead(true);
            props.clearHead(false);
        }
        ExtProps[] reportingPropsArray = new ExtProps[reportingPropsList.size()];
        reportingPropsList.toArray(reportingPropsArray);
        this.doSubsRemove(reportingPropsArray);
        new SheetAction_InsDel(range.activeRange, false, range.direction).run();
        this._manager.offsetReportingTemplateCellBlock(this._activeSheet, range.direction);
    }

    private void doSubsRemove(ExtProps[] reportingPropsArray) {
        if (reportingPropsArray.length > 0) {
            for (int i = 0; i < reportingPropsArray.length; ++i) {
                try {
                    new DeleteDataPlanCreator(this._manager).addDeleteDataPlan(reportingPropsArray[i].getCell());
                    continue;
                }
                catch (Throwable th) {
                    logger.error((Object)th);
                }
            }
        }
    }

    private void shrinkVerifyArea(Range activeRange, boolean yDir) {
        if (activeRange == null) {
            return;
        }
        ValidationList vList = this._activeSheet.getValidations();
        CellBlock deleteCellBlock = activeRange.getBlock(0);
        Sheet.ICellsIterator iter = this._activeSheet.getCellsIterator(deleteCellBlock, true, false);
        ArrayList<Validation> list = new ArrayList<Validation>();
        while (iter.hasNext()) {
            CellBlock deleteSingleBlock;
            int col;
            int row;
            Validation validation;
            Cell srcCell;
            Cell cell = iter.next();
            ExtProps props = cell.getExtProps(true);
            if ((props = props.getSource()) == null || (srcCell = props.getCell()) == null || (validation = vList.getValidationContainer(row = srcCell.getRow(), col = srcCell.getCol())) == null) continue;
            list.add(validation);
            SortedCellBlockArray cbs = validation.getBlocks();
            if (!cbs.contains(deleteSingleBlock = CellBlock.getCellBlock(cell.getRow(), cell.getCol()))) continue;
            cbs.remove(deleteSingleBlock);
            this.offsetCellBlock(cbs, deleteCellBlock, yDir);
        }
        for (int i = 0; i < vList.size(); ++i) {
            Validation validation = vList.getValidation(i);
            if (list.contains(validation)) continue;
            SortedCellBlockArray cbs = validation.getBlocks();
            this.offsetCellBlock(cbs, deleteCellBlock, yDir);
        }
    }

    private void offsetCellBlock(SortedCellBlockArray cbs, CellBlock deleteCellBlock, boolean yDir) {
        for (int j = 0; j < cbs.size(); ++j) {
            CellBlock other = cbs.getBlock(j);
            if (yDir) {
                if (other.getRow() < deleteCellBlock.getRow()) continue;
                other.setRow(other.getRow() - deleteCellBlock.getHeight());
                other.setRow2(other.getRow2() - deleteCellBlock.getHeight());
                continue;
            }
            if (other.getCol() < deleteCellBlock.getCol()) continue;
            other.setCol(other.getCol() - deleteCellBlock.getWidth());
            other.setCol2(other.getCol2() - deleteCellBlock.getWidth());
        }
    }
}

