/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.data.inner;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;

public class TextFileDatasetConfiger
extends KDDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private KDTextField jTextField1;
    private KDFileChooser fileChooser;
    public static final String KEY_TXT_FILE = "txtFile";
    public static final String KEY_OK = "ok";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_TITLE = "title";
    public static final String KEY_FILE_PATH = "filePath";
    private FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return TextFileDatasetConfiger.getLocalText(TextFileDatasetConfiger.KEY_TXT_FILE);
        }
    };

    public static String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, TextFileDatasetConfiger.class, (String)"NotFound");
    }

    public TextFileDatasetConfiger(Dialog parent) {
        super(parent);
        this.initComponents();
        this.initListeners();
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(TextFileDatasetConfiger.getLocalText(KEY_TITLE));
    }

    public String getFilePath() {
        return this.jTextField1.getText();
    }

    public void setFilePath(String filePath) {
        this.jTextField1.setText(filePath);
        if (this.fileChooser == null) {
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setFileFilter(this.filter);
            this.fileChooser.setFileSelectionMode(2);
        }
        if (!StringUtils.isEmpty((String)filePath)) {
            this.fileChooser.setSelectedFile(new File(filePath));
        } else {
            this.fileChooser.setSelectedFile(null);
        }
    }

    public void setMultiSelectionEnabled(boolean b) {
        if (this.fileChooser == null) {
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setFileFilter(this.filter);
            this.fileChooser.setFileSelectionMode(2);
        }
        this.fileChooser.setMultiSelectionEnabled(b);
    }

    private void initListeners() {
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextFileDatasetConfiger.this.fileChooser == null) {
                    TextFileDatasetConfiger.this.fileChooser = new KDFileChooser();
                    TextFileDatasetConfiger.this.fileChooser.setFileFilter(TextFileDatasetConfiger.this.filter);
                    TextFileDatasetConfiger.this.fileChooser.setFileSelectionMode(2);
                }
                if (!StringUtils.isEmpty((String)TextFileDatasetConfiger.this.jTextField1.getText())) {
                    TextFileDatasetConfiger.this.fileChooser.setCurrentDirectory(new File(TextFileDatasetConfiger.this.jTextField1.getText()));
                } else {
                    TextFileDatasetConfiger.this.fileChooser.setCurrentDirectory(new File("C:" + File.separator + "kd" + File.separator + "txt"));
                }
                if (0 == TextFileDatasetConfiger.this.fileChooser.showOpenDialog((Component)((Object)TextFileDatasetConfiger.this))) {
                    if (TextFileDatasetConfiger.this.fileChooser.isMultiSelectionEnabled()) {
                        File[] files = TextFileDatasetConfiger.this.fileChooser.getSelectedFiles();
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < files.length; ++i) {
                            sb.append(files[i].getAbsolutePath());
                            sb.append(";");
                        }
                        String text = sb.toString();
                        TextFileDatasetConfiger.this.jTextField1.setText(text.substring(0, text.length() - 1));
                    } else {
                        File file = TextFileDatasetConfiger.this.fileChooser.getSelectedFile();
                        TextFileDatasetConfiger.this.jTextField1.setText(file.getAbsolutePath());
                    }
                }
            }
        });
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFileDatasetConfiger.this.close();
            }
        });
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFileDatasetConfiger.this.jTextField1.setText("");
                TextFileDatasetConfiger.this.close();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new KDTextField();
        this.jButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel1.setText(TextFileDatasetConfiger.getLocalText(KEY_FILE_PATH));
        this.jButton1.setText("...");
        this.jButton2.setText(TextFileDatasetConfiger.getLocalText(KEY_OK));
        this.jButton3.setText(TextFileDatasetConfiger.getLocalText(KEY_CANCEL));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 346, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextField1, -2, 229, -2).addPreferredGap(0).add((Component)this.jButton1)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButton2).addPreferredGap(1).add((Component)this.jButton3))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(21, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextField1, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).add(2, 2, 2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButton3).add((Component)this.jButton2, -2, 25, -2)).addContainerGap()));
        this.pack();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

