/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableDocument;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.IUnit;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.NonFuncUnit;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.Param;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class ContentLayout {
    private static final Logger log = LogUtil.getPackageLogger(ContentLayout.class);
    static final String TabInstead = new String(new char[]{' ', ' ', ' ', ' '});
    private static final int MaxWidth = 64;
    private FuncCollapsableDocument _doc;
    private IFuncUnit _rootFuncUnit;
    private boolean _isFullCollect;
    private IParamWrapAsker _paramWrapAsker;

    ContentLayout(FuncCollapsableDocument doc, IFuncUnit virtualRoot, boolean isFullCollect) {
        this._doc = doc;
        this._rootFuncUnit = virtualRoot;
        this._isFullCollect = isFullCollect;
    }

    void setParamWrapAsker(IParamWrapAsker asker) {
        this._paramWrapAsker = asker;
    }

    private boolean isParamNeedWrap(String funcName, int paramsCount, int paramIdx) {
        if (this._paramWrapAsker == null) {
            return false;
        }
        Boolean askReslut = this._paramWrapAsker.isNeedWrap(funcName, paramsCount, paramIdx);
        if (askReslut == IParamWrapAsker.AUTO) {
            return false;
        }
        return askReslut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void layoutWithTab() {
        String oriText;
        log.debug((Object)("***********\u5185\u5bb9\u5e03\u5c40\u5f00\u59cb***********" + this._isFullCollect));
        log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u5c06\u6536\u8d77\u51fd\u6570\u4e34\u65f6\u5168\u90e8\u5c55\u5f00");
        Stack tempExpands = this.tempExpand();
        try {
            oriText = this._doc.getText(0, this._doc.getLength());
            log.debug((Object)oriText);
        }
        catch (BadLocationException ex) {
            log.error((Object)"", (Throwable)ex);
            return;
        }
        try {
            IUnit unit;
            int i;
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u6253\u5f00\u7ec4\u5408Undo");
            this._doc.openCompositeUndo();
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u5173\u95ed\u516c\u5f0f\u91cd\u89e3\u6790");
            this._doc.getCustomDocumentFilter().closeRemapping();
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u786e\u5b9a\u53c2\u6570\u4f4d\u7f6e\u548c\u975e\u51fd\u6570\u5355\u5143\u4f4d\u7f6e");
            this.confirmParamPos();
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u5220\u6389\u4e0a\u4e00\u6b21\u7684\u7f29\u8fdb/\u6362\u884c");
            Param root = this._rootFuncUnit.getParams()[0];
            for (i = root.getUnitCount() - 1; i >= 0; --i) {
                unit = root.getUnit(i);
                this.layoutWithTab(unit, 0, true, false);
                if (i <= 0 || !(unit instanceof IFuncUnit)) continue;
                this.removeEmptyChars(((IFuncUnit)unit).getNameStartPos(), false, true);
            }
            this.removeEmptyChars(0, true, false);
            this.removeEmptyChars(this._doc.getLength(), false, true);
            log.debug((Object)this._doc.getText(0, this._doc.getLength()));
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u91cd\u65b0\u786e\u5b9a\u53c2\u6570\u4f4d\u7f6e\u548c\u975e\u51fd\u6570\u5355\u5143\u4f4d\u7f6e");
            this.confirmParamPos();
            log.debug((Object)"@@@@ \u91cd\u65b0\u6dfb\u52a0\u7f29\u8fdb/\u6362\u884c");
            for (i = root.getUnitCount() - 1; i >= 0; --i) {
                unit = root.getUnit(i);
                this.layoutWithTab(unit, 0, false, false);
                if (i <= 0 || !(unit instanceof IFuncUnit)) continue;
                this.insertWrapAndTab(((IFuncUnit)unit).getNameStartPos(), 0);
            }
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u7ed3\u679c");
            log.debug((Object)this._doc.getText(0, this._doc.getLength()));
        }
        catch (BadLocationException ex) {
            log.error((Object)"\u5185\u5bb9\u5e03\u5c40\u5931\u8d25", (Throwable)ex);
            try {
                this._doc.replace(0, this._doc.getLength(), oriText, null);
            }
            catch (BadLocationException ex1) {
                log.error((Object)"", (Throwable)ex1);
            }
        }
        finally {
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u5173\u95ed\u7ec4\u5408Undo");
            this._doc.closeCompositeUndo();
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u6253\u5f00\u516c\u5f0f\u91cd\u89e3\u6790");
            this._doc.getCustomDocumentFilter().openRemapping();
            log.debug((Object)"@@@@ \u5185\u5bb9\u5e03\u5c40-\u5c06\u4e34\u65f6\u5c55\u5f00\u7684\u51fd\u6570\u91cd\u65b0\u6536\u8d77");
            this.tempCollapsed(tempExpands);
            log.debug((Object)"===========\u5185\u5bb9\u5e03\u5c40\u7ed3\u675f===========");
        }
    }

    private void confirmParamPos() throws BadLocationException {
        Param p = this._rootFuncUnit.getParams()[0];
        int len = this._doc.getLength();
        p.setPos(0);
        p.setLen(len);
        this.confirmParamPos(p, this._doc.getText(0, len).toUpperCase());
        this.debugOutputConfirmResult();
    }

    private void confirmParamPos(Param param, String text) throws BadLocationException {
        int fromPos = param.getPos();
        int c = param.getUnitCount();
        for (int j = 0; j < c; ++j) {
            IUnit unit = param.getUnit(j);
            if (unit instanceof IFuncUnit) {
                IFuncUnit func = (IFuncUnit)unit;
                this.confirmParamPos(func, text);
                fromPos = func.getNameStartPos() + func.getAllLength();
                continue;
            }
            NonFuncUnit nfu = (NonFuncUnit)unit;
            String name = nfu.getText().toUpperCase();
            int pos = text.indexOf(name, fromPos);
            nfu.setPos(pos);
            fromPos = pos + name.length();
        }
    }

    private void confirmParamPos(IFuncUnit parent, String text) throws BadLocationException {
        int i;
        if (parent.isInvalid()) {
            return;
        }
        int pos = parent.getLpPos() + 1;
        Param[] params = parent.getParams();
        int[] commasPos = parent.getCommasPos();
        for (i = 0; i < params.length; ++i) {
            Param param = params[i];
            if (i > 0) {
                int cp = commasPos[i - 1];
                params[i - 1].setLen(cp - pos);
                pos = cp + 1;
            }
            param.setPos(pos);
            this.confirmParamPos(param, text);
        }
        if (i > 0) {
            params[i - 1].setLen(parent.getRpPos() - pos);
        }
    }

    private void debugOutputConfirmResult() {
        if (!log.isDebugEnabled()) {
            return;
        }
        this.debugOutputConfirmResult(this._rootFuncUnit.getParams()[0], 0);
    }

    private void debugOutputConfirmResult(Param param, int tabCount) {
        int c = param.getUnitCount();
        for (int i = 0; i < c; ++i) {
            StringBuffer sb;
            IUnit unit = param.getUnit(i);
            if (unit instanceof IFuncUnit) {
                IFuncUnit fu = (IFuncUnit)unit;
                sb = new StringBuffer(ContentLayout.getTab(tabCount));
                sb.append(fu.getDisplayName());
                sb.append(", pos:");
                sb.append(fu.getNameStartPos());
                log.debug((Object)sb.toString());
                Param[] ps = fu.getParams();
                for (int j = 0; j < ps.length; ++j) {
                    sb = new StringBuffer(ContentLayout.getTab(tabCount + 1));
                    sb.append("param");
                    sb.append(j);
                    sb.append(", pos:");
                    sb.append(ps[j].getPos());
                    log.debug((Object)sb.toString());
                    this.debugOutputConfirmResult(ps[j], tabCount + 2);
                }
                continue;
            }
            NonFuncUnit nfu = (NonFuncUnit)unit;
            sb = new StringBuffer(ContentLayout.getTab(tabCount));
            sb.append(nfu.getText());
            sb.append(":");
            sb.append(nfu.getPos());
            sb.append("-");
            sb.append(nfu.getEndPos());
            log.debug((Object)sb.toString());
        }
    }

    private boolean layoutWithTab(IUnit parentUnit, int tabCount, boolean isCut, boolean paramIgnored) throws BadLocationException {
        if (!(parentUnit instanceof IFuncUnit)) {
            return false;
        }
        IFuncUnit parent = (IFuncUnit)parentUnit;
        if (parent.isInvalid()) {
            return false;
        }
        int charCount = tabCount * 4;
        Param[] params = parent.getParams();
        if (!(isCut || ContentLayout.isFuncNeedLayout(parent, charCount, charCount) && !paramIgnored)) {
            for (int i = params.length - 1; i >= 1; --i) {
                Param param = params[i];
                this.insertBlank(param.getPos());
            }
            return false;
        }
        this.modify(parent.getRpPos(), tabCount, isCut, false);
        int tempCharCount = charCount += 4;
        for (int i = params.length - 1; i >= 0; --i) {
            int c;
            Param param = params[i];
            boolean isIgnoreParam = false;
            if (!isCut && !ContentLayout.isParamNeedLayout(param, tempCharCount, charCount)) {
                if (i > 0 && !ContentLayout.isParamNeedLayout(params[i - 1], tempCharCount += param.getLen() + 2, charCount) && !this.isParamNeedWrap(parent.getFuncName(), params.length, i - 1)) {
                    isIgnoreParam = true;
                } else {
                    tempCharCount = charCount;
                }
            }
            for (int j = c = param.getUnitCount() - 1; j >= 0; --j) {
                boolean unitLayouted;
                IUnit unit = param.getUnit(j);
                if (j < c) {
                    if (unit instanceof IFuncUnit) {
                        this.modify2(((IFuncUnit)unit).getRpPos() + 1, isCut);
                    } else if (this._isFullCollect) {
                        this.modify2(((NonFuncUnit)unit).getEndPos(), isCut);
                    }
                }
                if ((unitLayouted = this.layoutWithTab(unit, tabCount + 1, isCut, isIgnoreParam)) && !isIgnoreParam && j > 0 && unit instanceof IFuncUnit) {
                    this.modify(((IFuncUnit)unit).getNameStartPos(), tabCount + 1, isCut, false);
                }
                if (unitLayouted || j <= 0) continue;
                if (isCut) {
                    if (unit instanceof IFuncUnit || !this._isFullCollect) continue;
                    this.removeEmptyChars(((NonFuncUnit)unit).getPos(), false, true);
                    continue;
                }
                if (unit instanceof IFuncUnit) {
                    this.insertBlank(((IFuncUnit)unit).getNameStartPos());
                    continue;
                }
                if (!this._isFullCollect) continue;
                this.insertBlank(((NonFuncUnit)unit).getPos());
            }
            if (isIgnoreParam) {
                this.insertBlank(param.getPos());
                continue;
            }
            this.modify(param.getPos(), tabCount + 1, isCut, true);
            if (!isCut) continue;
            this.modify(param.getPos() - 1, 0, isCut, false);
        }
        if (parent.getNameLength() > 0) {
            this.modify(parent.getLpPos(), tabCount, isCut, false);
        }
        return true;
    }

    private static int getMaxWidth(int tabChars) {
        return 64 + tabChars / 2;
    }

    private static boolean isFuncNeedLayout(IFuncUnit unit, int charsAdd, int tabChars) {
        int commasCount = unit.getCommasPos().length;
        if (charsAdd + unit.getAllLength() + commasCount > ContentLayout.getMaxWidth(tabChars)) {
            return true;
        }
        int deep = ContentLayout.getDeep(unit);
        return deep > 2 || deep > 1 && commasCount > 1 || commasCount > 4;
    }

    private static boolean isParamNeedLayout(Param param, int charsAdd, int tabChars) {
        if (charsAdd + param.getLen() > ContentLayout.getMaxWidth(tabChars)) {
            return true;
        }
        for (int i = param.getUnitCount() - 1; i >= 0; --i) {
            IUnit unit = param.getUnit(i);
            if (!(unit instanceof IFuncUnit) || !ContentLayout.isFuncNeedLayout((IFuncUnit)unit, charsAdd, tabChars)) continue;
            return true;
        }
        return false;
    }

    private void modify(int pos, int tabCount, boolean cut, boolean isForward) throws BadLocationException {
        if (cut) {
            this.removeEmptyChars(pos, isForward, true);
        } else {
            this.insertWrapAndTab(pos, tabCount);
        }
    }

    private void modify2(int pos, boolean cut) throws BadLocationException {
        if (cut) {
            this.removeEmptyChars(pos, true, false);
        } else {
            this.insertBlank(pos);
        }
    }

    private void removeEmptyChars(int pos, boolean isCutEmptyForward, boolean isCutEmptyBackward) throws BadLocationException {
        int cutCount;
        if (isCutEmptyForward && (cutCount = FuncCollapsableEditor.getEmptyCharCountForward(this._doc, pos)) > 0) {
            this._doc.remove(pos, cutCount);
        }
        if (isCutEmptyBackward && (cutCount = FuncCollapsableEditor.getEmptyCharCountBackward(this._doc, pos)) > 0) {
            this._doc.remove(pos - cutCount, cutCount);
        }
    }

    private void insertWrapAndTab(int pos, int tabCount) throws BadLocationException {
        StringBuffer sb = new StringBuffer("\n");
        if (tabCount > 0) {
            sb.append(ContentLayout.getTab(tabCount));
        }
        this._doc.insertString(pos, sb.toString(), null);
    }

    private static String getTab(int tabCount) {
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < tabCount; ++t) {
            sb.append(TabInstead);
        }
        return sb.toString();
    }

    private void insertBlank(int pos) throws BadLocationException {
        this._doc.insertString(pos, " ", null);
    }

    private Stack tempExpand() {
        Stack<IFuncUnit> result = new Stack<IFuncUnit>();
        LinkedList<IFuncUnit> queue = new LinkedList<IFuncUnit>();
        queue.add(this._rootFuncUnit);
        while (!queue.isEmpty()) {
            IFuncUnit unit = (IFuncUnit)queue.removeFirst();
            if (unit.isCollapsed()) {
                result.push(unit);
                this._doc.expandFuncUnit(unit);
            }
            if (unit.getChildrenCount() <= 0) continue;
            int c = unit.getChildrenCount();
            for (int i = 0; i < c; ++i) {
                queue.addLast(unit.getChild(i));
            }
        }
        return result;
    }

    private void tempCollapsed(Stack toCollapseds) {
        while (!toCollapseds.isEmpty()) {
            IFuncUnit unit = (IFuncUnit)toCollapseds.pop();
            this._doc.collapseFuncUnit(unit);
        }
    }

    private static int getDeep(IFuncUnit unit) {
        if (unit.getChildrenCount() == 0) {
            return 1;
        }
        int max = 0;
        int c = unit.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            max = Math.max(max, ContentLayout.getDeep(unit.getChild(i)) + 1);
        }
        return max;
    }

    public static interface IParamWrapAsker {
        public static final Boolean AUTO = new Boolean(false);

        public Boolean isNeedWrap(String var1, int var2, int var3);
    }
}

