/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.MobileWizardStyleDesigner;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.StyleDisplayPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleDescriptionModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleFileModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.TableStyleDesign;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.chart.panel.ChartPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.MutableTreeNode;
import org.jfree.ui.ExtensionFileFilter;

public class StyleEditPanel
extends KDPanel {
    private static final long serialVersionUID = 2418458098709571032L;
    private KDTextArea editArea;
    private KDTree tree;
    private transient TableStyleFileModel styleFileModel;
    private DefaultKingdeeTreeNode root;
    private KDButton saveButton;
    private KDButton newButton;
    private KDButton deleteButton;
    private KDButton screenshotButton;
    private boolean textChanged = false;
    private KDFrame parentFrame;
    private DefaultKingdeeTreeNode selectedNode;
    private StyleDisplayPanel displayPanel;
    private transient MobileWizardStyleDesigner designer;
    private transient TableStyleModel currentStyle;
    private List<String> deletedStyleNames = new ArrayList<String>();

    public StyleEditPanel(TableStyleFileModel styleFileModel, KDFrame frame, StyleDisplayPanel displayPanel, MobileWizardStyleDesigner designer) {
        this.styleFileModel = styleFileModel;
        this.init();
        this.parentFrame = frame;
        this.displayPanel = displayPanel;
        this.designer = designer;
    }

    private void init() {
        this.editArea = new KDTextArea("\u6d4b\u8bd5");
        this.editArea.setLineWrap(true);
        this.editArea.setWrapStyleWord(true);
        this.editArea.setSize(400, 800);
        this.root = new DefaultKingdeeTreeNode((Object)"Table Style");
        this.initTree();
        this.tree = new KDTree((ITreeNode)this.root, false);
        this.tree.setSelectionNode(this.root);
        this.tree.setPreferredSize(new Dimension(200, 800));
        this.saveButton = new KDButton("\u4fdd\u5b58");
        this.newButton = new KDButton("\u65b0\u5efa");
        this.deleteButton = new KDButton("\u5220\u9664");
        this.deleteButton.setEnabled(false);
        this.screenshotButton = new KDButton("\u622a\u53d6");
        this.setLayout(new BorderLayout());
        KDPanel editmenuPanel = new KDPanel();
        editmenuPanel.setLayout((LayoutManager)new GridLayout(1, 4));
        editmenuPanel.add((Component)this.newButton);
        editmenuPanel.add((Component)this.saveButton);
        editmenuPanel.add((Component)this.deleteButton);
        editmenuPanel.add((Component)this.screenshotButton);
        editmenuPanel.setSize(200, 20);
        this.add((Component)new KDScrollPane((Component)this.tree), "West");
        this.add((Component)new KDScrollPane((Component)this.editArea), "Center");
        this.add((Component)editmenuPanel, "North");
        this.initEditPanelActions();
    }

    private void initEditPanelActions() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (null != e.getNewLeadSelectionPath()) {
                    StyleEditPanel.this.selectedNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                }
                if (null != e.getOldLeadSelectionPath()) {
                    DefaultKingdeeTreeNode oldNode = (DefaultKingdeeTreeNode)e.getOldLeadSelectionPath().getLastPathComponent();
                    if (StyleEditPanel.this.textChanged) {
                        StyleEditPanel.this.resetTreeNodeData(oldNode);
                    }
                    StyleEditPanel.this.textChanged = false;
                }
                String editString = null;
                if (null != e.getNewLeadSelectionPath().getParentPath()) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                    DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
                    if (parent.equals(StyleEditPanel.this.root) || node.getUserObject() instanceof TableStyleModel) {
                        StyleEditPanel.this.editArea.setEditable(true);
                        editString = JSON.toJSONString((Object)node.getUserObject(), (boolean)true);
                        if (node.getUserObject() instanceof TableStyleModel) {
                            TableStyleModel selectedModel = (TableStyleModel)node.getUserObject();
                            StyleEditPanel.this.displayPanel.setAllViewStyle(selectedModel);
                            TableStyleDescriptionModel descriptionModel = StyleEditPanel.this.styleFileModel.getTableStyleMap().get(selectedModel.getStyleName());
                            StyleEditPanel.this.currentStyle = selectedModel;
                            descriptionModel.setLoadedStyle(selectedModel);
                        } else {
                            StyleEditPanel.this.deleteButton.setEnabled(true);
                            TableStyleDescriptionModel descriptionModel = (TableStyleDescriptionModel)node.getUserObject();
                            StyleEditPanel.this.currentStyle = descriptionModel.getLoadedStyle();
                            StyleEditPanel.this.displayPanel.setAllViewStyle(descriptionModel.getLoadedStyle());
                        }
                    } else {
                        StyleEditPanel.this.deleteButton.setEnabled(false);
                        editString = e.getPath().getLastPathComponent().toString();
                        StyleEditPanel.this.editArea.setEditable(false);
                    }
                    StyleEditPanel.this.editArea.setText(editString);
                } else {
                    StyleEditPanel.this.editArea.setText("\u8bf7\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u8fdb\u884c\u7f16\u8f91\u3002");
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleEditPanel.this.textChanged && null != StyleEditPanel.this.currentStyle && 0 == MessageDialog.show((Component)StyleEditPanel.this.parentFrame, (Object)"\u662f\u5426\u4fdd\u5b58", (String)"\u4fdd\u5b58\u4fee\u6539", (int)0, (int)3, null)) {
                    StyleEditPanel.this.resetTreeNodeData(StyleEditPanel.this.selectedNode);
                    StyleEditPanel.this.designer.saveStyles(StyleEditPanel.this.styleFileModel);
                    StyleEditPanel.this.saveStyleImages();
                    StyleEditPanel.this.actionDeletes();
                }
            }
        });
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewStyleDialog dialog = new NewStyleDialog((Frame)StyleEditPanel.this.parentFrame, "\u65b0\u5efa\u6837\u5f0f");
                dialog.show();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null != StyleEditPanel.this.selectedNode && StyleEditPanel.this.selectedNode.getUserObject() instanceof TableStyleDescriptionModel && 0 == MessageDialog.show((Component)StyleEditPanel.this.parentFrame, (Object)"\u662f\u5426\u5220\u9664", (String)"\u5220\u9664\u6837\u5f0f", (int)0, (int)3, null)) {
                    StyleEditPanel.this.styleFileModel.getTableStyleMap().remove(StyleEditPanel.this.selectedNode.getText());
                    StyleEditPanel.this.deletedStyleNames.add(StyleEditPanel.this.selectedNode.getText());
                    StyleEditPanel.this.root.remove((MutableTreeNode)StyleEditPanel.this.selectedNode);
                    StyleEditPanel.this.selectedNode = (DefaultKingdeeTreeNode)StyleEditPanel.this.root.getFirstChild();
                    StyleEditPanel.this.tree.setSelectionNode(StyleEditPanel.this.selectedNode);
                    StyleEditPanel.this.tree.updateUI();
                }
            }
        });
        this.screenshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditPanel.this.displayPanel.prepare2ScreenShot();
                ScreenShotDisplayDialog dialog = new ScreenShotDisplayDialog((Frame)StyleEditPanel.this.parentFrame, "\u622a\u56fe\u9884\u89c8");
                for (int i = 1; i <= 4; ++i) {
                    Point[] points = StyleEditPanel.this.displayPanel.getViewPoints(i);
                    Image image = StyleEditPanel.this.designer.createScreenShoot(points[0], points[1]);
                    dialog.setImage(image);
                }
                dialog.show();
            }
        });
        this.editArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                StyleEditPanel.this.textChanged = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                StyleEditPanel.this.textChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StyleEditPanel.this.textChanged = true;
            }
        });
    }

    private void resetTreeNodeData(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof TableStyleModel) {
            TableStyleModel model = (TableStyleModel)JSON.parseObject((String)this.editArea.getText(), TableStyleModel.class);
            node.setUserObject((Object)model);
            this.displayPanel.setAllViewStyle(model);
            TableStyleDescriptionModel ds = this.styleFileModel.getTableStyleMap().get(model.getStyleName());
            ds.setLoadedStyle(model);
        } else if (null != node.getParent() && node.getParent().equals(this.root)) {
            TableStyleDescriptionModel ds = (TableStyleDescriptionModel)JSON.parseObject((String)this.editArea.getText(), TableStyleDescriptionModel.class);
            String key = node.getText();
            TableStyleDescriptionModel old = this.styleFileModel.getTableStyleMap().get(key);
            ds.setLoadedStyle(old.getLoadedStyle());
            this.styleFileModel.getTableStyleMap().put(key, ds);
            node.setUserObject((Object)ds);
        }
    }

    private void initTree() {
        for (Map.Entry<String, TableStyleDescriptionModel> entry : this.styleFileModel.getTableStyleMap().entrySet()) {
            TableStyleDescriptionModel model = entry.getValue();
            String styleName = entry.getKey();
            this.root.add((MutableTreeNode)this.createTreeNode(styleName, model));
        }
    }

    private DefaultKingdeeTreeNode createTreeNode(String styleName, TableStyleDescriptionModel model) {
        DefaultKingdeeTreeNode name = new DefaultKingdeeTreeNode((Object)model);
        name.setText(styleName);
        DefaultKingdeeTreeNode desgin = new DefaultKingdeeTreeNode((Object)"\u8bbe\u8ba1\u65b9\u5f0f");
        name.add((MutableTreeNode)desgin);
        desgin.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)model.getDesign()));
        DefaultKingdeeTreeNode displayName = new DefaultKingdeeTreeNode((Object)"\u663e\u793a\u540d\u79f0");
        name.add((MutableTreeNode)displayName);
        displayName.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)model.getDisPlayName()));
        DefaultKingdeeTreeNode displayPic = new DefaultKingdeeTreeNode((Object)"\u5c55\u793a\u56fe\u7247");
        name.add((MutableTreeNode)displayPic);
        displayPic.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)model.getPicPath()));
        DefaultKingdeeTreeNode reportType = new DefaultKingdeeTreeNode((Object)"\u62a5\u8868\u7c7b\u578b");
        name.add((MutableTreeNode)reportType);
        reportType.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)model.getReportType()));
        DefaultKingdeeTreeNode stylePath = new DefaultKingdeeTreeNode((Object)"\u6837\u5f0f\u8def\u5f84");
        name.add((MutableTreeNode)stylePath);
        if (null == model.getLoadedStyle()) {
            String str = ResourceManager.getSourceAsString(model.getStyleFilePath(), "UTF-8");
            TableStyleModel styleModel = (TableStyleModel)JSON.parseObject((String)str, TableStyleModel.class);
            styleModel.setStyleName(styleName);
            model.setLoadedStyle(styleModel);
        }
        DefaultKingdeeTreeNode styleModelNode = new DefaultKingdeeTreeNode((Object)model.getLoadedStyle());
        styleModelNode.setText(model.getStyleFilePath());
        stylePath.add((MutableTreeNode)styleModelNode);
        return name;
    }

    private void saveStyleImages() {
        this.displayPanel.prepare2ScreenShot();
        ArrayList<Image> imagesList = new ArrayList<Image>();
        for (int i = 1; i <= 4; ++i) {
            Point[] points = this.displayPanel.getViewPoints(i);
            imagesList.add(this.designer.createScreenShoot(points[0], points[1]));
        }
        String path = this.getImageName(this.currentStyle.getStyleName(), "");
        Image image = (Image)imagesList.get(0);
        Point[] points = this.displayPanel.getViewPoints(1);
        double width = (points[1].getX() - points[0].getX()) * 0.55;
        double height = (points[1].getY() - points[0].getY()) * 0.55;
        this.saveImage(this.getTumbImage(image, (int)width, (int)height), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "example_list_");
        this.saveImage((BufferedImage)imagesList.get(0), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "mobile_list_");
        this.saveImage((BufferedImage)imagesList.get(0), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "example_group_");
        this.saveImage((BufferedImage)imagesList.get(1), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "mobile_group_");
        this.saveImage((BufferedImage)imagesList.get(1), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "example_segmentlist_");
        this.saveImage((BufferedImage)imagesList.get(2), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "mobile_segmentlist_");
        this.saveImage((BufferedImage)imagesList.get(2), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "example_segmentgroup_");
        this.saveImage((BufferedImage)imagesList.get(3), path);
        path = this.getImageName(this.currentStyle.getStyleName(), "mobile_segmentgroup_");
        this.saveImage((BufferedImage)imagesList.get(3), path);
    }

    private BufferedImage getTumbImage(Image image, int width, int height) {
        Image im = image.getScaledInstance(width, height, 4);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(im, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    private String getImageName(String styleName, String styleTypePrefix) {
        return this.getStyleDir(styleName) + File.separator + styleTypePrefix + styleName + ".png";
    }

    private String getStyleDir(String styleName) {
        return MobileWizardStyleDesigner.STYLE_STORE_DIR + File.separator + styleName;
    }

    public boolean saveImage(BufferedImage image, String path) {
        boolean flag = false;
        File file = new File(path);
        try {
            if (file.exists() || file.createNewFile()) {
                ImageIO.write((RenderedImage)image, ".png".substring(1), new File(path));
            }
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public String getEditString() {
        return this.editArea.getText();
    }

    private void actionDeletes() {
        for (String name : this.deletedStyleNames) {
            File file = new File(MobileWizardStyleDesigner.STYLE_STORE_DIR + File.separator + name);
            if (!file.exists()) continue;
            FileUtil.deleteFile((File)file);
        }
    }

    private class NewStyleDialog
    extends KDDialog {
        private static final long serialVersionUID = -2606669278267962739L;
        private KDTextField nameField;
        private KDTextField displayNameField;
        private KDButton fileChooseButton;
        private KDButton confirmButton;
        private KDButton cancelButton;
        private KDDialog dialog;
        private KDLabel fileNameLabel;
        private KDComboBox designBox;
        private KDComboBox reportTypeBox;

        public NewStyleDialog(Frame frame, String title) {
            super(frame, title);
            this.initDialog();
        }

        private void initDialog() {
            KDLabel nameLabel = new KDLabel("*\u540d\u79f0:");
            this.nameField = new KDTextField();
            KDLabel displayNameLabel = new KDLabel("*\u663e\u793a\u540d\u79f0\uff1a");
            this.displayNameField = new KDTextField();
            KDLabel picLabel = new KDLabel("\u5c55\u793a\u56fe\u7247:");
            this.fileChooseButton = new KDButton("\u9009\u62e9\uff1a");
            this.fileNameLabel = new KDLabel();
            this.confirmButton = new KDButton("\u786e\u5b9a");
            this.cancelButton = new KDButton("\u53d6\u6d88");
            KDLabel designName = new KDLabel("\u8bbe\u8ba1\u65b9\u5f0f\uff1a");
            this.designBox = new KDComboBox((Object[])TableStyleDesign.values());
            this.designBox.setSelectedItem((Object)TableStyleDesign.ECLIPSE);
            KDLabel reportTypeName = new KDLabel("\u62a5\u8868\u7c7b\u578b\uff1a");
            this.reportTypeBox = new KDComboBox((Object[])ReportType.values());
            KDPanel dialogPanel = new KDPanel((LayoutManager)new GridLayout(6, 2));
            dialogPanel.add((Component)nameLabel);
            dialogPanel.add((Component)this.nameField);
            dialogPanel.add((Component)displayNameLabel);
            dialogPanel.add((Component)this.displayNameField);
            dialogPanel.add((Component)designName);
            dialogPanel.add((Component)this.designBox);
            dialogPanel.add((Component)reportTypeName);
            dialogPanel.add((Component)this.reportTypeBox);
            dialogPanel.add((Component)picLabel);
            KDPanel fileChooserPanel = new KDPanel();
            fileChooserPanel.setLayout((LayoutManager)new GridLayout(1, 2));
            fileChooserPanel.add((Component)this.fileChooseButton);
            fileChooserPanel.add((Component)this.fileNameLabel);
            dialogPanel.add((Component)fileChooserPanel);
            dialogPanel.add((Component)this.confirmButton);
            dialogPanel.add((Component)this.cancelButton);
            this.add((Component)dialogPanel, "Center");
            this.setSize(400, 200);
            this.setLocation(400, 200);
            this.setLocationRelativeTo((Component)StyleEditPanel.this.parentFrame);
            this.dialog = this;
            this.initActions();
        }

        private void initActions() {
            this.confirmButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String styleName = NewStyleDialog.this.nameField.getText();
                    String displayName = NewStyleDialog.this.displayNameField.getText();
                    if (StyleEditPanel.this.styleFileModel.getTableStyleMap().containsKey(styleName) || StringUtil.isEmptyString((String)styleName) || StringUtil.isEmptyString((String)displayName)) {
                        MessageDialog.show((Component)NewStyleDialog.this.dialog, (Object)"\u6837\u5f0f\u540d\u6216\u663e\u793a\u540d\u79f0\u4e3a\u7a7a\u8bf7\u68c0\u67e5", (String)"\u8b66\u544a", (int)0, (int)2, null);
                        return;
                    }
                    File file = (File)NewStyleDialog.this.fileNameLabel.getUserObject();
                    if (null == file) {
                        file = new File(MobileWizardStyleDesigner.STYLE_STORE_DIR + File.separator + "lightGray/lightGray.png");
                    }
                    File storeDirectory = new File(MobileWizardStyleDesigner.STYLE_STORE_DIR + File.separator + styleName);
                    String picShortPath = styleName + "/" + styleName + ".png";
                    File desFile = new File(MobileWizardStyleDesigner.STYLE_STORE_DIR + File.separator + picShortPath);
                    try {
                        storeDirectory.mkdirs();
                        if (desFile.exists() || desFile.createNewFile()) {
                            FileUtil.copyFile((File)file, (File)desFile);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    String styleFileShortPath = styleName + "/" + styleName + ".json";
                    File styleFile = new File(MobileWizardStyleDesigner.STYLE_STORE_DIR + File.separator + styleFileShortPath);
                    String styleContent = null;
                    try {
                        if (styleFile.exists() || styleFile.createNewFile()) {
                            styleContent = ResourceManager.getSourceAsString("lightGray/lightGray.json", "UTF-8");
                            FileUtil.writeFileString((String)styleFile.getAbsolutePath(), (String)styleContent);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    TableStyleDescriptionModel ds = new TableStyleDescriptionModel();
                    ds.setDesign("ECLIPSE");
                    ds.setDisPlayName(displayName);
                    ds.setPicPath(picShortPath);
                    ds.setStyleFilePath(styleFileShortPath);
                    ds.setLoadedStyle((TableStyleModel)JSON.parseObject((String)styleContent, TableStyleModel.class));
                    ds.getLoadedStyle().setStyleName(styleName);
                    ds.setReportType(NewStyleDialog.this.reportTypeBox.getSelectedItem().toString());
                    ds.setDesign(NewStyleDialog.this.designBox.getSelectedItem().toString());
                    StyleEditPanel.this.styleFileModel.getTableStyleMap().put(styleName, ds);
                    StyleEditPanel.this.root.add((MutableTreeNode)StyleEditPanel.this.createTreeNode(styleName, ds));
                    StyleEditPanel.this.tree.updateUI();
                    NewStyleDialog.this.dialog.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewStyleDialog.this.dialog.dispose();
                }
            });
            this.fileChooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser fileChooser = new JFileChooser();
                    ExtensionFileFilter filter = new ExtensionFileFilter(LanguageManager.getLangMessage((String)"PNG_Image_Files", ChartPanel.class, (String)"PNG Image Files"), ".png");
                    fileChooser.removeChoosableFileFilter(fileChooser.getFileFilter());
                    fileChooser.addChoosableFileFilter((FileFilter)filter);
                    filter = new ExtensionFileFilter(LanguageManager.getLangMessage((String)"JPG_Image_Files", ChartPanel.class, (String)"JPG Image Files"), ".jpg");
                    fileChooser.addChoosableFileFilter((FileFilter)filter);
                    int option = fileChooser.showOpenDialog((Component)NewStyleDialog.this.dialog);
                    if (option == 0 && null != (file = fileChooser.getSelectedFile())) {
                        NewStyleDialog.this.fileNameLabel.setText(file.getName());
                        NewStyleDialog.this.fileNameLabel.setUserObject((Object)file);
                    }
                }
            });
        }
    }

    private class ScreenShotDisplayDialog
    extends KDDialog {
        private static final long serialVersionUID = 8619745965796422657L;

        public ScreenShotDisplayDialog(Frame parent, String title) {
            super(parent, title);
            this.setLayout(new GridLayout(2, 2));
            this.setSize(600, 600);
            this.setLocationRelativeTo(parent);
        }

        public void setImage(Image image) {
            KDLabel label = new KDLabel((Icon)new ImageIcon(image));
            this.add((Component)label);
        }
    }
}

