/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step;

import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.AbstractMobileReportWizardStep;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.ChartComposer;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.ReportFormatAndColorSchemeChooser;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.TableComposer;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.ui.DataSetImporterPanel;
import javax.swing.JComponent;

public class DataSetImporter
extends AbstractMobileReportWizardStep
implements DatasetImporter.TableChangeListener {
    private DatasetImporter importerPanel;
    private DataSetImporterPanel contentPanel;
    private WizardDialog.StepsManager manager;

    public DataSetImporter(KDExt ext, MobileReportWizardModel model) {
        super(ext, model);
    }

    public JComponent getContent() {
        this.contentPanel = new DataSetImporterPanel(this.importerPanel);
        return this.contentPanel;
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        super.initStep(manager);
        this.manager = manager;
        ReportFormatAndColorSchemeChooser rt = (ReportFormatAndColorSchemeChooser)manager.getWizardDialog().getStepsList().get(0);
        this.importerPanel = rt.getImporterPanel();
        this.importerPanel.setTableChangeListener(this);
        this.importerPanel.prepare();
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        if (!isOppose) {
            this.importerPanel.refreshTree();
        }
    }

    public IWizardStep outThisStep(boolean isOppose) {
        if (!isOppose) {
            if (!this.importerPanel.checkValid()) {
                return this;
            }
            if (ReportType.TABLE == this.model.getReportType()) {
                return new TableComposer(this.ext, this.model);
            }
            for (int i = 0; i < this.model.getChartModel().getFusionGraphicsModelList().size(); ++i) {
                this.manager.getWizardDialog().getStepsList().add(new ChartComposer(this.ext, this.model, i));
            }
        }
        return null;
    }

    @Override
    public void destroy(boolean isFinished) {
        if (!isFinished) {
            this.importerPanel.cancelEdit();
        }
    }

    @Override
    public void tableChanged(boolean tableEmpty) {
        if (this.manager.getWizardDialog().getCurrentStep() == this) {
            if (tableEmpty) {
                this.manager.setNextStepEnabled(false);
            } else {
                this.manager.setNextStepEnabled(true);
            }
        }
    }
}

