/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.ui;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.ChartTypeButton;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.ChartTypeSortLabel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.SelectionButtonDoubleClickListener;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.SortLabelUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.ui.AbstractMobileReportWizardPanel;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDEditorPane;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class ChartTypeChooserPanel
extends AbstractMobileReportWizardPanel
implements SelectionButtonDoubleClickListener {
    private KDPanel contentPanel;
    private JTextComponent detail = new KDEditorPane("text/html", "");
    private KDPanel detailPanel = new KDPanel();
    private KDTable table;
    private KDList flashList;
    private KDScrollPane flashScroll;
    private KDWorkButton btnAdd;
    private KDWorkButton btnRemove;
    private KDWorkButton btnUp;
    private KDWorkButton btnDown;
    private HashMap<String, FlashChartType> mapFCT = new HashMap();
    private KDExt ext;
    private KDContainer container;
    private KDScrollPane sp;
    private boolean isChartTable;
    private TableChangeListener listener;
    private ActionListener addAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ChartTypeChooserPanel.this.doAddChart();
        }
    };
    private ActionListener removeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ChartTypeChooserPanel.this.table.getRowCount() == 0) {
                return;
            }
            int[] rows = KDTableUtil.getSelectedRows((KDTable)ChartTypeChooserPanel.this.table);
            for (int i = rows.length - 1; i >= 0; --i) {
                ChartTypeChooserPanel.this.table.removeRow(rows[i]);
                if (ChartTypeChooserPanel.this.listener == null || ChartTypeChooserPanel.this.table.getRowCount() != 0) continue;
                ChartTypeChooserPanel.this.listener.tableChanged(true);
            }
        }
    };
    private ActionListener rowUpAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTSelectBlock sel = ChartTypeChooserPanel.this.table.getSelectManager().get();
            if (sel == null) {
                return;
            }
            int idx = sel.getBeginRow();
            if (idx == 0) {
                return;
            }
            IRow selRow = ChartTypeChooserPanel.this.table.getRow(idx);
            ChartTypeChooserPanel.this.table.removeRow(idx);
            ChartTypeChooserPanel.this.table.addRow(idx - 1, selRow);
            ChartTypeChooserPanel.this.table.getSelectManager().select(idx - 1, 0);
        }
    };
    private ActionListener rowDownAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTSelectBlock sel = ChartTypeChooserPanel.this.table.getSelectManager().get();
            if (sel == null) {
                return;
            }
            int idx = sel.getBeginRow();
            if (idx == ChartTypeChooserPanel.this.table.getRowCount() - 1) {
                return;
            }
            IRow selRow = ChartTypeChooserPanel.this.table.getRow(idx);
            ChartTypeChooserPanel.this.table.removeRow(idx);
            ChartTypeChooserPanel.this.table.addRow(idx + 1, selRow);
            ChartTypeChooserPanel.this.table.getSelectManager().select(idx + 1, 0);
        }
    };

    public ChartTypeChooserPanel(KDExt ext, boolean isChartTable) {
        this.ext = ext;
        this.isChartTable = isChartTable;
        this.contentPanel.setLayout(null);
        this.initComps();
        this.initListeners();
    }

    @Override
    protected String getLabPicIconName() {
        return "step2";
    }

    @Override
    protected JComponent getContentPanel() {
        this.contentPanel = new KDPanel();
        return this.contentPanel;
    }

    private void initComps() {
        ChartTypeSortLabel[] chartTypeDescriptions = SortLabelUtil.getAllUseableLabels();
        ArrayList<ChartTypeSortLabel> list = new ArrayList<ChartTypeSortLabel>();
        for (ChartTypeSortLabel chartTypeSortLabel : chartTypeDescriptions) {
            String chartName = chartTypeSortLabel.toString();
            if ("\u65f6\u5e8f\u56fe".equals(chartName) || "\u91cf\u8868".equals(chartName)) continue;
            list.add(chartTypeSortLabel);
        }
        this.flashList = new KDList(list.toArray());
        this.flashScroll = new KDScrollPane((Component)this.flashList);
        this.flashScroll.setBounds(0, 41, 150, 412);
        this.setPreferredSize(new Dimension(400, 360));
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        flow.setVgap(flow.getVgap() + 3);
        this.detailPanel.setLayout((LayoutManager)flow);
        this.container = new KDContainer();
        this.container.setTitle("\u5df2\u9009\u5217\u8868");
        this.container.setContainerType(1);
        this.container.setBounds(158, 343, 616, 108);
        this.btnAdd = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_addline.gif"));
        this.btnAdd.setText("\u6dfb\u52a0");
        this.btnAdd.setCustomInsets(new Insets(0, 0, 0, 0));
        this.btnAdd.addActionListener(this.addAction);
        this.btnRemove = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_deleteline.gif"));
        this.btnRemove.setCustomInsets(new Insets(0, 0, 0, 0));
        this.btnRemove.setText("\u79fb\u9664");
        this.btnRemove.addActionListener(this.removeAction);
        this.btnUp = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_moveup.gif"));
        this.btnUp.setText("\u4e0a\u79fb");
        this.btnUp.setCustomInsets(new Insets(0, 0, 0, 0));
        this.btnUp.addActionListener(this.rowUpAction);
        this.btnDown = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_movedown.gif"));
        this.btnDown.setText("\u4e0b\u79fb");
        this.btnDown.setCustomInsets(new Insets(0, 0, 0, 0));
        this.btnDown.addActionListener(this.rowDownAction);
        this.btnAdd.setBounds(392, 3, 50, 18);
        this.btnRemove.setBounds(446, 3, 50, 18);
        this.btnUp.setBounds(500, 3, 50, 18);
        this.btnDown.setBounds(554, 3, 50, 18);
        this.table = new KDTable();
        this.table.setDefaultRowHeight(30);
        this.table.getSelectManager().setSelectMode(10);
        this.table.addHeadRow();
        this.table.addColumn(0);
        this.table.getColumn(0).setWidth(200);
        this.table.getColumn(0).getStyleAttributes().setLocked(true);
        this.table.getHeadRow(0).getCell(0).setValue((Object)"\u540d\u79f0");
        this.table.setBounds(0, 21, 616, 87);
        this.container.add((Component)this.btnUp);
        this.container.add((Component)this.btnDown);
        this.container.add((Component)this.btnAdd);
        this.container.add((Component)this.btnRemove);
        this.container.add((Component)this.table);
        if (!this.isChartTable) {
            this.contentPanel.add((Component)this.container);
        }
        this.contentPanel.add((Component)this.flashScroll);
        this.sp = new KDScrollPane((Component)this.detailPanel);
        this.sp.setBorder(BorderFactory.createRaisedBevelBorder());
        this.sp.getVerticalScrollBar().setUnitIncrement(133);
        if (!this.isChartTable) {
            this.sp.setBounds(158, 43, 615, 290);
        } else {
            KDPanel wizardPanel = new KDPanel();
            wizardPanel.setLayout(null);
            wizardPanel.removeAll();
            Font f = new Font("\u65b0\u5b8b\u4f53", 1, 12);
            FontMetrics metrics = new FontMetrics(f){};
            KDLabel label = new KDLabel();
            String text = " \u2460 \u9009\u62e9\u56fe\u8868\u7c7b\u578b";
            label.setText(text);
            label.setFont(f);
            label.setForeground(new Color(53, 169, 228));
            Rectangle2D bounds = metrics.getStringBounds(text, null);
            int width = (int)bounds.getWidth() + 10;
            label.setBounds(0, 0, width, 20);
            KDLabel label1 = new KDLabel();
            String text1 = " \u2461 \u9009\u62e9\u8868\u683c\u7c7b\u578b";
            label1.setText(text1);
            label1.setFont(f);
            label1.setForeground(new Color(186, 185, 186));
            label1.setIcon((Icon)ResourceManager.getImageIcon("arrow_gray.png"));
            Rectangle2D bounds1 = metrics.getStringBounds(text1, null);
            int width1 = (int)bounds1.getWidth() + 40;
            label1.setBounds(width, 0, width1, 20);
            wizardPanel.add((Component)label);
            wizardPanel.add((Component)label1);
            wizardPanel.setBounds(390 - (width + width1) / 2, 10, width + width1, 20);
            this.flashScroll.setBounds(0, 41, 150, 412);
            this.sp.setBounds(158, 43, 615, 407);
            this.contentPanel.add((Component)wizardPanel);
        }
        this.contentPanel.add((Component)this.sp);
    }

    private void listSelectionChanged() {
        this.detailPanel.removeAll();
        ChartTypeSortLabel selection = (ChartTypeSortLabel)this.flashList.getSelectedValue();
        this.detail.setText(selection.getDescription());
        KDPanel[] p = selection.getPanels(this.detail);
        this.detailPanel.setPreferredSize(new Dimension(500, (int)(Math.ceil((double)p.length / 3.0) * 162.0)));
        int length = p.length;
        for (int i = 0; i < length; ++i) {
            if (p[i] == null) continue;
            this.detailPanel.add((Component)p[i]);
        }
        this.detailPanel.repaint();
        this.detailPanel.revalidate();
        if (ChartTypeButton.currentSelection() != null) {
            ChartTypeButton.currentSelection().setSelected(false);
            ChartTypeButton.clearSelection();
        }
        if (this.isChartTable && this.listener != null) {
            this.listener.tableChanged(true);
        }
    }

    private void initListeners() {
        this.flashList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChartTypeChooserPanel.this.listSelectionChanged();
            }
        });
        this.flashList.setSelectedIndex(0);
        ChartTypeButton.setSelectionButtonDoubleClickListener(this);
    }

    private void doAddChart() {
        if (ChartTypeButton.currentSelection() != null) {
            if (this.table.getRowCount() == 5) {
                final KDLabel label = new KDLabel();
                label.setText("\u6700\u591a\u6dfb\u52a0\u4e94\u4e2a\u56fe\u8868\uff01");
                label.setForeground(Color.red);
                label.setBounds(280, 3, 120, 18);
                this.container.add((Component)label);
                this.container.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ChartTypeChooserPanel.this.container.remove((Component)label);
                        ChartTypeChooserPanel.this.container.repaint();
                    }
                });
                return;
            }
            KDLabel label = (KDLabel)ChartTypeButton.currentSelection().getParent().getComponent(1);
            String chartTypeName = label.getText();
            IRow row = this.table.addRow();
            row.setHeight(20);
            row.getCell(0).setValue((Object)chartTypeName);
            this.table.scrollToVisible(row.getRowIndex(), 1);
            this.mapFCT.put(chartTypeName, ChartTypeButton.currentSelection().getChartType());
            if (this.listener != null) {
                this.listener.tableChanged(false);
            }
        }
    }

    public List getChartTypeNameList() {
        ArrayList<Object> chartTypeNameList = new ArrayList<Object>();
        if (this.isChartTable) {
            KDLabel label = (KDLabel)ChartTypeButton.currentSelection().getParent().getComponent(1);
            String chartTypeName = label.getText();
            chartTypeNameList.add(chartTypeName);
        } else {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                chartTypeNameList.add(this.table.getRow(i).getCell(0).getValue());
            }
        }
        return chartTypeNameList;
    }

    public List getFusionGraphicsModelList() {
        List list = this.getChartTypeNameList();
        ArrayList<FusionGraphicsModel> fusionGraphicsModelList = new ArrayList<FusionGraphicsModel>();
        if (this.isChartTable) {
            FusionGraphicsModel fusionGraphicsModel = new FusionGraphicsModel();
            fusionGraphicsModel.setChartType(ChartTypeButton.currentSelection().getChartType());
            Sheet sheet = MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet();
            FusionChartDataNode dataNode = new FusionChartDataNode(sheet);
            fusionGraphicsModel.setDataNode(dataNode);
            fusionGraphicsModel.getBean().setChartType(ChartTypeButton.currentSelection().getChartType());
            fusionGraphicsModelList.add(fusionGraphicsModel);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                FusionGraphicsModel fusionGraphicsModel = new FusionGraphicsModel();
                fusionGraphicsModel.setChartType(this.mapFCT.get(list.get(i)));
                Sheet sheet = MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet();
                FusionChartDataNode dataNode = new FusionChartDataNode(sheet);
                fusionGraphicsModel.setDataNode(dataNode);
                fusionGraphicsModel.getBean().setChartType(this.mapFCT.get(list.get(i)));
                fusionGraphicsModelList.add(fusionGraphicsModel);
            }
        }
        return fusionGraphicsModelList;
    }

    public void setTableChangeListener(TableChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void doubleClick() {
        this.doAddChart();
    }

    public static interface TableChangeListener {
        public void tableChanged(boolean var1);
    }
}

