/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.report;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.ext.IExtWizardManager;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.DatasetImporterWizard;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.ComboColorRenderer;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.GroupReportComposer;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.IReportComposer;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.lfm.ExtThemeConfigurationFactory;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class CrossReportComposer
extends KDPanel
implements IReportComposer,
IWizardStep {
    public static final String KEY_ASC = "asc";
    public static final String KEY_DESC = "desc";
    public static final String KEY_SUM = "sum";
    public static final String KEY_AVG = "avg";
    public static final String KEY_MAX = "max";
    public static final String KEY_MIN = "min";
    public static final String KEY_CNT = "cnt";
    public static final String KEY_MSG1 = "msg1";
    public static final String KEY_MSG_TITLE = "msgTitle";
    public static final String KEY_COL_FIELD = "colField";
    public static final String KEY_COL_SORT = "colSort";
    public static final String KEY_COL_SUBTOTAL = "colSubtotal";
    public static final String KEY_COL_STAT_TYPE = "colStatType";
    public static final String KEY_LABEL_CREATE = "labelCreate";
    public static final String KEY_LABEL_AVAILABLE_FIELDS = "labelAvailableFields";
    public static final String KEY_LABEL_CROSS_STAT = "labelCrossStat";
    public static final String KEY_LABEL_ROW = "labelRow";
    public static final String KEY_LABEL_COL = "labelCol";
    public static final String KEY_DISPLAY_TOTAL = "displayTotal";
    public static final String KEY_STAT_FIELD_ORIENTATION = "statFieldOrientation";
    public static final String KEY_SUBTOTAL = "subtotal";
    public static final String KEY_TOTAL = "total";
    private KDExt _ext;
    private DatasetImporter prev;
    private IWizardStep next;
    private KDWorkButton sumMovedown;
    private KDWorkButton colMoveup;
    private KDWorkButton colMovedown;
    private KDWorkButton rowMoveup;
    private KDWorkButton rowMovedown;
    private KDWorkButton sumMoveup;
    private KDCheckBox colTotal;
    private KDCheckBox rowTotal;
    private KDCheckBox sumOrientation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private KDList leftList;
    public KDTable colTable;
    public KDTable rowTable;
    public KDTable sumTable;
    private KDScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private KDWorkButton sumRemove;
    private KDWorkButton colAdd;
    private KDWorkButton colRemove;
    private KDWorkButton rowAdd;
    private KDWorkButton rowRemove;
    private KDWorkButton sumAdd;
    private ExtDataSet currentDs;
    private String asc = CrossReportComposer.getLocalText("asc", "\u5347\u5e8f");
    private String desc = CrossReportComposer.getLocalText("desc", "\u964d\u5e8f");
    private String sum = CrossReportComposer.getLocalText("sum", "\u6c42\u548c");
    private String avg = CrossReportComposer.getLocalText("avg", "\u5e73\u5747\u503c");
    private String max = CrossReportComposer.getLocalText("max", "\u6700\u5927\u503c");
    private String min = CrossReportComposer.getLocalText("min", "\u6700\u5c0f\u503c");
    private String cnt = CrossReportComposer.getLocalText("cnt", "\u8ba1\u6570");
    private ComboColorRenderer renderer = new ComboColorRenderer();
    private KDComboColor[] rowChooser = new KDComboColor[100];
    private KDComboColor[] columnChooser = new KDComboColor[100];
    private KDComboColor[] sumChooser = new KDComboColor[100];
    private Color[] defColors = (Color[])ExtThemeConfigurationFactory.getConfigurator().getColors(ExtThemeConfigurationFactory.getColorSpace(), "\u62a5\u8868\u5411\u5bfc--\u4ea4\u53c9\u5206\u6790\u578b");

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, CrossReportComposer.class, (String)defaultStr);
    }

    public CrossReportComposer(KDExt ext) {
        this._ext = ext;
        this.initComponents();
        this.initListeners();
    }

    @Override
    public boolean prepare() {
        int i;
        this.leftList.removeAllElements();
        DatasetImporter importer = (DatasetImporter)this.getPrevStep();
        List list = importer.getAllExtDataSets();
        List selected = importer.getSelectedExtDataSets();
        if (list.size() == 0) {
            this.colTable.removeRows();
            this.rowTable.removeRows();
            this.sumTable.removeRows();
            return true;
        }
        if (selected.size() > 1) {
            this.showMessage(CrossReportComposer.getLocalText(KEY_MSG1, "\u62a5\u8868\u5411\u5bfc\u53ea\u652f\u6301\u5355\u6570\u636e\u96c6\uff0c\u5411\u5bfc\u5c06\u4f7f\u7528\u6240\u9009\u7684\u7b2c\u4e00\u4e2a\u6570\u636e\u96c6\u5b8c\u6210\u540e\u7eed\u6b65\u9aa4\u3002"));
        }
        this.currentDs = (ExtDataSet)selected.get(0);
        String[] sawtooth = importer.getEditingInfo(this.currentDs);
        Object[] cols = MiscUtil.sortColumnsByIndex(this.currentDs.getColumns());
        for (int j = 0; j < cols.length; ++j) {
            ExtColumn col = (ExtColumn)cols[j];
            String colEditingAlias = sawtooth[j + 1];
            this.leftList.addElement((Object)new BinaryElement(this.getTreeNodeText(colEditingAlias, col), colEditingAlias));
        }
        for (i = this.colTable.getRowCount() - 1; i >= 0; --i) {
            if (this.leftList.getIndexOfElement(this.colTable.getRow(i).getCell(0).getValue()) != -1) continue;
            this.colTable.removeRow(i);
        }
        for (i = this.rowTable.getRowCount() - 1; i >= 0; --i) {
            if (this.leftList.getIndexOfElement(this.rowTable.getRow(i).getCell(0).getValue()) != -1) continue;
            this.rowTable.removeRow(i);
        }
        for (i = this.sumTable.getRowCount() - 1; i >= 0; --i) {
            if (this.leftList.getIndexOfElement(this.sumTable.getRow(i).getCell(0).getValue()) != -1) continue;
            this.sumTable.removeRow(i);
        }
        if (this.leftList.getElementCount() > 0) {
            this.leftList.setSelectedIndex(0);
        }
        return true;
    }

    @Override
    public IWizardStep getNextStep() {
        return null;
    }

    @Override
    public IWizardStep getPrevStep() {
        if (this.prev == null) {
            this.prev = ((DatasetImporterWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_DatasetImporter)).getDatasetImporter();
        }
        return this.prev;
    }

    private void showMessage(String message) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        MessageUtil.msgboxInfo((Component)((Object)this), message);
    }

    private String getTreeNodeText(String colEditingAlias, ExtColumn col) {
        String dataTypeName;
        StringBuffer sb = new StringBuffer();
        sb.append(colEditingAlias);
        sb.append("\uff1a");
        switch (col.getDataType()) {
            case 5: {
                dataTypeName = "decimal";
                break;
            }
            case 10: {
                dataTypeName = "string";
                break;
            }
            case 6: {
                dataTypeName = "date";
                break;
            }
            case 7: {
                dataTypeName = "time";
                break;
            }
            case 8: {
                dataTypeName = "boolean";
                break;
            }
            case 2: {
                dataTypeName = "int";
                break;
            }
            case 3: {
                dataTypeName = "long";
                break;
            }
            case 9: {
                dataTypeName = "object";
                break;
            }
            case 4: {
                dataTypeName = "double";
                break;
            }
            case 0: {
                dataTypeName = "byte";
                break;
            }
            case 1: {
                dataTypeName = "short";
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupportted data type.");
            }
        }
        sb.append(dataTypeName);
        return sb.toString();
    }

    private void initListeners() {
        this.colAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.addTableRow(CrossReportComposer.this.colTable);
            }
        });
        this.colRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.removeActiveRow(CrossReportComposer.this.colTable);
            }
        });
        this.colMoveup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.activeRowMoveup(CrossReportComposer.this.colTable);
            }
        });
        this.colMovedown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.activeRowMovedown(CrossReportComposer.this.colTable);
            }
        });
        this.rowAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.addTableRow(CrossReportComposer.this.rowTable);
            }
        });
        this.rowRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.removeActiveRow(CrossReportComposer.this.rowTable);
            }
        });
        this.rowMoveup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.activeRowMoveup(CrossReportComposer.this.rowTable);
            }
        });
        this.rowMovedown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.activeRowMovedown(CrossReportComposer.this.rowTable);
            }
        });
        this.sumAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object ele = CrossReportComposer.this.leftList.getSelectedValue();
                if (ele == null) {
                    return;
                }
                for (int i = 0; i < CrossReportComposer.this.sumTable.getRowCount(); ++i) {
                    if (!ele.equals(CrossReportComposer.this.sumTable.getRow(i).getCell(0).getValue())) continue;
                    return;
                }
                IRow row = CrossReportComposer.this.sumTable.addRow();
                row.getCell(0).setValue(ele);
                row.getCell(1).setValue((Object)CrossReportComposer.this.sum);
                int count = row.getRowIndex();
                Color c = CrossReportComposer.this.defColors[(count + 4) % CrossReportComposer.this.defColors.length];
                ((CrossReportComposer)CrossReportComposer.this).sumChooser[count] = new KDComboColor(c);
                row.getCell(2).setValue((Object)c);
                row.getCell(2).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)CrossReportComposer.this.sumChooser[count]));
                row.getCell(2).setRenderer((IBasicRender)CrossReportComposer.this.renderer);
                CrossReportComposer.this.sumTable.getSelectManager().select(CrossReportComposer.this.sumTable.getRowCount() - 1, 0);
            }
        });
        this.sumRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.removeActiveRow(CrossReportComposer.this.sumTable);
            }
        });
        this.sumMoveup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.activeRowMoveup(CrossReportComposer.this.sumTable);
            }
        });
        this.sumMovedown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossReportComposer.this.activeRowMovedown(CrossReportComposer.this.sumTable);
            }
        });
    }

    private void activeRowMovedown(KDTable table) {
        int index = table.getSelectManager().getActiveRowIndex();
        if (index < 0 || index == table.getRowCount() - 1) {
            return;
        }
        int newIndex = index + 1;
        table.addRow(newIndex, table.removeRow(index));
        table.getSelectManager().select(newIndex, 0);
    }

    private void activeRowMoveup(KDTable table) {
        int index = table.getSelectManager().getActiveRowIndex();
        if (index <= 0) {
            return;
        }
        int newIndex = index - 1;
        table.addRow(newIndex, table.removeRow(index));
        table.getSelectManager().select(newIndex, 0);
    }

    private void removeActiveRow(KDTable table) {
        int index = table.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            return;
        }
        table.removeRow(index);
    }

    private void addTableRow(KDTable table) {
        int size;
        Object ele = this.leftList.getSelectedValue();
        if (ele == null) {
            return;
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (!ele.equals(table.getRow(i).getCell(0).getValue())) continue;
            return;
        }
        IRow row = table.addRow();
        row.getCell(0).setValue(ele);
        row.getCell(1).setValue((Object)this.asc);
        row.getCell(2).setValue((Object)Boolean.FALSE);
        if (table == this.rowTable) {
            size = row.getRowIndex() + 2;
            this.rowChooser[row.getRowIndex()] = new KDComboColor(this.defColors[size % this.defColors.length]);
            row.getCell(3).setValue((Object)this.defColors[size % this.defColors.length]);
            row.getCell(3).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.rowChooser[row.getRowIndex()]));
        }
        if (table == this.colTable) {
            size = row.getRowIndex();
            this.columnChooser[row.getRowIndex()] = new KDComboColor(this.defColors[size % this.defColors.length]);
            row.getCell(3).setValue((Object)this.defColors[size % this.defColors.length]);
            row.getCell(3).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.columnChooser[row.getRowIndex()]));
        }
        row.getCell(3).setRenderer((IBasicRender)this.renderer);
        table.getSelectManager().select(table.getRowCount() - 1, 0);
    }

    private void initComponents() {
        int i;
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new KDScrollPane();
        this.leftList = new KDList();
        this.leftList.getSelectionModel().setSelectionMode(0);
        this.sumMovedown = new KDWorkButton();
        this.colMoveup = new KDWorkButton();
        this.colMovedown = new KDWorkButton();
        this.rowMoveup = new KDWorkButton();
        this.rowMovedown = new KDWorkButton();
        this.sumMoveup = new KDWorkButton();
        this.sumRemove = new KDWorkButton();
        this.colAdd = new KDWorkButton();
        this.colRemove = new KDWorkButton();
        this.rowAdd = new KDWorkButton();
        this.rowRemove = new KDWorkButton();
        this.sumAdd = new KDWorkButton();
        this.colTable = new KDTable();
        this.rowTable = new KDTable();
        this.sumTable = new KDTable();
        this.colTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.rowTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.sumTable.getIndexColumn().getStyleAttributes().setHided(true);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])new String[]{this.asc, this.desc}));
        int colCount = 4;
        for (i = 0; i < colCount; ++i) {
            this.colTable.addColumn(i);
            this.rowTable.addColumn(i);
        }
        this.sumTable.addColumn(0);
        this.sumTable.addColumn(1);
        this.sumTable.addColumn(2);
        this.colTable.addHeadRow();
        this.colTable.getHeadRow(0).getCell(0).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_FIELD, "\u5b57\u6bb5"));
        this.colTable.getHeadRow(0).getCell(1).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_SORT, "\u6392\u5e8f"));
        this.colTable.getHeadRow(0).getCell(2).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_SUBTOTAL, "\u5c0f\u8ba1"));
        this.colTable.getHeadRow(0).getCell(3).setValue((Object)"\u80cc\u666f");
        this.colTable.getColumn(0).setWidth(90);
        this.colTable.getColumn(1).setWidth(55);
        this.colTable.getColumn(2).setWidth(40);
        this.colTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.colTable.getColumn(1).setEditor((ICellEditor)editor);
        this.colTable.getSelectManager().setSelectMode(2);
        this.rowTable.addHeadRow();
        this.rowTable.getHeadRow(0).getCell(0).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_FIELD, "\u5b57\u6bb5"));
        this.rowTable.getHeadRow(0).getCell(1).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_SORT, "\u6392\u5e8f"));
        this.rowTable.getHeadRow(0).getCell(2).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_SUBTOTAL, "\u5c0f\u8ba1"));
        this.rowTable.getHeadRow(0).getCell(3).setValue((Object)"\u80cc\u666f");
        this.rowTable.getColumn(0).setWidth(90);
        this.rowTable.getColumn(1).setWidth(55);
        this.rowTable.getColumn(2).setWidth(40);
        this.rowTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.rowTable.getColumn(1).setEditor((ICellEditor)editor);
        this.rowTable.getSelectManager().setSelectMode(2);
        this.sumTable.addHeadRow();
        this.sumTable.getHeadRow(0).getCell(0).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_FIELD, "\u5b57\u6bb5"));
        this.sumTable.getHeadRow(0).getCell(1).setValue((Object)CrossReportComposer.getLocalText(KEY_COL_STAT_TYPE, "\u7edf\u8ba1\u7c7b\u578b"));
        this.sumTable.getHeadRow(0).getCell(2).setValue((Object)"\u80cc\u666f");
        this.sumTable.getColumn(0).setWidth(130);
        this.sumTable.getColumn(1).setWidth(55);
        this.sumTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.sumTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])new String[]{this.sum, this.avg, this.max, this.min, this.cnt})));
        this.sumTable.getSelectManager().setSelectMode(2);
        this.colTotal = new KDCheckBox();
        this.rowTotal = new KDCheckBox();
        this.sumOrientation = new KDCheckBox();
        this.setLayout(null);
        this.jLabel1.setText(CrossReportComposer.getLocalText(KEY_LABEL_CREATE, "\u5efa\u7acb\u4ea4\u53c9\u5206\u6790\u62a5\u8868"));
        this.add(this.jLabel1);
        this.jLabel1.setBounds(10, 10, 96, 15);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 30, 780, 10);
        this.jLabel2.setText(CrossReportComposer.getLocalText(KEY_LABEL_AVAILABLE_FIELDS, "\u53ef\u9009\u5b57\u6bb5"));
        this.add(this.jLabel2);
        this.jLabel2.setBounds(10, 50, 48, 15);
        this.jScrollPane1.setViewportView((Component)this.leftList);
        this.add((Component)this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 70, 240, 450);
        this.jLabel3.setText(CrossReportComposer.getLocalText(KEY_LABEL_CROSS_STAT, "\u4ea4\u53c9\u6c47\u603b\uff1a"));
        this.add(this.jLabel3);
        this.jLabel3.setBounds(570, 295, 60, 15);
        this.jLabel4.setText(CrossReportComposer.getLocalText(KEY_LABEL_ROW, "\u884c\uff1a"));
        this.add(this.jLabel4);
        this.jLabel4.setBounds(310, 295, 60, 15);
        this.jLabel5.setText(CrossReportComposer.getLocalText(KEY_LABEL_COL, "\u5217\uff1a"));
        this.add(this.jLabel5);
        this.jLabel5.setBounds(570, 45, 24, 15);
        this.sumMovedown.setIcon((Icon)ResourceManager.getImageIcon("tbtn_movedown.gif"));
        this.add((Component)this.sumMovedown);
        this.sumMovedown.setBounds(730, 290, 30, 20);
        this.colMoveup.setIcon((Icon)ResourceManager.getImageIcon("tbtn_moveup.gif"));
        this.add((Component)this.colMoveup);
        this.colMoveup.setBounds(690, 40, 30, 20);
        this.colMovedown.setIcon((Icon)ResourceManager.getImageIcon("tbtn_movedown.gif"));
        this.add((Component)this.colMovedown);
        this.colMovedown.setBounds(730, 40, 30, 20);
        this.rowMoveup.setIcon((Icon)ResourceManager.getImageIcon("tbtn_moveup.gif"));
        this.add((Component)this.rowMoveup);
        this.rowMoveup.setBounds(430, 290, 30, 20);
        this.rowMovedown.setIcon((Icon)ResourceManager.getImageIcon("tbtn_movedown.gif"));
        this.add((Component)this.rowMovedown);
        this.rowMovedown.setBounds(470, 290, 30, 20);
        this.sumMoveup.setIcon((Icon)ResourceManager.getImageIcon("tbtn_moveup.gif"));
        this.add((Component)this.sumMoveup);
        this.sumMoveup.setBounds(690, 290, 30, 20);
        this.sumRemove.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_left.gif"));
        this.add((Component)this.sumRemove);
        this.sumRemove.setBounds(530, 420, 30, 20);
        this.colAdd.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_right.gif"));
        this.add((Component)this.colAdd);
        this.colAdd.setBounds(530, 130, 30, 20);
        this.colRemove.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_left.gif"));
        this.add((Component)this.colRemove);
        this.colRemove.setBounds(530, 170, 30, 20);
        this.rowAdd.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_right.gif"));
        this.add((Component)this.rowAdd);
        this.rowAdd.setBounds(270, 380, 30, 20);
        this.rowRemove.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_left.gif"));
        this.add((Component)this.rowRemove);
        this.rowRemove.setBounds(270, 420, 30, 20);
        this.sumAdd.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_right.gif"));
        this.add((Component)this.sumAdd);
        this.sumAdd.setBounds(530, 380, 30, 20);
        this.add((Component)this.colTable);
        this.colTable.setBounds(570, 70, 190, 170);
        this.add((Component)this.rowTable);
        this.rowTable.setBounds(310, 320, 190, 170);
        this.add((Component)this.sumTable);
        this.sumTable.setBounds(570, 320, 190, 170);
        this.colTotal.setText(CrossReportComposer.getLocalText(KEY_DISPLAY_TOTAL, "\u663e\u793a\u603b\u8ba1"));
        this.add((Component)this.colTotal);
        this.colTotal.setBounds(570, 250, 85, 23);
        this.rowTotal.setText(CrossReportComposer.getLocalText(KEY_DISPLAY_TOTAL, "\u663e\u793a\u603b\u8ba1"));
        this.add((Component)this.rowTotal);
        this.rowTotal.setBounds(310, 500, 85, 23);
        this.sumOrientation.setText(CrossReportComposer.getLocalText(KEY_STAT_FIELD_ORIENTATION, "\u5c06\u6c47\u603b\u5b57\u6bb5\u653e\u5728\u884c\u4e0a"));
        this.add((Component)this.sumOrientation);
        this.sumOrientation.setBounds(570, 500, 140, 23);
        for (i = 0; i < 4; ++i) {
            this.rowTable.getColumn(i).setWidth(40);
            this.colTable.getColumn(i).setWidth(40);
        }
        this.rowTable.getColumn(0).setWidth(50);
        this.colTable.getColumn(0).setWidth(50);
        this.rowTable.getColumn(3).setWidth(50);
        this.colTable.getColumn(3).setWidth(50);
        for (i = 0; i < 3; ++i) {
            this.sumTable.getColumn(i).setWidth(60);
        }
    }

    private String getFormulaByName(Object name) {
        if (name == this.sum) {
            return KEY_SUM;
        }
        if (name == this.avg) {
            return "average";
        }
        if (name == this.max) {
            return KEY_MAX;
        }
        if (name == this.min) {
            return KEY_MIN;
        }
        if (name == this.cnt) {
            return "counta";
        }
        throw new IllegalArgumentException("bad desc string");
    }

    private String buildFormula(String[] ele) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ele.length; ++i) {
            sb.append(ele[i]);
        }
        return sb.toString();
    }

    @Override
    public void compose() {
        int i;
        int index;
        int index2;
        int j;
        int i2;
        int j2;
        int x;
        int temp;
        String ref;
        Cell cell;
        int i3;
        int i4;
        int rowMultiplier;
        int colMultiplier;
        if (this.colTable.getRowCount() == 0 || this.rowTable.getRowCount() == 0 || this.sumTable.getRowCount() == 0) {
            return;
        }
        StyleAttributes titleSa = Styles.getEmptySA();
        titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        titleSa.setFontSize(10);
        titleSa.setBold(true);
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        int sumFieldCount = this.sumTable.getRowCount();
        if (this.sumOrientation.isSelected()) {
            colMultiplier = sumFieldCount;
            rowMultiplier = 1;
        } else {
            colMultiplier = 1;
            rowMultiplier = sumFieldCount;
        }
        int colGroupCount = this.colTable.getRowCount();
        int rowGroupCount = this.rowTable.getRowCount();
        int[] colMergeInfo = new int[colGroupCount];
        int[] rowMergeInfo = new int[rowGroupCount];
        int baseCol = rowGroupCount;
        int baseRow = colGroupCount;
        String[] commonFormulas = new String[sumFieldCount];
        int row = 0;
        int col = 0;
        int row2 = colGroupCount - 1;
        int col2 = rowGroupCount - 1;
        CellBlock leftUpEmptyCells = CellBlock.getCellBlock(row, col, row2, col2);
        if (!leftUpEmptyCells.isSingleCell()) {
            sheet.getMerger(true).insert(leftUpEmptyCells);
        }
        if (leftUpEmptyCells.getHeight() == 1) {
            sheet.getRowRange(0, 0).setRowHeight(2 * sheet.getDefRowHeight());
        }
        DiagonalHeader info = new DiagonalHeader(sheet);
        info.setRowCol(row, col, row2, col2);
        info.setSplitInfo(ISplitRectInfo.RELATE_TO_UPLEFT, new int[0], new int[0]);
        BinaryElement tmpele = (BinaryElement)this.colTable.getRow(row).getCell(0).getValue();
        String tmpInfo = tmpele.getColName();
        for (i4 = 1; i4 <= row2; ++i4) {
            tmpele = (BinaryElement)this.colTable.getRow(i4).getCell(0).getValue();
            tmpInfo = tmpInfo + "; " + tmpele.getColName();
        }
        info.getTriangleInfo(0).setText(tmpInfo);
        tmpele = (BinaryElement)this.rowTable.getRow(col).getCell(0).getValue();
        tmpInfo = tmpele.getColName();
        for (i4 = 1; i4 <= col2; ++i4) {
            tmpele = (BinaryElement)this.rowTable.getRow(i4).getCell(0).getValue();
            tmpInfo = tmpInfo + "; " + tmpele.getColName();
        }
        info.getTriangleInfo(1).setText(tmpInfo);
        sheet.getRange(leftUpEmptyCells).setDiagonalHeader(info);
        int integer = 1;
        for (i3 = colGroupCount - 1; i3 >= 0; --i3) {
            BinaryElement ele = (BinaryElement)this.colTable.getRow(i3).getCell(0).getValue();
            String seq = this.colTable.getRow(i3).getCell(1).getValue() == this.asc ? "false" : "true";
            cell = sheet.getCell(i3, baseCol, true);
            ref = cell.getName(false, false);
            cell.setFormula(this.buildFormula(new String[]{"=group(", this.currentDs.getAlias(), " , ", ele.getColName(), " , ", seq + ")"}));
            cell.setSSA((ShareStyleAttributes)titleSa);
            if (i3 == 0) {
                cell.getExtProps(true).setExtensible(1);
            }
            if (this.colTable.getRow(i3).getCell(2).getValue() == Boolean.TRUE) {
                colMergeInfo[i3] = temp = integer * colMultiplier - 1;
                x = baseCol + temp + 1;
                cell = sheet.getCell(i3, x, true);
                cell.setFormula(this.buildFormula(new String[]{"=ex(", ref, ") & \" " + CrossReportComposer.getLocalText(KEY_SUBTOTAL, "\u5c0f\u8ba1") + ":\""}));
                cell.setSSA((ShareStyleAttributes)titleSa);
                cell.getExtProps(true).setHead(sheet.getCell(i3, baseCol, true).getName(false, false), false);
                sheet.getMerger(true).insert(CellBlock.getCellBlock(i3, x, i3, x + colMultiplier - 1));
                ++integer;
                continue;
            }
            colMergeInfo[i3] = integer * colMultiplier - 1;
        }
        for (j2 = 0; j2 < colMergeInfo.length; ++j2) {
            sheet.getMerger(true).insert(CellBlock.getCellBlock(j2, baseCol, j2, baseCol + colMergeInfo[j2]));
        }
        if (this.colTotal.isSelected()) {
            String ref2;
            int j3;
            i3 = baseCol + colMergeInfo[0];
            if (this.colTable.getRow(0).getCell(2).getValue().equals(Boolean.TRUE)) {
                i3 += colMultiplier;
            }
            Cell cell2 = sheet.getCell(0, i3 + 1, true);
            cell2.setFormula(CrossReportComposer.getLocalText(KEY_TOTAL, "\u603b\u8ba1"));
            cell2.setSSA((ShareStyleAttributes)titleSa);
            sheet.getMerger(true).insert(CellBlock.getCellBlock(0, i3 + 1, 0, i3 + colMultiplier));
            if (!this.sumOrientation.isSelected()) {
                for (j3 = 0; j3 < sumFieldCount; ++j3) {
                    ref2 = sheet.getCell(baseRow + j3, baseCol, true).getName(false, false);
                    commonFormulas[j3] = "=sum(exs(" + ref2 + "))";
                    sheet.getCell(baseRow + j3, i3 + 1, true).setFormula(commonFormulas[j3]);
                }
            } else {
                for (j3 = 0; j3 < sumFieldCount; ++j3) {
                    ref2 = sheet.getCell(baseRow, baseCol + j3, true).getName(false, false);
                    commonFormulas[j3] = "=sum(exs(" + ref2 + "))";
                    sheet.getCell(baseRow, i3 + j3 + 1, true).setFormula(commonFormulas[j3]);
                }
            }
        } else {
            String ref3;
            i3 = baseCol + colMergeInfo[0];
            if (this.colTable.getRow(0).getCell(2).getValue().equals(Boolean.TRUE)) {
                i3 += colMultiplier;
            }
            if (!this.sumOrientation.isSelected()) {
                for (int j4 = 0; j4 < sumFieldCount; ++j4) {
                    ref3 = sheet.getCell(baseRow + j4, baseCol, true).getName(false, false);
                    commonFormulas[j4] = "=sum(exs(" + ref3 + "))";
                }
            } else {
                for (int j5 = 0; j5 < sumFieldCount; ++j5) {
                    ref3 = sheet.getCell(baseRow, baseCol + j5, true).getName(false, false);
                    commonFormulas[j5] = "=sum(exs(" + ref3 + "))";
                }
            }
        }
        integer = 1;
        for (i3 = rowGroupCount - 1; i3 >= 0; --i3) {
            BinaryElement ele = (BinaryElement)this.rowTable.getRow(i3).getCell(0).getValue();
            String seq = this.rowTable.getRow(i3).getCell(1).getValue() == this.asc ? "false" : "true";
            cell = sheet.getCell(baseRow, i3, true);
            ref = cell.getName(false, false);
            cell.setFormula(this.buildFormula(new String[]{"=group(", this.currentDs.getAlias(), " , ", ele.getColName(), " , ", seq, ")"}));
            cell.setSSA((ShareStyleAttributes)titleSa);
            if (this.rowTable.getRow(i3).getCell(2).getValue() == Boolean.TRUE) {
                rowMergeInfo[i3] = temp = integer * rowMultiplier - 1;
                x = baseRow + temp + 1;
                cell = sheet.getCell(x, i3, true);
                cell.setFormula(this.buildFormula(new String[]{"=ex(", ref, ") & \" " + CrossReportComposer.getLocalText(KEY_SUBTOTAL, "\u5c0f\u8ba1") + ":\""}));
                cell.setSSA((ShareStyleAttributes)titleSa);
                cell.getExtProps(true).setHead(sheet.getCell(baseRow, i3, true).getName(false, false), true);
                sheet.getMerger(true).insert(CellBlock.getCellBlock(x, i3, x + rowMultiplier - 1, i3));
                ++integer;
                continue;
            }
            rowMergeInfo[i3] = integer * rowMultiplier - 1;
        }
        for (j2 = 0; j2 < rowMergeInfo.length; ++j2) {
            sheet.getMerger(true).insert(CellBlock.getCellBlock(baseRow, j2, baseRow + rowMergeInfo[j2], j2));
        }
        if (this.rowTotal.isSelected()) {
            i3 = baseRow + rowMergeInfo[0];
            if (this.rowTable.getRow(0).getCell(2).getValue().equals(Boolean.TRUE)) {
                i3 += rowMultiplier;
            }
            Cell cell3 = sheet.getCell(i3 + 1, 0, true);
            cell3.setFormula(CrossReportComposer.getLocalText(KEY_TOTAL, "\u603b\u8ba1"));
            cell3.setSSA((ShareStyleAttributes)titleSa);
            sheet.getMerger(true).insert(CellBlock.getCellBlock(i3 + 1, 0, i3 + rowMultiplier, 0));
            if (this.sumOrientation.isSelected()) {
                for (int j6 = 0; j6 < sumFieldCount; ++j6) {
                    sheet.getCell(i3 + 1, baseCol + j6, true).setFormula(commonFormulas[j6]);
                }
            } else {
                for (int j7 = 0; j7 < sumFieldCount; ++j7) {
                    sheet.getCell(i3 + j7 + 1, baseCol, true).setFormula(commonFormulas[j7]);
                }
            }
        }
        int x2 = baseRow;
        int y = baseCol;
        int y1 = baseCol + colMergeInfo[0];
        if (this.colTable.getRow(0).getCell(2).getValue().equals(Boolean.TRUE)) {
            y1 += colMultiplier;
        }
        int x1 = baseRow + rowMergeInfo[0];
        if (this.rowTable.getRow(0).getCell(2).getValue().equals(Boolean.TRUE)) {
            x1 += rowMultiplier;
        }
        if (!this.sumOrientation.isSelected()) {
            for (i2 = x2; i2 < x2 + sumFieldCount; ++i2) {
                for (j = y; j <= y1; ++j) {
                    index2 = (i2 - baseRow) % sumFieldCount;
                    sheet.getCell(i2, j, true).setFormula(commonFormulas[index2]);
                }
            }
            for (i2 = x2; i2 <= x1; ++i2) {
                index = (i2 - baseRow) % sumFieldCount;
                sheet.getCell(i2, y, true).setFormula(commonFormulas[index]);
            }
        } else {
            for (i2 = x2; i2 <= x1; ++i2) {
                for (j = y; j < y + sumFieldCount; ++j) {
                    index2 = (j - baseCol) % sumFieldCount;
                    sheet.getCell(i2, j, true).setFormula(commonFormulas[index2]);
                }
            }
            for (int j8 = y; j8 <= y1; ++j8) {
                index = (j8 - baseCol) % sumFieldCount;
                sheet.getCell(x2, j8, true).setFormula(commonFormulas[index]);
            }
        }
        for (i2 = 0; i2 < sumFieldCount; ++i2) {
            String formulaType;
            if (this.sumOrientation.isSelected()) {
                formulaType = (String)this.sumTable.getRow(i2).getCell(1).getValue();
                sheet.getCell(baseRow, baseCol + i2, true).setFormula(this.buildFormula(new String[]{"=", this.getFormulaByName(formulaType), "(FIELDS(" + this.currentDs.getAlias(), " , ", ((BinaryElement)this.sumTable.getRow(i2).getCell(0).getValue()).getColName(), "))"}));
                continue;
            }
            formulaType = (String)this.sumTable.getRow(i2).getCell(1).getValue();
            sheet.getCell(baseRow + i2, baseCol, true).setFormula(this.buildFormula(new String[]{"=", this.getFormulaByName(formulaType), "(FIELDS(" + this.currentDs.getAlias(), " , ", ((BinaryElement)this.sumTable.getRow(i2).getCell(0).getValue()).getColName(), "))"}));
        }
        int rowCount = this.rowTable.getRowCount();
        int columnCount = this.colTable.getRowCount();
        int sumCount = this.sumTable.getRowCount();
        for (i = 0; i < columnCount; ++i) {
            titleSa.setBackground(this.columnChooser[i].getColor());
            sheet.getCell(i, rowCount, true).setSSA((ShareStyleAttributes)titleSa);
        }
        for (i = 0; i < rowCount; ++i) {
            titleSa.setBackground(this.rowChooser[i].getColor());
            sheet.getCell(columnCount, i, true).setSSA((ShareStyleAttributes)titleSa);
        }
        StyleAttributes detailsSa = Styles.getEmptySA();
        detailsSa.setFontSize(10);
        detailsSa.setFontColor(new Color(Integer.parseInt("0581C7", 16)));
        if (!this.sumOrientation.isSelected()) {
            for (int i5 = 0; i5 < sumCount; ++i5) {
                detailsSa.setBackground(this.sumChooser[i5].getColor());
                sheet.getCell(columnCount + i5, rowCount, true).setSSA((ShareStyleAttributes)detailsSa);
            }
        } else {
            for (int i6 = 0; i6 < sumCount; ++i6) {
                detailsSa.setBackground(this.sumChooser[i6].getColor());
                sheet.getCell(columnCount, rowCount + i6, true).setSSA((ShareStyleAttributes)detailsSa);
            }
        }
        sheet.getColSpans().setSpanAttribute(new Span(0, sheet.getMaxColIndex()), null, new Integer(110), new Boolean(true), null, null, null);
    }

    @Override
    public boolean checkValid() {
        return true;
    }

    private static class BinaryElement
    implements GroupReportComposer.IElement {
        private String alias;
        private String colName;

        BinaryElement(String alias, String colName) {
            this.alias = alias;
            this.colName = colName;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public String getColName() {
            return this.colName;
        }

        public String toString() {
            return this.alias;
        }

        public int hashCode() {
            return this.colName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GroupReportComposer.IElement)) {
                return false;
            }
            GroupReportComposer.IElement byObj = (GroupReportComposer.IElement)obj;
            return this.colName.equals(byObj.getColName());
        }
    }
}

